/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.conversion;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.javalite.common.Util;
import org.javalite.conversion.ConverterAdapter;

public class StringToSqlDateConverter
extends ConverterAdapter<String, Date> {
    private final DateFormat format;
    private final ThreadLocal<DateFormat> threadLocalFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)StringToSqlDateConverter.this.format.clone();
        }
    };

    public StringToSqlDateConverter(String pattern) {
        this(new SimpleDateFormat(pattern));
    }

    public StringToSqlDateConverter(DateFormat format) {
        this.format = format;
    }

    @Override
    protected Class<String> sourceClass() {
        return String.class;
    }

    @Override
    protected Class<Date> destinationClass() {
        return Date.class;
    }

    @Override
    public Date doConvert(String source) throws ParseException {
        return Util.blank(source) ? null : new Date(this.threadLocalFormat.get().parse(source).getTime());
    }
}

