/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.util.Date;

public final class HumanDate {
    private HumanDate() {
    }

    public static String toHumanFormat(long fromTime, long toTime) {
        if (toTime < fromTime) {
            throw new IllegalArgumentException("toTime must be >= fromTime");
        }
        long distanceInSeconds = (toTime - fromTime) / 1000L;
        long distanceInMinutes = distanceInSeconds / 60L;
        if (distanceInMinutes == 0L) {
            return "less than a minute";
        }
        if (distanceInMinutes == 1L) {
            return "a minute";
        }
        if (HumanDate.inRange(2L, 44L, distanceInMinutes)) {
            return distanceInMinutes + " minutes";
        }
        if (HumanDate.inRange(45L, 89L, distanceInMinutes)) {
            return "about 1 hour";
        }
        if (HumanDate.inRange(90L, 1439L, distanceInMinutes)) {
            return "about " + Math.round((float)distanceInMinutes / 60.0f) + " hours";
        }
        if (HumanDate.inRange(1440L, 2879L, distanceInMinutes)) {
            return "1 day";
        }
        if (HumanDate.inRange(2880L, 43199L, distanceInMinutes)) {
            return Math.round((float)distanceInMinutes / 1440.0f) + " days";
        }
        if (HumanDate.inRange(43200L, 86399L, distanceInMinutes)) {
            return "about 1 month";
        }
        if (HumanDate.inRange(86400L, 525599L, distanceInMinutes)) {
            return Math.round((float)distanceInMinutes / 43200.0f) + " months";
        }
        if (HumanDate.inRange(525600L, 1051199L, distanceInMinutes)) {
            return "about 1 year";
        }
        return "about " + Math.round((float)distanceInMinutes / 525600.0f) + " years";
    }

    public static String toHumanFormat(long fromTime) {
        return HumanDate.toHumanFormat(fromTime, new Date().getTime());
    }

    private static boolean inRange(long min, long max, long val) {
        return val >= min && val <= max;
    }
}

