/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@Deprecated
public class XmlEntities {
    private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}};
    private static final String[][] APOS_ARRAY = new String[][]{{"apos", "39"}};
    public static final XmlEntities XML;
    private final EntityMap map;

    public XmlEntities() {
        this.map = new LookupEntityMap();
    }

    XmlEntities(EntityMap emap) {
        this.map = emap;
    }

    public void addEntities(String[][] entityArray) {
        for (String[] anEntityArray : entityArray) {
            this.addEntity(anEntityArray[0], Integer.parseInt(anEntityArray[1]));
        }
    }

    public void addEntity(String name, int value) {
        this.map.add(name, value);
    }

    public String entityName(int value) {
        return this.map.name(value);
    }

    public int entityValue(String name) {
        return this.map.value(name);
    }

    public String escape(String str) {
        StringBuilder sb = this.createStringBuilder(str);
        this.escape(sb, str);
        return sb.toString();
    }

    public void escape(StringBuilder sb, String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String entityName = this.entityName(c);
            if (entityName == null) {
                if (c > '\u007f') {
                    sb.append("&#");
                    sb.append(Integer.toString(c, 10));
                    sb.append(';');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append('&');
            sb.append(entityName);
            sb.append(';');
        }
    }

    @Deprecated
    public void escape(Writer writer, String str) throws IOException {
        writer.write(this.unescape(str));
    }

    public String unescape(String str) {
        int firstAmp = str.indexOf(38);
        if (firstAmp < 0) {
            return str;
        }
        StringBuilder sb = this.createStringBuilder(str);
        this.doUnescape(sb, str, firstAmp);
        return sb.toString();
    }

    private StringBuilder createStringBuilder(String str) {
        return new StringBuilder(str.length() + str.length() / 10);
    }

    public void unescape(StringBuilder sb, String str) {
        int firstAmp = str.indexOf(38);
        if (firstAmp < 0) {
            sb.append(str);
        } else {
            this.doUnescape(sb, str, firstAmp);
        }
    }

    @Deprecated
    public void unescape(Writer writer, String str) throws IOException {
        writer.write(this.unescape(str));
    }

    private void doUnescape(StringBuilder sb, String str, int firstAmp) {
        sb.append(str, 0, firstAmp);
        int len = str.length();
        for (int i = firstAmp; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '&') {
                int nextIdx = i + 1;
                int semiColonIdx = str.indexOf(59, nextIdx);
                if (semiColonIdx == -1) {
                    sb.append(c);
                    continue;
                }
                int amphersandIdx = str.indexOf(38, i + 1);
                if (amphersandIdx != -1 && amphersandIdx < semiColonIdx) {
                    sb.append(c);
                    continue;
                }
                String entityContent = str.substring(nextIdx, semiColonIdx);
                int entityValue = -1;
                int entityContentLen = entityContent.length();
                if (entityContentLen > 0) {
                    if (entityContent.charAt(0) == '#') {
                        if (entityContentLen > 1) {
                            char isHexChar = entityContent.charAt(1);
                            try {
                                switch (isHexChar) {
                                    case 'X': 
                                    case 'x': {
                                        entityValue = Integer.parseInt(entityContent.substring(2), 16);
                                        break;
                                    }
                                    default: {
                                        entityValue = Integer.parseInt(entityContent.substring(1), 10);
                                    }
                                }
                                if (entityValue > 65535) {
                                    entityValue = -1;
                                }
                            }
                            catch (NumberFormatException e) {
                                entityValue = -1;
                            }
                        }
                    } else {
                        entityValue = this.entityValue(entityContent);
                    }
                }
                if (entityValue == -1) {
                    sb.append('&');
                    sb.append(entityContent);
                    sb.append(';');
                } else {
                    sb.append(Character.toChars(entityValue));
                }
                i = semiColonIdx;
                continue;
            }
            sb.append(c);
        }
    }

    static {
        XmlEntities xml = new XmlEntities();
        xml.addEntities(BASIC_ARRAY);
        xml.addEntities(APOS_ARRAY);
        XML = xml;
    }

    static class BinaryEntityMap
    extends ArrayEntityMap {
        public BinaryEntityMap() {
        }

        public BinaryEntityMap(int growBy) {
            super(growBy);
        }

        private int binarySearch(int key) {
            int low = 0;
            int high = this.size - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int midVal = this.values[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        @Override
        public void add(String name, int value) {
            this.ensureCapacity(this.size + 1);
            int insertAt = this.binarySearch(value);
            if (insertAt > 0) {
                return;
            }
            insertAt = -(insertAt + 1);
            System.arraycopy(this.values, insertAt, this.values, insertAt + 1, this.size - insertAt);
            this.values[insertAt] = value;
            System.arraycopy(this.names, insertAt, this.names, insertAt + 1, this.size - insertAt);
            this.names[insertAt] = name;
            ++this.size;
        }

        @Override
        public String name(int value) {
            int index = this.binarySearch(value);
            if (index < 0) {
                return null;
            }
            return this.names[index];
        }
    }

    static class ArrayEntityMap
    implements EntityMap {
        protected final int growBy;
        protected int size = 0;
        protected String[] names;
        protected int[] values;

        public ArrayEntityMap() {
            this.growBy = 100;
            this.names = new String[this.growBy];
            this.values = new int[this.growBy];
        }

        public ArrayEntityMap(int growBy) {
            this.growBy = growBy;
            this.names = new String[growBy];
            this.values = new int[growBy];
        }

        @Override
        public void add(String name, int value) {
            this.ensureCapacity(this.size + 1);
            this.names[this.size] = name;
            this.values[this.size] = value;
            ++this.size;
        }

        protected void ensureCapacity(int capacity) {
            if (capacity > this.names.length) {
                int newSize = Math.max(capacity, this.size + this.growBy);
                String[] newNames = new String[newSize];
                System.arraycopy(this.names, 0, newNames, 0, this.size);
                this.names = newNames;
                int[] newValues = new int[newSize];
                System.arraycopy(this.values, 0, newValues, 0, this.size);
                this.values = newValues;
            }
        }

        @Override
        public String name(int value) {
            for (int i = 0; i < this.size; ++i) {
                if (this.values[i] != value) continue;
                return this.names[i];
            }
            return null;
        }

        @Override
        public int value(String name) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.names[i].equals(name)) continue;
                return this.values[i];
            }
            return -1;
        }
    }

    static class LookupEntityMap
    extends PrimitiveEntityMap {
        private String[] lookupTable;
        private final int LOOKUP_TABLE_SIZE = 256;

        LookupEntityMap() {
        }

        @Override
        public String name(int value) {
            if (value < 256) {
                return this.lookupTable()[value];
            }
            return super.name(value);
        }

        private String[] lookupTable() {
            if (this.lookupTable == null) {
                this.createLookupTable();
            }
            return this.lookupTable;
        }

        private void createLookupTable() {
            this.lookupTable = new String[256];
            for (int i = 0; i < 256; ++i) {
                this.lookupTable[i] = super.name(i);
            }
        }
    }

    static class TreeEntityMap
    extends MapIntMap {
        public TreeEntityMap() {
            super(new TreeMap(), new TreeMap());
        }
    }

    static class HashEntityMap
    extends MapIntMap {
        public HashEntityMap() {
            super(new HashMap(), new HashMap());
        }
    }

    static abstract class MapIntMap
    implements EntityMap {
        protected final Map mapNameToValue;
        protected final Map mapValueToName;

        MapIntMap(Map nameToValue, Map valueToName) {
            this.mapNameToValue = nameToValue;
            this.mapValueToName = valueToName;
        }

        @Override
        public void add(String name, int value) {
            this.mapNameToValue.put(name, new Integer(value));
            this.mapValueToName.put(new Integer(value), name);
        }

        @Override
        public String name(int value) {
            return (String)this.mapValueToName.get(new Integer(value));
        }

        @Override
        public int value(String name) {
            Object value = this.mapNameToValue.get(name);
            if (value == null) {
                return -1;
            }
            return (Integer)value;
        }
    }

    static class PrimitiveEntityMap
    implements EntityMap {
        private final Map mapNameToValue = new HashMap();
        private final HashMap mapValueToName = new HashMap();

        PrimitiveEntityMap() {
        }

        @Override
        public void add(String name, int value) {
            this.mapNameToValue.put(name, new Integer(value));
            this.mapValueToName.put(value, name);
        }

        @Override
        public String name(int value) {
            return (String)this.mapValueToName.get(value);
        }

        @Override
        public int value(String name) {
            Object value = this.mapNameToValue.get(name);
            if (value == null) {
                return -1;
            }
            return (Integer)value;
        }
    }

    static interface EntityMap {
        public void add(String var1, int var2);

        public String name(int var1);

        public int value(String var1);
    }
}

