/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.activejdbc.connection_config.DbConfiguration;
import org.javalite.test.jspec.JSpecSupport;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSpec
extends DbConfiguration
implements JSpecSupport {
    private static Logger LOGGER = LoggerFactory.getLogger((String)DBSpec.class.getSimpleName());
    private boolean rollback = true;
    private boolean suppressDb = false;
    private boolean loadConfigFile = true;

    public boolean suppressedDb() {
        return this.suppressDb;
    }

    public void setLoadConfigFile(boolean loadConfigFile) {
        this.loadConfigFile = loadConfigFile;
    }

    public void suppressDb(boolean suppressDb) {
        this.suppressDb = suppressDb;
    }

    public boolean rollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        if (!this.suppressDb) {
            this.rollback = rollback;
            Map<String, Connection> connections = DB.connections();
            for (String name : connections.keySet()) {
                try {
                    boolean autocommit = !rollback;
                    connections.get(name).setAutoCommit(autocommit);
                }
                catch (SQLException e) {
                    throw new InitException(e);
                }
            }
        }
    }

    @Before
    public final void loadConfigAndOpenConnections() {
        if (!this.suppressDb && this.loadConfigFile) {
            DBSpec.loadConfiguration("/database.properties");
            this.openTestConnections();
        }
    }

    protected void openTestConnections() {
        List<ConnectionSpecWrapper> connectionWrappers = this.getTestConnectionWrappers();
        if (!connectionWrappers.isEmpty()) {
            for (ConnectionSpecWrapper connectionWrapper : connectionWrappers) {
                DB db = new DB(connectionWrapper.getDbName());
                db.open(connectionWrapper.getConnectionSpec());
                if (!this.rollback()) continue;
                db.openTransaction();
            }
        } else {
            LOGGER.warn("no DB connections are configured, none opened");
        }
    }

    @After
    public final void closeTestConnections() {
        if (!this.suppressDb) {
            List<ConnectionSpecWrapper> connectionWrappers = this.getTestConnectionWrappers();
            for (ConnectionSpecWrapper connectionWrapper : connectionWrappers) {
                String dbName = connectionWrapper.getDbName();
                DB db = new DB(dbName);
                if (this.rollback()) {
                    db.rollbackTransaction();
                }
                db.close();
            }
            DBSpec.clearConnectionWrappers();
        }
    }
}

