/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.conversion;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.javalite.activejdbc.conversion.ConverterAdapter;
import org.javalite.common.Util;

public class StringToTimestampConverter
extends ConverterAdapter<String, Timestamp> {
    private final DateFormat format;
    private final ThreadLocal<DateFormat> threadLocalFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)StringToTimestampConverter.this.format.clone();
        }
    };

    public StringToTimestampConverter(String pattern) {
        this(new SimpleDateFormat(pattern));
    }

    public StringToTimestampConverter(DateFormat format) {
        this.format = format;
    }

    @Override
    protected Class<String> sourceClass() {
        return String.class;
    }

    @Override
    protected Class<Timestamp> destinationClass() {
        return Timestamp.class;
    }

    @Override
    public Timestamp doConvert(String source) throws ParseException {
        return Util.blank((Object)source) ? null : new Timestamp(this.threadLocalFormat.get().parse(source).getTime());
    }
}

