/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

public abstract class Folds {
    public static <T, R> R foldLeft(BiFunction<R, T, R> f, R z, Iterable<T> iter) {
        R acc = z;
        for (T t : iter) {
            acc = f.apply(acc, t);
        }
        return acc;
    }

    public static <T> T foldLeft1(BinaryOperator<T> f, Iterable<T> iter) {
        Object acc = null;
        for (T t : iter) {
            if (acc == null) {
                acc = t;
                continue;
            }
            acc = f.apply(acc, t);
        }
        if (acc == null) {
            throw new IllegalArgumentException("Supplied Iterable argument is empty");
        }
        return acc;
    }

    public static <T, R> R foldRight(BiFunction<T, R, R> f, R z, List<T> l) {
        R acc = z;
        for (int i = l.size() - 1; i >= 0; --i) {
            acc = f.apply(l.get(i), acc);
        }
        return acc;
    }

    public static <T> T foldRight1(BinaryOperator<T> f, List<T> l) {
        int i0 = l.size() - 1;
        Object acc = null;
        for (int i = i0; i >= 0; --i) {
            acc = i == i0 ? (Object)l.get(i) : (Object)f.apply(l.get(i), acc);
        }
        return (T)acc;
    }

    public static <T, R> R foldRight(BiFunction<T, R, R> f, R z, Set<T> s) {
        return Folds.foldRight(f, z, new ArrayList<T>(s));
    }

    public static <T> T foldRight1(BinaryOperator<T> f, Set<T> s) {
        return Folds.foldRight1(f, new ArrayList<T>(s));
    }
}

