/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj.input;

import java.util.Arrays;
import java.util.List;
import org.javafp.parsecj.input.Input;

public class ArrayInput<I>
implements Input<I> {
    protected final I[] symbols;
    protected final int pos;

    ArrayInput(I[] symbols, int pos) {
        this.symbols = symbols;
        this.pos = pos;
    }

    ArrayInput(I[] symbols) {
        this(symbols, 0);
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public boolean end() {
        return this.pos >= this.symbols.length;
    }

    @Override
    public I current() {
        return this.pos < this.symbols.length ? (I)this.symbols[this.pos] : null;
    }

    @Override
    public List<I> current(int n) {
        return Arrays.asList(this.symbols).subList(this.pos, this.pos + n);
    }

    @Override
    public Input<I> next() {
        return new ArrayInput<I>(this.symbols, this.pos + 1);
    }

    @Override
    public Input<I> next(int n) {
        return new ArrayInput<I>(this.symbols, this.pos + n);
    }
}

