/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.function.Function;
import org.javafp.data.Unit;
import org.javafp.parsecj.Message;
import org.javafp.parsecj.input.Input;

public abstract class Reply<I, A> {
    public final Message<I> msg;

    public static <I, A> Ok<I, A> ok(A result, Input<I> tail, Message<I> msg) {
        return new Ok<I, A>(result, tail, msg);
    }

    public static <I> Ok<I, Unit> ok(Input<I> tail, Message<I> msg) {
        return new Ok<I, Object>(null, tail, msg);
    }

    public static <I, A> Error<I, A> error(Message<I> msg) {
        return new Error(msg);
    }

    Reply(Message<I> msg) {
        this.msg = msg;
    }

    public abstract <B> B match(Function<Ok<I, A>, B> var1, Function<Error<I, A>, B> var2);

    public abstract A getResult() throws Exception;

    public abstract boolean isOk();

    public abstract boolean isError();

    public String getMsg() {
        return this.msg.toString();
    }

    public static final class Error<I, A>
    extends Reply<I, A> {
        Error(Message<I> msg) {
            super(msg);
        }

        @Override
        public <B> B match(Function<Ok<I, A>, B> ok, Function<Error<I, A>, B> error) {
            return error.apply(this);
        }

        public <B> Reply<I, B> cast() {
            return this;
        }

        @Override
        public A getResult() throws Exception {
            throw new Exception(this.msg.toString());
        }

        @Override
        public boolean isOk() {
            return false;
        }

        @Override
        public boolean isError() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return this.msg.equals(error.msg);
        }

        public int hashCode() {
            return this.msg.hashCode();
        }

        public String toString() {
            return "Error{msg=" + this.msg + '}';
        }
    }

    public static final class Ok<I, A>
    extends Reply<I, A> {
        public final A result;
        public final Input<I> rest;

        Ok(A result, Input<I> rest, Message<I> msg) {
            super(msg);
            this.result = result;
            this.rest = rest;
        }

        @Override
        public <U> U match(Function<Ok<I, A>, U> ok, Function<Error<I, A>, U> error) {
            return ok.apply(this);
        }

        @Override
        public A getResult() {
            return this.result;
        }

        @Override
        public boolean isOk() {
            return true;
        }

        @Override
        public boolean isError() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ok ok = (Ok)o;
            if (!this.msg.equals(ok.msg)) {
                return false;
            }
            if (!this.rest.equals(ok.rest)) {
                return false;
            }
            return this.result == null ? ok.result == null : this.result.equals(ok.result);
        }

        public int hashCode() {
            int hc = this.msg.hashCode();
            hc = 31 * hc + (this.result != null ? this.result.hashCode() : 0);
            hc = 31 * hc + this.rest.hashCode();
            return hc;
        }

        public String toString() {
            return "Ok{msg=" + this.msg + ", result=" + this.result + ", rest=" + this.rest + '}';
        }
    }
}

