/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.javafp.data.IList;
import org.javafp.data.Unit;
import org.javafp.parsecj.Combinators;
import org.javafp.parsecj.ConsumedT;
import org.javafp.parsecj.Message;
import org.javafp.parsecj.Reply;
import org.javafp.parsecj.input.Input;

@FunctionalInterface
public interface Parser<I, A> {
    public static <I, A> Parser<I, A> parser(Function<Input<I>, ConsumedT<I, A>> parser) {
        return parser::apply;
    }

    public static <I, A> Ref<I, A> ref() {
        return new Ref();
    }

    public static <I, A> Ref<I, A> ref(Parser<I, A> parser) {
        return new Ref(parser);
    }

    public ConsumedT<I, A> apply(Input<I> var1);

    default public Reply<I, A> parse(Input<I> input) {
        return this.apply(input).getReply().match(ok -> Reply.ok(ok.result, ok.rest, Message.of()), error -> error);
    }

    default public <B> Parser<I, B> bind(Function<A, Parser<I, B>> f) {
        return Combinators.bind(this, f);
    }

    default public <B> Parser<I, B> then(Parser<I, B> p) {
        return Combinators.then(this, p);
    }

    default public <B> Parser<I, B> map(Function<A, B> f) {
        return Combinators.map(this, f);
    }

    default public Parser<I, A> or(Parser<I, ? extends A> q) {
        return Combinators.or(this, q);
    }

    default public Parser<I, A> label(String name) {
        return Combinators.label(this, name);
    }

    default public Parser<I, A> attempt() {
        return Combinators.attempt(this);
    }

    default public Parser<I, A> option(A x) {
        return Combinators.option(this, x);
    }

    default public Parser<I, Optional<A>> optionalOpt() {
        return Combinators.optionalOpt(this);
    }

    default public Parser<I, Unit> optional() {
        return Combinators.optional(this);
    }

    default public <OPEN, CLOSE> Parser<I, A> between(Parser<I, OPEN> open, Parser<I, CLOSE> close) {
        return Combinators.between(open, close, this);
    }

    default public Parser<I, IList<A>> many() {
        return Combinators.many(this);
    }

    default public Parser<I, IList<A>> many1() {
        return Combinators.many1(this);
    }

    default public Parser<I, Unit> skipMany() {
        return Combinators.skipMany(this);
    }

    default public Parser<I, Unit> skipMany1() {
        return Combinators.skipMany1(this);
    }

    default public <SEP> Parser<I, IList<A>> sepBy(Parser<I, SEP> sep) {
        return Combinators.sepBy(this, sep);
    }

    default public <SEP> Parser<I, IList<A>> sepBy1(Parser<I, SEP> sep) {
        return Combinators.sepBy1(this, sep);
    }

    default public <SEP> Parser<I, IList<A>> sepEndBy(Parser<I, SEP> sep) {
        return Combinators.sepEndBy(this, sep);
    }

    default public <SEP> Parser<I, IList<A>> sepEndBy1(Parser<I, SEP> sep) {
        return Combinators.sepEndBy1(this, sep);
    }

    default public <SEP> Parser<I, IList<A>> endBy(Parser<I, SEP> sep) {
        return Combinators.endBy(this, sep);
    }

    default public <SEP> Parser<I, IList<A>> endBy1(Parser<I, SEP> sep) {
        return Combinators.endBy1(this, sep);
    }

    default public Parser<I, IList<A>> count(int n) {
        return Combinators.count(this, n);
    }

    default public Parser<I, A> chainr(Parser<I, BinaryOperator<A>> op, A x) {
        return Combinators.chainr(this, op, x);
    }

    default public Parser<I, A> chainr1(Parser<I, BinaryOperator<A>> op) {
        return Combinators.chainr1(this, op);
    }

    default public Parser<I, A> chainl(Parser<I, BinaryOperator<A>> op, A x) {
        return Combinators.chainl(this, op, x);
    }

    default public Parser<I, A> chainl1(Parser<I, BinaryOperator<A>> op) {
        return Combinators.chainl1(this, op);
    }

    public static class Ref<I, A>
    implements Supplier<Parser<I, A>>,
    Parser<I, A> {
        private Parser<I, A> parser;

        private Ref(Parser<I, A> parser) {
            this.parser = parser;
        }

        private Ref() {
            this.parser = null;
        }

        public Parser<I, A> set(Parser<I, A> parser) {
            this.parser = parser;
            return this;
        }

        @Override
        public synchronized Parser<I, A> get() {
            if (this.parser == null) {
                throw new RuntimeException("Null Parser Reference");
            }
            return this.parser;
        }

        @Override
        public ConsumedT<I, A> apply(Input<I> input) {
            return this.get().apply(input);
        }
    }
}

