/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.Objects;
import java.util.Set;
import org.javafp.parsecj.EmptyMessage;
import org.javafp.parsecj.EndOfInput;
import org.javafp.parsecj.Message;
import org.javafp.parsecj.utils.Folds;

final class MessageImpl<I>
implements Message<I> {
    public final int pos;
    public final I sym;
    public final Set<String> expected;

    public MessageImpl(int pos, I sym, Set<String> expected) {
        this.pos = pos;
        this.sym = sym;
        this.expected = Objects.requireNonNull(expected);
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof Message)) {
            return false;
        }
        Message message = (Message)rhs;
        if (message instanceof EndOfInput || message instanceof EmptyMessage) {
            return false;
        }
        if (this.pos != message.position()) {
            return false;
        }
        if (!this.expected.equals(message.expected())) {
            return false;
        }
        return this.sym.equals(message.symbol());
    }

    public int hashCode() {
        int result = this.pos;
        result = 31 * result + this.sym.hashCode();
        result = 31 * result + this.expected.hashCode();
        return result;
    }

    public String toString() {
        switch (this.expected.size()) {
            case 0: {
                return "Unexpected '" + this.sym + "' at position " + (this.pos == -1 ? "EOF" : Integer.valueOf(this.pos)) + ". Expecting nothing";
            }
        }
        String expectedStr = Folds.foldRight1((x, y) -> x + ',' + y, this.expected);
        return "Unexpected '" + this.sym + "' at position " + (this.pos == -1 ? "EOF" : Integer.valueOf(this.pos)) + ". Expecting one of [" + expectedStr + ']';
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public I symbol() {
        return this.sym;
    }

    @Override
    public Set<String> expected() {
        return this.expected;
    }
}

