/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.Set;
import java.util.function.Supplier;
import org.javafp.parsecj.EmptyMessage;
import org.javafp.parsecj.EndOfInput;
import org.javafp.parsecj.ErrorMessage;
import org.javafp.parsecj.LazyMessage;
import org.javafp.parsecj.MessageImpl;
import org.javafp.parsecj.utils.Sets;

public interface Message<I> {
    public static <I> Message<I> of(int pos, I sym, String expected) {
        return new MessageImpl<I>(pos, sym, Sets.singleton(expected));
    }

    public static <I> Message<I> of(int pos, String expected) {
        return new MessageImpl<Object>(pos, null, Sets.singleton(expected));
    }

    public static <I> Message<I> of(int pos) {
        return new MessageImpl<Object>(pos, null, Sets.empty());
    }

    public static <I> Message<I> of(String msg, int pos) {
        return new ErrorMessage(pos, msg);
    }

    public static <I> Message<I> of() {
        return EmptyMessage.instance();
    }

    public static <I> Message<I> endOfInput(int pos, String expected) {
        return new EndOfInput(pos, Sets.singleton(expected));
    }

    public static <I> LazyMessage<I> lazy(Supplier<Message<I>> supplier) {
        return new LazyMessage<I>(supplier);
    }

    public int position();

    public I symbol();

    public Set<String> expected();

    default public LazyMessage<I> expect(String name) {
        return Message.lazy(() -> Message.of(this.position(), this.symbol(), name));
    }

    default public Message<I> merge(Message<I> rhs) {
        return Message.lazy(() -> new MessageImpl<I>(this.position(), this.symbol(), Sets.union(this.expected(), rhs.expected())));
    }

    public static final class Exception
    extends RuntimeException {
        public final Message message;

        public Exception(Message<?> message) {
            this.message = message;
        }
    }
}

