/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.Set;
import java.util.function.Supplier;
import org.javafp.parsecj.Message;

final class LazyMessage<I>
implements Message<I> {
    private Supplier<Message<I>> supplier;
    private Message<I> value;

    public LazyMessage(Supplier<Message<I>> supplier) {
        this.supplier = supplier;
    }

    private synchronized Message<I> get() {
        if (this.supplier != null) {
            this.value = this.supplier.get();
            this.supplier = null;
        }
        return this.value;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof Message)) {
            return false;
        }
        Message message = (Message)rhs;
        if (this.get().position() != message.position()) {
            return false;
        }
        if (!this.get().expected().equals(message.expected())) {
            return false;
        }
        return this.get().symbol().equals(message.symbol());
    }

    public int hashCode() {
        return this.get().hashCode();
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public int position() {
        return this.get().position();
    }

    @Override
    public I symbol() {
        return this.get().symbol();
    }

    @Override
    public Set<String> expected() {
        return this.get().expected();
    }
}

