/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.data;

import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.javafp.data.IList;

class ListAdaptor<T>
extends AbstractSequentialList<T> {
    private final IList<T> impl;
    private final int size;

    ListAdaptor(IList<T> impl) {
        this.impl = impl;
        this.size = impl.size();
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            private int pos;
            private IList<T> node;
            {
                this.pos = index;
                this.node = this.move(ListAdaptor.this.impl, index);
            }

            private IList<T> move(IList<T> node, int count) {
                for (int i = 0; i < count; ++i) {
                    node = node.tail();
                }
                return node;
            }

            @Override
            public boolean hasNext() {
                return this.pos < ListAdaptor.this.size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object ret = this.node.head();
                this.node = this.node.tail();
                ++this.pos;
                return ret;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos >= 0;
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                --this.pos;
                this.node = this.move(ListAdaptor.this.impl, this.pos);
                ++this.pos;
                return this.node.head();
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void remove() {
                throw this.modError();
            }

            @Override
            public void set(T t) {
                throw this.modError();
            }

            @Override
            public void add(T t) {
                throw this.modError();
            }

            private UnsupportedOperationException modError() {
                return new UnsupportedOperationException("IList can not be modified");
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

