/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.mojo.javacc.Suffix;
import org.codehaus.plexus.util.FileUtils;

class GrammarInfo {
    private final File sourceDirectory;
    private final String grammarFile;
    private final String parserPackage;
    private final String parserDirectory;
    private final String parserName;
    private final String parserFile;

    public GrammarInfo(File sourceDir, String inputFile) throws IOException {
        this(Suffix.Java, sourceDir, inputFile, null);
    }

    public GrammarInfo(Suffix suffix, File sourceDir, String inputFile, String packageName) throws IOException {
        if (!sourceDir.isAbsolute()) {
            throw new IllegalArgumentException("source directory is not absolute: " + sourceDir);
        }
        this.sourceDirectory = sourceDir;
        File inFile = new File(inputFile);
        if (!inFile.isAbsolute()) {
            this.grammarFile = inFile.getPath();
        } else if (inFile.getPath().startsWith(sourceDir.getPath())) {
            this.grammarFile = inFile.getPath().substring(sourceDir.getPath().length() + 1);
        } else {
            throw new IllegalArgumentException("input file is not relative to source directory:" + inputFile);
        }
        String grammar = FileUtils.fileRead((File)this.getGrammarFile());
        this.parserPackage = packageName == null ? this.findPackageName(grammar) : packageName;
        this.parserDirectory = this.parserPackage.replace('.', File.separatorChar);
        String name = this.findParserName(grammar);
        this.parserName = name.length() <= 0 ? FileUtils.removeExtension((String)inFile.getName()) : name;
        this.parserFile = this.parserDirectory.length() > 0 ? new File(this.parserDirectory, this.parserName + "." + suffix.string()).getPath() : this.parserName + "." + suffix.string();
    }

    private String findPackageName(String grammar) {
        String packageDeclaration = "package\\s+([^\\s.;]+(\\.[^\\s.;]+)*)\\s*;";
        Matcher matcher = Pattern.compile("package\\s+([^\\s.;]+(\\.[^\\s.;]+)*)\\s*;").matcher(grammar);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private String findParserName(String grammar) {
        String parserBegin = "PARSER_BEGIN\\s*\\(\\s*([^\\s\\)]+)\\s*\\)";
        Matcher matcher = Pattern.compile("PARSER_BEGIN\\s*\\(\\s*([^\\s\\)]+)\\s*\\)").matcher(grammar);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getGrammarFile() {
        return new File(this.sourceDirectory, this.grammarFile);
    }

    public String getRelativeGrammarFile() {
        return this.grammarFile;
    }

    public String resolvePackageName(String packageName) {
        String resolvedPackageName = packageName;
        if (resolvedPackageName != null && resolvedPackageName.startsWith("*") && (resolvedPackageName = this.getParserPackage() + resolvedPackageName.substring(1)).startsWith(".")) {
            resolvedPackageName = resolvedPackageName.substring(1);
        }
        return resolvedPackageName;
    }

    public String getParserPackage() {
        return this.parserPackage;
    }

    public String getParserDirectory() {
        return this.parserDirectory;
    }

    public String getParserName() {
        return this.parserName;
    }

    public String getParserFile() {
        return this.parserFile;
    }

    public String toString() {
        return this.getGrammarFile() + " -> " + this.getParserFile();
    }
}

