/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units.javasound;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiolibs.pipes.units.AudioTable;
import org.jaudiolibs.pipes.units.javasound.AudioFloatConverter;

public class JSAudioTableLoader
implements AudioTable.Loader {
    public AudioTable load(URI source) throws Exception {
        try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(source.toURL());){
            int bytesRead;
            AudioFormat format = audioInputStream.getFormat();
            int channelCount = format.getChannels();
            float sampleRate = format.getSampleRate();
            if (channelCount < 1 || sampleRate < 1.0f) {
                throw new UnsupportedAudioFileException();
            }
            int estSize = Math.max(4096, audioInputStream.available());
            BAOS baos = new BAOS(estSize);
            byte[] data = new byte[4096];
            while ((bytesRead = audioInputStream.read(data, 0, data.length)) > -1) {
                baos.write(data, 0, bytesRead);
            }
            byte[] byteData = baos.toByteArray();
            float[] floatData = new float[byteData.length / (format.getFrameSize() / channelCount)];
            AudioFloatConverter conv = AudioFloatConverter.getConverter(format);
            conv.toFloatArray(byteData, floatData);
            AudioTable audioTable = AudioTable.wrap((float[])floatData, (double)sampleRate, (int)channelCount);
            return audioTable;
        }
    }

    private static class BAOS
    extends ByteArrayOutputStream {
        private BAOS(int size) {
            super(size);
        }

        @Override
        public byte[] toByteArray() {
            if (this.buf.length == this.count) {
                return this.buf;
            }
            return super.toByteArray();
        }
    }
}

