/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units.javasound;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.sound.sampled.AudioFormat;

abstract class AudioFloatConverter {
    public static final AudioFormat.Encoding PCM_FLOAT = new AudioFormat.Encoding("PCM_FLOAT");
    private AudioFormat format;

    AudioFloatConverter() {
    }

    public static AudioFloatConverter getConverter(AudioFormat format) {
        AudioFloatConverter conv = null;
        if (format.getFrameSize() != format.getSampleSizeInBits() / 8 * format.getChannels()) {
            return null;
        }
        if (format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (format.isBigEndian()) {
                if (format.getSampleSizeInBits() == 8) {
                    conv = new AudioFloatConversion8S();
                } else if (format.getSampleSizeInBits() > 8 && format.getSampleSizeInBits() <= 16) {
                    conv = new AudioFloatConversion16SB();
                } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                    conv = new AudioFloatConversion24SB();
                } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                    conv = new AudioFloatConversion32SB();
                }
            } else if (format.getSampleSizeInBits() == 8) {
                conv = new AudioFloatConversion8S();
            } else if (format.getSampleSizeInBits() > 8 & format.getSampleSizeInBits() <= 16) {
                conv = new AudioFloatConversion16SL();
            } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                conv = new AudioFloatConversion24SL();
            } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                conv = new AudioFloatConversion32SL();
            }
        } else if (format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            if (format.isBigEndian()) {
                if (format.getSampleSizeInBits() == 8) {
                    conv = new AudioFloatConversion8U();
                } else if (format.getSampleSizeInBits() > 8 && format.getSampleSizeInBits() <= 16) {
                    conv = new AudioFloatConversion16UB();
                } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                    conv = new AudioFloatConversion24UB();
                } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                    conv = new AudioFloatConversion32UB();
                }
            } else if (format.getSampleSizeInBits() == 8) {
                conv = new AudioFloatConversion8U();
            } else if (format.getSampleSizeInBits() > 8 && format.getSampleSizeInBits() <= 16) {
                conv = new AudioFloatConversion16UL();
            } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                conv = new AudioFloatConversion24UL();
            } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                conv = new AudioFloatConversion32UL();
            }
        } else if (format.getEncoding().equals(PCM_FLOAT) && format.getSampleSizeInBits() == 32) {
            conv = format.isBigEndian() ? new AudioFloatConversion32B() : new AudioFloatConversion32L();
        }
        if (conv != null) {
            conv.format = format;
        }
        return conv;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public abstract float[] toFloatArray(byte[] var1, int var2, float[] var3, int var4, int var5);

    public float[] toFloatArray(byte[] in_buff, float[] out_buff, int out_offset, int out_len) {
        return this.toFloatArray(in_buff, 0, out_buff, out_offset, out_len);
    }

    public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_len) {
        return this.toFloatArray(in_buff, in_offset, out_buff, 0, out_len);
    }

    public float[] toFloatArray(byte[] in_buff, float[] out_buff, int out_len) {
        return this.toFloatArray(in_buff, 0, out_buff, 0, out_len);
    }

    public float[] toFloatArray(byte[] in_buff, float[] out_buff) {
        return this.toFloatArray(in_buff, 0, out_buff, 0, out_buff.length);
    }

    public abstract byte[] toByteArray(float[] var1, int var2, int var3, byte[] var4, int var5);

    public byte[] toByteArray(float[] in_buff, int in_len, byte[] out_buff, int out_offset) {
        return this.toByteArray(in_buff, 0, in_len, out_buff, out_offset);
    }

    public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff) {
        return this.toByteArray(in_buff, in_offset, in_len, out_buff, 0);
    }

    public byte[] toByteArray(float[] in_buff, int in_len, byte[] out_buff) {
        return this.toByteArray(in_buff, 0, in_len, out_buff, 0);
    }

    public byte[] toByteArray(float[] in_buff, byte[] out_buff) {
        return this.toByteArray(in_buff, 0, in_buff.length, out_buff, 0);
    }

    private static class AudioFloatConversion32UB
    extends AudioFloatConverter {
        private AudioFloatConversion32UB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 24 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                out_buff[ox++] = (float)(x -= Integer.MAX_VALUE) * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)((double)in_buff[ix++] * 2.147483647E9);
                out_buff[ox++] = (byte)((x += Integer.MAX_VALUE) >>> 24);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32UL
    extends AudioFloatConverter {
        private AudioFloatConversion32UL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 24;
                out_buff[ox++] = (float)(x -= Integer.MAX_VALUE) * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)((double)in_buff[ix++] * 2.147483647E9);
                out_buff[ox++] = (byte)(x += Integer.MAX_VALUE);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 24);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32SB
    extends AudioFloatConverter {
        private AudioFloatConversion32SB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 24 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                out_buff[ox++] = (float)x * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)((double)in_buff[ix++] * 2.147483647E9);
                out_buff[ox++] = (byte)(x >>> 24);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32SL
    extends AudioFloatConverter {
        private AudioFloatConversion32SL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 24;
                out_buff[ox++] = (float)x * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)((double)in_buff[ix++] * 2.147483647E9);
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 24);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24UB
    extends AudioFloatConverter {
        private AudioFloatConversion24UB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                out_buff[ox++] = (float)(x -= 0x7FFFFF) * 1.192093E-7f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)((double)in_buff[ix++] * 8388607.0);
                out_buff[ox++] = (byte)((x += 0x7FFFFF) >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24UL
    extends AudioFloatConverter {
        private AudioFloatConversion24UL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16;
                out_buff[ox++] = (float)(x -= 0x7FFFFF) * 1.192093E-7f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)((double)in_buff[ix++] * 8388607.0);
                out_buff[ox++] = (byte)(x += 0x7FFFFF);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24SB
    extends AudioFloatConverter {
        private AudioFloatConversion24SB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x;
                if ((x = (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF) > 0x7FFFFF) {
                    x -= 0x1000000;
                }
                out_buff[ox++] = (float)x * 1.192093E-7f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x;
                if ((x = (int)((double)in_buff[ix++] * 8388607.0)) < 0) {
                    x += 0x1000000;
                }
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24SL
    extends AudioFloatConverter {
        private AudioFloatConversion24SL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x;
                if ((x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16) > 0x7FFFFF) {
                    x -= 0x1000000;
                }
                out_buff[ox++] = (float)x * 1.192093E-7f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x;
                if ((x = (int)((double)in_buff[ix++] * 8388607.0)) < 0) {
                    x += 0x1000000;
                }
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16UB
    extends AudioFloatConverter {
        private AudioFloatConversion16UB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                out_buff[ox++] = (float)(((in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF) - Short.MAX_VALUE) * 3.051851E-5f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = Short.MAX_VALUE + (int)((double)in_buff[ix++] * 32767.0);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16UL
    extends AudioFloatConverter {
        private AudioFloatConversion16UL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                out_buff[ox++] = (float)((in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8) - Short.MAX_VALUE) * 3.051851E-5f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = Short.MAX_VALUE + (int)((double)in_buff[ix++] * 32767.0);
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16SB
    extends AudioFloatConverter {
        private AudioFloatConversion16SB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                out_buff[ox++] = (float)((short)(in_buff[ix++] << 8 | in_buff[ix++] & 0xFF)) * 3.051851E-5f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)((double)in_buff[ix++] * 32767.0);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16SL
    extends AudioFloatConverter {
        private AudioFloatConversion16SL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int len = out_offset + out_len;
            for (int ox = out_offset; ox < len; ++ox) {
                out_buff[ox] = (float)((short)(in_buff[ix++] & 0xFF | in_buff[ix++] << 8)) * 3.051851E-5f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ox = out_offset;
            int len = in_offset + in_len;
            for (int ix = in_offset; ix < len; ++ix) {
                int x = (int)((double)in_buff[ix] * 32767.0);
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion8U
    extends AudioFloatConverter {
        private AudioFloatConversion8U() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                out_buff[ox++] = (float)((in_buff[ix++] & 0xFF) - 127) * 0.007874016f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                out_buff[ox++] = (byte)(127.0f + in_buff[ix++] * 127.0f);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion8S
    extends AudioFloatConverter {
        private AudioFloatConversion8S() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                out_buff[ox++] = (float)in_buff[ix++] * 0.007874016f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                out_buff[ox++] = (byte)(in_buff[ix++] * 127.0f);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32B
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        FloatBuffer floatbuffer = null;

        private AudioFloatConversion32B() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int in_len = out_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < in_len) {
                this.bytebuffer = ByteBuffer.allocate(in_len).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(in_buff, in_offset, in_len);
            this.floatbuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int out_len = in_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < out_len) {
                this.bytebuffer = ByteBuffer.allocate(out_len).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            this.floatbuffer.put(in_buff, in_offset, in_len);
            this.bytebuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }
    }

    private static class AudioFloatConversion32L
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        FloatBuffer floatbuffer = null;

        private AudioFloatConversion32L() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int in_len = out_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < in_len) {
                this.bytebuffer = ByteBuffer.allocate(in_len).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(in_buff, in_offset, in_len);
            this.floatbuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int out_len = in_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < out_len) {
                this.bytebuffer = ByteBuffer.allocate(out_len).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            this.floatbuffer.put(in_buff, in_offset, in_len);
            this.bytebuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }
    }
}

