/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.mixed.utils;

import org.apache.lucene.util.SloppyMath;

public class CircleUtils {
    static final int CIRCLE_TO_POLYGON_MINIMUM_NUMBER_OF_SIDES = 4;
    static final int CIRCLE_TO_POLYGON_MAXIMUM_NUMBER_OF_SIDES = 1000;

    private CircleUtils() {
    }

    public static double[][] createRegularGeoShapePolygon(double centerCenterLat, double circleCenterLon, double circleRadiusMeters, int gons) {
        if (SloppyMath.haversinMeters((double)centerCenterLat, (double)circleCenterLon, (double)90.0, (double)0.0) < circleRadiusMeters) {
            throw new IllegalArgumentException("circle [lat: " + centerCenterLat + " lon: " + circleCenterLon + " radius: " + circleRadiusMeters + "] contains the north pole. It cannot be translated to a polygon");
        }
        if (SloppyMath.haversinMeters((double)centerCenterLat, (double)circleCenterLon, (double)-90.0, (double)0.0) < circleRadiusMeters) {
            throw new IllegalArgumentException("circle [lat: " + centerCenterLat + " lon: " + circleCenterLon + " radius: " + circleRadiusMeters + "] contains the south pole. It cannot be translated to a polygon");
        }
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double lon;
            double lat;
            double angle = (double)i * (360.0 / (double)gons);
            double x = Math.cos(Math.toRadians(angle));
            double y = Math.sin(Math.toRadians(angle));
            double factor = 2.0;
            double step = 1.0;
            int last = 0;
            while (true) {
                double distanceMeters;
                if (Math.abs((distanceMeters = SloppyMath.haversinMeters((double)centerCenterLat, (double)circleCenterLon, (double)(lat = centerCenterLat + y * factor), (double)(lon = circleCenterLon + x * factor))) - circleRadiusMeters) < 0.1) break;
                if (distanceMeters > circleRadiusMeters) {
                    factor -= step;
                    if (last == 1) {
                        step /= 2.0;
                    }
                    last = -1;
                    continue;
                }
                if (!(distanceMeters < circleRadiusMeters)) continue;
                factor += step;
                if (last == -1) {
                    step /= 2.0;
                }
                last = 1;
            }
            result[0][i] = lon;
            result[1][i] = lat;
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return result;
    }

    public static double[][] createRegularShapePolygon(double circleCenterX, double circleCenterY, double circleRadius, int gons) {
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double angle = (double)i * (360.0 / (double)gons);
            double x = circleRadius * Math.cos(Math.toRadians(angle));
            double y = circleRadius * Math.sin(Math.toRadians(angle));
            result[0][i] = x + circleCenterX;
            result[1][i] = y + circleCenterY;
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return result;
    }

    public static int circleToPolygonNumSides(double radiusMeters, double errorDistanceMeters) {
        int val = (int)Math.ceil(Math.PI * 2 / Math.acos(1.0 - errorDistanceMeters / radiusMeters));
        return Math.min(1000, Math.max(4, val));
    }
}

