/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import java.util.List;
import org.janusgraph.diskstorage.inmemory.InMemoryColumnValueStore;

public class InMemoryKeyColumnValueStoreFragmentationReport {
    private String name;
    private int numStores;
    private int numMultipageStores;
    private int totalPageCount;
    private int[] pageLevels;
    private int[] pageCounts;
    private int[] compressablePageLevels;
    private int[] compressablePageCounts;
    private int[] reductionLevels;
    private int[] reductionCounts;
    private int[] entryLevels;
    private int[] entryCounts;
    private int keysByteSize;
    private int numFragmentedStores;
    private int totalFragmentedPages;
    private int numCompressableStores;
    private int totalCompressablePages;
    private int totalAchievablePageReduction;
    private List<InMemoryColumnValueStore> storesToDefragment;

    private InMemoryKeyColumnValueStoreFragmentationReport(Builder builder) {
        this.setName(builder.name);
        this.setNumStores(builder.numStores);
        this.setNumMultipageStores(builder.numMultipageStores);
        this.setTotalPageCount(builder.totalPageCount);
        this.setPageLevels(builder.pageLevels);
        this.setPageCounts(builder.pageCounts);
        this.setCompressablePageLevels(builder.compressablePageLevels);
        this.setCompressablePageCounts(builder.compressablePageCounts);
        this.setReductionLevels(builder.reductionLevels);
        this.setReductionCounts(builder.reductionCounts);
        this.setEntryLevels(builder.entryLevels);
        this.setEntryCounts(builder.entryCounts);
        this.setKeysByteSize(builder.keysByteSize);
        this.setNumFragmentedStores(builder.numFragmentedStores);
        this.setTotalFragmentedPages(builder.totalFragmentedPages);
        this.setNumCompressableStores(builder.numCompressableStores);
        this.setTotalCompressablePages(builder.totalCompressablePages);
        this.setTotalAchievablePageReduction(builder.totalAchievablePageReduction);
        this.setStoresToDefragment(builder.storesToDefragment);
    }

    public List<InMemoryColumnValueStore> getStoresToDefragment() {
        return this.storesToDefragment;
    }

    public void setStoresToDefragment(List<InMemoryColumnValueStore> storesToDefragment) {
        this.storesToDefragment = storesToDefragment;
    }

    public int getTotalAchievablePageReduction() {
        return this.totalAchievablePageReduction;
    }

    public void setTotalAchievablePageReduction(int totalAchievablePageReduction) {
        this.totalAchievablePageReduction = totalAchievablePageReduction;
    }

    public int[] getReductionCounts() {
        return this.reductionCounts;
    }

    public void setReductionCounts(int[] reductionCounts) {
        this.reductionCounts = reductionCounts;
    }

    public int[] getReductionLevels() {
        return this.reductionLevels;
    }

    public void setReductionLevels(int[] reductionLevels) {
        this.reductionLevels = reductionLevels;
    }

    public int getNumMultipageStores() {
        return this.numMultipageStores;
    }

    public void setNumMultipageStores(int numMultipageStores) {
        this.numMultipageStores = numMultipageStores;
    }

    public int getNumStores() {
        return this.numStores;
    }

    public void setNumStores(int numStores) {
        this.numStores = numStores;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String storeName) {
        this.name = storeName;
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    public void setTotalPageCount(int totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    public int[] getPageLevels() {
        return this.pageLevels;
    }

    public void setPageLevels(int[] pageLevels) {
        this.pageLevels = pageLevels;
    }

    public int[] getPageCounts() {
        return this.pageCounts;
    }

    public void setPageCounts(int[] pageCounts) {
        this.pageCounts = pageCounts;
    }

    public int[] getCompressablePageLevels() {
        return this.compressablePageLevels;
    }

    public void setCompressablePageLevels(int[] compressablePageLevels) {
        this.compressablePageLevels = compressablePageLevels;
    }

    public int[] getCompressablePageCounts() {
        return this.compressablePageCounts;
    }

    public void setCompressablePageCounts(int[] compressablePageCounts) {
        this.compressablePageCounts = compressablePageCounts;
    }

    public int[] getEntryLevels() {
        return this.entryLevels;
    }

    public void setEntryLevels(int[] entryLevels) {
        this.entryLevels = entryLevels;
    }

    public int[] getEntryCounts() {
        return this.entryCounts;
    }

    public void setEntryCounts(int[] entryCounts) {
        this.entryCounts = entryCounts;
    }

    public int getKeysByteSize() {
        return this.keysByteSize;
    }

    public void setKeysByteSize(int keysByteSize) {
        this.keysByteSize = keysByteSize;
    }

    public int getNumFragmentedStores() {
        return this.numFragmentedStores;
    }

    public void setNumFragmentedStores(int numFragmentedStores) {
        this.numFragmentedStores = numFragmentedStores;
    }

    public int getTotalFragmentedPages() {
        return this.totalFragmentedPages;
    }

    public void setTotalFragmentedPages(int totalFragmentedPages) {
        this.totalFragmentedPages = totalFragmentedPages;
    }

    public int getNumCompressableStores() {
        return this.numCompressableStores;
    }

    public void setNumCompressableStores(int numCompressableStores) {
        this.numCompressableStores = numCompressableStores;
    }

    public int getTotalCompressablePages() {
        return this.totalCompressablePages;
    }

    public void setTotalCompressablePages(int totalCompressablePages) {
        this.totalCompressablePages = totalCompressablePages;
    }

    private void printHistogram(StringBuilder sb, int[] levels, int[] counts) {
        int i;
        for (i = 0; i < levels.length; ++i) {
            if (counts[i] <= 0) continue;
            sb.append("<=").append(levels[i]).append(": ").append(counts[i]).append("; ");
        }
        if (counts[i] > 0) {
            sb.append(">").append(levels[i - 1]).append(": ").append(counts[i]).append("; ").append(System.lineSeparator());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        sb.append("KCVS name: ").append(this.name).append(System.lineSeparator());
        sb.append("Total number of CVS: ").append(this.numStores).append(System.lineSeparator());
        sb.append("Total number of multi-page CVS: ").append(this.numMultipageStores).append(System.lineSeparator());
        sb.append("Total number of pages: ").append(this.totalPageCount).append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Number of fragmented CVS: ").append(this.numFragmentedStores).append(System.lineSeparator());
        sb.append("Total number of fragmented pages: ").append(this.totalFragmentedPages).append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Number of compressible CVS: ").append(this.numCompressableStores).append(System.lineSeparator());
        sb.append("Total number of compressible pages: ").append(this.totalCompressablePages).append(System.lineSeparator());
        sb.append("Total achievable page reduction: ").append(this.totalAchievablePageReduction).append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Total row keys bytesize: ").append(this.keysByteSize).append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Number of CVS by #entries: ").append(System.lineSeparator());
        this.printHistogram(sb, this.entryLevels, this.entryCounts);
        sb.append(System.lineSeparator());
        sb.append("Number of CVS by #pages: ").append(System.lineSeparator());
        this.printHistogram(sb, this.pageLevels, this.pageCounts);
        sb.append(System.lineSeparator());
        sb.append("Number of CVS by #compressable pages: ").append(System.lineSeparator());
        this.printHistogram(sb, this.compressablePageLevels, this.compressablePageCounts);
        sb.append(System.lineSeparator());
        sb.append("Number of CVS by achievable page reduction: ").append(System.lineSeparator());
        this.printHistogram(sb, this.reductionLevels, this.reductionCounts);
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public static final class Builder {
        private String name;
        private int numStores;
        private int numMultipageStores;
        private int totalPageCount;
        private int[] pageLevels;
        private int[] pageCounts;
        private int[] compressablePageLevels;
        private int[] compressablePageCounts;
        private int[] reductionLevels;
        private int[] reductionCounts;
        private int[] entryLevels;
        private int[] entryCounts;
        private int keysByteSize;
        private int numFragmentedStores;
        private int totalFragmentedPages;
        private int numCompressableStores;
        private int totalCompressablePages;
        private int totalAchievablePageReduction;
        private List<InMemoryColumnValueStore> storesToDefragment;

        public Builder name(String val) {
            this.name = val;
            return this;
        }

        public Builder numStores(int val) {
            this.numStores = val;
            return this;
        }

        public Builder numMultipageStores(int val) {
            this.numMultipageStores = val;
            return this;
        }

        public Builder totalPageCount(int val) {
            this.totalPageCount = val;
            return this;
        }

        public Builder pageLevels(int[] val) {
            this.pageLevels = val;
            return this;
        }

        public Builder pageCounts(int[] val) {
            this.pageCounts = val;
            return this;
        }

        public Builder compressablePageLevels(int[] val) {
            this.compressablePageLevels = val;
            return this;
        }

        public Builder compressablePageCounts(int[] val) {
            this.compressablePageCounts = val;
            return this;
        }

        public Builder reductionLevels(int[] val) {
            this.reductionLevels = val;
            return this;
        }

        public Builder reductionCounts(int[] val) {
            this.reductionCounts = val;
            return this;
        }

        public Builder entryLevels(int[] val) {
            this.entryLevels = val;
            return this;
        }

        public Builder entryCounts(int[] val) {
            this.entryCounts = val;
            return this;
        }

        public Builder keysByteSize(int val) {
            this.keysByteSize = val;
            return this;
        }

        public Builder numFragmentedStores(int val) {
            this.numFragmentedStores = val;
            return this;
        }

        public Builder totalFragmentedPages(int val) {
            this.totalFragmentedPages = val;
            return this;
        }

        public Builder numCompressableStores(int val) {
            this.numCompressableStores = val;
            return this;
        }

        public Builder totalCompressablePages(int val) {
            this.totalCompressablePages = val;
            return this;
        }

        public Builder totalAchievablePageReduction(int val) {
            this.totalAchievablePageReduction = val;
            return this;
        }

        public Builder storesToDefragment(List<InMemoryColumnValueStore> val) {
            this.storesToDefragment = val;
            return this;
        }

        public InMemoryKeyColumnValueStoreFragmentationReport build() {
            return new InMemoryKeyColumnValueStoreFragmentationReport(this);
        }
    }
}

