/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.inmemory.BufferPage;
import org.janusgraph.diskstorage.inmemory.MultiPageEntryBuffer;
import org.janusgraph.diskstorage.inmemory.SharedEntryBuffer;
import org.janusgraph.diskstorage.inmemory.SinglePageEntryBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferPageUtils {
    private static final Logger log = LoggerFactory.getLogger(BufferPageUtils.class);

    public static BufferPage readPage(DataInputStream in) throws IOException {
        int numEntries = in.readInt();
        if (log.isDebugEnabled()) {
            log.debug("page numentries is " + numEntries);
        }
        if (numEntries > 0) {
            int[] index = new int[numEntries];
            for (int i = 0; i < index.length; ++i) {
                index[i] = in.readInt();
            }
            int dataLength = in.readInt();
            if (log.isDebugEnabled()) {
                log.debug("page data size is " + dataLength);
            }
            byte[] data = new byte[dataLength];
            BufferPageUtils.readWholeArray(in, data);
            return new BufferPage(index, data);
        }
        return new BufferPage(BufferPage.EMPTY_INDEX, BufferPage.EMPTY_DATA);
    }

    public static void readWholeArray(DataInputStream in, byte[] data) throws IOException {
        int bytesRead;
        int offset = 0;
        do {
            if ((bytesRead = in.read(data, offset, data.length - offset)) >= 0) continue;
            throw new IllegalStateException("Premature end of file while reading, expected to read " + data.length);
        } while ((offset += bytesRead) < data.length);
    }

    public static SharedEntryBuffer readFrom(DataInputStream in) throws IOException {
        int numPages = in.readInt();
        if (log.isDebugEnabled()) {
            log.debug("number of pages in column store is " + numPages);
        }
        if (numPages == 1) {
            BufferPage p = BufferPageUtils.readPage(in);
            return new SinglePageEntryBuffer(p.getOffsetIndex(), p.getRawData());
        }
        ArrayList<BufferPage> pages = new ArrayList<BufferPage>(numPages);
        for (int i = 0; i < numPages; ++i) {
            BufferPage p = BufferPageUtils.readPage(in);
            pages.add(p);
        }
        return new MultiPageEntryBuffer(pages);
    }

    static int computeValPosSize(int valuePosition) {
        return valuePosition > 127 ? 4 : 1;
    }

    static int writeValPos(Entry e, byte[] rawData, int offset) {
        if (e.getValuePosition() <= 127) {
            byte entryValPos;
            rawData[offset] = entryValPos = (byte)e.getValuePosition();
            return 1;
        }
        ByteBuffer.wrap(rawData, offset, 4).order(ByteOrder.BIG_ENDIAN).asIntBuffer().put(-e.getValuePosition());
        return 4;
    }

    public static BufferPage buildFromEntryArray(Entry[] array, int start, int end) {
        Preconditions.checkArgument((start >= 0 && end <= array.length ? 1 : 0) != 0);
        int size = end - start;
        int[] offsetIndex = new int[size];
        int rawSize = 0;
        for (int i = 0; i < size; ++i) {
            offsetIndex[i] = rawSize;
            rawSize += array[start + i].length() + BufferPageUtils.computeValPosSize(array[start + i].getValuePosition());
        }
        byte[] rawData = new byte[rawSize];
        for (int i = 0; i < size; ++i) {
            int valPosSize = BufferPageUtils.writeValPos(array[start + i], rawData, offsetIndex[i]);
            if (array[start + i] instanceof StaticArrayBuffer) {
                StaticArrayBuffer arrayBuffer = (StaticArrayBuffer)array[start + i];
                arrayBuffer.copyTo(rawData, offsetIndex[i] + valPosSize);
                continue;
            }
            byte[] entryData = array[start + i].getBytes(0, array[start + i].length());
            System.arraycopy(entryData, 0, rawData, offsetIndex[i] + valPosSize, entryData.length);
        }
        return new BufferPage(offsetIndex, rawData);
    }

    public static BufferPage buildFromEntryArray(Entry[] array, int size) {
        return BufferPageUtils.buildFromEntryArray(array, 0, size);
    }

    public static void dumpTo(BufferPage page, DataOutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("page index numEntries is " + page.getOffsetIndex().length + ", byte size is " + page.getOffsetIndex().length * 4);
        }
        out.writeInt(page.getOffsetIndex().length);
        if (page.getOffsetIndex().length > 0) {
            for (int i : page.getOffsetIndex()) {
                out.writeInt(i);
            }
            out.writeInt(page.getRawData().length);
            out.write(page.getRawData());
            if (log.isDebugEnabled()) {
                log.debug("page data length is " + page.getRawData().length + ", byte size is " + page.getRawData().length * 4);
            }
        }
    }
}

