/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.inmemory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.inmemory.BufferPage;
import org.janusgraph.diskstorage.inmemory.BufferPageUtils;
import org.janusgraph.diskstorage.inmemory.MultiPageEntryBuffer;
import org.janusgraph.diskstorage.inmemory.SharedEntryBuffer;
import org.janusgraph.diskstorage.inmemory.SharedEntryBufferFragmentationReport;
import org.janusgraph.diskstorage.inmemory.SinglePageEntryBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.NoLock;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

class InMemoryColumnValueStore {
    static final int DEF_PAGE_SIZE = 500;
    private SharedEntryBuffer buffer = new SinglePageEntryBuffer();
    private volatile ReentrantLock lock = null;

    public int getMaxPageSize() {
        return 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty(StoreTransaction txh) {
        Lock lock = this.getLock(txh);
        lock.lock();
        try {
            boolean bl = this.buffer.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntryList getSlice(KeySliceQuery query, StoreTransaction txh) {
        Lock lock = this.getLock(txh);
        lock.lock();
        try {
            EntryList entryList = this.buffer.getSlice(query);
            return entryList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void mutate(List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) {
        Object[] del;
        Object[] add;
        if (!additions.isEmpty()) {
            add = new Entry[additions.size()];
            int pos = 0;
            for (Entry e : additions) {
                add[pos] = e;
                ++pos;
            }
            Arrays.sort(add);
        } else {
            add = new Entry[]{};
        }
        if (!deletions.isEmpty()) {
            del = new Entry[deletions.size()];
            int pos = 0;
            for (StaticBuffer deletion : deletions) {
                Entry delEntry = StaticArrayEntry.of((StaticBuffer)deletion);
                if (Arrays.binarySearch(add, delEntry) >= 0) continue;
                del[pos++] = delEntry;
            }
            if (pos < deletions.size()) {
                del = (Entry[])Arrays.copyOf(del, pos);
            }
            Arrays.sort(del);
        } else {
            del = new Entry[]{};
        }
        Lock lock = this.getLock(txh);
        lock.lock();
        try {
            this.buffer.mutate((Entry[])add, (Entry[])del, this.getMaxPageSize());
            if (!this.buffer.isPaged() && this.buffer.numEntries() > this.getMaxPageSize()) {
                this.buffer = new MultiPageEntryBuffer((BufferPage)((Object)this.buffer));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getLock(StoreTransaction txh) {
        Boolean txOn = (Boolean)txh.getConfiguration().getCustomOption(GraphDatabaseConfiguration.STORAGE_TRANSACTIONAL);
        if (null != txOn && txOn.booleanValue()) {
            ReentrantLock result = this.lock;
            if (result == null) {
                InMemoryColumnValueStore inMemoryColumnValueStore = this;
                synchronized (inMemoryColumnValueStore) {
                    result = this.lock;
                    if (result == null) {
                        this.lock = result = new ReentrantLock();
                    }
                }
            }
            return result;
        }
        return NoLock.INSTANCE;
    }

    public int numPages(StoreTransaction txh) {
        this.lock.lock();
        try {
            int n = this.buffer.numPages();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int numEntries(StoreTransaction txh) {
        this.lock.lock();
        try {
            int n = this.buffer.numEntries();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SharedEntryBufferFragmentationReport createFragmentationReport(StoreTransaction txh) {
        this.lock.lock();
        try {
            SharedEntryBufferFragmentationReport sharedEntryBufferFragmentationReport = this.buffer.createFragmentationReport(this.getMaxPageSize());
            return sharedEntryBufferFragmentationReport;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void quickDefragment(StoreTransaction txh) {
        this.lock.lock();
        try {
            this.buffer.quickDefragment(this.getMaxPageSize());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void dumpTo(DataOutputStream out) throws IOException {
        this.lock.lock();
        try {
            this.buffer.dumpTo(out);
        }
        finally {
            this.lock.unlock();
        }
    }

    public static InMemoryColumnValueStore readFrom(DataInputStream in) throws IOException {
        InMemoryColumnValueStore store = new InMemoryColumnValueStore();
        store.buffer = BufferPageUtils.readFrom(in);
        return store;
    }

    private static class MemoryEntryList
    extends ArrayList<Entry>
    implements EntryList {
        public MemoryEntryList(int size) {
            super(size);
        }

        public Iterator<Entry> reuseIterator() {
            return this.iterator();
        }

        public int getByteSize() {
            int size = 48;
            for (Entry e : this) {
                size += 40 + e.length();
            }
            return size;
        }
    }
}

