/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.EntryArrayList;
import org.janusgraph.hadoop.compat.HadoopCompatLoader;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.config.ModifiableHadoopConfiguration;
import org.janusgraph.hadoop.scan.HadoopContextScanMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopScanMapper
extends Mapper<StaticBuffer, Iterable<Entry>, NullWritable, NullWritable> {
    private static final Logger log = LoggerFactory.getLogger(HadoopScanMapper.class);
    protected ScanJob job;
    protected HadoopContextScanMetrics metrics;
    protected Configuration jobConf;
    private Predicate<StaticBuffer> keyFilter;
    private SliceQuery initialQuery;
    private List<SliceQuery> subsequentQueries;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
        ModifiableHadoopConfiguration scanConf = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, hadoopConf);
        this.job = this.getJob((Configuration)scanConf);
        this.metrics = new HadoopContextScanMetrics((TaskInputOutputContext)context);
        ModifiableConfiguration graphConf = HadoopScanMapper.getJanusGraphConfiguration(context);
        this.finishSetup(scanConf, (Configuration)graphConf);
    }

    protected void finishSetup(ModifiableHadoopConfiguration scanConf, Configuration graphConf) {
        this.jobConf = HadoopScanMapper.getJobConfiguration(scanConf);
        Preconditions.checkNotNull((Object)this.metrics);
        Preconditions.checkNotNull((Object)this.job);
        this.job.workerIterationStart(this.jobConf, graphConf, (ScanMetrics)this.metrics);
        this.keyFilter = this.job.getKeyFilter();
        List sliceQueries = this.job.getQueries();
        Preconditions.checkArgument((null != sliceQueries ? 1 : 0) != 0, (Object)"Job cannot specify null query list");
        Preconditions.checkArgument((0 < sliceQueries.size() ? 1 : 0) != 0, (Object)"Job must specify at least one query");
        this.initialQuery = (SliceQuery)sliceQueries.get(0);
        this.subsequentQueries = new ArrayList<SliceQuery>(sliceQueries.subList(1, sliceQueries.size()));
        Preconditions.checkState((sliceQueries.size() == this.subsequentQueries.size() + 1 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.initialQuery);
        if (0 < this.subsequentQueries.size()) {
            StaticBuffer start = this.initialQuery.getSliceStart();
            Preconditions.checkArgument((boolean)start.equals(BufferUtil.zeroBuffer((int)1)), (String)"Expected start of first query to be all 0s: %s", (Object[])new Object[]{start});
            StaticBuffer end = this.initialQuery.getSliceEnd();
            Preconditions.checkArgument((boolean)end.equals(BufferUtil.oneBuffer((int)end.length())), (String)"Expected end of first query to be all 1s: %s", (Object[])new Object[]{end});
        }
    }

    protected void map(StaticBuffer key, Iterable<Entry> values, Mapper.Context context) throws IOException, InterruptedException {
        EntryArrayList al = EntryArrayList.of(values);
        if (!this.keyFilter.test(key)) {
            log.debug("Skipping key {} based on KeyFilter", (Object)key);
            return;
        }
        EntryList initialQueryMatches = this.findEntriesMatchingQuery(this.initialQuery, (EntryList)al);
        if (0 == initialQueryMatches.size()) {
            log.debug("Skipping key {} based on InitialQuery ({}) match failure", (Object)key, (Object)this.initialQuery);
            return;
        }
        HashMap<SliceQuery, EntryList> matches = new HashMap<SliceQuery, EntryList>();
        matches.put(this.initialQuery, initialQueryMatches);
        for (SliceQuery sq : this.subsequentQueries) {
            matches.put(sq, this.findEntriesMatchingQuery(sq, (EntryList)al));
        }
        this.job.process(key, matches, (ScanMetrics)this.metrics);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        this.job.workerIterationEnd((ScanMetrics)this.metrics);
    }

    private EntryList findEntriesMatchingQuery(SliceQuery query, EntryList sortedEntries) {
        Entry midVal;
        int mid;
        int lowestStartMatch = sortedEntries.size();
        int highestEndMatch = -1;
        StaticBuffer queryStart = query.getSliceStart();
        StaticBuffer queryEnd = query.getSliceEnd();
        int low = 0;
        int high = sortedEntries.size() - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            midVal = (Entry)sortedEntries.get(mid);
            int cmpStart = queryStart.compareTo((Object)midVal.getColumn());
            if (0 < cmpStart) {
                if (lowestStartMatch == mid + 1) break;
                low = mid + 1;
                continue;
            }
            if (mid < lowestStartMatch) {
                lowestStartMatch = mid;
            }
            high = mid - 1;
        }
        if (sortedEntries.size() == lowestStartMatch) {
            return EntryList.EMPTY_LIST;
        }
        low = 0;
        high = sortedEntries.size() - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            midVal = (Entry)sortedEntries.get(mid);
            int cmpEnd = queryEnd.compareTo((Object)midVal.getColumn());
            if (0 < cmpEnd) {
                if (mid > highestEndMatch) {
                    highestEndMatch = mid;
                }
                low = mid + 1;
                continue;
            }
            if (highestEndMatch == mid - 1) break;
            high = mid - 1;
        }
        if (0 <= highestEndMatch - lowestStartMatch) {
            int endIndex = highestEndMatch + 1;
            if (query.hasLimit()) {
                endIndex = Math.min(endIndex, query.getLimit() + lowestStartMatch);
            }
            return EntryArrayList.of((Iterable)sortedEntries.subList(lowestStartMatch, endIndex));
        }
        return EntryList.EMPTY_LIST;
    }

    private ScanJob getJob(Configuration scanConf) {
        String jobClass = (String)scanConf.get(JanusGraphHadoopConfiguration.SCAN_JOB_CLASS, new String[0]);
        try {
            return (ScanJob)Class.forName(jobClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static ModifiableConfiguration getJanusGraphConfiguration(Mapper.Context context) {
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
        return ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, hadoopConf).getJanusGraphConf();
    }

    static Configuration getJobConfiguration(ModifiableHadoopConfiguration scanConf) {
        if (!scanConf.has(JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_ROOT, new String[0])) {
            log.debug("No job configuration root provided");
            return null;
        }
        ConfigNamespace jobRoot = HadoopScanMapper.getJobRoot((String)scanConf.get(JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_ROOT, new String[0]));
        return ModifiableHadoopConfiguration.prefixView(jobRoot, JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, scanConf);
    }

    static ConfigNamespace getJobRoot(String confRootName) {
        String[] tokens = confRootName.split("#");
        String className = tokens[0];
        String fieldName = tokens[1];
        try {
            Field f = Class.forName(className).getField(fieldName);
            return (ConfigNamespace)f.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

