/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import java.util.stream.Stream;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonIgnoreProperties;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonProperty;
import org.janusgraph.diskstorage.es.ElasticSearchResponse;
import org.janusgraph.diskstorage.es.rest.RestSearchResults;
import org.janusgraph.diskstorage.indexing.RawQuery;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RestSearchResponse
extends ElasticSearchResponse {
    private long took;
    @JsonProperty(value="hits")
    private RestSearchResults hits;
    @JsonProperty(value="_scroll_id")
    private String scrollId;

    @Override
    public long getTook() {
        return this.took;
    }

    @Override
    public void setTook(long took) {
        this.took = took;
    }

    public RestSearchResults getHits() {
        return this.hits;
    }

    public void setHits(RestSearchResults hits) {
        this.hits = hits;
    }

    public int getNumHits() {
        return this.hits.getHits().size();
    }

    public Float getMaxScore() {
        return this.hits.getMaxScore();
    }

    @Override
    public Stream<RawQuery.Result<String>> getResults() {
        return this.hits.getHits().stream().map(hit -> new RawQuery.Result((Object)hit.getId(), hit.getScore() != null ? (double)hit.getScore().floatValue() : 0.0));
    }

    @Override
    public int numResults() {
        return this.hits.getHits().size();
    }

    @Override
    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }
}

