/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectReader;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectWriter;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.janusgraph.core.attribute.JtsGeoshapeHelper;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class Geoshape {
    private static final String FIELD_LABEL = "geometry";
    private static final String FIELD_TYPE = "type";
    public static final String FIELD_COORDINATES = "coordinates";
    private static final double MAX_LONGITUDE = 180.0;
    private static final double MAX_LATITUDE = 90.0;
    public static final JtsGeoshapeHelper HELPER = new JtsGeoshapeHelper();
    private static final ObjectReader mapReader;
    public static final ObjectWriter mapWriter;
    private final Shape shape;

    protected Geoshape(Shape shape) {
        this.shape = (Shape)Preconditions.checkNotNull((Object)shape, (Object)"Invalid shape (null)");
    }

    public int hashCode() {
        return this.shape.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        Geoshape oth = (Geoshape)other;
        return this.shape.equals((Object)oth.shape);
    }

    public String toString() {
        return HELPER.getWktWriter().toString(this.shape);
    }

    public String toGeoJson() {
        return GeoshapeGsonSerializerV2d0.toGeoJson(this);
    }

    public Map<String, Object> toMap() throws IOException {
        return (Map)mapReader.readValue(this.toGeoJson());
    }

    public Shape getShape() {
        return this.shape;
    }

    public Type getType() {
        return HELPER.getType(this.shape);
    }

    public int size() {
        return HELPER.size(this.shape);
    }

    public Point getPoint(int position) {
        return HELPER.getPoint(this, position);
    }

    public Point getPoint() {
        Preconditions.checkArgument((this.getType() == Type.POINT || this.getType() == Type.CIRCLE ? 1 : 0) != 0, (Object)"Shape does not have a single point");
        return new Point(this.shape.getCenter().getY(), this.shape.getCenter().getX());
    }

    public double getRadius() {
        Preconditions.checkArgument((this.getType() == Type.CIRCLE ? 1 : 0) != 0, (Object)"This shape is not a circle");
        double radiusInDeg = ((Circle)this.shape).getRadius();
        return DistanceUtils.degrees2Dist((double)radiusInDeg, (double)6371.0087714);
    }

    public double getRadiusMeters() {
        return this.getRadius() * 1000.0;
    }

    private SpatialRelation getSpatialRelation(Geoshape other) {
        Preconditions.checkNotNull((Object)other);
        return this.shape.relate(other.shape);
    }

    public boolean intersect(Geoshape other) {
        SpatialRelation r = this.getSpatialRelation(other);
        return r == SpatialRelation.INTERSECTS || r == SpatialRelation.CONTAINS || r == SpatialRelation.WITHIN;
    }

    public boolean within(Geoshape outer) {
        return this.getSpatialRelation(outer) == SpatialRelation.WITHIN;
    }

    public boolean contains(Geoshape outer) {
        return this.getSpatialRelation(outer) == SpatialRelation.CONTAINS;
    }

    public boolean disjoint(Geoshape other) {
        return this.getSpatialRelation(other) == SpatialRelation.DISJOINT;
    }

    public static Geoshape point(double latitude, double longitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        return new Geoshape((Shape)Geoshape.getShapeFactory().pointXY(longitude, latitude));
    }

    public static Geoshape circle(double latitude, double longitude, double radiusInKM) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        Preconditions.checkArgument((radiusInKM > 0.0 ? 1 : 0) != 0, (String)"Invalid radius provided [%s]", (Object)radiusInKM);
        return new Geoshape((Shape)Geoshape.getShapeFactory().circle(longitude, latitude, DistanceUtils.dist2Degrees((double)radiusInKM, (double)6371.0087714)));
    }

    public static Geoshape box(double southWestLatitude, double southWestLongitude, double northEastLatitude, double northEastLongitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(southWestLatitude, southWestLongitude), (Object)"Invalid south-west coordinate provided");
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(northEastLatitude, northEastLongitude), (Object)"Invalid north-east coordinate provided");
        return new Geoshape((Shape)Geoshape.getShapeFactory().rect(southWestLongitude, northEastLongitude, southWestLatitude, northEastLatitude));
    }

    public static Geoshape line(List<double[]> coordinates) {
        Preconditions.checkArgument((coordinates.size() >= 2 ? 1 : 0) != 0, (Object)"Too few coordinate pairs provided");
        ShapeFactory.LineStringBuilder builder = Geoshape.getShapeFactory().lineString();
        for (double[] coordinate : coordinates) {
            Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(coordinate[1], coordinate[0]), (Object)"Invalid coordinate provided");
            builder.pointXY(coordinate[0], coordinate[1]);
        }
        return new Geoshape(builder.build());
    }

    public static Geoshape polygon(List<double[]> coordinates) {
        return HELPER.polygon(coordinates);
    }

    public static Geoshape geoshape(Shape shape) {
        return new Geoshape(shape);
    }

    public static Geoshape fromWkt(String wkt) throws ParseException {
        return new Geoshape(HELPER.getWktReader().parse(wkt));
    }

    public static boolean isValidCoordinate(double latitude, double longitude) {
        return latitude >= -90.0 && latitude <= 90.0 && longitude >= -180.0 && longitude <= 180.0;
    }

    public static SpatialContext getSpatialContext() {
        return HELPER.getContext();
    }

    public static ShapeFactory getShapeFactory() {
        return Geoshape.getSpatialContext().getShapeFactory();
    }

    public static ShapeFactory.MultiShapeBuilder<Shape> getGeometryCollectionBuilder() {
        return Geoshape.getShapeFactory().multiShape(Shape.class);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapReader = mapper.readerWithView(LinkedHashMap.class).forType(LinkedHashMap.class);
        mapWriter = mapper.writerWithView(Map.class);
    }

    public static class GeoshapeBinarySerializer {
        public static void write(OutputStream outputStream, Geoshape attribute) throws IOException {
            try (DataOutputStream dataOutput = new DataOutputStream(outputStream);){
                HELPER.write(dataOutput, attribute);
                dataOutput.flush();
            }
            outputStream.flush();
        }

        public static Geoshape read(InputStream inputStream) throws IOException {
            try (DataInputStream dataInput = new DataInputStream(inputStream);){
                Geoshape geoshape = new Geoshape(HELPER.readShape(dataInput));
                return geoshape;
            }
        }
    }

    public static class GeoshapeGsonDeserializerV2d0
    extends AbstractObjectDeserializer<Geoshape> {
        public GeoshapeGsonDeserializerV2d0() {
            super(Geoshape.class);
        }

        public Geoshape createObject(Map<String, Object> data) {
            Geoshape shape;
            if (data.containsKey(Geoshape.FIELD_COORDINATES) && data.get(Geoshape.FIELD_COORDINATES) instanceof List) {
                List coordinates = (List)data.get(Geoshape.FIELD_COORDINATES);
                if (coordinates.size() < 2) {
                    throw new RuntimeException("Expecting two coordinates when reading point");
                }
                shape = Geoshape.point(((Number)coordinates.get(1)).doubleValue(), ((Number)coordinates.get(0)).doubleValue());
            } else {
                try {
                    String json = mapWriter.writeValueAsString(data.get(Geoshape.FIELD_LABEL));
                    shape = new Geoshape(HELPER.getGeojsonReader().read((Reader)new StringReader(json)));
                }
                catch (IOException | ParseException e) {
                    throw new RuntimeException("I/O exception reading geoshape", e);
                }
            }
            return shape;
        }
    }

    public static class GeoshapeGsonSerializerV2d0
    extends GeoshapeGsonSerializerV1d0 {
        @Override
        public void serializeWithType(Geoshape geoshape, JsonGenerator jgen, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jgen.writeStartObject();
            if (typeSerializer != null) {
                jgen.writeStringField("@type", "janusgraph:Geoshape");
            }
            jgen.writeFieldName("@value");
            GraphSONUtil.writeStartObject((Object)geoshape, (JsonGenerator)jgen, (TypeSerializer)typeSerializer);
            Map json = (Map)mapReader.readValue(GeoshapeGsonSerializerV2d0.toGeoJson(geoshape));
            if (geoshape.getType() == Type.POINT) {
                double[] coordinates = ((List)json.get(Geoshape.FIELD_COORDINATES)).stream().mapToDouble(Number::doubleValue).toArray();
                GraphSONUtil.writeWithType((String)Geoshape.FIELD_COORDINATES, (Object)coordinates, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            } else {
                GraphSONUtil.writeWithType((String)Geoshape.FIELD_LABEL, (Object)json, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            }
            GraphSONUtil.writeEndObject((Object)geoshape, (JsonGenerator)jgen, (TypeSerializer)typeSerializer);
            jgen.writeEndObject();
        }

        public static String toGeoJson(Geoshape geoshape) {
            return HELPER.getGeojsonWriter().toString(geoshape.shape);
        }
    }

    public static class GeoshapeGsonDeserializerV1d0
    extends StdDeserializer<Geoshape> {
        public GeoshapeGsonDeserializerV1d0() {
            super(Geoshape.class);
        }

        public Geoshape deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            jsonParser.nextToken();
            if (jsonParser.getCurrentName().equals(Geoshape.FIELD_COORDINATES)) {
                double[] f = (double[])jsonParser.readValueAs(double[].class);
                jsonParser.nextToken();
                return Geoshape.point(f[1], f[0]);
            }
            try {
                HashMap map = (HashMap)jsonParser.readValueAs(LinkedHashMap.class);
                jsonParser.nextToken();
                String json = mapWriter.writeValueAsString((Object)map);
                return new Geoshape(HELPER.getGeojsonReader().read((Reader)new StringReader(json)));
            }
            catch (ParseException e) {
                throw new IOException("Unable to read and parse geojson", e);
            }
        }
    }

    public static class GeoshapeGsonSerializerV1d0
    extends StdSerializer<Geoshape> {
        public GeoshapeGsonSerializerV1d0() {
            super(Geoshape.class);
        }

        public void serialize(Geoshape value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            switch (value.getType()) {
                case POINT: {
                    jgen.writeStartObject();
                    jgen.writeFieldName(Geoshape.FIELD_TYPE);
                    jgen.writeString(Type.POINT.toString());
                    jgen.writeFieldName(Geoshape.FIELD_COORDINATES);
                    jgen.writeStartArray();
                    jgen.writeNumber(value.getPoint().getLongitude());
                    jgen.writeNumber(value.getPoint().getLatitude());
                    jgen.writeEndArray();
                    jgen.writeEndObject();
                    break;
                }
                default: {
                    jgen.writeRawValue(GeoshapeGsonSerializerV1d0.toGeoJson(value));
                }
            }
        }

        public void serializeWithType(Geoshape geoshape, JsonGenerator jgen, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jgen.writeStartObject();
            if (typeSerializer != null) {
                jgen.writeStringField("@class", Geoshape.class.getName());
            }
            String geojson = GeoshapeGsonSerializerV1d0.toGeoJson(geoshape);
            Map json = (Map)mapReader.readValue(geojson);
            if (geoshape.getType() == Type.POINT) {
                double[] coords = ((List)json.get(Geoshape.FIELD_COORDINATES)).stream().map(Number::doubleValue).mapToDouble(i -> i).toArray();
                GraphSONUtil.writeWithType((String)Geoshape.FIELD_COORDINATES, (Object)coords, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            } else {
                GraphSONUtil.writeWithType((String)Geoshape.FIELD_LABEL, (Object)json, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            }
            jgen.writeEndObject();
        }

        public static String toGeoJson(Geoshape geoshape) {
            return HELPER.getGeojsonWriter().toString(geoshape.shape);
        }
    }

    public static class GeoShapeGryoSerializer
    extends Serializer<Geoshape> {
        public void write(Kryo kryo, Output output, Geoshape geoshape) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                GeoshapeBinarySerializer.write(outputStream, geoshape);
                byte[] bytes = outputStream.toByteArray();
                output.writeLong((long)bytes.length);
                output.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception writing geoshape", e);
            }
        }

        public Geoshape read(Kryo kryo, Input input, Class<Geoshape> aClass) {
            long l = input.readLong();
            assert (l > 0L && l < Integer.MAX_VALUE);
            int length = (int)l;
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(input.readBytes(length));
                return GeoshapeBinarySerializer.read(inputStream);
            }
            catch (IOException | KryoException e) {
                try {
                    input.setPosition(0);
                    input.readLong();
                    float lat = input.readFloat();
                    float lon = input.readFloat();
                    return Geoshape.point(lat, lon);
                }
                catch (KryoException kryoException) {
                    throw new RuntimeException("I/O exception reading geoshape", e);
                }
            }
        }
    }

    public static final class Point {
        private final double longitude;
        private final double latitude;

        Point(double latitude, double longitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        private org.locationtech.spatial4j.shape.Point getSpatial4jPoint() {
            return Geoshape.getShapeFactory().pointXY(this.longitude, this.latitude);
        }

        public double distance(Point other) {
            return DistanceUtils.degrees2Dist((double)HELPER.getContext().getDistCalc().distance(this.getSpatial4jPoint(), other.getSpatial4jPoint()), (double)6371.0087714);
        }
    }

    public static enum Type {
        POINT("Point"),
        BOX("Box"),
        CIRCLE("Circle"),
        LINE("Line"),
        POLYGON("Polygon"),
        MULTIPOINT("MultiPoint"),
        MULTILINESTRING("MultiLineString"),
        MULTIPOLYGON("MultiPolygon"),
        GEOMETRYCOLLECTION("GeometryCollection");

        private final String gsonName;

        private Type(String gsonName) {
            this.gsonName = gsonName;
        }

        public boolean gsonEquals(String otherGson) {
            return this.gsonName.equals(otherGson);
        }

        public static Type fromGson(String gsonShape) {
            return Type.valueOf(gsonShape.toUpperCase());
        }

        public String toString() {
            return this.gsonName;
        }
    }
}

