/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary.geoshape;

import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeoshapeTypeSerializer;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class BoxSerializer
extends GeoshapeTypeSerializer {
    public BoxSerializer() {
        super(2);
    }

    @Override
    public Geoshape readNonNullableGeoshapeValue(Buffer buffer, GraphBinaryReader context) {
        double minY = buffer.readDouble();
        double minX = buffer.readDouble();
        double maxY = buffer.readDouble();
        double maxX = buffer.readDouble();
        return Geoshape.box(minY, minX, maxY, maxX);
    }

    @Override
    public void writeNonNullableGeoshapeValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) {
        Shape shape = geoshape.getShape();
        Rectangle rect = (Rectangle)shape;
        buffer.writeDouble(rect.getMinY());
        buffer.writeDouble(rect.getMinX());
        buffer.writeDouble(rect.getMaxY());
        buffer.writeDouble(rect.getMaxX());
    }
}

