/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.GraphBinaryType;
import org.janusgraph.graphdb.tinkerpop.io.binary.JanusGraphTypeSerializer;

public class GeoshapeGraphBinarySerializer
extends JanusGraphTypeSerializer<Geoshape> {
    public GeoshapeGraphBinarySerializer() {
        super(GraphBinaryType.Geoshape);
    }

    @Override
    public Geoshape readNonNullableValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        BufferInputStream bufferOutputStream = new BufferInputStream(buffer);
        return Geoshape.GeoshapeBinarySerializer.read(bufferOutputStream);
    }

    @Override
    public void writeNonNullableValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) throws IOException {
        BufferOutputStream bufferOutputStream = new BufferOutputStream(buffer);
        Geoshape.GeoshapeBinarySerializer.write(bufferOutputStream, geoshape);
    }

    private static class BufferOutputStream
    extends OutputStream {
        private Buffer buffer;

        public BufferOutputStream(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int i) {
            this.buffer.writeInt(i);
        }
    }

    private static class BufferInputStream
    extends InputStream {
        private Buffer buffer;

        public BufferInputStream(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() {
            return this.buffer.readInt();
        }
    }
}

