/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import org.janusgraph.util.encoding.LongEncoding;

public final class RelationIdentifier
implements Serializable {
    public static final String TOSTRING_DELIMITER = "-";
    private final long outVertexId;
    private final long typeId;
    private final long relationId;
    private final long inVertexId;

    private RelationIdentifier() {
        this.outVertexId = 0L;
        this.typeId = 0L;
        this.relationId = 0L;
        this.inVertexId = 0L;
    }

    public RelationIdentifier(long outVertexId, long typeId, long relationId, long inVertexId) {
        this.outVertexId = outVertexId;
        this.typeId = typeId;
        this.relationId = relationId;
        this.inVertexId = inVertexId;
    }

    public long getRelationId() {
        return this.relationId;
    }

    public long getTypeId() {
        return this.typeId;
    }

    public long getOutVertexId() {
        return this.outVertexId;
    }

    public long getInVertexId() {
        Preconditions.checkState((this.inVertexId != 0L ? 1 : 0) != 0);
        return this.inVertexId;
    }

    public static RelationIdentifier get(long[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0L) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? ids[3] : 0L);
    }

    public static RelationIdentifier get(int[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? (long)ids[3] : 0L);
    }

    public long[] getLongRepresentation() {
        long[] r = new long[3 + (this.inVertexId != 0L ? 1 : 0)];
        r[0] = this.relationId;
        r[1] = this.outVertexId;
        r[2] = this.typeId;
        if (this.inVertexId != 0L) {
            r[3] = this.inVertexId;
        }
        return r;
    }

    public int hashCode() {
        return Long.hashCode(this.relationId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        RelationIdentifier oth = (RelationIdentifier)other;
        return this.relationId == oth.relationId && this.typeId == oth.typeId;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(LongEncoding.encode(this.relationId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.outVertexId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.typeId));
        if (this.inVertexId != 0L) {
            s.append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.inVertexId));
        }
        return s.toString();
    }

    public static RelationIdentifier parse(String id) {
        String[] elements = id.split(TOSTRING_DELIMITER);
        if (elements.length != 3 && elements.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + id);
        }
        try {
            return new RelationIdentifier(LongEncoding.decode(elements[1]), LongEncoding.decode(elements[2]), LongEncoding.decode(elements[0]), elements.length == 4 ? LongEncoding.decode(elements[3]) : 0L);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid id - each token expected to be a number", e);
        }
    }
}

