/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.service;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.QueryGroups;
import org.janusgraph.diskstorage.cql.function.slice.AsyncCQLMultiKeyMultiColumnFunction;
import org.janusgraph.diskstorage.cql.function.slice.AsyncCQLMultiKeySliceFunction;
import org.janusgraph.diskstorage.cql.function.slice.AsyncCQLSingleKeyMultiColumnFunction;
import org.janusgraph.diskstorage.cql.function.slice.AsyncCQLSingleKeySliceFunction;
import org.janusgraph.diskstorage.cql.query.MultiKeysMultiColumnQuery;
import org.janusgraph.diskstorage.cql.query.MultiKeysSingleSliceQuery;
import org.janusgraph.diskstorage.cql.query.SingleKeyMultiColumnQuery;
import org.janusgraph.diskstorage.cql.service.AsyncQueryExecutionService;
import org.janusgraph.diskstorage.cql.strategy.GroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.strategy.GroupedExecutionStrategyBuilder;
import org.janusgraph.diskstorage.cql.strategy.ResultFiller;
import org.janusgraph.diskstorage.cql.util.CQLSliceQueryUtil;
import org.janusgraph.diskstorage.cql.util.KeysGroup;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeysQueriesGroup;
import org.janusgraph.diskstorage.keycolumnvalue.MultiKeysQueryGroups;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.EntryArrayList;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupingAsyncQueryExecutionService
implements AsyncQueryExecutionService {
    private static final Logger log = LoggerFactory.getLogger(GroupingAsyncQueryExecutionService.class);
    private final ResultFiller<Map<StaticBuffer, CompletableFuture<EntryList>>, SliceQuery, KeysGroup> SINGLE_QUERY_WITH_KEYS_GROUPING_FILLER;
    private final ResultFiller<Map<StaticBuffer, CompletableFuture<EntryList>>, SliceQuery, List<StaticBuffer>> SINGLE_QUERY_WITHOUT_KEYS_GROUPING_FILLER;
    private final ResultFiller<Map<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>>, QueryGroups, KeysGroup> MULTI_QUERY_WITH_KEYS_GROUPING_FILLER;
    private final ResultFiller<Map<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>>, QueryGroups, List<StaticBuffer>> MULTI_QUERY_WITHOUT_KEYS_GROUPING_FILLER;
    private final AsyncCQLSingleKeySliceFunction cqlSingleKeySliceFunction;
    private final AsyncCQLSingleKeyMultiColumnFunction cqlSingleKeyMultiColumnFunction;
    private final AsyncCQLMultiKeySliceFunction cqlMultiKeySliceFunction;
    private final AsyncCQLMultiKeyMultiColumnFunction cqlMultiKeyMultiColumnFunction;
    private final boolean sliceGroupingAllowed;
    private final int sliceGroupingLimit;
    private final boolean keysGroupingAllowed;
    private final int keysGroupingLimit;
    private final int keysGroupingMin;
    private final GroupedExecutionStrategy groupedExecutionStrategy;

    public GroupingAsyncQueryExecutionService(Configuration configuration, CQLStoreManager storeManager, String tableName, Function<Select, Select> addTTLFunction, Function<Select, Select> addTimestampFunction, CQLColValGetter singleKeyGetter, CQLColValGetter multiKeysGetter) {
        this.sliceGroupingLimit = GroupingAsyncQueryExecutionService.getLimitOption(configuration, CQLConfigOptions.SLICE_GROUPING_LIMIT, 1);
        this.keysGroupingLimit = GroupingAsyncQueryExecutionService.getLimitOption(configuration, CQLConfigOptions.KEYS_GROUPING_LIMIT, 1);
        this.keysGroupingMin = GroupingAsyncQueryExecutionService.getLimitOption(configuration, CQLConfigOptions.KEYS_GROUPING_MIN, 2);
        this.keysGroupingAllowed = this.keysGroupingLimit > 1 && (Boolean)configuration.get(CQLConfigOptions.KEYS_GROUPING_ALLOWED, new String[0]) != false;
        this.sliceGroupingAllowed = this.sliceGroupingLimit > 1 && (Boolean)configuration.get(CQLConfigOptions.SLICE_GROUPING_ALLOWED, new String[0]) != false;
        String keyspaceName = storeManager.getKeyspaceName();
        CqlSession session = storeManager.getSession();
        ExecutorService executorService = storeManager.getExecutorService();
        QueryBackPressure queryBackPressure = storeManager.getQueriesBackPressure();
        Select getSliceSelect = ((Select)QueryBuilder.selectFrom((String)keyspaceName, (String)tableName).column("column1").column("value").where(new Relation[]{(Relation)Relation.column((String)"key").isEqualTo((Term)QueryBuilder.bindMarker((String)"key")), (Relation)Relation.column((String)"column1").isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)"sliceStart")), (Relation)Relation.column((String)"column1").isLessThan((Term)QueryBuilder.bindMarker((String)"sliceEnd"))})).limit(QueryBuilder.bindMarker((String)"maxRows"));
        PreparedStatement getSlice = session.prepare(addTTLFunction.apply(addTimestampFunction.apply(getSliceSelect)).build());
        this.cqlSingleKeySliceFunction = new AsyncCQLSingleKeySliceFunction(session, getSlice, singleKeyGetter, executorService, queryBackPressure);
        if (this.sliceGroupingAllowed) {
            Select getMultiColumnSelect = ((Select)QueryBuilder.selectFrom((String)keyspaceName, (String)tableName).column("column1").column("value").where(new Relation[]{(Relation)Relation.column((String)"key").isEqualTo((Term)QueryBuilder.bindMarker((String)"key")), (Relation)Relation.column((String)"column1").in(QueryBuilder.bindMarker((String)"column1"))})).limit(QueryBuilder.bindMarker((String)"maxRows"));
            PreparedStatement getMultiColumn = session.prepare(addTTLFunction.apply(addTimestampFunction.apply(getMultiColumnSelect)).build());
            this.cqlSingleKeyMultiColumnFunction = new AsyncCQLSingleKeyMultiColumnFunction(session, getMultiColumn, singleKeyGetter, executorService, queryBackPressure);
        } else {
            this.cqlSingleKeyMultiColumnFunction = null;
        }
        if (this.keysGroupingAllowed) {
            Select getMultiKeySliceSelect = ((Select)QueryBuilder.selectFrom((String)keyspaceName, (String)tableName).column("key").column("column1").column("value").where(new Relation[]{(Relation)Relation.column((String)"key").in(QueryBuilder.bindMarker((String)"key")), (Relation)Relation.column((String)"column1").isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)"sliceStart")), (Relation)Relation.column((String)"column1").isLessThan((Term)QueryBuilder.bindMarker((String)"sliceEnd"))})).perPartitionLimit(QueryBuilder.bindMarker((String)"maxRows"));
            PreparedStatement getMultiKeySlice = session.prepare(addTTLFunction.apply(addTimestampFunction.apply(getMultiKeySliceSelect)).build());
            this.cqlMultiKeySliceFunction = new AsyncCQLMultiKeySliceFunction(session, getMultiKeySlice, multiKeysGetter, executorService, queryBackPressure);
            if (this.sliceGroupingAllowed) {
                Select getMultiKeyMultiColumnSelect = ((Select)QueryBuilder.selectFrom((String)keyspaceName, (String)tableName).column("key").column("column1").column("value").where(new Relation[]{(Relation)Relation.column((String)"key").in(QueryBuilder.bindMarker((String)"key")), (Relation)Relation.column((String)"column1").in(QueryBuilder.bindMarker((String)"column1"))})).perPartitionLimit(QueryBuilder.bindMarker((String)"maxRows"));
                PreparedStatement getMultiKeyMultiColumn = session.prepare(addTTLFunction.apply(addTimestampFunction.apply(getMultiKeyMultiColumnSelect)).build());
                this.cqlMultiKeyMultiColumnFunction = new AsyncCQLMultiKeyMultiColumnFunction(session, getMultiKeyMultiColumn, multiKeysGetter, executorService, queryBackPressure);
            } else {
                this.cqlMultiKeyMultiColumnFunction = null;
            }
        } else {
            this.cqlMultiKeySliceFunction = null;
            this.cqlMultiKeyMultiColumnFunction = null;
        }
        this.SINGLE_QUERY_WITH_KEYS_GROUPING_FILLER = this::fillSingleQueryWithKeysGrouping;
        this.SINGLE_QUERY_WITHOUT_KEYS_GROUPING_FILLER = this::fillSingleQueryWithoutKeysGrouping;
        this.MULTI_QUERY_WITH_KEYS_GROUPING_FILLER = this::fillMultiQueryWithKeysGrouping;
        this.MULTI_QUERY_WITHOUT_KEYS_GROUPING_FILLER = this::fillMultiQueryWithoutKeysGrouping;
        this.groupedExecutionStrategy = GroupedExecutionStrategyBuilder.build(configuration, storeManager, (String)configuration.get(CQLConfigOptions.KEYS_GROUPING_CLASS, new String[0]));
    }

    private static int getLimitOption(Configuration configuration, ConfigOption<Integer> limitOption, int minValue) {
        int value = (Integer)configuration.get(limitOption, new String[0]);
        if (value < minValue) {
            log.warn("Configuration option `{}` is set to {}, but it should be {} or more. This configuration is going to be force-set to {}.", new Object[]{limitOption.toStringWithoutRoot(), value, minValue, minValue});
            return minValue;
        }
        return value;
    }

    @Override
    public CompletableFuture<EntryList> executeSingleKeySingleSlice(KeySliceQuery query, StoreTransaction txh) {
        return this.cqlSingleKeySliceFunction.execute(query, txh);
    }

    @Override
    public Map<StaticBuffer, CompletableFuture<EntryList>> executeMultiKeySingleSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) {
        HashMap<StaticBuffer, CompletableFuture<EntryList>> futureResult = new HashMap<StaticBuffer, CompletableFuture<EntryList>>(keys.size());
        if (this.isKeysGroupingAllowed(keys)) {
            this.groupedExecutionStrategy.execute(futureResult, query, keys, this.SINGLE_QUERY_WITH_KEYS_GROUPING_FILLER, this.SINGLE_QUERY_WITHOUT_KEYS_GROUPING_FILLER, txh, this.keysGroupingLimit);
        } else {
            this.fillSingleQueryWithoutKeysGrouping(futureResult, query, keys, txh);
        }
        return futureResult;
    }

    @Override
    public Map<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>> executeMultiKeyMultiSlice(MultiKeysQueryGroups<StaticBuffer, SliceQuery> multiSliceQueriesForKeys, StoreTransaction txh) {
        HashMap<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>> futureResult = new HashMap<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>>(multiSliceQueriesForKeys.getMultiQueryContext().getTotalAmountOfQueries());
        if (this.sliceGroupingAllowed) {
            this.fillMultiSlicesWithQueryGrouping(futureResult, multiSliceQueriesForKeys, txh);
        } else {
            this.fillMultiSlicesWithoutQueryGrouping(futureResult, multiSliceQueriesForKeys, txh);
        }
        return futureResult;
    }

    private void fillMultiSlicesWithoutQueryGrouping(Map<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>> futureResult, MultiKeysQueryGroups<StaticBuffer, SliceQuery> multiSliceQueriesForKeys, StoreTransaction txh) {
        for (KeysQueriesGroup queryGroup : multiSliceQueriesForKeys.getQueryGroups()) {
            List keys = queryGroup.getKeysGroup();
            if (this.isKeysGroupingAllowed(keys)) {
                for (SliceQuery query : queryGroup.getQueries()) {
                    this.groupedExecutionStrategy.execute(futureResult.computeIfAbsent(query, q -> new HashMap(keys.size())), query, keys, this.SINGLE_QUERY_WITH_KEYS_GROUPING_FILLER, this.SINGLE_QUERY_WITHOUT_KEYS_GROUPING_FILLER, txh, this.keysGroupingLimit);
                }
                continue;
            }
            for (SliceQuery query : queryGroup.getQueries()) {
                this.fillSingleQueryWithoutKeysGrouping(futureResult.computeIfAbsent(query, q -> new HashMap(keys.size())), query, keys, txh);
            }
        }
    }

    private void fillMultiSlicesWithQueryGrouping(Map<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>> futureResult, MultiKeysQueryGroups<StaticBuffer, SliceQuery> multiSliceQueriesForKeys, StoreTransaction txh) {
        for (KeysQueriesGroup queryGroup : multiSliceQueriesForKeys.getQueryGroups()) {
            List keys = queryGroup.getKeysGroup();
            QueryGroups queryGroups = CQLSliceQueryUtil.getQueriesGroupedByDirectEqualityQueries((KeysQueriesGroup<StaticBuffer, SliceQuery>)queryGroup, multiSliceQueriesForKeys.getQueryGroups().size(), this.sliceGroupingLimit);
            if (this.isKeysGroupingAllowed(keys)) {
                this.groupedExecutionStrategy.execute(futureResult, queryGroups, keys, this.MULTI_QUERY_WITH_KEYS_GROUPING_FILLER, this.MULTI_QUERY_WITHOUT_KEYS_GROUPING_FILLER, txh, this.keysGroupingLimit);
                continue;
            }
            this.fillMultiQueryWithoutKeysGrouping(futureResult, queryGroups, keys, txh);
        }
    }

    private void fillMultiQueryWithKeysGrouping(Map<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>> futureResult, QueryGroups queryGroups, KeysGroup keysGroup, StoreTransaction txh) {
        for (Map.Entry<Integer, List<SliceQuery>> sliceQueriesGroup : queryGroups.getDirectEqualityGroupedQueriesByLimit().entrySet()) {
            int limit = sliceQueriesGroup.getKey();
            ArrayList<ByteBuffer> queryStarts = new ArrayList<ByteBuffer>(sliceQueriesGroup.getValue().size());
            HashMap<StaticBuffer, SliceQuery> columnToQueryMap = new HashMap<StaticBuffer, SliceQuery>(sliceQueriesGroup.getValue().size());
            for (SliceQuery sliceQuery : sliceQueriesGroup.getValue()) {
                StaticBuffer column = sliceQuery.getSliceStart();
                queryStarts.add(column.asByteBuffer());
                columnToQueryMap.put(column, sliceQuery);
            }
            CompletableFuture<EntryList> multiKeyMultiColumnResult = this.cqlMultiKeyMultiColumnFunction.execute(new MultiKeysMultiColumnQuery(keysGroup.getRoutingToken(), keysGroup.getRawKeys(), queryStarts, limit), txh);
            HashMap partialResultToCompute = new HashMap(queryStarts.size());
            for (SliceQuery sliceQuery : sliceQueriesGroup.getValue()) {
                HashMap perKeyQueryPartialResult = new HashMap(keysGroup.size());
                partialResultToCompute.put(sliceQuery, perKeyQueryPartialResult);
                Map perKeyQueryFutureResult = futureResult.computeIfAbsent(sliceQuery, q -> new HashMap(keysGroup.size()));
                for (StaticBuffer key : keysGroup.getKeys()) {
                    CompletableFuture future = new CompletableFuture();
                    perKeyQueryFutureResult.put(key, future);
                    perKeyQueryPartialResult.put(key, future);
                }
            }
            multiKeyMultiColumnResult.whenComplete((entries, throwable) -> {
                if (throwable == null) {
                    HashMap<SliceQuery, Map> returnedResult = new HashMap<SliceQuery, Map>(partialResultToCompute.size());
                    for (Entry entry : entries) {
                        StaticBuffer column = entry.getColumn();
                        StaticBuffer key = (StaticBuffer)entry.getMetaData().get(EntryMetaData.ROW_KEY);
                        assert (key != null);
                        SliceQuery query = (SliceQuery)columnToQueryMap.get(column);
                        returnedResult.computeIfAbsent(query, q -> new HashMap(keysGroup.size())).computeIfAbsent(key, k -> new EntryArrayList()).add((Object)entry);
                    }
                    for (Map.Entry futureResultEntry : partialResultToCompute.entrySet()) {
                        SliceQuery query = (SliceQuery)futureResultEntry.getKey();
                        Map futureKeysResults = (Map)futureResultEntry.getValue();
                        Map queryResults = (Map)returnedResult.get(query);
                        if (queryResults == null) {
                            for (CompletableFuture completableFuture : futureKeysResults.values()) {
                                completableFuture.complete(EntryList.EMPTY_LIST);
                            }
                            continue;
                        }
                        for (Map.Entry entry : futureKeysResults.entrySet()) {
                            ((CompletableFuture)entry.getValue()).complete(queryResults.getOrDefault(entry.getKey(), EntryList.EMPTY_LIST));
                        }
                    }
                } else {
                    partialResultToCompute.values().forEach(keysMapToFail -> keysMapToFail.values().forEach(futureToFail -> futureToFail.completeExceptionally((Throwable)throwable)));
                }
            });
        }
        for (SliceQuery separateQuery : queryGroups.getSeparateRangeQueries()) {
            Map perKeyQueryFutureResult = futureResult.computeIfAbsent(separateQuery, q -> new HashMap(keysGroup.size()));
            this.fillSingleQueryWithKeysGrouping(perKeyQueryFutureResult, separateQuery, keysGroup, txh);
        }
    }

    private void fillMultiQueryWithoutKeysGrouping(Map<SliceQuery, Map<StaticBuffer, CompletableFuture<EntryList>>> futureResult, QueryGroups queryGroups, List<StaticBuffer> keys, StoreTransaction txh) {
        for (Map.Entry<Integer, List<SliceQuery>> sliceQueriesGroup : queryGroups.getDirectEqualityGroupedQueriesByLimit().entrySet()) {
            ArrayList<ByteBuffer> queryStarts = new ArrayList<ByteBuffer>(sliceQueriesGroup.getValue().size());
            for (SliceQuery sliceQuery : sliceQueriesGroup.getValue()) {
                queryStarts.add(sliceQuery.getSliceStart().asByteBuffer());
                futureResult.computeIfAbsent(sliceQuery, q -> new HashMap(keys.size()));
            }
            for (StaticBuffer key : keys) {
                CompletableFuture<EntryList> multiColumnResult = this.cqlSingleKeyMultiColumnFunction.execute(new SingleKeyMultiColumnQuery(key.asByteBuffer(), queryStarts, sliceQueriesGroup.getKey()), txh);
                HashMap queryKeyFutureResult = new HashMap(sliceQueriesGroup.getValue().size());
                for (SliceQuery query : sliceQueriesGroup.getValue()) {
                    CompletableFuture futureQueryKeyResult = new CompletableFuture();
                    queryKeyFutureResult.put(query, futureQueryKeyResult);
                    futureResult.get(query).put(key, futureQueryKeyResult);
                }
                multiColumnResult.whenComplete((entries, throwable) -> {
                    if (throwable == null) {
                        HashMap columnToFilteredResult = new HashMap(((List)sliceQueriesGroup.getValue()).size());
                        entries.forEach(entry -> columnToFilteredResult.computeIfAbsent(entry.getColumn(), c -> new EntryArrayList()).add(entry));
                        queryKeyFutureResult.forEach((query, futureQueryResult) -> futureQueryResult.complete(columnToFilteredResult.getOrDefault(query.getSliceStart(), EntryList.EMPTY_LIST)));
                    } else {
                        queryKeyFutureResult.values().forEach(futureQueryResult -> futureQueryResult.completeExceptionally((Throwable)throwable));
                    }
                });
            }
        }
        for (SliceQuery separateQuery : queryGroups.getSeparateRangeQueries()) {
            Map perKeyQueryFutureResult = futureResult.computeIfAbsent(separateQuery, q -> new HashMap(keys.size()));
            this.fillSingleQueryWithoutKeysGrouping(perKeyQueryFutureResult, separateQuery, keys, txh);
        }
    }

    private void fillSingleQueryWithKeysGrouping(Map<StaticBuffer, CompletableFuture<EntryList>> futureQueryResult, SliceQuery query, KeysGroup keysGroup, StoreTransaction txh) {
        CompletableFuture<EntryList> multiKeySingleSliceResult = this.cqlMultiKeySliceFunction.execute(new MultiKeysSingleSliceQuery(keysGroup.getRoutingToken(), keysGroup.getRawKeys(), query, query.getLimit()), txh);
        HashMap perKeyQueryPartialResult = new HashMap(keysGroup.size());
        for (StaticBuffer key : keysGroup.getKeys()) {
            CompletableFuture futureKeyResult = new CompletableFuture();
            futureQueryResult.put(key, futureKeyResult);
            perKeyQueryPartialResult.put(key, futureKeyResult);
        }
        multiKeySingleSliceResult.whenComplete((entries, throwable) -> {
            if (throwable == null) {
                HashMap<StaticBuffer, Object> returnedResult = new HashMap<StaticBuffer, Object>(perKeyQueryPartialResult.size());
                for (Entry entry : entries) {
                    StaticBuffer key = (StaticBuffer)entry.getMetaData().get(EntryMetaData.ROW_KEY);
                    assert (key != null);
                    returnedResult.computeIfAbsent(key, k -> new EntryArrayList()).add((Object)entry);
                }
                for (Map.Entry futureKeyResultEntry : perKeyQueryPartialResult.entrySet()) {
                    ((CompletableFuture)futureKeyResultEntry.getValue()).complete(returnedResult.getOrDefault(futureKeyResultEntry.getKey(), EntryList.EMPTY_LIST));
                }
            } else {
                perKeyQueryPartialResult.values().forEach(futureToFail -> futureToFail.completeExceptionally((Throwable)throwable));
            }
        });
    }

    private void fillSingleQueryWithoutKeysGrouping(Map<StaticBuffer, CompletableFuture<EntryList>> futureQueryResult, SliceQuery query, List<StaticBuffer> keys, StoreTransaction txh) {
        for (StaticBuffer key : keys) {
            futureQueryResult.put(key, this.cqlSingleKeySliceFunction.execute(new KeySliceQuery(key, query), txh));
        }
    }

    private boolean isKeysGroupingAllowed(List<StaticBuffer> keys) {
        return this.keysGroupingAllowed && keys.size() >= this.keysGroupingMin;
    }
}

