/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.builder;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Stack;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.builder.CQLProgrammaticConfigurationLoaderBuilder;

public class CQLSessionBuilder {
    public CqlSession build(Configuration configuration, String[] baseHostnames, int baseDefaultPort, Duration baseConnectionTimeoutMS, CQLProgrammaticConfigurationLoaderBuilder baseConfigurationLoaderBuilder) throws PermanentBackendException {
        ArrayList<String> contactPoints = new ArrayList<String>(baseHostnames.length);
        for (String contactPoint : baseHostnames) {
            if (!contactPoint.contains(":")) {
                contactPoint = contactPoint + ":" + baseDefaultPort;
            }
            contactPoints.add(contactPoint);
        }
        CqlSessionBuilder builder = CqlSession.builder();
        Stack<DriverConfigLoader> driverConfigLoadersToUse = new Stack<DriverConfigLoader>();
        if (((Boolean)configuration.get(CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, new String[0])).booleanValue()) {
            driverConfigLoadersToUse.push(baseConfigurationLoaderBuilder.build(configuration, contactPoints, baseConnectionTimeoutMS));
        }
        if (configuration.has(CQLConfigOptions.URL_CONFIGURATION, new String[0])) {
            URL url;
            String stringUrlRepresentation = (String)configuration.get(CQLConfigOptions.URL_CONFIGURATION, new String[0]);
            try {
                url = new URL(stringUrlRepresentation);
            }
            catch (MalformedURLException e) {
                throw new PermanentBackendException("Malformed URL: " + stringUrlRepresentation, (Throwable)e);
            }
            driverConfigLoadersToUse.push(DriverConfigLoader.fromUrl((URL)url));
        }
        if (configuration.has(CQLConfigOptions.STRING_CONFIGURATION, new String[0])) {
            String stringConfiguration = (String)configuration.get(CQLConfigOptions.STRING_CONFIGURATION, new String[0]);
            driverConfigLoadersToUse.push(DriverConfigLoader.fromString((String)stringConfiguration));
        }
        if (configuration.has(CQLConfigOptions.RESOURCE_CONFIGURATION, new String[0])) {
            String resourceConfigurationPath = (String)configuration.get(CQLConfigOptions.RESOURCE_CONFIGURATION, new String[0]);
            driverConfigLoadersToUse.push(DriverConfigLoader.fromClasspath((String)resourceConfigurationPath));
        }
        if (configuration.has(CQLConfigOptions.FILE_CONFIGURATION, new String[0])) {
            String fileConfigurationPath = (String)configuration.get(CQLConfigOptions.FILE_CONFIGURATION, new String[0]);
            driverConfigLoadersToUse.push(DriverConfigLoader.fromFile((File)new File(fileConfigurationPath)));
        }
        if (!driverConfigLoadersToUse.empty()) {
            DriverConfigLoader composedDriverConfigLoader = (DriverConfigLoader)driverConfigLoadersToUse.pop();
            while (!driverConfigLoadersToUse.empty()) {
                composedDriverConfigLoader = DriverConfigLoader.compose((DriverConfigLoader)composedDriverConfigLoader, (DriverConfigLoader)((DriverConfigLoader)driverConfigLoadersToUse.pop()));
            }
            builder.withConfigLoader(composedDriverConfigLoader);
        }
        return (CqlSession)builder.build();
    }
}

