/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.builder;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.auth.PlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.ssl.DefaultSslEngineFactory;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class CQLProgrammaticConfigurationLoaderBuilder {
    public DriverConfigLoader build(Configuration configuration, List<String> contactPoints, Duration connectionTimeoutMS) {
        ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder = DriverConfigLoader.programmaticBuilder();
        configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, contactPoints);
        configLoaderBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, (String)configuration.get(CQLConfigOptions.LOCAL_DATACENTER, new String[0]));
        configLoaderBuilder.withString((DriverOption)DefaultDriverOption.SESSION_NAME, (String)configuration.get(CQLConfigOptions.SESSION_NAME, new String[0]));
        configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.REQUEST_TIMEOUT, new String[0])));
        configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT, connectionTimeoutMS);
        if ((Integer)configuration.get(CQLConfigOptions.PROTOCOL_VERSION, new String[0]) != 0) {
            configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.PROTOCOL_VERSION, ((Integer)configuration.get(CQLConfigOptions.PROTOCOL_VERSION, new String[0])).intValue());
        }
        if (configuration.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) && configuration.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])) {
            ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withClass((DriverOption)DefaultDriverOption.AUTH_PROVIDER_CLASS, PlainTextAuthProvider.class)).withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, (String)configuration.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]))).withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, (String)configuration.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]));
        }
        if (((Boolean)configuration.get(CQLConfigOptions.SSL_ENABLED, new String[0])).booleanValue()) {
            ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withClass((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, DefaultSslEngineFactory.class)).withString((DriverOption)DefaultDriverOption.SSL_TRUSTSTORE_PATH, (String)configuration.get(CQLConfigOptions.SSL_TRUSTSTORE_LOCATION, new String[0]))).withString((DriverOption)DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD, (String)configuration.get(CQLConfigOptions.SSL_TRUSTSTORE_PASSWORD, new String[0]))).withBoolean((DriverOption)DefaultDriverOption.SSL_HOSTNAME_VALIDATION, ((Boolean)configuration.get(CQLConfigOptions.SSL_HOSTNAME_VALIDATION, new String[0])).booleanValue());
            if (((Boolean)configuration.get(CQLConfigOptions.SSL_CLIENT_AUTHENTICATION_ENABLED, new String[0])).booleanValue()) {
                ((ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.SSL_KEYSTORE_PATH, (String)configuration.get(CQLConfigOptions.SSL_KEYSTORE_LOCATION, new String[0]))).withString((DriverOption)DefaultDriverOption.SSL_KEYSTORE_PASSWORD, (String)configuration.get(CQLConfigOptions.SSL_KEYSTORE_KEY_PASSWORD, new String[0]));
            }
        }
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, ((Integer)configuration.get(CQLConfigOptions.LOCAL_MAX_CONNECTIONS_PER_HOST, new String[0])).intValue());
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, ((Integer)configuration.get(CQLConfigOptions.REMOTE_MAX_CONNECTIONS_PER_HOST, new String[0])).intValue());
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS, ((Integer)configuration.get(CQLConfigOptions.MAX_REQUESTS_PER_CONNECTION, new String[0])).intValue());
        if (configuration.has(CQLConfigOptions.HEARTBEAT_INTERVAL, new String[0])) {
            configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.HEARTBEAT_INTERVAL, new String[0])));
        }
        if (configuration.has(CQLConfigOptions.HEARTBEAT_TIMEOUT, new String[0])) {
            configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.HEARTBEAT_TIMEOUT, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.HEARTBEAT_TIMEOUT, new String[0])));
        }
        if (configuration.has(CQLConfigOptions.METADATA_SCHEMA_ENABLED, new String[0])) {
            configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.METADATA_SCHEMA_ENABLED, ((Boolean)configuration.get(CQLConfigOptions.METADATA_SCHEMA_ENABLED, new String[0])).booleanValue());
        }
        if (configuration.has(CQLConfigOptions.METADATA_TOKEN_MAP_ENABLED, new String[0])) {
            configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.METADATA_TOKEN_MAP_ENABLED, ((Boolean)configuration.get(CQLConfigOptions.METADATA_TOKEN_MAP_ENABLED, new String[0])).booleanValue());
        }
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.METADATA_SCHEMA_WINDOW, 0);
        this.configureCqlNetty(configuration, configLoaderBuilder);
        if (((Boolean)configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0])).booleanValue()) {
            this.configureMetrics(configuration, configLoaderBuilder);
        }
        this.configureRequestTracker(configuration, configLoaderBuilder);
        if (configuration.has(CQLConfigOptions.SESSION_LEAK_THRESHOLD, new String[0])) {
            configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.SESSION_LEAK_THRESHOLD, ((Integer)configuration.get(CQLConfigOptions.SESSION_LEAK_THRESHOLD, new String[0])).intValue());
        }
        return configLoaderBuilder.build();
    }

    private void configureCqlNetty(Configuration configuration, ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder) {
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.NETTY_IO_SIZE, ((Integer)configuration.get(CQLConfigOptions.NETTY_IO_SIZE, new String[0])).intValue());
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.NETTY_ADMIN_SIZE, ((Integer)configuration.get(CQLConfigOptions.NETTY_ADMIN_SIZE, new String[0])).intValue());
        if (configuration.has(CQLConfigOptions.NETTY_TIMER_TICK_DURATION, new String[0])) {
            configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.NETTY_TIMER_TICK_DURATION, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.NETTY_TIMER_TICK_DURATION, new String[0])));
        }
        if (configuration.has(CQLConfigOptions.NETTY_TIMER_TICKS_PER_WHEEL, new String[0])) {
            configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.NETTY_TIMER_TICKS_PER_WHEEL, ((Integer)configuration.get(CQLConfigOptions.NETTY_TIMER_TICKS_PER_WHEEL, new String[0])).intValue());
        }
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.NETTY_IO_SHUTDOWN_QUIET_PERIOD, 0);
        configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD, 0);
    }

    private void configureMetrics(Configuration configuration, ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder) {
        if (configuration.has(CQLConfigOptions.METRICS_SESSION_ENABLED, new String[0])) {
            configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED, Arrays.asList((Object[])configuration.get(CQLConfigOptions.METRICS_SESSION_ENABLED, new String[0])));
            if (configuration.has(CQLConfigOptions.METRICS_SESSION_REQUESTS_HIGHEST_LATENCY, new String[0])) {
                configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_HIGHEST, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.METRICS_SESSION_REQUESTS_HIGHEST_LATENCY, new String[0])));
            }
            if (configuration.has(CQLConfigOptions.METRICS_SESSION_REQUESTS_SIGNIFICANT_DIGITS, new String[0])) {
                configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_DIGITS, ((Integer)configuration.get(CQLConfigOptions.METRICS_SESSION_REQUESTS_SIGNIFICANT_DIGITS, new String[0])).intValue());
            }
            if (configuration.has(CQLConfigOptions.METRICS_SESSION_REQUESTS_REFRESH_INTERVAL, new String[0])) {
                configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_INTERVAL, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.METRICS_SESSION_REQUESTS_REFRESH_INTERVAL, new String[0])));
            }
            if (configuration.has(CQLConfigOptions.METRICS_SESSION_THROTTLING_HIGHEST_LATENCY, new String[0])) {
                configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_HIGHEST, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.METRICS_SESSION_THROTTLING_HIGHEST_LATENCY, new String[0])));
            }
            if (configuration.has(CQLConfigOptions.METRICS_SESSION_THROTTLING_SIGNIFICANT_DIGITS, new String[0])) {
                configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_DIGITS, ((Integer)configuration.get(CQLConfigOptions.METRICS_SESSION_THROTTLING_SIGNIFICANT_DIGITS, new String[0])).intValue());
            }
            if (configuration.has(CQLConfigOptions.METRICS_SESSION_THROTTLING_REFRESH_INTERVAL, new String[0])) {
                configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_INTERVAL, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.METRICS_SESSION_THROTTLING_REFRESH_INTERVAL, new String[0])));
            }
        }
        if (configuration.has(CQLConfigOptions.METRICS_NODE_ENABLED, new String[0])) {
            configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED, Arrays.asList((Object[])configuration.get(CQLConfigOptions.METRICS_NODE_ENABLED, new String[0])));
            if (configuration.has(CQLConfigOptions.METRICS_NODE_MESSAGES_HIGHEST_LATENCY, new String[0])) {
                configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_HIGHEST, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.METRICS_NODE_MESSAGES_HIGHEST_LATENCY, new String[0])));
            }
            if (configuration.has(CQLConfigOptions.METRICS_NODE_MESSAGES_SIGNIFICANT_DIGITS, new String[0])) {
                configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_DIGITS, ((Integer)configuration.get(CQLConfigOptions.METRICS_NODE_MESSAGES_SIGNIFICANT_DIGITS, new String[0])).intValue());
            }
            if (configuration.has(CQLConfigOptions.METRICS_NODE_MESSAGES_REFRESH_INTERVAL, new String[0])) {
                configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_INTERVAL, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.METRICS_NODE_MESSAGES_REFRESH_INTERVAL, new String[0])));
            }
            if (configuration.has(CQLConfigOptions.METRICS_NODE_EXPIRE_AFTER, new String[0])) {
                configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.METRICS_NODE_EXPIRE_AFTER, new String[0])));
            }
        }
    }

    private void configureRequestTracker(Configuration configuration, ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder) {
        if (configuration.has(CQLConfigOptions.REQUEST_TRACKER_CLASS, new String[0])) {
            configLoaderBuilder.withString((DriverOption)DefaultDriverOption.REQUEST_TRACKER_CLASS, (String)configuration.get(CQLConfigOptions.REQUEST_TRACKER_CLASS, new String[0]));
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_SUCCESS_ENABLED, new String[0])) {
            configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.REQUEST_LOGGER_SUCCESS_ENABLED, ((Boolean)configuration.get(CQLConfigOptions.REQUEST_LOGGER_SUCCESS_ENABLED, new String[0])).booleanValue());
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_SLOW_THRESHOLD, new String[0])) {
            configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_LOGGER_SLOW_THRESHOLD, Duration.ofMillis((Long)configuration.get(CQLConfigOptions.REQUEST_LOGGER_SLOW_THRESHOLD, new String[0])));
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_SLOW_ENABLED, new String[0])) {
            configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.REQUEST_LOGGER_SLOW_ENABLED, ((Boolean)configuration.get(CQLConfigOptions.REQUEST_LOGGER_SLOW_ENABLED, new String[0])).booleanValue());
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_ERROR_ENABLED, new String[0])) {
            configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.REQUEST_LOGGER_ERROR_ENABLED, ((Boolean)configuration.get(CQLConfigOptions.REQUEST_LOGGER_ERROR_ENABLED, new String[0])).booleanValue());
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_MAX_QUERY_LENGTH, new String[0])) {
            configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.REQUEST_LOGGER_MAX_QUERY_LENGTH, ((Integer)configuration.get(CQLConfigOptions.REQUEST_LOGGER_MAX_QUERY_LENGTH, new String[0])).intValue());
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_SHOW_VALUES, new String[0])) {
            configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.REQUEST_LOGGER_VALUES, ((Boolean)configuration.get(CQLConfigOptions.REQUEST_LOGGER_SHOW_VALUES, new String[0])).booleanValue());
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_MAX_VALUE_LENGTH, new String[0])) {
            configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.REQUEST_LOGGER_MAX_VALUE_LENGTH, ((Integer)configuration.get(CQLConfigOptions.REQUEST_LOGGER_MAX_VALUE_LENGTH, new String[0])).intValue());
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_MAX_VALUES, new String[0])) {
            configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.REQUEST_LOGGER_MAX_VALUES, ((Integer)configuration.get(CQLConfigOptions.REQUEST_LOGGER_MAX_VALUES, new String[0])).intValue());
        }
        if (configuration.has(CQLConfigOptions.REQUEST_LOGGER_SHOW_STACK_TRACES, new String[0])) {
            configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.REQUEST_LOGGER_STACK_TRACES, ((Boolean)configuration.get(CQLConfigOptions.REQUEST_LOGGER_SHOW_STACK_TRACES, new String[0])).booleanValue());
        }
    }
}

