/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.dht.AbstractByteOrderedPartitioner;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.cassandra.CassandraTransaction;
import org.janusgraph.diskstorage.cassandra.thrift.CassandraThriftKeyColumnValueStore;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnection;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnectionFactory;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnectionPool;
import org.janusgraph.diskstorage.cassandra.utils.CassandraHelper;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.janusgraph.util.system.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class CassandraThriftStoreManager
extends AbstractCassandraStoreManager {
    private static final Logger log = LoggerFactory.getLogger(CassandraThriftStoreManager.class);
    public static final ConfigNamespace THRIFT_NS = new ConfigNamespace(AbstractCassandraStoreManager.CASSANDRA_NS, "thrift", "Options for JanusGraph's own Thrift Cassandra backend");
    public static final ConfigNamespace CPOOL_NS = new ConfigNamespace(THRIFT_NS, "cpool", "Options for the Apache commons-pool connection manager");
    public static final ConfigOption<String> CPOOL_WHEN_EXHAUSTED = new ConfigOption(CPOOL_NS, "when-exhausted", "What to do when clients concurrently request more active connections than are allowed by the pool.  The value must be one of BLOCK, FAIL, or GROW.", ConfigOption.Type.MASKABLE, String.class, (Object)PoolExhaustedAction.BLOCK.toString(), ConfigOption.disallowEmpty(String.class));
    public static final ConfigOption<Integer> CPOOL_MAX_TOTAL = new ConfigOption(CPOOL_NS, "max-total", "Max number of allowed Thrift connections, idle or active (-1 to leave undefined)", ConfigOption.Type.MASKABLE, (Object)-1);
    public static final ConfigOption<Integer> CPOOL_MAX_ACTIVE = new ConfigOption(CPOOL_NS, "max-active", "Maximum number of concurrently in-use connections (-1 to leave undefined)", ConfigOption.Type.MASKABLE, (Object)16);
    public static final ConfigOption<Integer> CPOOL_MAX_IDLE = new ConfigOption(CPOOL_NS, "max-idle", "Maximum number of concurrently idle connections (-1 to leave undefined)", ConfigOption.Type.MASKABLE, (Object)4);
    public static final ConfigOption<Integer> CPOOL_MIN_IDLE = new ConfigOption(CPOOL_NS, "min-idle", "Minimum number of idle connections the pool attempts to maintain", ConfigOption.Type.MASKABLE, (Object)0);
    public static final ConfigOption<Long> CPOOL_MAX_WAIT = new ConfigOption(CPOOL_NS, "max-wait", "Maximum number of milliseconds to block when " + ConfigElement.getPath(CPOOL_WHEN_EXHAUSTED, (String[])new String[0]) + " is set to BLOCK.  Has no effect when set to actions besides BLOCK.  Set to -1 to wait indefinitely.", ConfigOption.Type.MASKABLE, (Object)-1L);
    public static final ConfigOption<Long> CPOOL_EVICTOR_PERIOD = new ConfigOption(CPOOL_NS, "evictor-period", "Approximate number of milliseconds between runs of the idle connection evictor.  Set to -1 to never run the idle connection evictor.", ConfigOption.Type.MASKABLE, (Object)30000L);
    public static final ConfigOption<Long> CPOOL_MIN_EVICTABLE_IDLE_TIME = new ConfigOption(CPOOL_NS, "min-evictable-idle-time", "Minimum number of milliseconds a connection must be idle before it is eligible for eviction.  See also " + ConfigElement.getPath(CPOOL_EVICTOR_PERIOD, (String[])new String[0]) + ".  Set to -1 to never evict idle connections.", ConfigOption.Type.MASKABLE, (Object)60000L);
    public static final ConfigOption<Boolean> CPOOL_IDLE_TESTS = new ConfigOption(CPOOL_NS, "idle-test", "Whether the idle connection evictor validates idle connections and drops those that fail to validate", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Integer> CPOOL_IDLE_TESTS_PER_EVICTION_RUN = new ConfigOption(CPOOL_NS, "idle-tests-per-eviction-run", "When the value is negative, e.g. -n, roughly one nth of the idle connections are tested per run.  When the value is positive, e.g. n, the min(idle-count, n) connections are tested per run.", ConfigOption.Type.MASKABLE, (Object)0);
    private final Map<String, CassandraThriftKeyColumnValueStore> openStores;
    private final CTConnectionPool pool;
    private final DistributedStoreManager.Deployment deployment;

    public CassandraThriftStoreManager(Configuration config) throws BackendException {
        super(config);
        int thriftTimeoutMS = (int)((Duration)config.get(GraphDatabaseConfiguration.CONNECTION_TIMEOUT, new String[0])).toMillis();
        CTConnectionFactory.Config factoryConfig = new CTConnectionFactory.Config(this.hostnames, this.port, this.username, this.password).setTimeoutMS(thriftTimeoutMS).setFrameSize(this.thriftFrameSizeBytes);
        if (((Boolean)config.get(SSL_ENABLED, new String[0])).booleanValue()) {
            factoryConfig.setSSLTruststoreLocation((String)config.get(SSL_TRUSTSTORE_LOCATION, new String[0]));
            factoryConfig.setSSLTruststorePassword((String)config.get(SSL_TRUSTSTORE_PASSWORD, new String[0]));
        }
        PoolExhaustedAction poolExhaustedAction = (PoolExhaustedAction)ConfigOption.getEnumValue((String)((String)config.get(CPOOL_WHEN_EXHAUSTED, new String[0])), PoolExhaustedAction.class);
        CTConnectionPool p = new CTConnectionPool(factoryConfig.build());
        p.setTestOnBorrow(true);
        p.setTestOnReturn(true);
        p.setTestWhileIdle((Boolean)config.get(CPOOL_IDLE_TESTS, new String[0]));
        p.setNumTestsPerEvictionRun((Integer)config.get(CPOOL_IDLE_TESTS_PER_EVICTION_RUN, new String[0]));
        p.setWhenExhaustedAction(poolExhaustedAction.getByte());
        p.setMaxActive((Integer)config.get(CPOOL_MAX_ACTIVE, new String[0]));
        p.setMaxTotal((Integer)config.get(CPOOL_MAX_TOTAL, new String[0]));
        p.setMaxIdle((Integer)config.get(CPOOL_MAX_IDLE, new String[0]));
        p.setMinIdle((Integer)config.get(CPOOL_MIN_IDLE, new String[0]));
        p.setMaxWait((Long)config.get(CPOOL_MAX_WAIT, new String[0]));
        p.setTimeBetweenEvictionRunsMillis((Long)config.get(CPOOL_EVICTOR_PERIOD, new String[0]));
        p.setMinEvictableIdleTimeMillis((Long)config.get(CPOOL_MIN_EVICTABLE_IDLE_TIME, new String[0]));
        this.pool = p;
        this.openStores = new HashMap<String, CassandraThriftKeyColumnValueStore>();
        this.deployment = this.getCassandraPartitioner() instanceof ByteOrderedPartitioner ? (this.hostnames.length == 1 ? (NetworkUtil.isLocalConnection((String)this.hostnames[0]) ? DistributedStoreManager.Deployment.LOCAL : DistributedStoreManager.Deployment.REMOTE) : DistributedStoreManager.Deployment.REMOTE) : DistributedStoreManager.Deployment.REMOTE;
    }

    public DistributedStoreManager.Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public IPartitioner getCassandraPartitioner() throws BackendException {
        CTConnection conn = null;
        try {
            conn = (CTConnection)this.pool.borrowObject("system");
            IPartitioner iPartitioner = FBUtilities.newPartitioner((String)conn.getClient().describe_partitioner());
            return iPartitioner;
        }
        catch (Exception e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        finally {
            this.pool.returnObjectUnsafe("system", conn);
        }
    }

    @Override
    public String toString() {
        return "thriftCassandra" + super.toString();
    }

    public void close() throws BackendException {
        this.openStores.clear();
        this.closePool();
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        Preconditions.checkNotNull(mutations);
        DistributedStoreManager.MaskedTimestamp commitTime = new DistributedStoreManager.MaskedTimestamp(txh);
        ConsistencyLevel consistency = CassandraTransaction.getTx(txh).getWriteConsistencyLevel().getThrift();
        int size = 0;
        for (Map<StaticBuffer, KCVMutation> map : mutations.values()) {
            size += map.size();
        }
        HashMap batch = new HashMap(size);
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> entry : mutations.entrySet()) {
            String columnFamily = entry.getKey();
            for (Map.Entry<StaticBuffer, KCVMutation> mutEntry : entry.getValue().entrySet()) {
                ByteBuffer keyBB = mutEntry.getKey().asByteBuffer();
                HashMap cfmutation = (HashMap)batch.get(keyBB);
                if (cfmutation == null) {
                    cfmutation = new HashMap(3);
                    batch.put(keyBB, cfmutation);
                }
                KCVMutation mutation = mutEntry.getValue();
                ArrayList<Mutation> thriftMutation = new ArrayList<Mutation>(mutations.size());
                if (mutation.hasDeletions()) {
                    for (StaticBuffer buf : mutation.getDeletions()) {
                        Deletion d = new Deletion();
                        SlicePredicate sp = new SlicePredicate();
                        sp.addToColumn_names((ByteBuffer)buf.as(StaticBuffer.BB_FACTORY));
                        d.setPredicate(sp);
                        d.setTimestamp(commitTime.getDeletionTime(this.times));
                        Mutation m = new Mutation();
                        m.setDeletion(d);
                        thriftMutation.add(m);
                    }
                }
                if (mutation.hasAdditions()) {
                    for (Entry ent : mutation.getAdditions()) {
                        ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
                        Column column = new Column((ByteBuffer)ent.getColumnAs(StaticBuffer.BB_FACTORY));
                        column.setValue((ByteBuffer)ent.getValueAs(StaticBuffer.BB_FACTORY));
                        column.setTimestamp(commitTime.getAdditionTime(this.times));
                        Integer ttl = (Integer)ent.getMetaData().get(EntryMetaData.TTL);
                        if (null != ttl && ttl > 0) {
                            column.setTtl(ttl.intValue());
                        }
                        cosc.setColumn(column);
                        Mutation m = new Mutation();
                        m.setColumn_or_supercolumn(cosc);
                        thriftMutation.add(m);
                    }
                }
                cfmutation.put(columnFamily, thriftMutation);
            }
        }
        CTConnection cTConnection = null;
        try {
            CTConnection cTConnection2 = (CTConnection)this.pool.borrowObject(this.keySpaceName);
            Cassandra.Client client = cTConnection2.getClient();
            if (this.atomicBatch) {
                client.atomic_batch_mutate(batch, consistency);
            } else {
                client.batch_mutate(batch, consistency);
            }
            this.pool.returnObjectUnsafe(this.keySpaceName, cTConnection2);
        }
        catch (Exception exception) {
            try {
                throw CassandraThriftKeyColumnValueStore.convertException(exception);
            }
            catch (Throwable throwable) {
                this.pool.returnObjectUnsafe(this.keySpaceName, cTConnection);
                throw throwable;
            }
        }
        this.sleepAfterWrite(txh, commitTime);
    }

    public synchronized CassandraThriftKeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        if (this.openStores.containsKey(name)) {
            return this.openStores.get(name);
        }
        this.ensureColumnFamilyExists(this.keySpaceName, name);
        CassandraThriftKeyColumnValueStore store = new CassandraThriftKeyColumnValueStore(this.keySpaceName, name, this, this.pool);
        this.openStores.put(name, store);
        return store;
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        CTConnection conn = null;
        IPartitioner partitioner = this.getCassandraPartitioner();
        if (!(partitioner instanceof AbstractByteOrderedPartitioner)) {
            throw new UnsupportedOperationException("getLocalKeyPartition() only supported by byte ordered partitioner.");
        }
        Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
        try {
            this.ensureKeyspaceExists(this.keySpaceName);
            conn = (CTConnection)this.pool.borrowObject(this.keySpaceName);
            List ranges = conn.getClient().describe_ring(this.keySpaceName);
            ArrayList<KeyRange> keyRanges = new ArrayList<KeyRange>(ranges.size());
            for (TokenRange range : ranges) {
                if (!NetworkUtil.hasLocalAddress((Collection)range.endpoints)) continue;
                keyRanges.add(CassandraHelper.transformRange(tokenFactory.fromString(range.start_token), tokenFactory.fromString(range.end_token)));
            }
            ArrayList<KeyRange> arrayList = keyRanges;
            this.pool.returnObjectUnsafe(this.keySpaceName, conn);
            return arrayList;
        }
        catch (Exception e) {
            try {
                throw CassandraThriftKeyColumnValueStore.convertException(e);
            }
            catch (Throwable throwable) {
                this.pool.returnObjectUnsafe(this.keySpaceName, conn);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void clearStorage() throws BackendException {
        block38: {
            this.openStores.clear();
            String lp = "ClearStorage: ";
            CTConnection conn = null;
            try {
                KsDef ksDef;
                conn = (CTConnection)this.pool.borrowObject("system");
                Cassandra.Client client = conn.getClient();
                try {
                    client.set_keyspace(this.keySpaceName);
                    ksDef = client.describe_keyspace(this.keySpaceName);
                }
                catch (NotFoundException e) {
                    log.debug("ClearStorage: Keyspace {} does not exist, not attempting to truncate.", (Object)this.keySpaceName);
                    if (conn != null && conn.getClient() != null) {
                        try {
                            conn.getClient().set_keyspace("system");
                        }
                        catch (InvalidRequestException e2) {
                            log.warn("Failed to reset keyspace", (Throwable)e2);
                        }
                        catch (TException e3) {
                            log.warn("Failed to reset keyspace", (Throwable)e3);
                        }
                    }
                    this.pool.returnObjectUnsafe("system", conn);
                    return;
                }
                catch (InvalidRequestException e) {
                    block37: {
                        log.debug("ClearStorage: InvalidRequestException when attempting to describe keyspace {}, not attempting to truncate.", (Object)this.keySpaceName);
                        if (conn == null || conn.getClient() == null) break block37;
                        try {
                            conn.getClient().set_keyspace("system");
                        }
                        catch (InvalidRequestException e4) {
                            log.warn("Failed to reset keyspace", (Throwable)e4);
                        }
                        catch (TException e5) {
                            log.warn("Failed to reset keyspace", (Throwable)e5);
                        }
                    }
                    this.pool.returnObjectUnsafe("system", conn);
                    return;
                }
                if (null == ksDef) {
                    log.debug("ClearStorage: Received null KsDef for keyspace {}; not truncating its CFs", (Object)this.keySpaceName);
                    return;
                }
                if (((Boolean)this.storageConfig.get(GraphDatabaseConfiguration.DROP_ON_CLEAR, new String[0])).booleanValue()) {
                    client.system_drop_keyspace(this.keySpaceName);
                    this.pool.clear();
                    break block38;
                }
                List cfDefs = ksDef.getCf_defs();
                if (null == cfDefs) {
                    log.debug("ClearStorage: Received empty CfDef list for keyspace {}; not truncating CFs", (Object)this.keySpaceName);
                    return;
                }
                for (CfDef cfDef : ksDef.getCf_defs()) {
                    client.truncate(cfDef.name);
                    log.info("ClearStorage: Truncated CF {} in keyspace {}", (Object)cfDef.name, (Object)this.keySpaceName);
                }
                {
                    break block38;
                    catch (Exception e) {
                        throw new TemporaryBackendException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (conn != null && conn.getClient() != null) {
                    try {
                        conn.getClient().set_keyspace("system");
                    }
                    catch (InvalidRequestException e) {
                        log.warn("Failed to reset keyspace", (Throwable)e);
                    }
                    catch (TException e) {
                        log.warn("Failed to reset keyspace", (Throwable)e);
                    }
                }
                this.pool.returnObjectUnsafe("system", conn);
            }
        }
    }

    public boolean exists() throws BackendException {
        CTConnection connection = null;
        try {
            connection = (CTConnection)this.pool.borrowObject("system");
            Cassandra.Client client = connection.getClient();
            try {
                client.set_keyspace(this.keySpaceName);
                client.set_keyspace("system");
                boolean bl = true;
                return bl;
            }
            catch (InvalidRequestException e) {
                try {
                    boolean bl = false;
                    this.pool.returnObjectUnsafe("system", connection);
                    return bl;
                }
                catch (Exception e2) {
                    throw new TemporaryBackendException((Throwable)e2);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.returnObjectUnsafe("system", connection);
        }
    }

    private KsDef ensureKeyspaceExists(String keyspaceName) throws TException, BackendException {
        CTConnection connection = null;
        try {
            connection = (CTConnection)this.pool.borrowObject("system");
            Cassandra.Client client = connection.getClient();
            try {
                client.set_keyspace(keyspaceName);
                client.set_keyspace("system");
                log.debug("Found existing keyspace {}", (Object)keyspaceName);
            }
            catch (InvalidRequestException e) {
                log.debug("Creating keyspace {}...", (Object)keyspaceName);
                KsDef ksdef = new KsDef().setName(keyspaceName).setCf_defs(new LinkedList()).setStrategy_class((String)this.storageConfig.get(REPLICATION_STRATEGY, new String[0])).setStrategy_options(this.strategyOptions);
                client.set_keyspace("system");
                try {
                    client.system_add_keyspace(ksdef);
                    this.retrySetKeyspace(keyspaceName, client);
                    log.debug("Created keyspace {}", (Object)keyspaceName);
                }
                catch (InvalidRequestException ire) {
                    log.error("system_add_keyspace failed for keyspace=" + keyspaceName, (Throwable)ire);
                    throw ire;
                }
            }
            KsDef ksDef = client.describe_keyspace(keyspaceName);
            return ksDef;
        }
        catch (Exception e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        finally {
            this.pool.returnObjectUnsafe("system", connection);
        }
    }

    private void retrySetKeyspace(String ksName, Cassandra.Client client) throws BackendException {
        long end = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() <= end) {
            try {
                client.set_keyspace(ksName);
                return;
            }
            catch (Exception e) {
                log.warn("Exception when changing to keyspace {} after creating it", (Object)ksName, (Object)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new PermanentBackendException("Unexpected interrupt (shutting down?)", (Throwable)ie);
                }
            }
        }
        throw new PermanentBackendException("Could change to keyspace " + ksName + " after creating it");
    }

    private void ensureColumnFamilyExists(String ksName, String cfName) throws BackendException {
        this.ensureColumnFamilyExists(ksName, cfName, "org.apache.cassandra.db.marshal.BytesType");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ensureColumnFamilyExists(String ksName, String cfName, String comparator) throws BackendException {
        CTConnection conn = null;
        try {
            KsDef keyspaceDef = this.ensureKeyspaceExists(ksName);
            conn = (CTConnection)this.pool.borrowObject(ksName);
            Cassandra.Client client = conn.getClient();
            log.debug("Looking up metadata on keyspace {}...", (Object)ksName);
            boolean foundColumnFamily = false;
            for (CfDef cfDef : keyspaceDef.getCf_defs()) {
                String curCfName = cfDef.getName();
                if (!curCfName.equals(cfName)) continue;
                foundColumnFamily = true;
            }
            if (!foundColumnFamily) {
                this.createColumnFamily(client, ksName, cfName, comparator);
            } else {
                log.debug("Keyspace {} and ColumnFamily {} were found.", (Object)ksName, (Object)cfName);
            }
            this.pool.returnObjectUnsafe(ksName, conn);
            return;
        }
        catch (SchemaDisagreementException e) {
            try {
                throw new TemporaryBackendException((Throwable)e);
                catch (Exception e2) {
                    throw new PermanentBackendException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.pool.returnObjectUnsafe(ksName, conn);
                throw throwable;
            }
        }
    }

    private void createColumnFamily(Cassandra.Client client, String ksName, String cfName, String comparator) throws BackendException {
        CfDef createColumnFamily = new CfDef();
        createColumnFamily.setName(cfName);
        createColumnFamily.setKeyspace(ksName);
        createColumnFamily.setComparator_type(comparator);
        if (this.storageConfig.has(COMPACTION_STRATEGY, new String[0])) {
            createColumnFamily.setCompaction_strategy((String)this.storageConfig.get(COMPACTION_STRATEGY, new String[0]));
        }
        if (!this.compactionOptions.isEmpty()) {
            createColumnFamily.setCompaction_strategy_options(this.compactionOptions);
        }
        ImmutableMap.Builder compressionOptions = new ImmutableMap.Builder();
        if (this.compressionEnabled) {
            compressionOptions.put((Object)"sstable_compression", (Object)this.compressionClass).put((Object)"chunk_length_kb", (Object)Integer.toString(this.compressionChunkSizeKB));
        }
        createColumnFamily.setCompression_options((Map)compressionOptions.build());
        if (cfName.startsWith("edgestore")) {
            createColumnFamily.setCaching("keys_only");
        } else if (cfName.startsWith("graphindex")) {
            createColumnFamily.setCaching("rows_only");
        }
        log.debug("Adding column family {} to keyspace {}...", (Object)cfName, (Object)ksName);
        try {
            client.system_add_column_family(createColumnFamily);
        }
        catch (SchemaDisagreementException e) {
            throw new TemporaryBackendException("Error in setting up column family", (Throwable)e);
        }
        catch (Exception e) {
            throw new PermanentBackendException((Throwable)e);
        }
        log.debug("Added column family {} to keyspace {}.", (Object)cfName, (Object)ksName);
    }

    @Override
    public Map<String, String> getCompressionOptions(String cf) throws BackendException {
        CTConnection conn = null;
        Map result = null;
        try {
            conn = (CTConnection)this.pool.borrowObject(this.keySpaceName);
            Cassandra.Client client = conn.getClient();
            KsDef ksDef = client.describe_keyspace(this.keySpaceName);
            for (CfDef cfDef : ksDef.getCf_defs()) {
                if (null == cfDef || !cfDef.getName().equals(cf)) continue;
                result = cfDef.getCompression_options();
                break;
            }
            Iterator iterator = result;
            return iterator;
        }
        catch (InvalidRequestException e) {
            log.debug("Keyspace {} does not exist", (Object)this.keySpaceName);
            Map<String, String> map = null;
            return map;
        }
        catch (Exception e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        finally {
            this.pool.returnObjectUnsafe(this.keySpaceName, conn);
        }
    }

    private void closePool() {
        try {
            this.pool.close();
            log.info("Closed Thrift connection pooler.");
        }
        catch (Exception e) {
            log.warn("Failed to close connection pooler.  We might be leaking Cassandra connections.", (Throwable)e);
        }
    }

    public static enum PoolExhaustedAction {
        BLOCK(1),
        FAIL(0),
        GROW(2);

        private final byte b;

        private PoolExhaustedAction(byte b) {
            this.b = b;
        }

        public byte getByte() {
            return this.b;
        }
    }
}

