/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.embedded;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.BigIntegerToken;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LongToken;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.commons.lang.ArrayUtils;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.cassandra.CassandraTransaction;
import org.janusgraph.diskstorage.cassandra.embedded.CassandraEmbeddedStoreManager;
import org.janusgraph.diskstorage.cassandra.utils.CassandraHelper;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.ByteBufferUtil;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraEmbeddedKeyColumnValueStore
implements KeyColumnValueStore {
    private static final Logger log = LoggerFactory.getLogger(CassandraEmbeddedKeyColumnValueStore.class);
    private final String keyspace;
    private final String columnFamily;
    private final CassandraEmbeddedStoreManager storeManager;
    private final TimestampProvider times;
    private final CassandraEmbeddedGetter entryGetter;

    public CassandraEmbeddedKeyColumnValueStore(String keyspace, String columnFamily, CassandraEmbeddedStoreManager storeManager) throws RuntimeException {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.storeManager = storeManager;
        this.times = this.storeManager.getTimestampProvider();
        this.entryGetter = new CassandraEmbeddedGetter(storeManager.getMetaDataSchema(columnFamily), this.times);
    }

    public void close() throws BackendException {
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(KeyRangeQuery keyRangeQuery, StoreTransaction txh) throws BackendException {
        IPartitioner partitioner = StorageService.getPartitioner();
        if (partitioner instanceof RandomPartitioner || partitioner instanceof Murmur3Partitioner) {
            throw new PermanentBackendException("This operation is only supported when byte-ordered partitioner is used.");
        }
        return new RowIterator(keyRangeQuery, this.storeManager.getPageSize(), txh);
    }

    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
        return new RowIterator(CassandraEmbeddedKeyColumnValueStore.getMinimumToken(), CassandraEmbeddedKeyColumnValueStore.getMaximumToken(), query, this.storeManager.getPageSize(), txh);
    }

    private List<Row> getKeySlice(Token start, Token end, @Nullable SliceQuery sliceQuery, int pageSize, long nowMillis) throws BackendException {
        List rows;
        IPartitioner partitioner = StorageService.getPartitioner();
        SliceRange columnSlice = new SliceRange();
        if (sliceQuery == null) {
            columnSlice.setStart(ArrayUtils.EMPTY_BYTE_ARRAY).setFinish(ArrayUtils.EMPTY_BYTE_ARRAY).setCount(5);
        } else {
            columnSlice.setStart(sliceQuery.getSliceStart().asByteBuffer()).setFinish(sliceQuery.getSliceEnd().asByteBuffer()).setCount(sliceQuery.hasLimit() ? sliceQuery.getLimit() : Integer.MAX_VALUE);
        }
        SlicePredicate predicate = new SlicePredicate().setSlice_range(columnSlice);
        Token.KeyBound startPosition = start.minKeyBound(partitioner);
        Token.KeyBound endPosition = end.minKeyBound(partitioner);
        try {
            CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace, this.columnFamily);
            IDiskAtomFilter filter = ThriftValidation.asIFilter((SlicePredicate)predicate, (CFMetaData)cfm, null);
            RangeSliceCommand cmd = new RangeSliceCommand(this.keyspace, this.columnFamily, nowMillis, filter, (AbstractBounds)new Bounds((RingPosition)startPosition, (RingPosition)endPosition), pageSize);
            rows = StorageProxy.getRangeSlice((AbstractRangeCommand)cmd, (ConsistencyLevel)ConsistencyLevel.QUORUM);
        }
        catch (Exception e) {
            throw new PermanentBackendException((Throwable)e);
        }
        return rows;
    }

    public String getName() {
        return this.columnFamily;
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        long nowMillis = this.times.getTime().toEpochMilli();
        CellName startComposite = CellNames.simpleDense((ByteBuffer)query.getSliceStart().asByteBuffer());
        CellName endComposite = CellNames.simpleDense((ByteBuffer)query.getSliceEnd().asByteBuffer());
        SliceQueryFilter sqf = new SliceQueryFilter((Composite)startComposite, (Composite)endComposite, false, query.getLimit() + (query.hasLimit() ? 1 : 0));
        SliceFromReadCommand sliceCmd = new SliceFromReadCommand(this.keyspace, query.getKey().asByteBuffer(), this.columnFamily, nowMillis, sqf);
        List<Row> slice = CassandraEmbeddedKeyColumnValueStore.read((ReadCommand)sliceCmd, CassandraTransaction.getTx(txh).getReadConsistencyLevel().getDB());
        if (null == slice || 0 == slice.size()) {
            return EntryList.EMPTY_LIST;
        }
        int sliceSize = slice.size();
        if (1 < sliceSize) {
            throw new PermanentBackendException("Received " + sliceSize + " rows for single key");
        }
        Row r = slice.get(0);
        if (null == r) {
            log.warn("Null Row object retrieved from Cassandra StorageProxy");
            return EntryList.EMPTY_LIST;
        }
        ColumnFamily cf = r.cf;
        if (null == cf) {
            log.debug("null ColumnFamily (\"{}\")", (Object)this.columnFamily);
            return EntryList.EMPTY_LIST;
        }
        if (cf.isMarkedForDelete()) {
            return EntryList.EMPTY_LIST;
        }
        return CassandraHelper.makeEntryList(Iterables.filter((Iterable)cf.getSortedColumns(), (Predicate)new FilterDeletedColumns(nowMillis)), this.entryGetter, query.getSliceEnd(), query.getLimit());
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        ImmutableMap mutations = ImmutableMap.of((Object)key, (Object)new KCVMutation(additions, deletions));
        this.mutateMany((Map<StaticBuffer, KCVMutation>)mutations, txh);
    }

    public void mutateMany(Map<StaticBuffer, KCVMutation> mutations, StoreTransaction txh) throws BackendException {
        this.storeManager.mutateMany((Map<String, Map<StaticBuffer, KCVMutation>>)ImmutableMap.of((Object)this.columnFamily, mutations), txh);
    }

    private static List<Row> read(ReadCommand cmd, ConsistencyLevel clvl) throws BackendException {
        ArrayList<ReadCommand> cmdHolder = new ArrayList<ReadCommand>(1);
        cmdHolder.add(cmd);
        return CassandraEmbeddedKeyColumnValueStore.read(cmdHolder, clvl);
    }

    private static List<Row> read(List<ReadCommand> cmds, ConsistencyLevel clvl) throws BackendException {
        try {
            return StorageProxy.read(cmds, (ConsistencyLevel)clvl);
        }
        catch (UnavailableException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        catch (RequestTimeoutException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        catch (IsBootstrappingException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        catch (InvalidRequestException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private static Token getMinimumToken() throws PermanentBackendException {
        IPartitioner partitioner = StorageService.getPartitioner();
        if (partitioner instanceof RandomPartitioner) {
            return ((RandomPartitioner)partitioner).getMinimumToken();
        }
        if (partitioner instanceof Murmur3Partitioner) {
            return ((Murmur3Partitioner)partitioner).getMinimumToken();
        }
        if (partitioner instanceof ByteOrderedPartitioner) {
            return new BytesToken(ByteBufferUtil.zeroByteBuffer((int)8));
        }
        throw new PermanentBackendException("Unsupported partitioner: " + partitioner);
    }

    private static Token getMaximumToken() throws PermanentBackendException {
        IPartitioner partitioner = StorageService.getPartitioner();
        if (partitioner instanceof RandomPartitioner) {
            return new BigIntegerToken(RandomPartitioner.MAXIMUM);
        }
        if (partitioner instanceof Murmur3Partitioner) {
            return new LongToken(Long.MAX_VALUE);
        }
        if (partitioner instanceof ByteOrderedPartitioner) {
            return new BytesToken(ByteBufferUtil.oneByteBuffer((int)8));
        }
        throw new PermanentBackendException("Unsupported partitioner: " + partitioner);
    }

    private class RowIterator
    implements KeyIterator {
        private final Token maximumToken;
        private final SliceQuery sliceQuery;
        private final StoreTransaction txh;
        private final long nowMillis;
        private Iterator<Row> keys;
        private ByteBuffer lastSeenKey = null;
        private Row currentRow;
        private int pageSize;
        private boolean isClosed;

        public RowIterator(KeyRangeQuery keyRangeQuery, int pageSize, StoreTransaction txh) throws BackendException {
            this(StorageService.getPartitioner().getToken(keyRangeQuery.getKeyStart().asByteBuffer()), StorageService.getPartitioner().getToken(keyRangeQuery.getKeyEnd().asByteBuffer()), (SliceQuery)keyRangeQuery, pageSize, txh);
        }

        public RowIterator(Token minimum, Token maximum, SliceQuery sliceQuery, int pageSize, StoreTransaction txh) throws BackendException {
            this.pageSize = pageSize;
            this.sliceQuery = sliceQuery;
            this.maximumToken = maximum;
            this.txh = txh;
            this.nowMillis = CassandraEmbeddedKeyColumnValueStore.this.times.getTime().toEpochMilli();
            this.keys = this.getRowsIterator(CassandraEmbeddedKeyColumnValueStore.this.getKeySlice(minimum, maximum, sliceQuery, pageSize, this.nowMillis));
        }

        public boolean hasNext() {
            try {
                return this.hasNextInternal();
            }
            catch (BackendException e) {
                throw new RuntimeException(e);
            }
        }

        public StaticBuffer next() {
            this.ensureOpen();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentRow = this.keys.next();
            ByteBuffer currentKey = this.currentRow.key.getKey().duplicate();
            try {
                StaticArrayBuffer staticArrayBuffer = StaticArrayBuffer.of((ByteBuffer)currentKey);
                return staticArrayBuffer;
            }
            finally {
                this.lastSeenKey = currentKey;
            }
        }

        public void close() {
            this.isClosed = true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public RecordIterator<Entry> getEntries() {
            this.ensureOpen();
            if (this.sliceQuery == null) {
                throw new IllegalStateException("getEntries() requires SliceQuery to be set.");
            }
            return new RecordIterator<Entry>(){
                final Iterator<Entry> columns;
                {
                    this.columns = CassandraHelper.makeEntryIterator(Iterables.filter((Iterable)((RowIterator)RowIterator.this).currentRow.cf.getSortedColumns(), (Predicate)new FilterDeletedColumns(RowIterator.this.nowMillis)), CassandraEmbeddedKeyColumnValueStore.this.entryGetter, RowIterator.this.sliceQuery.getSliceEnd(), RowIterator.this.sliceQuery.getLimit());
                }

                public boolean hasNext() {
                    RowIterator.this.ensureOpen();
                    return this.columns.hasNext();
                }

                public Entry next() {
                    RowIterator.this.ensureOpen();
                    return this.columns.next();
                }

                public void close() {
                    RowIterator.this.isClosed = true;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private final boolean hasNextInternal() throws BackendException {
            this.ensureOpen();
            if (this.keys == null) {
                return false;
            }
            boolean hasNext = this.keys.hasNext();
            if (!hasNext && this.lastSeenKey != null) {
                Token lastSeenToken = StorageService.getPartitioner().getToken(this.lastSeenKey.duplicate());
                if (this.maximumToken != CassandraEmbeddedKeyColumnValueStore.getMinimumToken() && lastSeenToken.equals(this.maximumToken)) {
                    return false;
                }
                List newKeys = CassandraEmbeddedKeyColumnValueStore.this.getKeySlice(StorageService.getPartitioner().getToken(this.lastSeenKey), this.maximumToken, this.sliceQuery, this.pageSize, this.nowMillis);
                this.keys = this.getRowsIterator(newKeys, this.lastSeenKey);
                hasNext = this.keys.hasNext();
            }
            return hasNext;
        }

        private void ensureOpen() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed.");
            }
        }

        private Iterator<Row> getRowsIterator(List<Row> rows) {
            if (rows == null) {
                return null;
            }
            return Iterators.filter(rows.iterator(), (Predicate)new Predicate<Row>(){

                public boolean apply(@Nullable Row row) {
                    return row != null && row.cf != null && !row.cf.isMarkedForDelete() && !row.cf.hasOnlyTombstones(RowIterator.this.nowMillis);
                }
            });
        }

        private Iterator<Row> getRowsIterator(List<Row> rows, final ByteBuffer exceptKey) {
            Iterator<Row> rowIterator = this.getRowsIterator(rows);
            if (rowIterator == null) {
                return null;
            }
            return Iterators.filter(rowIterator, (Predicate)new Predicate<Row>(){

                public boolean apply(@Nullable Row row) {
                    return row != null && !row.key.getKey().equals(exceptKey);
                }
            });
        }
    }

    private static class CassandraEmbeddedGetter
    implements StaticArrayEntry.GetColVal<Cell, ByteBuffer> {
        private final EntryMetaData[] schema;
        private final TimestampProvider times;

        private CassandraEmbeddedGetter(EntryMetaData[] schema, TimestampProvider times) {
            this.schema = schema;
            this.times = times;
        }

        public ByteBuffer getColumn(Cell element) {
            return org.apache.cassandra.utils.ByteBufferUtil.clone((ByteBuffer)element.name().toByteBuffer());
        }

        public ByteBuffer getValue(Cell element) {
            return org.apache.cassandra.utils.ByteBufferUtil.clone((ByteBuffer)element.value());
        }

        public EntryMetaData[] getMetaSchema(Cell element) {
            return this.schema;
        }

        public Object getMetaData(Cell element, EntryMetaData meta) {
            switch (meta) {
                case TIMESTAMP: {
                    return element.timestamp();
                }
                case TTL: {
                    return element instanceof ExpiringCell ? ((ExpiringCell)element).getTimeToLive() : 0;
                }
            }
            throw new UnsupportedOperationException("Unsupported meta data: " + meta);
        }
    }

    private static class FilterDeletedColumns
    implements Predicate<Cell> {
        private final long tsMillis;
        private final int tsSeconds;

        private FilterDeletedColumns(long tsMillis) {
            this.tsMillis = tsMillis;
            this.tsSeconds = (int)(this.tsMillis / 1000L);
        }

        public boolean apply(Cell input) {
            return input.isLive(this.tsMillis);
        }
    }
}

