/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra;

import com.google.common.base.Preconditions;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.janusgraph.diskstorage.cassandra.CLevelInterface;

public enum CLevel implements CLevelInterface
{
    ANY,
    ONE,
    TWO,
    THREE,
    QUORUM,
    ALL,
    LOCAL_ONE,
    LOCAL_QUORUM,
    EACH_QUORUM;

    private final org.apache.cassandra.db.ConsistencyLevel db = org.apache.cassandra.db.ConsistencyLevel.valueOf((String)this.toString());
    private final ConsistencyLevel thrift = ConsistencyLevel.valueOf((String)this.toString());
    private final com.netflix.astyanax.model.ConsistencyLevel astyanax = com.netflix.astyanax.model.ConsistencyLevel.valueOf((String)("CL_" + this.toString()));

    @Override
    public org.apache.cassandra.db.ConsistencyLevel getDB() {
        return this.db;
    }

    @Override
    public ConsistencyLevel getThrift() {
        return this.thrift;
    }

    @Override
    public com.netflix.astyanax.model.ConsistencyLevel getAstyanax() {
        return this.astyanax;
    }

    public static CLevel parse(String value) {
        Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0);
        value = value.trim();
        if (value.equals("1")) {
            return ONE;
        }
        if (value.equals("2")) {
            return TWO;
        }
        if (value.equals("3")) {
            return THREE;
        }
        for (CLevel c : CLevel.values()) {
            if (!c.toString().equalsIgnoreCase(value) && !("CL_" + c.toString()).equalsIgnoreCase(value)) continue;
            return c;
        }
        throw new IllegalArgumentException("Unrecognized cassandra consistency level: " + value);
    }
}

