/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.thrift;

import org.janusgraph.CassandraStorageSetup;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.graphdb.JanusGraphSpeedTest;
import org.janusgraph.graphdb.SpeedTestSchema;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.testcategory.PerformanceTests;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={PerformanceTests.class})
public class ThriftGraphSpeedTest
extends JanusGraphSpeedTest {
    private static StandardJanusGraph graph;
    private static SpeedTestSchema schema;
    private static final Logger log;

    public ThriftGraphSpeedTest() throws BackendException {
        super(CassandraStorageSetup.getCassandraThriftGraphConfiguration(ThriftGraphSpeedTest.class.getSimpleName()));
    }

    @BeforeClass
    public static void beforeClass() {
        CassandraStorageSetup.startCleanEmbedded();
    }

    protected StandardJanusGraph getGraph() throws BackendException {
        if (null == graph) {
            GraphDatabaseConfiguration graphconfig = new GraphDatabaseConfiguration((ReadConfiguration)this.conf);
            graphconfig.getBackend().clearStorage();
            log.debug("Cleared backend storage");
            graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)this.conf);
            this.initializeGraph((JanusGraph)graph);
        }
        return graph;
    }

    protected SpeedTestSchema getSchema() {
        if (null == schema) {
            schema = SpeedTestSchema.get();
        }
        return schema;
    }

    static {
        log = LoggerFactory.getLogger(ThriftGraphSpeedTest.class);
    }
}

