/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.thrift;

import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.thrift.ThriftServer;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnection;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftConnectionTest {
    private Logger log = LoggerFactory.getLogger(ThriftConnectionTest.class);
    private CTConnectionFactory.Config factoryConfig;

    @Before
    public void setUp() throws Exception {
        try {
            Config.setClientMode((boolean)true);
            Schema.instance.load(KSMetaData.newKeyspace((String)"janusgraph", (String)"SimpleStrategy", (Map)ImmutableMap.of((Object)"replication_factor", (Object)"1"), (boolean)true));
            this.log.debug("Starting ThriftServer for connection drop on port [9099]");
            ThriftServer server = new ThriftServer(InetAddress.getLocalHost(), 9099, 9098);
            server.start();
            this.log.debug("Started ThriftServer for connection drop on port [9099]");
            String[] hosts = new String[]{InetAddress.getLocalHost().getHostAddress()};
            this.factoryConfig = new CTConnectionFactory.Config(hosts, 9099, null, null).setTimeoutMS(5000).setFrameSize(0xF00000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testConnectionDropped() throws Exception {
        CTConnectionFactory connectionFactory = (CTConnectionFactory)Mockito.spy((Object)this.factoryConfig.build());
        CTConnection mockConnection = (CTConnection)Mockito.spy((Object)connectionFactory.makeObject("janusgraph"));
        Mockito.when((Object)mockConnection.getConfig()).thenReturn((Object)this.factoryConfig);
        Mockito.when((Object)mockConnection.isOpen()).thenReturn((Object)true);
        TTransport mockClient = (TTransport)Mockito.spy((Object)mockConnection.getTransport());
        Assert.assertTrue((boolean)connectionFactory.validateObject(null, mockConnection));
        Mockito.when((Object)mockClient.readAll(new byte[0], 0, 0)).thenThrow(new Throwable[]{new TTransportException("Broken Pipe")});
        Assert.assertTrue((boolean)mockClient.isOpen());
    }
}

