/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import org.janusgraph.CassandraStorageSetup;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.JanusGraphTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.JanusGraphConstants;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class CassandraGraphTest
extends JanusGraphTest {
    @BeforeClass
    public static void startCassandra() {
        CassandraStorageSetup.startCleanEmbedded();
    }

    @Test
    public void testHasTTL() throws Exception {
        Assert.assertTrue((boolean)this.features.hasCellTTL());
    }

    @Test
    public void testGraphConfigUsedByThreadBoundTx() {
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"LOCAL_QUORUM");
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)this.graph.getCurrentThreadTx();
        Assert.assertEquals((Object)"ALL", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, new String[0]));
        Assert.assertEquals((Object)"LOCAL_QUORUM", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, new String[0]));
    }

    @Test
    public void testGraphConfigUsedByTx() {
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"TWO");
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"THREE");
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)this.graph.newTransaction();
        Assert.assertEquals((Object)"TWO", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, new String[0]));
        Assert.assertEquals((Object)"THREE", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, new String[0]));
        tx.rollback();
    }

    @Test
    public void testCustomConfigUsedByTx() {
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)this.graph.buildTransaction().customOption(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (String[])new String[0]), (Object)"ONE").customOption(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (String[])new String[0]), (Object)"TWO").start();
        Assert.assertEquals((Object)"ONE", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, new String[0]));
        Assert.assertEquals((Object)"TWO", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, new String[0]));
        tx.rollback();
    }

    @Test
    public void testTitanGraphBackwardCompatibility() {
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, (String[])new String[0]), (Object)"titan");
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), (Object)"x.x.x");
        Assert.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, (String[])new String[0]), GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION.getDatatype()));
        Assert.assertFalse((boolean)JanusGraphConstants.TITAN_COMPATIBLE_VERSIONS.contains(wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS.getDatatype())));
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), (Object)"1.0.0");
        Assert.assertTrue((boolean)JanusGraphConstants.TITAN_COMPATIBLE_VERSIONS.contains(wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS.getDatatype())));
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.IDS_STORE_NAME, (String[])new String[0]), (Object)"titan_ids");
        Assert.assertTrue((boolean)"titan_ids".equals(wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.IDS_STORE_NAME, (String[])new String[0]), GraphDatabaseConfiguration.IDS_STORE_NAME.getDatatype())));
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
    }
}

