/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.utils;

import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.Token;
import org.janusgraph.diskstorage.cassandra.utils.CassandraHelper;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.junit.Assert;
import org.junit.Test;

public class CassandraHelperTest {
    private static final BytesToken ZERO = new BytesToken(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});

    @Test
    public void testTransformRange() {
        BytesToken token2 = new BytesToken(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1});
        KeyRange keyRange = CassandraHelper.transformRange((Token)ZERO, (Token)token2);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, (byte[])keyRange.getStart().asByteBuffer().array());
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 0}, (byte[])keyRange.getEnd().asByteBuffer().array());
    }

    @Test
    public void testTransformRangeWithRollingCarry() {
        BytesToken token2 = new BytesToken(new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        KeyRange keyRange = CassandraHelper.transformRange((Token)ZERO, (Token)token2);
        Assert.assertArrayEquals((byte[])new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (byte[])keyRange.getEnd().asByteBuffer().array());
    }
}

