/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.astyanax;

import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.CassandraStorageSetup;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreTest;
import org.janusgraph.diskstorage.cassandra.astyanax.AstyanaxStoreManager;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AstyanaxColumnPaginationTest
extends AbstractCassandraStoreTest {
    private static final int DEFAULT_READ_PAGE_SIZE = 4096;

    @BeforeClass
    public static void startCassandra() {
        CassandraStorageSetup.startCleanEmbedded();
    }

    @Override
    public ModifiableConfiguration getBaseStorageConfiguration() {
        return this.getBaseStorageConfiguration(((Object)((Object)this)).getClass().getSimpleName());
    }

    @Override
    public ModifiableConfiguration getBaseStorageConfiguration(String keyspace) {
        return CassandraStorageSetup.getAstyanaxConfiguration(keyspace);
    }

    @Override
    public AbstractCassandraStoreManager openStorageManager(Configuration c) throws BackendException {
        return new AstyanaxStoreManager(c);
    }

    @Test
    public void ensureReadPageSizePropertySetCorrectly() {
        Assert.assertEquals((long)((AstyanaxStoreManager)this.manager).readPageSize, (long)4096L);
    }

    @Test
    public void retrieveLessThanBoundaryColumnPaginationProperties() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        for (int i = 0; i < 4095; ++i) {
            v.property(String.valueOf(i), (Object)i);
        }
        graph.tx().commit();
        Assert.assertEquals((long)4095L, (long)((Map)graph.traversal().V(new Object[]{v}).valueMap(new String[0]).next()).keySet().size());
    }

    @Test
    public void retrieveBoundaryColumnPaginationProperties() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        for (int i = 0; i < 4096; ++i) {
            v.property(String.valueOf(i), (Object)i);
        }
        graph.tx().commit();
        Assert.assertEquals((long)4096L, (long)((Map)graph.traversal().V(new Object[]{v}).valueMap(new String[0]).next()).keySet().size());
    }

    @Test
    public void retrieveBeyondBoundaryColumnPaginationProperties() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        for (int i = 0; i < 4097; ++i) {
            v.property(String.valueOf(i), (Object)i);
        }
        graph.tx().commit();
        Assert.assertEquals((long)4097L, (long)((Map)graph.traversal().V(new Object[]{v}).valueMap(new String[0]).next()).keySet().size());
    }

    @Test
    public void retrieveWayBeyondBoundaryColumnPaginationProperties() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        for (int i = 0; i < 20480; ++i) {
            v.property(String.valueOf(i), (Object)i);
        }
        graph.tx().commit();
        Assert.assertEquals((long)20480L, (long)((Map)graph.traversal().V(new Object[]{v}).valueMap(new String[0]).next()).keySet().size());
    }

    @Test
    public void retrieveLessThanBoundaryColumnPaginationEdges() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        Vertex v2 = graph.addVertex(new Object[0]);
        for (int i = 0; i < 4095; ++i) {
            v.addEdge("edgeLabel", v2, new Object[0]);
        }
        graph.tx().commit();
        Assert.assertEquals((long)4095L, (long)graph.traversal().V(new Object[]{v}).outE(new String[0]).toList().size());
    }

    @Test
    public void retrieveBoundaryColumnPaginationEdges() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        Vertex v2 = graph.addVertex(new Object[0]);
        for (int i = 0; i < 4096; ++i) {
            v.addEdge("edgeLabel", v2, new Object[0]);
        }
        graph.tx().commit();
        Assert.assertEquals((long)4096L, (long)graph.traversal().V(new Object[]{v}).outE(new String[0]).toList().size());
    }

    @Test
    public void retrieveBeyondBoundaryColumnPaginationEdges() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        Vertex v2 = graph.addVertex(new Object[0]);
        for (int i = 0; i < 4097; ++i) {
            v.addEdge("edgeLabel", v2, new Object[0]);
        }
        graph.tx().commit();
        Assert.assertEquals((long)4097L, (long)graph.traversal().V(new Object[]{v}).outE(new String[0]).toList().size());
    }

    @Test
    public void retrieveWayBeyondBoundaryColumnPaginationEdges() {
        JanusGraph graph = JanusGraphFactory.open((BasicConfiguration)this.getBaseStorageConfiguration());
        Vertex v = graph.addVertex(new Object[0]);
        Vertex v2 = graph.addVertex(new Object[0]);
        for (int i = 0; i < 20480; ++i) {
            v.addEdge("edgeLabel", v2, new Object[0]);
        }
        graph.tx().commit();
        Assert.assertEquals((long)20480L, (long)graph.traversal().V(new Object[]{v}).outE(new String[0]).toList().size());
    }
}

