/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra;

import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.cassandra.CLevel;
import org.janusgraph.diskstorage.cassandra.CassandraTransaction;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class CassandraTransactionTest {
    @Test
    public void testWriteConsistencyLevel() {
        int levelsChecked = 0;
        for (CLevel writeLevel : CLevel.values()) {
            StandardBaseTransactionConfig.Builder b = new StandardBaseTransactionConfig.Builder();
            ModifiableConfiguration mc = GraphDatabaseConfiguration.buildGraphConfiguration();
            mc.set(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (Object)writeLevel.name(), new String[0]);
            b.customOptions((Configuration)mc);
            b.timestampProvider((TimestampProvider)TimestampProviders.MICRO);
            CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)b.build());
            Assert.assertEquals((Object)writeLevel, (Object)ct.getWriteConsistencyLevel());
            ++levelsChecked;
        }
        Preconditions.checkState((0 < levelsChecked ? 1 : 0) != 0);
    }

    @Test
    public void testReadConsistencyLevel() {
        int levelsChecked = 0;
        for (CLevel writeLevel : CLevel.values()) {
            StandardBaseTransactionConfig.Builder b = new StandardBaseTransactionConfig.Builder();
            ModifiableConfiguration mc = GraphDatabaseConfiguration.buildGraphConfiguration();
            mc.set(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (Object)writeLevel.name(), new String[0]);
            b.timestampProvider((TimestampProvider)TimestampProviders.MICRO);
            b.customOptions((Configuration)mc);
            CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)b.build());
            Assert.assertEquals((Object)writeLevel, (Object)ct.getReadConsistencyLevel());
            ++levelsChecked;
        }
        Preconditions.checkState((0 < levelsChecked ? 1 : 0) != 0);
    }

    @Test
    public void testTimestampProvider() {
        StandardBaseTransactionConfig txcfg = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.NANO);
        CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)TimestampProviders.NANO, (Object)ct.getConfiguration().getTimestampProvider());
        txcfg = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MICRO);
        ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)TimestampProviders.MICRO, (Object)ct.getConfiguration().getTimestampProvider());
        txcfg = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI);
        ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)TimestampProviders.MILLI, (Object)ct.getConfiguration().getTimestampProvider());
    }
}

