/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import org.apache.commons.io.FileUtils;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.cassandra.utils.CassandraDaemonWrapper;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStorageSetup {
    public static final String CONFDIR_SYSPROP = "test.cassandra.confdir";
    public static final String DATADIR_SYSPROP = "test.cassandra.datadir";
    public static final String HOSTNAME = System.getProperty(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_HOSTS, (String[])new String[0]));
    private static volatile Paths paths;
    private static final Logger log;

    private static synchronized Paths getPaths() {
        if (null == paths) {
            String yamlPath = "file://" + CassandraStorageSetup.loadAbsoluteDirectoryPath("conf", CONFDIR_SYSPROP, true) + File.separator + "cassandra.yaml";
            String dataPath = CassandraStorageSetup.loadAbsoluteDirectoryPath("data", DATADIR_SYSPROP, false);
            paths = new Paths(yamlPath, dataPath);
        }
        return paths;
    }

    private static ModifiableConfiguration getGenericConfiguration(String ks, String backend) {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        if (null != ks) {
            config.set(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, (Object)CassandraStorageSetup.cleanKeyspaceName(ks), new String[0]);
            log.debug("Set keyspace name: {}", config.get(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0]));
        }
        config.set(GraphDatabaseConfiguration.PAGE_SIZE, (Object)500, new String[0]);
        config.set(GraphDatabaseConfiguration.CONNECTION_TIMEOUT, (Object)Duration.ofSeconds(60L), new String[0]);
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)backend, new String[0]);
        if (HOSTNAME != null) {
            config.set(GraphDatabaseConfiguration.STORAGE_HOSTS, (Object)new String[]{HOSTNAME}, new String[0]);
        }
        config.set(GraphDatabaseConfiguration.DROP_ON_CLEAR, (Object)false, new String[0]);
        return config;
    }

    public static ModifiableConfiguration getEmbeddedConfiguration(String ks) {
        ModifiableConfiguration config = CassandraStorageSetup.getGenericConfiguration(ks, "embeddedcassandra");
        config.set(GraphDatabaseConfiguration.STORAGE_CONF_FILE, (Object)CassandraStorageSetup.getPaths().yamlPath, new String[0]);
        return config;
    }

    public static ModifiableConfiguration getEmbeddedCassandraPartitionConfiguration(String ks) {
        ModifiableConfiguration config = CassandraStorageSetup.getEmbeddedConfiguration(ks);
        config.set(GraphDatabaseConfiguration.IDS_FLUSH, (Object)false, new String[0]);
        return config;
    }

    public static WriteConfiguration getEmbeddedGraphConfiguration(String ks) {
        return CassandraStorageSetup.getEmbeddedConfiguration(ks).getConfiguration();
    }

    public static WriteConfiguration getEmbeddedCassandraPartitionGraphConfiguration(String ks) {
        return CassandraStorageSetup.getEmbeddedConfiguration(ks).getConfiguration();
    }

    public static ModifiableConfiguration getAstyanaxConfiguration(String ks) {
        return CassandraStorageSetup.getGenericConfiguration(ks, "astyanax");
    }

    public static ModifiableConfiguration getAstyanaxSSLConfiguration(String ks) {
        return CassandraStorageSetup.enableSSL(CassandraStorageSetup.getGenericConfiguration(ks, "astyanax"));
    }

    public static WriteConfiguration getAstyanaxGraphConfiguration(String ks) {
        return CassandraStorageSetup.getAstyanaxConfiguration(ks).getConfiguration();
    }

    public static ModifiableConfiguration getCassandraConfiguration(String ks) {
        return CassandraStorageSetup.getGenericConfiguration(ks, "cassandra");
    }

    public static WriteConfiguration getCassandraGraphConfiguration(String ks) {
        return CassandraStorageSetup.getCassandraConfiguration(ks).getConfiguration();
    }

    public static ModifiableConfiguration getCassandraThriftConfiguration(String ks) {
        return CassandraStorageSetup.getGenericConfiguration(ks, "cassandrathrift");
    }

    public static ModifiableConfiguration getCassandraThriftSSLConfiguration(String ks) {
        return CassandraStorageSetup.enableSSL(CassandraStorageSetup.getGenericConfiguration(ks, "cassandrathrift"));
    }

    public static WriteConfiguration getCassandraThriftGraphConfiguration(String ks) {
        return CassandraStorageSetup.getCassandraThriftConfiguration(ks).getConfiguration();
    }

    public static ModifiableConfiguration getEmbeddedOrThriftConfiguration(String keyspace) {
        ModifiableConfiguration config = HOSTNAME == null ? CassandraStorageSetup.getEmbeddedConfiguration(keyspace) : CassandraStorageSetup.getCassandraThriftConfiguration(keyspace);
        return config;
    }

    public static void startCleanEmbedded() {
        if (HOSTNAME == null) {
            CassandraStorageSetup.startCleanEmbedded(CassandraStorageSetup.getPaths());
        }
    }

    public static String cleanKeyspaceName(String raw) {
        Preconditions.checkNotNull((Object)raw);
        Preconditions.checkArgument((0 < raw.length() ? 1 : 0) != 0);
        if (48 < raw.length() || raw.matches("^.*[^a-zA-Z0-9_].*$")) {
            return "strhash" + String.valueOf(Math.abs(raw.hashCode()));
        }
        return raw;
    }

    private static ModifiableConfiguration enableSSL(ModifiableConfiguration mc) {
        mc.set(AbstractCassandraStoreManager.SSL_ENABLED, (Object)true, new String[0]);
        mc.set(GraphDatabaseConfiguration.STORAGE_HOSTS, (Object)new String[]{HOSTNAME != null ? HOSTNAME : "127.0.0.1"}, new String[0]);
        mc.set(AbstractCassandraStoreManager.SSL_TRUSTSTORE_LOCATION, (Object)Joiner.on((String)File.separator).join((Object)"target", (Object)"cassandra", new Object[]{"conf", "localhost-murmur-ssl", "test.truststore"}), new String[0]);
        mc.set(AbstractCassandraStoreManager.SSL_TRUSTSTORE_PASSWORD, (Object)"cassandra", new String[0]);
        return mc;
    }

    private static void startCleanEmbedded(Paths p) {
        if (!CassandraDaemonWrapper.isStarted()) {
            try {
                FileUtils.deleteDirectory((File)new File(p.dataPath));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        CassandraDaemonWrapper.start((String)p.yamlPath);
    }

    private static String loadAbsoluteDirectoryPath(String name, String prop, boolean mustExistAndBeAbsolute) {
        String s = System.getProperty(prop);
        if (null == s) {
            s = Joiner.on((String)File.separator).join((Object)System.getProperty("user.dir"), (Object)"target", new Object[]{"cassandra", name, "localhost-bop"});
            log.info("Set default Cassandra {} directory path {}", (Object)name, (Object)s);
        } else {
            log.info("Loaded Cassandra {} directory path {} from system property {}", new Object[]{name, s, prop});
        }
        if (mustExistAndBeAbsolute) {
            File dir = new File(s);
            Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"Path %s must be a directory", (Object[])new Object[]{s});
            Preconditions.checkArgument((boolean)dir.isAbsolute(), (String)"Path %s must be absolute", (Object[])new Object[]{s});
        }
        return s;
    }

    static {
        log = LoggerFactory.getLogger(CassandraStorageSetup.class);
    }

    private static class Paths {
        private final String yamlPath;
        private final String dataPath;

        public Paths(String yamlPath, String dataPath) {
            this.yamlPath = yamlPath;
            this.dataPath = dataPath;
        }
    }
}

