/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.olap;

import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class PageRankMapReduce
extends StaticMapReduce<Object, Double, Object, Double, Iterator<KeyValue<Object, Double>>> {
    public static final String PAGE_RANK_MEMORY_KEY = "janusgraph.pageRank.memoryKey";
    public static final String DEFAULT_MEMORY_KEY = "pageRank";
    private String memoryKey = "pageRank";

    private PageRankMapReduce() {
    }

    private PageRankMapReduce(String memoryKey) {
        this.memoryKey = memoryKey;
    }

    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty(PAGE_RANK_MEMORY_KEY, (Object)this.memoryKey);
    }

    public void loadState(Graph graph, Configuration configuration) {
        this.memoryKey = configuration.getString(PAGE_RANK_MEMORY_KEY, DEFAULT_MEMORY_KEY);
    }

    public boolean doStage(MapReduce.Stage stage) {
        return stage.equals((Object)MapReduce.Stage.MAP);
    }

    public void map(Vertex vertex, MapReduce.MapEmitter<Object, Double> emitter) {
        VertexProperty pageRank = vertex.property("janusgraph.pageRank.pageRank");
        if (pageRank.isPresent()) {
            emitter.emit(vertex.id(), (Object)((Double)pageRank.value()));
        }
    }

    public Iterator<KeyValue<Object, Double>> generateFinalResult(Iterator<KeyValue<Object, Double>> keyValues) {
        return keyValues;
    }

    public String getMemoryKey() {
        return this.memoryKey;
    }

    public String toString() {
        return StringFactory.mapReduceString((MapReduce)this, (String)this.memoryKey);
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private String memoryKey = "pageRank";

        private Builder() {
        }

        public Builder memoryKey(String memoryKey) {
            this.memoryKey = memoryKey;
            return this;
        }

        public PageRankMapReduce create() {
            return new PageRankMapReduce(this.memoryKey);
        }
    }
}

