/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.management;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagementTest
extends JanusGraphBaseTest {
    private static final Logger log = LoggerFactory.getLogger(ManagementTest.class);
    private static final Set<String> ILLEGAL_USER_DEFINED_NAMES = ImmutableSet.of((Object)"~key", (Object)"~value", (Object)"~id", (Object)"~nid", (Object)"~label", (Object)"~adjacent", (Object[])new String[]{"~timestamp", "~ttl", "~visibility", "key", "vertex", "edge", "element", "property", "label", "~T$VertexExists", "~T$SchemaName", "~T$SchemaDefinitionProperty", "~T$SchemaCategory", "~T$SchemaDefinitionDescription", "~T$SchemaUpdateTimestamp", "~T$SchemaRelated", "~T$VertexLabel"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReservedNamesRejectedForPropertyKeys() {
        for (String s : ILLEGAL_USER_DEFINED_NAMES) {
            JanusGraphManagement tm = this.graph.openManagement();
            try {
                tm.makePropertyKey(s);
                Assertions.fail((String)("Property key  \"" + s + "\" must be rejected"));
            }
            catch (IllegalArgumentException e) {
                log.debug("Caught expected exception", (Throwable)e);
            }
            finally {
                tm.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReservedNamesRejectedForEdgeLabels() {
        for (String s : ILLEGAL_USER_DEFINED_NAMES) {
            JanusGraphManagement tm = this.graph.openManagement();
            try {
                tm.makeEdgeLabel(s);
                Assertions.fail((String)("Edge label \"" + s + "\" must be rejected"));
            }
            catch (IllegalArgumentException e) {
                log.debug("Caught expected exception", (Throwable)e);
            }
            finally {
                tm.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReservedNamesRejectedForVertexLabels() {
        for (String s : ILLEGAL_USER_DEFINED_NAMES) {
            JanusGraphManagement tm = this.graph.openManagement();
            try {
                tm.makeVertexLabel(s);
                Assertions.fail((String)("Vertex label \"" + s + "\" must be rejected"));
            }
            catch (IllegalArgumentException e) {
                log.debug("Caught expected exception", (Throwable)e);
            }
            finally {
                tm.commit();
            }
        }
    }
}

