/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.ChooseStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.OptionalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.UnionStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphConfigurationException;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.SchemaViolationException;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.VertexList;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.log.Change;
import org.janusgraph.core.log.LogProcessorFramework;
import org.janusgraph.core.log.TransactionRecovery;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.Message;
import org.janusgraph.diskstorage.log.MessageReader;
import org.janusgraph.diskstorage.log.ReadMarker;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.TestMockLog;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.log.LogTxMeta;
import org.janusgraph.graphdb.database.log.LogTxStatus;
import org.janusgraph.graphdb.database.log.TransactionLogHeader;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.management.RelationIndexStatusWatcher;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.log.StandardTransactionLogProcessor;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.profile.SimpleQueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.relations.AbstractEdge;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.schema.EdgeLabelDefinition;
import org.janusgraph.graphdb.schema.PropertyKeyDefinition;
import org.janusgraph.graphdb.schema.SchemaContainer;
import org.janusgraph.graphdb.schema.VertexLabelDefinition;
import org.janusgraph.graphdb.serializer.SpecialInt;
import org.janusgraph.graphdb.serializer.SpecialIntSerializer;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexHasIdOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexIsOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphPropertiesStep;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphStep;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphVertexStep;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.graphdb.types.StandardPropertyKeyMaker;
import org.janusgraph.graphdb.types.system.BaseVertexLabel;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.testutil.FeatureFlag;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.testutil.JanusGraphFeature;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphTest
extends JanusGraphBaseTest {
    private final Logger log = LoggerFactory.getLogger(JanusGraphTest.class);

    final boolean isLockingOptimistic() {
        return this.features.hasOptimisticLocking();
    }

    private void initializeGraphWithVerticesAndEdges() {
        if (this.mgmt.getEdgeLabel("fork-connect") == null) {
            EdgeLabel forkConnect = this.mgmt.makeEdgeLabel("fork-connect").make();
            this.mgmt.setConsistency((JanusGraphSchemaElement)forkConnect, ConsistencyModifier.FORK);
            this.finishSchema();
        }
        Vertex v = (Vertex)this.graph.traversal().addV().property((Object)"_v", (Object)1, new Object[0]).next();
        v.property("_v").property("flag", (Object)false);
        Vertex v2 = (Vertex)this.graph.traversal().addV().property((Object)"_v", (Object)2, new Object[0]).property((Object)"prop", (Object)"old", new Object[0]).next();
        Edge edge = v.addEdge("connect", v2, new Object[]{"_e", 1});
        Edge forkEdge = v.addEdge("fork-connect", v2, new Object[]{"_e", 2});
        this.graph.tx().commit();
    }

    @Test
    public void testUpdateVertexPropThenRemoveProp() {
        this.initializeGraphWithVerticesAndEdges();
        Vertex v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        Assertions.assertEquals((Object)"old", (Object)v2.property("prop").value());
        v2.property("prop", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)v2.property("prop").value());
        v2.property("prop", (Object)"new2");
        Assertions.assertEquals((Object)"new2", (Object)v2.property("prop").value());
        v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        v2.property("prop", (Object)"new3");
        Assertions.assertEquals((Object)"new3", (Object)v2.property("prop").value());
        v2.property("prop").remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[]{v2}).values(new String[]{"prop"}).hasNext());
    }

    @Test
    public void testNestedAddVertexPropThenRemoveProp() {
        this.mgmt.makePropertyKey("prop").dataType(String.class).make();
        this.mgmt.commit();
        this.graph.addVertex(new Object[0]);
        this.graph.tx().commit();
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        ((Vertex)tx1.traversal().V(new Object[0]).next()).property("prop", (Object)"tx1");
        Vertex v = (Vertex)tx2.traversal().V(new Object[0]).next();
        v.property("prop", (Object)"tx2");
        tx1.commit();
        v.property("prop").remove();
        tx2.commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).values(new String[]{"prop"}).hasNext());
    }

    @Test
    public void testUpdateVertexPropThenRemoveVertex() {
        this.initializeGraphWithVerticesAndEdges();
        Vertex v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        Assertions.assertEquals((Object)"old", (Object)v2.property("prop").value());
        v2.property("prop", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)v2.property("prop").value());
        v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        v2.property("prop", (Object)"new2");
        Assertions.assertEquals((Object)"new2", (Object)v2.property("prop").value());
        v2.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[]{v2}).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("prop", (Object)"old").hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("prop", (Object)"new").hasNext());
    }

    @Test
    public void testUpdatePropertyPropThenRemoveProperty() {
        for (boolean reload : Arrays.asList(true, false)) {
            this.graph.traversal().V(new Object[0]).drop().iterate();
            this.initializeGraphWithVerticesAndEdges();
            Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext());
            VertexProperty p = (VertexProperty)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).next();
            Assertions.assertEquals((Object)false, (Object)p.property("flag").value());
            p.property("flag", (Object)true);
            Assertions.assertEquals((Object)true, (Object)p.property("flag").value());
            if (!reload) {
                p.remove();
            } else {
                ((VertexProperty)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).next()).remove();
            }
            this.graph.tx().commit();
            Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext());
        }
    }

    @Test
    public void testUpdatePropertyPropThenRemovePropertyProp() {
        this.initializeGraphWithVerticesAndEdges();
        VertexProperty p = (VertexProperty)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).next();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).values(new String[]{"flag"}).hasNext());
        Assertions.assertEquals((Object)false, (Object)p.property("flag").value());
        p.property("flag", (Object)true);
        Assertions.assertEquals((Object)true, (Object)p.property("flag").value());
        p.property("flag").remove();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).values(new String[]{"flag"}).hasNext());
    }

    @Test
    public void testUpdatePropertyPropThenRemoveVertex() {
        this.initializeGraphWithVerticesAndEdges();
        Vertex v = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).next();
        VertexProperty p = (VertexProperty)v.properties(new String[]{"_v"}).next();
        Assertions.assertEquals((Object)false, (Object)p.property("flag").value());
        p.property("flag", (Object)true);
        Assertions.assertEquals((Object)true, (Object)p.property("flag").value());
        p.property("flag").remove();
        v.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).hasNext());
    }

    @Test
    public void testUpdateEdgePropertyThenRemoveEdge() {
        this.initializeGraphWithVerticesAndEdges();
        AbstractEdge edge = (AbstractEdge)this.graph.traversal().E(new Object[0]).has("_e", (Object)1).next();
        Assertions.assertTrue((boolean)ElementLifeCycle.isLoaded((byte)edge.getLifeCycle()));
        RelationIdentifier id = edge.id();
        for (int val : Arrays.asList(-1, -11)) {
            edge.property("_e", (Object)val);
            Assertions.assertEquals((Object)id, (Object)edge.id());
            Assertions.assertTrue((boolean)ElementLifeCycle.isRemoved((byte)edge.getLifeCycle()));
            Assertions.assertEquals((Object)id, (Object)edge.it().id());
            Assertions.assertTrue((boolean)ElementLifeCycle.isNew((byte)edge.it().getLifeCycle()));
            Assertions.assertTrue((boolean)edge.isNew());
        }
        edge.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)1).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-1).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-11).hasNext());
        Assertions.assertTrue((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)2).hasNext());
    }

    @Test
    public void testUpdateForkEdgePropertyThenRemoveEdge() {
        this.initializeGraphWithVerticesAndEdges();
        AbstractEdge edge = (AbstractEdge)this.graph.traversal().E(new Object[0]).has("_e", (Object)2).next();
        Assertions.assertTrue((boolean)ElementLifeCycle.isLoaded((byte)edge.getLifeCycle()));
        RelationIdentifier id = edge.id();
        edge.property("_e", (Object)-2);
        Assertions.assertEquals((Object)id, (Object)edge.id());
        Assertions.assertTrue((boolean)ElementLifeCycle.isRemoved((byte)edge.getLifeCycle()));
        Object forkedId = edge.it().id();
        Assertions.assertNotEquals((Object)id, (Object)forkedId);
        Assertions.assertTrue((boolean)ElementLifeCycle.isNew((byte)edge.it().getLifeCycle()));
        Assertions.assertTrue((boolean)edge.isNew());
        edge.property("_e", (Object)-3);
        Assertions.assertEquals((Object)id, (Object)edge.id());
        Assertions.assertTrue((boolean)ElementLifeCycle.isRemoved((byte)edge.getLifeCycle()));
        Assertions.assertEquals((Object)forkedId, (Object)edge.it().id());
        Assertions.assertTrue((boolean)ElementLifeCycle.isNew((byte)edge.it().getLifeCycle()));
        Assertions.assertTrue((boolean)edge.isNew());
        edge.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)2).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-2).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-3).hasNext());
    }

    @Test
    public void testOpenClose() {
    }

    @Test
    public void testClearStorage() throws Exception {
        this.tearDown();
        this.config.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.DROP_ON_CLEAR, (String[])new String[0]), (Object)true);
        Backend backend = JanusGraphTest.getBackend(this.config, false);
        Assertions.assertTrue((boolean)backend.getStoreManager().exists(), (String)"graph should exist before clearing storage");
        JanusGraphTest.clearGraph(this.config);
        Assertions.assertFalse((boolean)backend.getStoreManager().exists(), (String)"graph should not exist after clearing storage");
    }

    @Test
    public void testBasic() throws BackendException {
        PropertyKey uid = this.makeVertexIndexedUniqueKey("name", String.class);
        this.finishSchema();
        JanusGraphVertex n1 = this.tx.addVertex(new Object[0]);
        uid = this.tx.getPropertyKey("name");
        n1.property(uid.name(), (Object)"abcd");
        this.clopen(new Object[0]);
        long nid = n1.longId();
        uid = this.tx.getPropertyKey("name");
        Assertions.assertNotNull((Object)JanusGraphTest.getV((Transaction)this.tx, nid));
        Assertions.assertNotNull((Object)JanusGraphTest.getV((Transaction)this.tx, uid.longId()));
        JanusGraphTest.assertMissing((Transaction)this.tx, nid + 64L);
        uid = this.tx.getPropertyKey(uid.name());
        n1 = JanusGraphTest.getV((Transaction)this.tx, nid);
        Assertions.assertEquals((Object)n1, (Object)JanusGraphTest.getOnlyVertex(this.tx.query().has(uid.name(), (Object)"abcd")));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)n1.query().relations()));
        Assertions.assertEquals((Object)"abcd", (Object)n1.value(uid.name()));
        JanusGraphAssert.assertCount(1, this.tx.query().vertices());
        this.close();
        JanusGraphFactory.drop((JanusGraph)this.graph);
        this.open(this.config);
        JanusGraphAssert.assertEmpty(this.tx.query().vertices());
    }

    @Test
    public void testVertexRemoval() {
        String nameUniqueVertexPropertyName = "name";
        this.makeVertexIndexedUniqueKey("name", String.class);
        this.finishSchema();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "v1"});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "v2"});
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        JanusGraphAssert.assertCount(2, this.graph.query().vertices());
        JanusGraphAssert.assertCount(1, this.graph.query().has("name", (Object)"v2").vertices());
        this.clopen(new Object[0]);
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2);
        JanusGraphAssert.assertCount(1, v1.query().direction(Direction.BOTH).edges());
        JanusGraphAssert.assertCount(1, v2.query().direction(Direction.BOTH).edges());
        v2.remove();
        JanusGraphAssert.assertCount(0, v1.query().direction(Direction.BOTH).edges());
        JanusGraphVertex v2Copied = v2;
        Assertions.assertThrows(IllegalStateException.class, () -> v2Copied.query().direction(Direction.BOTH).edges());
        JanusGraphAssert.assertCount(1, this.graph.query().vertices());
        JanusGraphAssert.assertCount(1, this.graph.query().has("name", (Object)"v1").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (Object)"v2").vertices());
        this.graph.tx().commit();
        JanusGraphTest.assertMissing((Transaction)this.graph, v2);
        JanusGraphAssert.assertCount(1, this.graph.query().vertices());
        JanusGraphAssert.assertCount(1, this.graph.query().has("name", (Object)"v1").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (Object)"v2").vertices());
    }

    @Test
    public void testGlobalIteration() {
        int i;
        int numV = 50;
        int deleteV = 5;
        JanusGraphVertex previous = this.tx.addVertex(new Object[]{"count", 0});
        for (int i2 = 1; i2 < numV; ++i2) {
            JanusGraphVertex next = this.tx.addVertex(new Object[]{"count", i2});
            previous.addEdge("next", (Vertex)next, new Object[0]);
            previous = next;
        }
        int numE = numV - 1;
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        for (Object v : this.tx.query().limit(deleteV).vertices()) {
            ((JanusGraphVertex)v).remove();
        }
        for (i = 0; i < 10; ++i) {
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().vertices());
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().has("count", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0).vertices());
        }
        this.clopen(new Object[0]);
        for (i = 0; i < 10; ++i) {
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().vertices());
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().has("count", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0).vertices());
        }
    }

    @Test
    public void testMediumCreateRetrieve() {
        JanusGraphVertex n;
        int i;
        JanusGraphVertex n2;
        this.makeLabel("connect");
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{id}).signature(new PropertyKey[]{weight}).make();
        this.finishSchema();
        int noVertices = 500;
        String[] names = new String[noVertices];
        int[] ids = new int[noVertices];
        JanusGraphVertex[] nodes = new JanusGraphVertex[noVertices];
        long[] nodeIds = new long[noVertices];
        List[] nodeEdges = new List[noVertices];
        for (int i2 = 0; i2 < noVertices; ++i2) {
            names[i2] = "vertex" + i2;
            ids[i2] = i2;
            nodes[i2] = this.tx.addVertex(new Object[]{"name", names[i2], "uid", ids[i2]});
            if ((i2 + 1) % 100 != 0) continue;
            this.log.debug("Added 100 nodes");
        }
        this.log.debug("Nodes created");
        int[] connectOff = new int[]{-100, -34, -4, 10, 20};
        int[] knowsOff = new int[]{-400, -18, 8, 232, 334};
        for (int i3 = 0; i3 < noVertices; ++i3) {
            JanusGraphVertex n3 = nodes[i3];
            nodeEdges[i3] = new ArrayList(10);
            for (int c : connectOff) {
                JanusGraphEdge r = n3.addEdge("connect", (Vertex)nodes[JanusGraphTest.wrapAround(i3 + c, noVertices)], new Object[0]);
                nodeEdges[i3].add(r);
            }
            for (int k : knowsOff) {
                n2 = nodes[JanusGraphTest.wrapAround(i3 + k, noVertices)];
                JanusGraphEdge r = n3.addEdge("knows", (Vertex)n2, new Object[]{"uid", ((Number)n3.value("uid")).intValue() + ((Number)n2.value("uid")).intValue(), "weight", (double)k * 1.5, "name", i3 + "-" + k});
                nodeEdges[i3].add(r);
            }
            if (i3 % 100 != 99) continue;
            this.log.debug(".");
        }
        this.tx.commit();
        this.tx = null;
        Set[] nodeEdgeIds = new Set[noVertices];
        for (i = 0; i < noVertices; ++i) {
            nodeIds[i] = (Long)nodes[i].id();
            nodeEdgeIds[i] = new HashSet(10);
            Object object = nodeEdges[i].iterator();
            while (object.hasNext()) {
                Object r = object.next();
                nodeEdgeIds[i].add(((JanusGraphEdge)r).longId());
            }
        }
        this.clopen(new Object[0]);
        nodes = new JanusGraphVertex[noVertices];
        for (i = 0; i < noVertices; ++i) {
            n = this.getVertex("uid", (Object)ids[i]);
            Assertions.assertEquals((Object)n, (Object)this.getVertex("name", (Object)names[i]));
            Assertions.assertEquals((Object)names[i], (Object)n.value("name"));
            nodes[i] = n;
            Assertions.assertEquals((long)nodeIds[i], (long)n.longId());
        }
        for (i = 0; i < noVertices; ++i) {
            n = nodes[i];
            JanusGraphAssert.assertCount(connectOff.length + knowsOff.length, n.query().direction(Direction.OUT).edges());
            JanusGraphAssert.assertCount(connectOff.length, n.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
            JanusGraphAssert.assertCount(connectOff.length * 2, n.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
            JanusGraphAssert.assertCount(knowsOff.length * 2, n.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(connectOff.length + knowsOff.length, n.query().direction(Direction.OUT).edges());
            JanusGraphAssert.assertCount(2, n.properties(new String[0]));
            for (Object o : n.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges()) {
                Object r = (JanusGraphEdge)o;
                n2 = r.vertex(Direction.IN);
                int idSum = ((Number)n.value("uid")).intValue() + ((Number)n2.value("uid")).intValue();
                Assertions.assertEquals((int)idSum, (int)((Number)r.value("uid")).intValue());
                double k = ((Number)r.value("weight")).doubleValue() / 1.5;
                int ki = (int)k;
                Assertions.assertEquals((Object)(i + "-" + ki), (Object)r.value("name"));
            }
            HashSet<Long> edgeIds = new HashSet<Long>(10);
            for (Object r : n.query().direction(Direction.OUT).edges()) {
                edgeIds.add(r.longId());
            }
            Assertions.assertEquals(edgeIds, (Object)nodeEdgeIds[i], (String)(edgeIds + " vs " + nodeEdgeIds[i]));
        }
        this.newTx();
        long[] vertexIdsOne = new long[noVertices / 10];
        System.arraycopy(nodeIds, 0, vertexIdsOne, 0, vertexIdsOne.length);
        this.verifyVerticesRetrieval(vertexIdsOne, Lists.newArrayList((Iterable)this.tx.getVertices(vertexIdsOne)));
        this.verifyVerticesRetrieval(vertexIdsOne, Lists.newArrayList((Iterable)this.tx.getVertices(vertexIdsOne)));
        long[] vertexIdsTwo = new long[noVertices / 10 * 2];
        System.arraycopy(nodeIds, 0, vertexIdsTwo, 0, vertexIdsTwo.length);
        this.verifyVerticesRetrieval(vertexIdsTwo, Lists.newArrayList((Iterable)this.tx.getVertices(vertexIdsTwo)));
    }

    private void verifyVerticesRetrieval(long[] vertexIds, List<JanusGraphVertex> vs) {
        Assertions.assertEquals((int)vertexIds.length, (int)vs.size());
        HashSet vertexIdSet = new HashSet(vs.size());
        vs.forEach(v -> vertexIdSet.add((Long)v.id()));
        for (long vertexId : vertexIds) {
            Assertions.assertTrue((boolean)vertexIdSet.contains(vertexId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaTypes() {
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", String.class);
        PropertyKey someId = this.makeVertexIndexedKey("someid", Object.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        PropertyKey value = this.mgmt.makePropertyKey("value").dataType(Double.class).signature(new PropertyKey[]{weight}).cardinality(Cardinality.LIST).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{uid}).multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel parent = this.mgmt.makeEdgeLabel("parent").multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel tag = this.mgmt.makeVertexLabel("tag").make();
        VertexLabel tweet = this.mgmt.makeVertexLabel("tweet").setStatic().make();
        Assertions.assertTrue((boolean)this.mgmt.isOpen());
        Assertions.assertEquals((Object)"weight", (Object)weight.toString());
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assertions.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assertions.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assertions.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assertions.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assertions.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assertions.assertTrue((boolean)weight.isPropertyKey());
        Assertions.assertFalse((boolean)weight.isEdgeLabel());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)weight.cardinality());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)someId.cardinality());
        Assertions.assertEquals((Object)Cardinality.SET, (Object)name.cardinality());
        Assertions.assertEquals((Object)Cardinality.LIST, (Object)value.cardinality());
        Assertions.assertEquals(Object.class, (Object)someId.dataType());
        Assertions.assertEquals(Float.class, (Object)weight.dataType());
        long[] sig = ((InternalRelationType)value).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((long)weight.longId(), (long)sig[0]);
        Assertions.assertTrue((boolean)this.mgmt.getGraphIndex(uid.name()).isUnique());
        Assertions.assertFalse((boolean)this.mgmt.getGraphIndex(someId.name()).isUnique());
        Assertions.assertEquals((Object)"friend", (Object)friend.name());
        Assertions.assertTrue((boolean)friend.isEdgeLabel());
        Assertions.assertFalse((boolean)friend.isPropertyKey());
        Assertions.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MULTI, (Object)friend.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.multiplicity());
        Assertions.assertTrue((boolean)link.isUnidirected());
        Assertions.assertFalse((boolean)link.isDirected());
        Assertions.assertFalse((boolean)child.isUnidirected());
        Assertions.assertTrue((boolean)spouse.isDirected());
        Assertions.assertFalse((boolean)((InternalRelationType)friend).isInvisibleType());
        Assertions.assertTrue((boolean)((InternalRelationType)friend).isInvisible());
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((long)uid.longId(), (long)sig[0]);
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSortKey().length);
        Assertions.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assertions.assertEquals((int)5, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assertions.assertEquals((int)6, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assertions.assertEquals((int)11, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assertions.assertEquals((Object)"tweet", (Object)tweet.name());
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assertions.assertFalse((boolean)person.isPartitioned());
        Assertions.assertFalse((boolean)person.isStatic());
        Assertions.assertFalse((boolean)tag.isPartitioned());
        Assertions.assertTrue((boolean)tweet.isStatic());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makePropertyKey("fid").make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeEdgeLabel("link").unidirected().make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new PropertyKey[]{someId, weight}).signature(new PropertyKey[]{someId}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new PropertyKey[]{weight}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new PropertyKey[]{weight}).make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeVertexLabel("tweet").make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makeEdgeLabel("test").signature(new PropertyKey[]{someId}).make());
        this.finishSchema();
        this.clopen(new Object[0]);
        PropertyKey weight2 = this.mgmt.getPropertyKey("weight");
        uid = this.mgmt.getPropertyKey("uid");
        PropertyKey someId2 = this.mgmt.getPropertyKey("someid");
        name = this.mgmt.getPropertyKey("name");
        value = this.mgmt.getPropertyKey("value");
        friend = this.mgmt.getEdgeLabel("friend");
        link = this.mgmt.getEdgeLabel("link");
        connect = this.mgmt.getEdgeLabel("connect");
        parent = this.mgmt.getEdgeLabel("parent");
        child = this.mgmt.getEdgeLabel("child");
        spouse = this.mgmt.getEdgeLabel("spouse");
        person = this.mgmt.getVertexLabel("person");
        tag = this.mgmt.getVertexLabel("tag");
        tweet = this.mgmt.getVertexLabel("tweet");
        Assertions.assertTrue((boolean)this.mgmt.isOpen());
        Assertions.assertEquals((Object)"weight", (Object)weight2.toString());
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assertions.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assertions.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assertions.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assertions.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assertions.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assertions.assertTrue((boolean)weight2.isPropertyKey());
        Assertions.assertFalse((boolean)weight2.isEdgeLabel());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)weight2.cardinality());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)someId2.cardinality());
        Assertions.assertEquals((Object)Cardinality.SET, (Object)name.cardinality());
        Assertions.assertEquals((Object)Cardinality.LIST, (Object)value.cardinality());
        Assertions.assertEquals(Object.class, (Object)someId2.dataType());
        Assertions.assertEquals(Float.class, (Object)weight2.dataType());
        sig = ((InternalRelationType)value).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((long)weight2.longId(), (long)sig[0]);
        Assertions.assertTrue((boolean)this.mgmt.getGraphIndex(uid.name()).isUnique());
        Assertions.assertFalse((boolean)this.mgmt.getGraphIndex(someId2.name()).isUnique());
        Assertions.assertEquals((Object)"friend", (Object)friend.name());
        Assertions.assertTrue((boolean)friend.isEdgeLabel());
        Assertions.assertFalse((boolean)friend.isPropertyKey());
        Assertions.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MULTI, (Object)friend.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.multiplicity());
        Assertions.assertTrue((boolean)link.isUnidirected());
        Assertions.assertFalse((boolean)link.isDirected());
        Assertions.assertFalse((boolean)child.isUnidirected());
        Assertions.assertTrue((boolean)spouse.isDirected());
        Assertions.assertFalse((boolean)((InternalRelationType)friend).isInvisibleType());
        Assertions.assertTrue((boolean)((InternalRelationType)friend).isInvisible());
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((long)uid.longId(), (long)sig[0]);
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSortKey().length);
        Assertions.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assertions.assertEquals((int)5, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assertions.assertEquals((int)6, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assertions.assertEquals((int)11, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assertions.assertEquals((Object)"tweet", (Object)tweet.name());
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assertions.assertFalse((boolean)person.isPartitioned());
        Assertions.assertFalse((boolean)person.isStatic());
        Assertions.assertFalse((boolean)tag.isPartitioned());
        Assertions.assertTrue((boolean)tweet.isStatic());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makePropertyKey("fid").make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeEdgeLabel("link").unidirected().make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new PropertyKey[]{someId2, weight2}).signature(new PropertyKey[]{someId2}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new PropertyKey[]{weight2}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new PropertyKey[]{weight2}).make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeVertexLabel("tweet").make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makeEdgeLabel("test").signature(new PropertyKey[]{someId2}).make());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertEmpty(this.tx.query().has("uid", (Object)"v1").vertices());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.property("uid", (Object)"v1");
        v.property("weight", (Object)1.5);
        v.property("someid", (Object)"Hello");
        v.property("name", (Object)"Bob");
        v.property("name", (Object)"John");
        JanusGraphVertexProperty p = v.property("value", (Object)11);
        p.property("weight", (Object)22);
        v.property("value", (Object)33.3, new Object[]{"weight", 66.6});
        v.property("value", (Object)11, new Object[]{"weight", 22});
        JanusGraphVertex v12 = this.tx.addVertex("person");
        JanusGraphVertex v13 = this.tx.addVertex("person");
        v12.property("uid", (Object)"v12");
        v13.property("uid", (Object)"v13");
        v12.addEdge("parent", (Vertex)v, new Object[]{"weight", 4.5});
        v13.addEdge("parent", (Vertex)v, new Object[]{"weight", 4.5});
        v.addEdge("child", (Vertex)v12, new Object[0]);
        v.addEdge("child", (Vertex)v13, new Object[0]);
        v.addEdge("spouse", (Vertex)v12, new Object[0]);
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v.addEdge("connect", (Vertex)v12, new Object[]{"uid", "e1"});
        v.addEdge("link", (Vertex)v13, new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex("tweet");
        v2.addEdge("link", (Vertex)v13, new Object[0]);
        v12.addEdge("connect", (Vertex)v2, new Object[0]);
        Assertions.assertEquals((Object)v, JanusGraphTest.getOnlyElement(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1").vertices()));
        v = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"));
        v12 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v12"));
        v13 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v13"));
        JanusGraphVertex finalV = v;
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV.property("weight", (Object)"x"));
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV.property(VertexProperty.Cardinality.list, "name", (Object)"John", new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalV.property("link", (Object)finalV));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)1.0, new Object[0]);
        JanusGraphAssert.assertCount(1, v.properties(new String[]{"weight"}));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)0.5, new Object[0]);
        Assertions.assertEquals((double)0.5, (double)((Float)v.value("weight")).doubleValue(), (double)1.0E-5);
        Assertions.assertEquals((Object)"v1", (Object)v.value("uid"));
        JanusGraphAssert.assertCount(2, v.properties(new String[]{"name"}));
        for (Object prop : v.query().labels(new String[]{"name"}).properties()) {
            String nameString = (String)((JanusGraphVertexProperty)prop).value();
            Assertions.assertTrue((nameString.equals("Bob") || nameString.equals("John") ? 1 : 0) != 0);
        }
        Assertions.assertTrue((Iterators.size((Iterator)v.properties(new String[]{"value"})) >= 3 ? 1 : 0) != 0);
        for (Object o : v.query().labels(new String[]{"value"}).properties()) {
            JanusGraphVertexProperty prop = (JanusGraphVertexProperty)o;
            double prec = (Double)prop.value();
            Assertions.assertEquals((double)(prec * 2.0), (double)((Number)prop.value("weight")).doubleValue(), (double)1.0E-5);
        }
        p = v.property("value", (Object)44.4, new Object[]{"weight", 88.8});
        Assertions.assertEquals((Object)v, JanusGraphTest.getOnlyElement(this.tx.query().has("someid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Hello").vertices()));
        try {
            v12.addEdge("parent", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("child", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("spouse", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addEdge("spouse", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        JanusGraphAssert.assertCount(1, v12.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        JanusGraphAssert.assertCount(1, v13.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        Assertions.assertEquals((Object)v12, JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"spouse"}).vertices()));
        JanusGraphEdge edge = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((int)1, (int)edge.keys().size());
        Assertions.assertEquals((Object)"e1", (Object)edge.value("uid"));
        try {
            v.addEdge("connect", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        JanusGraphAssert.assertCount(0, v13.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v2 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v12.query().direction(Direction.OUT).labels(new String[]{"connect"}).vertices());
        Assertions.assertEquals((Object)v13, JanusGraphTest.getOnlyElement(v2.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices()));
        Assertions.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.label());
        Assertions.assertEquals((Object)"person", (Object)v12.label());
        Assertions.assertEquals((Object)"person", (Object)v13.label());
        JanusGraphAssert.assertCount(4, this.tx.query().vertices());
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v, (Object)JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1")));
        v = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"));
        v12 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v12"));
        v13 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v13"));
        JanusGraphVertex finalV1 = v;
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV1.property("weight", (Object)"x"));
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV1.property(VertexProperty.Cardinality.list, "name", (Object)"John", new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalV1.property("link", (Object)finalV1));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)1.0, new Object[0]);
        JanusGraphAssert.assertCount(1, v.properties(new String[]{"weight"}));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)0.5, new Object[0]);
        Assertions.assertEquals((double)0.5, (double)((Float)v.value("weight")).doubleValue(), (double)1.0E-5);
        Assertions.assertEquals((Object)"v1", (Object)v.value("uid"));
        JanusGraphAssert.assertCount(2, v.properties(new String[]{"name"}));
        for (Object o : v.query().labels(new String[]{"name"}).properties()) {
            JanusGraphVertexProperty prop = (JanusGraphVertexProperty)o;
            String nameString = (String)prop.value();
            Assertions.assertTrue((nameString.equals("Bob") || nameString.equals("John") ? 1 : 0) != 0);
        }
        Assertions.assertTrue((Iterables.size((Iterable)v.query().labels(new String[]{"value"}).properties()) >= 3 ? 1 : 0) != 0);
        for (Object o : v.query().labels(new String[]{"value"}).properties()) {
            JanusGraphVertexProperty prop = (JanusGraphVertexProperty)o;
            double prec = (Double)prop.value();
            Assertions.assertEquals((double)(prec * 2.0), (double)((Number)prop.value("weight")).doubleValue(), (double)1.0E-5);
        }
        p = v.property("value", (Object)44.4, new Object[]{"weight", 88.8});
        Assertions.assertEquals((Object)v, JanusGraphTest.getOnlyElement(this.tx.query().has("someid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Hello").vertices()));
        try {
            v12.addEdge("parent", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        try {
            v13.addEdge("child", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        try {
            v13.addEdge("spouse", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        try {
            v.addEdge("spouse", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        JanusGraphAssert.assertCount(1, v12.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        JanusGraphAssert.assertCount(1, v13.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        Assertions.assertEquals((Object)v12, JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"spouse"}).vertices()));
        edge = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((int)1, (int)edge.keys().size());
        Assertions.assertEquals((Object)"e1", (Object)edge.value("uid"));
        try {
            v.addEdge("connect", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        JanusGraphAssert.assertCount(0, v13.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v2 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v12.query().direction(Direction.OUT).labels(new String[]{"connect"}).vertices());
        Assertions.assertEquals((Object)v13, JanusGraphTest.getOnlyElement(v2.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices()));
        Assertions.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.label());
        Assertions.assertEquals((Object)"person", (Object)v12.label());
        Assertions.assertEquals((Object)"person", (Object)v13.label());
        JanusGraphAssert.assertCount(4, this.tx.query().vertices());
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        try {
            JanusGraphVertex vx = tx2.addVertex(new Object[0]);
            try {
                vx.property(VertexProperty.Cardinality.single, "uid", (Object)"v1", new Object[0]);
                Assertions.fail();
            }
            catch (SchemaViolationException o) {
                // empty catch block
            }
            vx.property(VertexProperty.Cardinality.single, "uid", (Object)"unique", new Object[0]);
            JanusGraphVertex vx2 = tx2.addVertex(new Object[0]);
            try {
                vx2.property(VertexProperty.Cardinality.single, "uid", (Object)"unique", new Object[0]);
                Assertions.fail();
            }
            catch (SchemaViolationException prop) {
                // empty catch block
            }
        }
        finally {
            tx2.rollback();
        }
        v2 = JanusGraphTest.getV((Transaction)this.tx, v2);
        Assertions.assertEquals((Object)"tweet", (Object)v2.label());
        try {
            v2.property(VertexProperty.Cardinality.single, "weight", (Object)11, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException vx) {
            // empty catch block
        }
        try {
            v2.addEdge("friend", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException vx) {
            // empty catch block
        }
        JanusGraphTest.getV((Transaction)this.tx, v13).remove();
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        SchemaContainer schemaContainer = new SchemaContainer((JanusGraph)this.graph);
        Assertions.assertTrue((boolean)schemaContainer.containsRelationType("weight"));
        Assertions.assertTrue((boolean)schemaContainer.containsRelationType("friend"));
        Assertions.assertTrue((boolean)schemaContainer.containsVertexLabel("person"));
        VertexLabelDefinition vld = schemaContainer.getVertexLabel("tag");
        Assertions.assertFalse((boolean)vld.isPartitioned());
        Assertions.assertFalse((boolean)vld.isStatic());
        PropertyKeyDefinition pkd = schemaContainer.getPropertyKey("name");
        Assertions.assertEquals((Object)Cardinality.SET, (Object)pkd.getCardinality());
        Assertions.assertEquals(String.class, (Object)pkd.getDataType());
        EdgeLabelDefinition eld = schemaContainer.getEdgeLabel("child");
        Assertions.assertEquals((Object)"child", (Object)eld.getName());
        Assertions.assertEquals((long)child.longId(), (long)eld.getLongId());
        Assertions.assertEquals((Object)Multiplicity.ONE2MANY, (Object)eld.getMultiplicity());
        Assertions.assertFalse((boolean)eld.isUnidirected());
    }

    @Test
    public void testDataTypes() {
        Object value;
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_CLASS, "attribute10"), SpecialInt.class.getCanonicalName(), JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, "attribute10"), SpecialIntSerializer.class.getCanonicalName());
        PropertyKey any = this.mgmt.makePropertyKey("any").cardinality(Cardinality.LIST).dataType(Object.class).make();
        try {
            this.makeKey("pint", Integer.TYPE);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.makeKey("number", Number.class);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        any = this.tx.getPropertyKey("any");
        Assertions.assertEquals(Object.class, (Object)any.dataType());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.property(JanusGraphTest.n(any), (Object)"Hello");
        v.property(JanusGraphTest.n(any), (Object)10L);
        int[] testArray = new int[]{5, 6, 7};
        v.property(JanusGraphTest.n(any), (Object)testArray);
        for (Object prop : v.query().labels(new String[]{"any"}).properties()) {
            value = ((JanusGraphVertexProperty)prop).value();
            if (value instanceof String) {
                Assertions.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assertions.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value.getClass().isArray()) {
                Assertions.assertArrayEquals((int[])testArray, (int[])((int[])value));
                continue;
            }
            Assertions.fail();
        }
        this.clopen(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (Object prop : v.query().labels(new String[]{"any"}).properties()) {
            value = ((JanusGraphVertexProperty)prop).value();
            if (value instanceof String) {
                Assertions.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assertions.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value.getClass().isArray()) {
                Assertions.assertArrayEquals((int[])testArray, (int[])((int[])value));
                continue;
            }
            Assertions.fail();
        }
    }

    private static Stream<Arguments> generateParametersTestSupportOfDataTypes() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{SpecialInt.class, new SpecialInt(10), a -> a.getValue() == 10}), Arguments.arguments((Object[])new Object[]{byte[].class, new byte[]{1, 2, 3, 4}, a -> ((byte[])a).length == 4}), Arguments.arguments((Object[])new Object[]{Boolean.class, true, a -> a}), Arguments.arguments((Object[])new Object[]{Instant.class, Instant.ofEpochSecond(1429225756L), a -> a.equals(Instant.ofEpochSecond(1429225756L))}), Arguments.arguments((Object[])new Object[]{Geoshape.class, Geoshape.point((double)10.0, (double)10.0), a -> a.equals((Object)Geoshape.point((double)10.0, (double)10.0))}), Arguments.arguments((Object[])new Object[]{Geoshape.class, Geoshape.box((double)10.0, (double)10.0, (double)20.0, (double)20.0), a -> a.equals((Object)Geoshape.box((double)10.0, (double)10.0, (double)20.0, (double)20.0))}), Arguments.arguments((Object[])new Object[]{Double.class, 10.12345, a -> a == 10.12345})});
    }

    @ParameterizedTest
    @MethodSource(value={"generateParametersTestSupportOfDataTypes"})
    public <T> void testSupportOfDataTypes(Class<T> classes, T data, Equals<T> a) {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_CLASS, "attribute10"), SpecialInt.class.getCanonicalName(), JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, "attribute10"), SpecialIntSerializer.class.getCanonicalName());
        PropertyKey num = this.makeKey("propertyKey", classes);
        this.finishSchema();
        this.clopen(new Object[0]);
        num = this.tx.getPropertyKey("propertyKey");
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.property(VertexProperty.Cardinality.single, JanusGraphTest.n(num), data, new Object[0]);
        Assertions.assertTrue((boolean)a.verifyValue(v.value("propertyKey")));
        this.clopen(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        Assertions.assertTrue((boolean)a.verifyValue(v.value("propertyKey")));
    }

    @Test
    public void testTransactionalScopeOfSchemaTypes() {
        this.makeVertexIndexedUniqueKey("domain", String.class);
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property(VertexProperty.Cardinality.single, "domain", (Object)"unique1", new Object[0]);
        this.tx.rollback();
        this.tx = null;
        this.newTx();
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("domain", (Object)"unique1");
        Assertions.assertThrows(SchemaViolationException.class, () -> {
            JanusGraphVertex vInternal = this.tx.addVertex(new Object[0]);
            vInternal.property("domain", (Object)"unique1");
        });
        this.tx.rollback();
        this.tx = null;
        this.newTx();
        this.clopen(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v3.property("domain", (Object)"unique1");
        JanusGraphAssert.assertCount(1, this.tx.query().has("domain", (Object)"unique1").vertices());
        Assertions.assertThrows(SchemaViolationException.class, () -> {
            JanusGraphVertex vInternal = this.tx.addVertex(new Object[0]);
            vInternal.property("domain", (Object)"unique1");
        });
        this.tx.rollback();
        this.tx = null;
    }

    @Test
    public void testAutomaticTypeCreation() {
        Assertions.assertFalse((boolean)this.tx.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.tx.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.tx.containsRelationType("value"));
        Assertions.assertNull((Object)this.tx.getPropertyKey("value"));
        PropertyKey value = this.tx.getOrCreatePropertyKey("value");
        Assertions.assertNotNull((Object)value);
        Assertions.assertTrue((boolean)this.tx.containsRelationType("value"));
        JanusGraphVertex v = this.tx.addVertex("person");
        Assertions.assertTrue((boolean)this.tx.containsVertexLabel("person"));
        Assertions.assertEquals((Object)"person", (Object)v.label());
        Assertions.assertFalse((boolean)this.tx.containsRelationType("knows"));
        JanusGraphEdge e = v.addEdge("knows", (Vertex)v, new Object[0]);
        Assertions.assertTrue((boolean)this.tx.containsRelationType("knows"));
        Assertions.assertNotNull((Object)this.tx.getEdgeLabel(e.label()));
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none");
        Assertions.assertTrue((boolean)this.tx.containsRelationType("value"));
        Assertions.assertTrue((boolean)this.tx.containsVertexLabel("person"));
        Assertions.assertTrue((boolean)this.tx.containsRelationType("knows"));
        JanusGraphVertex v1 = JanusGraphTest.getV((Transaction)this.tx, v);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.tx.addVertex("org"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> JanusGraphTest.lambda$testAutomaticTypeCreation$32((Vertex)v1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> JanusGraphTest.lambda$testAutomaticTypeCreation$33((Vertex)v1));
    }

    @Test
    public void testUpdateSchemaChangeNameForEdgeLabel() {
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex("people");
        v.addEdge("knows", (Vertex)v, new Object[0]);
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((Object)"people", (Object)v.label());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        this.newTx();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("knows"));
        knows = this.mgmt.getEdgeLabel("knows");
        this.mgmt.changeName((JanusGraphSchemaElement)knows, "know");
        Assertions.assertEquals((Object)"know", (Object)knows.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("know"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationType("knows"));
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"know"}).edges());
        JanusGraphAssert.assertCount(0, v.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
    }

    @Test
    public void testUpdateSchemaChangeNameForVertexLabel() {
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex("people");
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        Assertions.assertEquals((Object)"people", (Object)v.label());
        this.newTx();
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("people"));
        VertexLabel vl = this.mgmt.getVertexLabel("people");
        this.mgmt.changeName((JanusGraphSchemaElement)vl, "person");
        Assertions.assertEquals((Object)"person", (Object)vl.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.mgmt.containsVertexLabel("people"));
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((Object)"person", (Object)v.label());
    }

    @Test
    public void testUpdateSchemaChangeNameForCompositeIndex() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("timeIndex", Vertex.class).addKey(time).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("timeIndex"));
        JanusGraphIndex graphIndex = this.mgmt.getGraphIndex("timeIndex");
        this.mgmt.changeName((JanusGraphSchemaElement)graphIndex, "byTime");
        Assertions.assertEquals((Object)"byTime", (Object)graphIndex.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("byTime"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("timeIndex"));
    }

    @Test
    public void testUpdateSchemaChangeNameForRelationIndex() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.buildEdgeIndex(knows, "byTime", Direction.BOTH, new PropertyKey[]{time});
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
        RelationTypeIndex byTimeIndex = this.mgmt.getRelationIndex((RelationType)knows, "byTime");
        Assertions.assertEquals((Object)"byTime", (Object)byTimeIndex.name());
        this.mgmt.changeName((JanusGraphSchemaElement)byTimeIndex, "overTime");
        Assertions.assertEquals((Object)"overTime", (Object)byTimeIndex.name());
        this.finishSchema();
        knows = this.mgmt.getEdgeLabel("knows");
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "overTime"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
    }

    @Test
    public void testGotGLoadWithoutIndexBackendException() {
        try {
            GraphOfTheGodsFactory.load((JanusGraph)this.graph);
            Assertions.fail((String)"Expected an exception to be thrown indicating improper index backend configuration");
        }
        catch (IllegalStateException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("loadWithoutMixedIndex"), (String)"An exception asking the user to use loadWithoutMixedIndex was expected");
        }
    }

    @Test
    public void testGotGIndexRemoval() throws InterruptedException, ExecutionException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        String name = "name";
        GraphOfTheGodsFactory.loadWithoutMixedIndex((JanusGraph)this.graph, (boolean)true);
        this.newTx();
        this.finishSchema();
        JanusGraphIndex graphIndex = this.mgmt.getGraphIndex("name");
        Assertions.assertNotNull((Object)graphIndex);
        Assertions.assertEquals((int)1, (int)graphIndex.getFieldKeys().length);
        Assertions.assertEquals((Object)"name", (Object)graphIndex.getFieldKeys()[0].name());
        Assertions.assertEquals((Object)"internalindex", (Object)graphIndex.getBackingIndex());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)graphIndex.getIndexStatus(graphIndex.getFieldKeys()[0]));
        this.finishSchema();
        graphIndex = this.mgmt.getGraphIndex("name");
        this.mgmt.updateIndex((Index)graphIndex, SchemaAction.DISABLE_INDEX);
        this.mgmt.commit();
        this.tx.commit();
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"name", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        graphIndex = this.mgmt.getGraphIndex("name");
        this.mgmt.updateIndex((Index)graphIndex, SchemaAction.REMOVE_INDEX);
        JanusGraphManagement.IndexJobFuture graphMetrics = this.mgmt.getIndexJobStatus((Index)graphIndex);
        this.finishSchema();
        Assertions.assertNotEquals((long)0L, (long)((ScanMetrics)graphMetrics.get()).getCustom("deletes"));
    }

    @Test
    public void testVertexCentricEdgeIndexOnSimpleMultiplicityShouldWork() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.SIMPLE).make();
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime").getIndexStatus());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (int i = 200; i < 210; ++i) {
            JanusGraphVertex o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(199), (Comparable)Integer.valueOf(210)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @Test
    public void testVertexCentricPropertyIndexOnSetCardinalityShouldWork() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        this.mgmt.buildPropertyIndex(name, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("name"), "byTime").getIndexStatus());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (int i = 200; i < 210; ++i) {
            v.property("name", (Object)String.valueOf(i), new Object[]{"time", i});
        }
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(199), (Comparable)Integer.valueOf(210)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @Test
    public void testVertexCentricIndexOrderingOnEdgePropertyWithCardinalityList() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        for (int i = 200; i < 210; ++i) {
            JanusGraphVertex o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime").getIndexStatus());
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @Test
    public void testVertexCentricIndexOrderingOnMetaPropertyWithCardinalityList() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        PropertyKey sensor = this.mgmt.makePropertyKey("sensor").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildPropertyIndex(sensor, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        for (int i = 200; i < 210; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
        }
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime").getIndexStatus());
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @Test
    public void testIndexUpdatesWithReindexAndRemove() throws InterruptedException, ExecutionException {
        JanusGraphVertex o;
        int i;
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        PropertyKey sensor = this.mgmt.makePropertyKey("sensor").dataType(Double.class).cardinality(Cardinality.LIST).make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        for (i = 0; i < 10; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, new String[0]);
        this.newTx();
        this.finishSchema();
        sensor = this.mgmt.getPropertyKey("sensor");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        friend = this.mgmt.getEdgeLabel("friend");
        this.mgmt.buildPropertyIndex(sensor, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildIndex("bySensorReading", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (i = 100; i < 110; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.tx.commit();
        RelationTypeIndex pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        RelationTypeIndex eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        JanusGraphIndex graphIndex = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)pindex, SchemaAction.ENABLE_INDEX));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)eindex, SchemaAction.ENABLE_INDEX));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)graphIndex, SchemaAction.ENABLE_INDEX));
        this.mgmt.commit();
        ManagementUtil.awaitVertexIndexUpdate((JanusGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        RelationTypeIndex pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        RelationTypeIndex eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        JanusGraphIndex graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)eindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.finishSchema();
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        this.mgmt.updateIndex((Index)eindex2, SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        Assertions.assertTrue((boolean)((RelationIndexStatusWatcher)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)"byTime", (String)"friend").status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        ScanMetrics reindexSensorByTime = (ScanMetrics)this.mgmt.updateIndex((Index)pindex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics reindexBySensorReading = (ScanMetrics)this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assertions.assertNotEquals((long)0L, (long)reindexSensorByTime.getCustom("adds"));
        Assertions.assertNotEquals((long)0L, (long)reindexBySensorReading.getCustom("adds"));
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)eindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (int i2 = 200; i2 < 210; ++i2) {
            v.property("sensor", (Object)i2, new Object[]{"time", i2});
            v.property("name", (Object)("v" + i2));
            JanusGraphVertex o2 = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o2, new Object[]{"time", i2});
        }
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 0, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        this.finishSchema();
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        ScanMetrics reindexFriendByTime = (ScanMetrics)this.mgmt.updateIndex((Index)eindex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assertions.assertNotEquals((long)0L, (long)reindexFriendByTime.getCustom("adds"));
        this.finishSchema();
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        this.mgmt.updateIndex((Index)pindex2, SchemaAction.DISABLE_INDEX);
        this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.DISABLE_INDEX);
        this.mgmt.commit();
        this.tx.commit();
        ManagementUtil.awaitVertexIndexUpdate((JanusGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.finishSchema();
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.tx.commit();
        this.finishSchema();
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics pmetrics = (ScanMetrics)this.mgmt.updateIndex((Index)pindex2, SchemaAction.REMOVE_INDEX).get();
        ScanMetrics graphIndexMetrics = (ScanMetrics)this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.REMOVE_INDEX).get();
        this.finishSchema();
        Assertions.assertEquals((long)30L, (long)pmetrics.getCustom("deletes"));
        Assertions.assertEquals((long)30L, (long)graphIndexMetrics.getCustom("deletes"));
    }

    @Tag(value="BRITTLE_TESTS")
    @Test
    public void testIndexUpdateSyncWithMultipleInstances() throws InterruptedException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        StandardJanusGraph graph2 = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)this.config);
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "v1"});
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTransaction tx2 = graph2.newTransaction();
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(this.mgmt.getPropertyKey("name")).buildCompositeIndex();
        this.mgmt.commit();
        JanusGraphTransaction tx3 = graph2.newTransaction();
        tx3.addVertex(new Object[]{"name", "v2"});
        tx3.commit();
        this.newTx();
        this.tx.addVertex(new Object[]{"name", "v3"});
        this.tx.commit();
        this.finishSchema();
        try {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        tx2.commit();
        this.mgmt.rollback();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").status(new SchemaStatus[]{SchemaStatus.REGISTERED})).timeout(TestGraphConfigs.getSchemaConvergenceTime(ChronoUnit.SECONDS), (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        tx2 = graph2.newTransaction();
        tx2.addVertex(new Object[]{"name", "v4"});
        tx2.commit();
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        tx2 = graph2.newTransaction();
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        tx2.commit();
        Set openInstances = this.mgmt.getOpenInstances();
        Assertions.assertEquals((int)2, (int)openInstances.size());
        Assertions.assertTrue((boolean)openInstances.contains(this.graph.getConfiguration().getUniqueGraphId() + "(current)"));
        Assertions.assertTrue((boolean)openInstances.contains(graph2.getConfiguration().getUniqueGraphId()));
        try {
            this.mgmt.forceCloseInstance(this.graph.getConfiguration().getUniqueGraphId());
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.forceCloseInstance(graph2.getConfiguration().getUniqueGraphId());
        graph2.close();
    }

    @Tag(value="BRITTLE_TESTS")
    @Test
    public void testIndexShouldRegisterWhenWeRemoveAnInstance() throws InterruptedException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        StandardJanusGraph graph2 = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)this.config);
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "v1"});
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTransaction tx2 = graph2.newTransaction();
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(this.mgmt.getPropertyKey("name")).buildCompositeIndex();
        this.mgmt.commit();
        JanusGraphTransaction tx3 = graph2.newTransaction();
        tx3.addVertex(new Object[]{"name", "v2"});
        tx3.commit();
        this.newTx();
        this.tx.addVertex(new Object[]{"name", "v3"});
        this.tx.commit();
        this.finishSchema();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX));
        this.finishSchema();
        Set openInstances = this.mgmt.getOpenInstances();
        Assertions.assertEquals((int)2, (int)openInstances.size());
        Assertions.assertTrue((boolean)openInstances.contains(this.graph.getConfiguration().getUniqueGraphId() + "(current)"));
        Assertions.assertTrue((boolean)openInstances.contains(graph2.getConfiguration().getUniqueGraphId()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.forceCloseInstance(this.graph.getConfiguration().getUniqueGraphId()));
        this.mgmt.forceCloseInstance(graph2.getConfiguration().getUniqueGraphId());
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").status(new SchemaStatus[]{SchemaStatus.REGISTERED})).timeout(TestGraphConfigs.getSchemaConvergenceTime(ChronoUnit.SECONDS), (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
    }

    @Test
    public void testIndexShouldBeEnabledForExistingPropertyKeyAndConstrainedToNewVertexLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        VertexLabel newLabel = this.mgmt.makeVertexLabel("newLabel").make();
        this.mgmt.buildIndex("newIndex", Vertex.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)newLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldBeEnabledForExistingPropertyKeyAndConstrainedToNewEdgeLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel newLabel = this.mgmt.makeEdgeLabel("newLabel").make();
        this.mgmt.buildIndex("newIndex", Edge.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)newLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldNotBeEnabledForExistingPropertyKeyAndConstrainedToExistingVertexLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeVertexLabel("alreadyExistingLabel").make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        VertexLabel existingLabel = this.mgmt.getVertexLabel("alreadyExistingLabel");
        this.mgmt.buildIndex("newIndex", Vertex.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)existingLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldNotBeEnabledForExistingPropertyKeyAndConstrainedToExistingEdgeLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildIndex("newIndex", Edge.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)existingLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldNotBeEnabledForExistingPropertyKeyWithoutLabelConstraint() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        this.mgmt.buildIndex("newIndex", Vertex.class).addKey(existingPropertyKey).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForExistingPropertyKeyAndNewRelationType() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        this.mgmt.makeEdgeLabel("newLabel").make();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel newLabel = this.mgmt.getEdgeLabel("newLabel");
        this.mgmt.buildEdgeIndex(newLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)newLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForNewPropertyKeyAndExistingRelationType() {
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.finishSchema();
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildEdgeIndex(existingLabel, "newIndex", Direction.BOTH, new PropertyKey[]{newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)existingLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForSingleNewPropertyKeyAndExistingRelationType() {
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildEdgeIndex(existingLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey, newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)existingLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForSingleNewPropertyKeyAndNewRelationType() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        this.mgmt.makeEdgeLabel("newLabel").make();
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel newLabel = this.mgmt.getEdgeLabel("newLabel");
        this.mgmt.buildEdgeIndex(newLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey, newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)newLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForNewPropertyKeyAndNewRelationType() {
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("newLabel").make();
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel newLabel = this.mgmt.getEdgeLabel("newLabel");
        this.mgmt.buildEdgeIndex(newLabel, "newIndex", Direction.BOTH, new PropertyKey[]{newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)newLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldNotBeEnabledForExistingPropertyKeyAndExistingRelationType() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildEdgeIndex(existingLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey});
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)existingLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testPropertyCardinality() {
        PropertyKey uid = this.mgmt.makePropertyKey("uid").dataType(Long.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("byUid", Vertex.class).addKey(uid).unique().buildCompositeIndex();
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property("name", (Object)"name1");
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("uid", (Object)512);
        this.newTx();
        v1 = this.tx.getVertex(v1.longId());
        v1.property("name", (Object)"name2");
        v2 = this.tx.getVertex(v2.longId());
        v2.property("uid", (Object)512);
        this.newTx();
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (Object)"name1").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (Object)"name2").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("uid", (Object)512).vertices());
    }

    @Test
    public void testImplicitKey() {
        JanusGraphVertex v = this.graph.addVertex(new Object[]{"name", "Dan"});
        JanusGraphVertex u = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e = v.addEdge("knows", (Vertex)u, new Object[0]);
        this.graph.tx().commit();
        RelationIdentifier eid = (RelationIdentifier)e.id();
        Assertions.assertEquals((Object)v.id(), (Object)v.value(ID_NAME));
        Assertions.assertEquals((Object)eid, (Object)e.value(ID_NAME));
        Assertions.assertEquals((Object)"knows", (Object)e.value(LABEL_NAME));
        Assertions.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.value(LABEL_NAME));
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has(ID_NAME, (Object)eid).edges());
        JanusGraphAssert.assertCount(0, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has(ID_NAME, (Object)RelationIdentifier.get((long[])new long[]{4L, 5L, 6L, 7L})).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has("~nid", (Object)eid.getRelationId()).edges());
        JanusGraphAssert.assertCount(0, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has("~nid", (Object)110111).edges());
        Assertions.assertNotNull((Object)JanusGraphTest.getE((Transaction)this.graph, eid));
        Assertions.assertEquals((Object)eid, (Object)JanusGraphTest.getE((Transaction)this.graph, eid).id());
        Assertions.assertEquals((long)1L, (long)v.query().direction(Direction.BOTH).has("~adjacent", u.id()).edgeCount());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).has("~adjacent", (Object)((int)JanusGraphTest.getId((Element)u))).edges());
        try {
            JanusGraphAssert.assertCount(0, v.query().direction(Direction.BOTH).has("~adjacent", (Object)110111).edges());
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayEqualityUsingImplicitKey() {
        JanusGraphVertex v = this.graph.addVertex(new Object[0]);
        byte[] singleDimension = new byte[]{127, 0, 0, 1};
        byte[] singleDimensionCopy = new byte[]{127, 0, 0, 1};
        String singlePropName = "single";
        v.property("single", (Object)singleDimension);
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
        this.graph.tx().commit();
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
    }

    @Test
    public void testSelfLoop() {
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.addEdge("self", (Vertex)v, new Object[0]);
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"self"}).edges());
        this.clopen(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        Assertions.assertNotNull((Object)v);
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"self"}).edges());
    }

    @Test
    public void testThreadBoundTx() {
        PropertyKey t = this.mgmt.makePropertyKey("type").dataType(Integer.class).make();
        this.mgmt.buildIndex("etype", Edge.class).addKey(t).buildCompositeIndex();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new PropertyKey[]{t}).make();
        this.finishSchema();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "Vertex1", "age", 35});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "Vertex2", "age", 45});
        JanusGraphVertex v3 = this.graph.addVertex(new Object[]{"name", "Vertex3", "age", 55});
        JanusGraphEdge e1 = v1.addEdge("knows", (Vertex)v2, new Object[]{"time", 5});
        JanusGraphEdge e2 = v2.addEdge("knows", (Vertex)v3, new Object[]{"time", 15});
        JanusGraphEdge e3 = v3.addEdge("knows", (Vertex)v1, new Object[]{"time", 25});
        JanusGraphEdge e4 = v2.addEdge("friend", (Vertex)v2, new Object[]{"type", 1});
        for (JanusGraphVertex v : new JanusGraphVertex[]{v1, v2, v3}) {
            JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            JanusGraphEdge tmpE = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assertions.assertEquals((int)5, (int)((Integer)tmpE.value("time") % 10));
        }
        e3.property("time", (Object)35);
        Assertions.assertEquals((int)35, (int)((Integer)e3.value("time")));
        v1.addEdge("friend", (Vertex)v2, new Object[]{"type", 0});
        this.graph.tx().commit();
        e4.property("type", (Object)2);
        JanusGraphEdge ef = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"friend"}).edges());
        Assertions.assertEquals((Object)ef, JanusGraphTest.getOnlyElement(this.graph.query().has("type", (Object)0).edges()));
        ef.property("type", (Object)1);
        this.graph.tx().commit();
        Assertions.assertEquals((int)35, (int)((Integer)e3.value("time")));
        e3 = JanusGraphTest.getE((Transaction)this.graph, e3);
        e3.property("time", (Object)45);
        Assertions.assertEquals((int)45, (int)((Integer)e3.value("time")));
        Assertions.assertEquals((int)15, (int)((Integer)e2.value("time")));
        e2.property("time", (Object)25);
        Assertions.assertEquals((int)25, (int)((Integer)e2.value("time")));
        Assertions.assertEquals((int)35, (int)((Integer)v1.value("age")));
        Assertions.assertEquals((int)55, (int)((Integer)v3.value("age")));
        v3.property("age", (Object)65);
        Assertions.assertEquals((int)65, (int)((Integer)v3.value("age")));
        e1 = JanusGraphTest.getE((Transaction)this.graph, e1);
        for (JanusGraphVertex v : new JanusGraphVertex[]{v1, v2, v3}) {
            JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assertions.assertEquals((int)5, (int)((Integer)((JanusGraphEdge)JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges())).value("time") % 10));
        }
        this.graph.tx().commit();
        VertexProperty prop = (VertexProperty)v1.properties(new String[0]).next();
        Assertions.assertTrue((JanusGraphTest.getId((Element)prop) > 0L ? 1 : 0) != 0);
        prop = (VertexProperty)((Iterable)this.graph.multiQuery(new JanusGraphVertex[]{v1}).properties().values().iterator().next()).iterator().next();
        Assertions.assertTrue((JanusGraphTest.getId((Element)prop) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)45, (int)((Integer)e3.value("time")));
        Assertions.assertEquals((int)5, (int)((Integer)e1.value("time")));
        Assertions.assertEquals((int)35, (int)((Integer)v1.value("age")));
        Assertions.assertEquals((int)65, (int)((Integer)v3.value("age")));
        for (JanusGraphVertex v : new JanusGraphVertex[]{v1, v2, v3}) {
            JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assertions.assertEquals((int)5, (int)((Integer)((JanusGraphEdge)JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges())).value("time") % 10));
        }
        this.graph.tx().commit();
        v1 = this.graph.addVertex(new Object[0]);
        v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        v3 = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e = v1.addEdge("knows", (Vertex)v3, new Object[0]);
        Assertions.assertFalse((boolean)e.property("age").isPresent());
    }

    @Test
    public void testPropertyIdAccessInDifferentTransaction() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        Object expectedId = v1.property("name", (Object)"foo").id();
        this.graph.tx().commit();
        VertexProperty p = (VertexProperty)JanusGraphTest.getOnlyElement(v1.properties(new String[]{"name"}));
        this.graph.tx().commit();
        Assertions.assertEquals((Object)expectedId, (Object)p.id());
    }

    @Test
    public void testNestedTransactions() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        this.newTx();
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("name", (Object)"foo");
        this.tx.commit();
        v1.addEdge("related", (Vertex)this.graph.traversal().V(new Object[]{v2}).next(), new Object[0]);
        this.graph.tx().commit();
        JanusGraphAssert.assertCount(1, v1.edges(Direction.OUT, new String[0]));
    }

    @Test
    public void testStaleVertex() {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex cartman = this.graph.addVertex(new Object[]{"name", "cartman", "age", 10});
        this.graph.addVertex(new Object[]{"name", "stan", "age", 8});
        this.graph.tx().commit();
        cartman = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.graph.query().has("name", (Object)"cartman").vertices());
        this.graph.tx().commit();
        JanusGraphVertexProperty p = (JanusGraphVertexProperty)cartman.properties(new String[0]).next();
        Assertions.assertTrue((p.longId() > 0L ? 1 : 0) != 0);
        this.graph.tx().commit();
    }

    @Test
    public void testTransactionIsolation() {
        this.makeLabel("knows");
        this.finishSchema();
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        JanusGraphVertex v11 = tx1.addVertex(new Object[0]);
        JanusGraphVertex v12 = tx1.addVertex(new Object[0]);
        v11.addEdge("knows", (Vertex)v12, new Object[0]);
        JanusGraphVertex v21 = tx2.addVertex(new Object[0]);
        try {
            v21.addEdge("knows", (Vertex)v11, new Object[0]);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JanusGraphVertex v22 = tx2.addVertex(new Object[0]);
        v21.addEdge("knows", (Vertex)v22, new Object[0]);
        tx2.commit();
        try {
            v22.addEdge("knows", (Vertex)v21, new Object[0]);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        tx1.rollback();
        try {
            v11.property(VertexProperty.Cardinality.single, "test", (Object)5, new Object[0]);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.newTx();
        v21 = JanusGraphTest.getV((Transaction)this.tx, v21);
        this.tx.makeEdgeLabel("link").unidirected().make();
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v21.addEdge("link", (Vertex)v3, new Object[0]);
        this.newTx();
        v21 = JanusGraphTest.getV((Transaction)this.tx, v21);
        v3 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assertions.assertFalse((boolean)v3.isRemoved());
        v3.remove();
        this.newTx();
        v21 = JanusGraphTest.getV((Transaction)this.tx, v21);
        v3 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assertions.assertFalse((boolean)v3.isRemoved());
        this.newTx();
        JanusGraphTransaction tx3 = this.graph.buildTransaction().checkInternalVertexExistence(true).start();
        v21 = JanusGraphTest.getV((Transaction)tx3, v21);
        v3 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assertions.assertTrue((boolean)v3.isRemoved());
        tx3.commit();
    }

    @Test
    public <V> void testMultivaluedVertexProperty() {
        String foo = "foo";
        String bar = "bar";
        String weight = "weight";
        ImmutableList values = ImmutableList.of((Object)"four", (Object)"score", (Object)"and", (Object)"seven");
        Assertions.assertTrue((2 <= values.size() ? 1 : 0) != 0, (String)"Values list must have multiple elements for this test to make sense");
        PropertyKey w = this.makeKey("weight", Integer.class);
        PropertyKey f = ((StandardPropertyKeyMaker)this.mgmt.makePropertyKey("foo")).dataType(String.class).cardinality(Cardinality.LIST).sortKey(new PropertyKey[]{w}).sortOrder(Order.DESC).make();
        this.mgmt.buildIndex("foo", Vertex.class).addKey(f).buildCompositeIndex();
        PropertyKey b = this.mgmt.makePropertyKey("bar").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("bar", Vertex.class).addKey(b).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        int i = 0;
        for (String s : values) {
            v.property("foo", (Object)s, new Object[]{"weight", ++i});
            v.property("bar", (Object)s, new Object[]{"weight", i});
        }
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"foo"}));
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"bar"}));
        for (String prop : new String[]{"foo", "bar"}) {
            int sum = 0;
            int index = values.size();
            for (Object o : v.query().labels(new String[]{"foo"}).properties()) {
                JanusGraphVertexProperty p = (JanusGraphVertexProperty)o;
                Assertions.assertTrue((boolean)values.contains(p.value()));
                int weightAsInteger = (Integer)p.value("weight");
                sum += weightAsInteger;
                if (prop.equals("foo")) {
                    Assertions.assertEquals((int)index, (int)weightAsInteger);
                }
                --index;
            }
            Assertions.assertEquals((int)(values.size() * (values.size() + 1) / 2), (int)sum);
        }
        JanusGraphAssert.assertCount(1, this.tx.query().has("foo", values.get(1)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("foo", values.get(3)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(1)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(3)).vertices());
        JanusGraphTest.asStream(v.properties(new String[]{"foo"})).forEach(Property::remove);
        JanusGraphAssert.assertEmpty(v.properties(new String[]{"foo"}));
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(0, this.tx.query().has("foo", values.get(1)).vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("foo", values.get(3)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(1)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(3)).vertices());
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphAssert.assertEmpty(v.properties(new String[]{"foo"}));
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"bar"}));
        for (String s : values) {
            v.property("foo", (Object)s);
        }
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"foo"}));
        JanusGraphTest.asStream(v.properties(new String[]{"foo"})).forEach(Property::remove);
        JanusGraphAssert.assertEmpty(v.properties(new String[]{"foo"}));
    }

    @Test
    public void testLocalGraphConfiguration() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.STORAGE_READONLY, ConfigOption.Type.LOCAL, true);
    }

    @Test
    public void testMaskableGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.DB_CACHE, ConfigOption.Type.MASKABLE, true, false);
    }

    @Test
    public void testGlobalGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, ConfigOption.Type.GLOBAL, true, false);
    }

    @Test
    public void testGlobalOfflineGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.DB_CACHE_TIME, ConfigOption.Type.GLOBAL_OFFLINE, 500L, 777L);
    }

    @Test
    public void testFixedGraphConfig() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, ConfigOption.Type.FIXED, "foo");
    }

    @Test
    public void testManagedOptionMasking() throws BackendException {
        Duration customCommitTime = Duration.ofMillis(456L);
        Preconditions.checkState((boolean)((Boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getDefaultValue()));
        Preconditions.checkState((boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getType().equals((Object)ConfigOption.Type.MASKABLE));
        Preconditions.checkState((!customCommitTime.equals(GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue()) ? 1 : 0) != 0);
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        try {
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            Assertions.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (JanusGraphConfigurationException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
        this.graph.getBackend().clearStorage();
        try {
            this.graph.close();
        }
        catch (Throwable t) {
            this.log.debug("Swallowing throwable during shutdown after clearing backend storage", t);
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        try {
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            Assertions.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (JanusGraphConfigurationException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
    }

    @Test
    public void testTransactionConfiguration() {
        block2: {
            JanusGraphTransaction readOnlyTx = this.graph.buildTransaction().readOnly().start();
            try {
                readOnlyTx.addVertex(new Object[0]);
                readOnlyTx.commit();
                Assertions.fail((String)"Read-only transactions should not be able to add a vertex and commit");
            }
            catch (Throwable t) {
                if (!readOnlyTx.isOpen()) break block2;
                readOnlyTx.rollback();
            }
        }
        String logID = "spam";
        StandardJanusGraphTx customLogIDTx = (StandardJanusGraphTx)this.graph.buildTransaction().logIdentifier(logID).start();
        Assertions.assertEquals((Object)logID, (Object)customLogIDTx.getConfiguration().getLogIdentifier());
        customLogIDTx.rollback();
        Instant customTimestamp = Instant.ofEpochMilli(-42L);
        StandardJanusGraphTx customTimeTx = (StandardJanusGraphTx)this.graph.buildTransaction().commitTime(customTimestamp).start();
        Assertions.assertTrue((boolean)customTimeTx.getConfiguration().hasCommitTime());
        Assertions.assertEquals((Object)customTimestamp, (Object)customTimeTx.getConfiguration().getCommitTime());
        customTimeTx.rollback();
    }

    private <A> void setAndCheckGraphOption(ConfigOption<A> opt, ConfigOption.Type requiredType, A firstValue, A secondValue) {
        Preconditions.checkState((boolean)opt.getType().equals((Object)requiredType));
        EnumSet<ConfigOption.Type> allowedTypes = EnumSet.of(ConfigOption.Type.GLOBAL, ConfigOption.Type.GLOBAL_OFFLINE, ConfigOption.Type.MASKABLE);
        Preconditions.checkState((boolean)allowedTypes.contains(opt.getType()));
        Preconditions.checkArgument((!firstValue.equals(secondValue) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        this.mgmt.set(path, firstValue);
        Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.tx.rollback();
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.set(path, secondValue);
        Assertions.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assertions.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        JanusGraph g2 = JanusGraphFactory.open((ReadConfiguration)this.config);
        JanusGraphManagement m2 = g2.openManagement();
        Assertions.assertEquals((Object)secondValue.toString(), (Object)m2.get(path));
        if (opt.getType().equals((Object)ConfigOption.Type.GLOBAL_OFFLINE)) {
            try {
                this.mgmt.set(path, firstValue);
                this.mgmt.commit();
                Assertions.fail((String)("Option " + path + " with type " + ConfigOption.Type.GLOBAL_OFFLINE + " should not be modifiable with concurrent instances"));
            }
            catch (RuntimeException e) {
                this.log.debug("Caught expected exception", (Throwable)e);
            }
            Assertions.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        } else {
            this.mgmt.set(path, firstValue);
            Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
            this.mgmt.commit();
            this.clopen(new Object[0]);
            Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        }
        m2.rollback();
        g2.close();
    }

    private <A> void setIllegalGraphOption(ConfigOption<A> opt, ConfigOption.Type requiredType, A attemptedValue) {
        ConfigOption.Type type = opt.getType();
        Preconditions.checkState((boolean)type.equals((Object)requiredType));
        Preconditions.checkArgument((requiredType.equals((Object)ConfigOption.Type.LOCAL) || requiredType.equals((Object)ConfigOption.Type.FIXED) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        try {
            this.mgmt.get(path);
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
        try {
            this.mgmt.set(path, attemptedValue);
            this.mgmt.commit();
            Assertions.fail((String)("Option " + path + " with type " + type + " should not be modifiable in the persistent graph config"));
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
    }

    @Test
    public void testConsistencyEnforcement() {
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.setConsistency((JanusGraphSchemaElement)uid, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)name, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").multiplicity(Multiplicity.MULTI).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.setConsistency((JanusGraphSchemaElement)knows, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)spouse, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)related, ConsistencyModifier.FORK);
        this.finishSchema();
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{"uid", 1});
        JanusGraphVertex v2 = this.tx.addVertex(new Object[]{"uid", 2});
        JanusGraphVertex v3 = this.tx.addVertex(new Object[]{"uid", 3});
        JanusGraphEdge e1 = v1.addEdge(connect.name(), (Vertex)v2, new Object[]{name.name(), "e1"});
        JanusGraphEdge e2 = v1.addEdge(related.name(), (Vertex)v2, new Object[]{name.name(), "e2"});
        this.newTx();
        v1 = JanusGraphTest.getV((Transaction)this.tx, v1);
        long e1id = JanusGraphTest.getId((Element)e1);
        long e2id = JanusGraphTest.getId((Element)e2);
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((Object)"e1", (Object)e1.value("name"));
        Assertions.assertEquals((long)e1id, (long)JanusGraphTest.getId((Element)e1));
        e2 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"related"}).edges());
        Assertions.assertEquals((Object)"e2", (Object)e2.value("name"));
        Assertions.assertEquals((long)e2id, (long)JanusGraphTest.getId((Element)e2));
        e1.property("name", (Object)"e1.2");
        e2.property("name", (Object)"e2.2");
        this.newTx();
        v1 = JanusGraphTest.getV((Transaction)this.tx, v1);
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((Object)"e1.2", (Object)e1.value("name"));
        Assertions.assertEquals((long)e1id, (long)JanusGraphTest.getId((Element)e1));
        e2 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"related"}).edges());
        Assertions.assertEquals((Object)"e2.2", (Object)e2.value("name"));
        Assertions.assertNotEquals((long)e2id, (long)JanusGraphTest.getId((Element)e2));
        this.clopen(new Object[0]);
        Random random = new Random();
        final long[] vertexIds = new long[]{JanusGraphTest.getId((Element)v1), JanusGraphTest.getId((Element)v2), JanusGraphTest.getId((Element)v3)};
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, new TransactionJob(){
            private int pos = 0;

            @Override
            public void run(JanusGraphTransaction tx) {
                JanusGraphVertex u = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[this.pos++]);
                u.property(VertexProperty.Cardinality.single, "uid", (Object)5, new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, tx -> {
            JanusGraphVertex u = JanusGraphTest.getV((Transaction)tx, vertexIds[0]);
            u.property(VertexProperty.Cardinality.single, "name", (Object)("v" + random.nextInt(10)), new Object[0]);
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, tx -> {
            JanusGraphVertex u1 = JanusGraphTest.getV((Transaction)tx, vertexIds[0]);
            JanusGraphVertex u2 = JanusGraphTest.getV((Transaction)tx, vertexIds[1]);
            u1.addEdge("knows", (Vertex)u2, new Object[0]);
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(JanusGraphTransaction tx) {
                JanusGraphVertex u1 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[0]);
                JanusGraphVertex u2 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[this.pos++]);
                u1.addEdge("spouse", (Vertex)u2, new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(JanusGraphTransaction tx) {
                JanusGraphVertex u1 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[this.pos++]);
                JanusGraphVertex u2 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[0]);
                u1.addEdge("spouse", (Vertex)u2, new Object[0]);
            }
        });
        try {
            this.mgmt.setConsistency((JanusGraphSchemaElement)this.mgmt.getPropertyKey("name"), ConsistencyModifier.FORK);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void executeLockConflictingTransactionJobs(JanusGraph graph, TransactionJob job) {
        JanusGraphTransaction tx1 = graph.newTransaction();
        JanusGraphTransaction tx2 = graph.newTransaction();
        job.run(tx1);
        job.run(tx2);
        if (this.isLockingOptimistic()) {
            tx1.commit();
            try {
                tx2.commit();
                Assertions.fail((String)"Storage backend does not abort conflicting transactions");
            }
            catch (JanusGraphException janusGraphException) {}
        } else {
            try {
                tx1.commit();
                Assertions.fail((String)"Storage backend does not abort conflicting transactions");
            }
            catch (JanusGraphException janusGraphException) {
                // empty catch block
            }
            tx2.commit();
        }
    }

    @Test
    public void testConcurrentConsistencyEnforcement() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        JanusGraphIndex nameIndex = this.mgmt.buildIndex("name", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.mgmt.setConsistency((JanusGraphSchemaElement)nameIndex, ConsistencyModifier.LOCK);
        EdgeLabel married = this.mgmt.makeEdgeLabel("married").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.setConsistency((JanusGraphSchemaElement)married, ConsistencyModifier.LOCK);
        this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        JanusGraphVertex baseV = this.tx.addVertex(new Object[]{"name", "base"});
        this.newTx();
        long baseVid = JanusGraphTest.getId((Element)baseV);
        String nameA = "a";
        String nameB = "b";
        int parallelThreads = 4;
        int numSuccess = this.executeParallelTransactions(tx -> {
            JanusGraphVertex a = tx.addVertex(new Object[0]);
            JanusGraphVertex base = JanusGraphTest.getV((Transaction)tx, baseVid);
            base.addEdge("married", (Vertex)a, new Object[0]);
        }, 4);
        Assertions.assertTrue((numSuccess <= 1 ? 1 : 0) != 0, (String)("At most 1 tx should succeed: " + numSuccess));
        numSuccess = this.executeParallelTransactions(tx -> {
            tx.addVertex(new Object[]{"name", "a"});
            JanusGraphVertex b = tx.addVertex(new Object[]{"name", "b"});
            b.addEdge("friend", (Vertex)b, new Object[0]);
        }, 4);
        this.newTx();
        long numA = Iterables.size((Iterable)this.tx.query().has("name", (Object)"a").vertices());
        long numB = Iterables.size((Iterable)this.tx.query().has("name", (Object)"b").vertices());
        Assertions.assertTrue((numSuccess <= 1 ? 1 : 0) != 0, (String)("At most 1 tx should succeed: " + numSuccess));
        Assertions.assertTrue((numA <= 1L ? 1 : 0) != 0);
        Assertions.assertTrue((numB <= 1L ? 1 : 0) != 0);
    }

    private void failTransactionOnCommit(TransactionJob job) {
        JanusGraphTransaction tx = this.graph.newTransaction();
        Assertions.assertThrows(Exception.class, () -> {
            job.run(tx);
            tx.commit();
        });
        if (tx.isOpen()) {
            tx.rollback();
        }
    }

    private int executeParallelTransactions(final TransactionJob job, int number) {
        final CountDownLatch startLatch = new CountDownLatch(number);
        final CountDownLatch finishLatch = new CountDownLatch(number);
        final AtomicInteger txSuccess = new AtomicInteger(0);
        for (int i = 0; i < number; ++i) {
            new Thread(){

                @Override
                public void run() {
                    this.awaitAllThreadsReady();
                    JanusGraphTransaction tx = JanusGraphTest.this.graph.newTransaction();
                    try {
                        job.run(tx);
                        tx.commit();
                        txSuccess.incrementAndGet();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (tx.isOpen()) {
                            tx.rollback();
                        }
                    }
                    finally {
                        finishLatch.countDown();
                    }
                }

                private void awaitAllThreadsReady() {
                    startLatch.countDown();
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        try {
            finishLatch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return txSuccess.get();
    }

    @Test
    public void testVertexCentricQuery() {
        this.testVertexCentricQuery(10000);
    }

    public void testVertexCentricQuery(int noVertices) {
        int nowTime;
        int i;
        VertexList vl;
        int i2;
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey time = this.makeKey("time", Integer.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey number = this.makeKey("number", Long.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connect")).sortKey(new PropertyKey[]{time}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connectDesc")).sortKey(new PropertyKey[]{time}).sortOrder(Order.DESC).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new PropertyKey[]{weight, time}).sortOrder(Order.ASC).signature(new PropertyKey[]{number}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friendDesc")).sortKey(new PropertyKey[]{weight, time}).sortOrder(Order.DESC).signature(new PropertyKey[]{number}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{number, weight}).make();
        this.mgmt.makeEdgeLabel("follows").make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "v"});
        JanusGraphVertex u = this.tx.addVertex(new Object[]{"name", "u"});
        Assertions.assertEquals((int)0, (int)((noVertices - 1) % 3));
        JanusGraphVertex[] vs = new JanusGraphVertex[noVertices];
        for (int i3 = 0; i3 < noVertices; ++i3) {
            vs[i3] = this.tx.addVertex(new Object[]{"name", "v" + i3});
        }
        EdgeLabel[] labelsV = new EdgeLabel[]{this.tx.getEdgeLabel("connect"), this.tx.getEdgeLabel("friend"), this.tx.getEdgeLabel("knows")};
        EdgeLabel[] labelsU = new EdgeLabel[]{this.tx.getEdgeLabel("connectDesc"), this.tx.getEdgeLabel("friendDesc"), this.tx.getEdgeLabel("knows")};
        for (int i4 = 1; i4 < noVertices; ++i4) {
            for (JanusGraphVertex vertex : new JanusGraphVertex[]{v, u}) {
                for (Direction d : new Direction[]{Direction.OUT, Direction.IN}) {
                    EdgeLabel label = vertex == v ? labelsV[i4 % 3] : labelsU[i4 % 3];
                    JanusGraphEdge e = d == Direction.OUT ? vertex.addEdge(JanusGraphTest.n(label), (Vertex)vs[i4], new Object[0]) : vs[i4].addEdge(JanusGraphTest.n(label), (Vertex)vertex, new Object[0]);
                    e.property("time", (Object)i4);
                    e.property("weight", (Object)((double)(i4 % 4) + 0.5));
                    e.property("name", (Object)("e" + i4));
                    e.property("number", (Object)(i4 % 5));
                }
            }
        }
        int edgesPerLabel = noVertices / 3;
        this.clopen(new Object[0]);
        long[] vertexIdSubset = new long[28];
        for (i2 = 0; i2 < vertexIdSubset.length; ++i2) {
            vertexIdSubset[i2] = vs[i2 + 3].longId();
        }
        Arrays.sort(vertexIdSubset);
        this.clopen(new Object[0]);
        for (i2 = 1; i2 < noVertices; ++i2) {
            vs[i2] = JanusGraphTest.getV((Transaction)this.tx, vs[i2].longId());
        }
        v = JanusGraphTest.getV((Transaction)this.tx, v.longId());
        u = JanusGraphTest.getV((Transaction)this.tx, u.longId());
        Object[] qvs = new JanusGraphVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        JanusGraphAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assertions.assertEquals((long)1L, (long)v.query().propertyCount());
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        int lastTime = 0;
        for (Object e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime2 = (Integer)e.value("time");
            Assertions.assertTrue((lastTime <= nowTime2 ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime2));
            lastTime = nowTime2;
        }
        lastTime = Integer.MAX_VALUE;
        for (Object e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime3 = (Integer)e.value("time");
            Assertions.assertTrue((lastTime >= nowTime3 ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime3));
            lastTime = nowTime3;
        }
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Iterator outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (Object e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assertions.assertEquals((Object)e, outer.next());
        }
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assertions.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).edgeCount());
        Assertions.assertEquals((int)10, (int)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assertions.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)31).count());
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        int friendsWhoHaveOutEdgesWithWeightBetweenPointFiveAndOnePointFive = (int)Math.round(Math.ceil((double)(1667 * noVertices) / 10000.0));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, friendsWhoHaveOutEdgesWithWeightBetweenPointFiveAndOnePointFive, 2, new boolean[]{true, true});
        Assertions.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)5).edgeCount());
        Assertions.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10).edgeCount());
        Assertions.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assertions.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).has("weight", (Object)3.5).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[8]).has("time", (Object)8).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((int)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assertions.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).edgeCount());
        Assertions.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.OUT).vertices()));
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assertions.assertEquals((long)vertexIdSubset[i], (long)vl.getID(i));
            }
        }
        JanusGraphAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().properties()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().keys(new String[]{"name"}).properties()));
        Map results = this.tx.multiQuery((JanusGraphVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).labels(new String[]{"knows"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)result));
        }
        Map results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        this.clopen(new Object[0]);
        for (int i5 = 1; i5 < noVertices; ++i5) {
            vs[i5] = JanusGraphTest.getV((Transaction)this.tx, vs[i5].longId());
        }
        v = JanusGraphTest.getV((Transaction)this.tx, v.longId());
        u = JanusGraphTest.getV((Transaction)this.tx, u.longId());
        qvs = new JanusGraphVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        lastTime = 0;
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime = (Integer)e.value("time");
            Assertions.assertTrue((lastTime <= nowTime ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime));
            lastTime = nowTime;
        }
        lastTime = Integer.MAX_VALUE;
        for (Edge e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime = (Integer)e.value("time");
            Assertions.assertTrue((lastTime >= nowTime ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime));
            lastTime = nowTime;
        }
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assertions.assertEquals((Object)e, outer.next());
        }
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assertions.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).edgeCount());
        Assertions.assertEquals((int)10, (int)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assertions.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)31).count());
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, friendsWhoHaveOutEdgesWithWeightBetweenPointFiveAndOnePointFive, 2, new boolean[]{true, true});
        Assertions.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10).edgeCount());
        Assertions.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assertions.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).has("weight", (Object)3.5).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[8]).has("time", (Object)8).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((int)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assertions.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).edgeCount());
        Assertions.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.OUT).vertices()));
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assertions.assertEquals((long)vertexIdSubset[i], (long)vl.getID(i));
            }
        }
        JanusGraphAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().properties()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().keys(new String[]{"name"}).properties()));
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).labels(new String[]{"knows"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("name", (Object)"v").vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((int)2, (int)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).vertexIds().size());
        Assertions.assertEquals((int)10, (int)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).vertexIds().size());
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("name", (Object)"v").vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((long)2L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).edgeCount());
        Assertions.assertEquals((long)10L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).edgeCount());
        this.newTx();
        JanusGraphVertex[] qvs2 = new JanusGraphVertex[qvs.length + 2];
        qvs2[0] = this.tx.addVertex(new Object[0]);
        for (int i6 = 0; i6 < qvs.length; ++i6) {
            qvs2[i6 + 1] = JanusGraphTest.getV((Transaction)this.tx, qvs[i6].longId());
        }
        qvs2[qvs2.length - 1] = this.tx.addVertex(new Object[0]);
        qvs2[0].addEdge("connect", (Vertex)qvs2[qvs2.length - 1], new Object[0]);
        qvs2[qvs2.length - 1].addEdge("connect", (Vertex)qvs2[0], new Object[0]);
        results = this.tx.multiQuery(qvs2).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
    }

    @Test
    public void testRelationTypeIndexes() {
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{time}).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().make();
        RelationTypeIndex name1 = this.mgmt.buildPropertyIndex(name, "weightDesc", new PropertyKey[]{weight});
        RelationTypeIndex connect1 = this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.asc, new PropertyKey[]{weight});
        RelationTypeIndex connect2 = this.mgmt.buildEdgeIndex(connect, "weightDesc", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{weight});
        RelationTypeIndex connect3 = this.mgmt.buildEdgeIndex(connect, "time+weight", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time, weight});
        RelationTypeIndex child1 = this.mgmt.buildEdgeIndex(child, "time", Direction.OUT, new PropertyKey[]{time});
        RelationTypeIndex link1 = this.mgmt.buildEdgeIndex(link, "time", Direction.OUT, new PropertyKey[]{time});
        String name1n = name1.name();
        String connect1n = connect1.name();
        String connect2n = connect2.name();
        String connect3n = connect3.name();
        String child1n = child1.name();
        String link1n = link1.name();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assertions.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").name());
        Assertions.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assertions.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)child)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)connect)));
        Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        weight = this.mgmt.getPropertyKey("weight");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        connect = this.mgmt.getEdgeLabel("connect");
        child = this.mgmt.getEdgeLabel("child");
        link = this.mgmt.getEdgeLabel("link");
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assertions.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").name());
        Assertions.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assertions.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)child)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)connect)));
        Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.rollback();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        int numV = 100;
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        JanusGraphVertex[] ns = new JanusGraphVertex[100];
        for (int i = 0; i < 100; ++i) {
            double w = (double)i * 0.5 % 5.0;
            long t = (i + 77) % 100;
            JanusGraphVertexProperty p = v.property("name", (Object)("v" + i), new Object[]{"weight", w, "time", t});
            ns[i] = this.tx.addVertex(new Object[0]);
            String[] stringArray = new String[]{"connect", "child", "link"};
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String label = stringArray[j];
                JanusGraphEdge janusGraphEdge = v.addEdge(label, (Vertex)ns[i], new Object[]{"weight", w, "time", t});
            }
        }
        JanusGraphVertex u = ns[0];
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        u = JanusGraphTest.getV((Transaction)this.tx, u);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)0.9).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("weight", (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        VertexList vl = v.query().labels(new String[]{"child"}).direction(Direction.BOTH).vertexIds();
        Assertions.assertEquals((int)100, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assertions.assertEquals((int)20, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).vertexIds();
        Assertions.assertEquals((int)10, (int)vl.size());
        Assertions.assertFalse((boolean)vl.isSorted());
        Assertions.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        u = JanusGraphTest.getV((Transaction)this.tx, u);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)0.9).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("weight", (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        vl = v.query().labels(new String[]{"child"}).direction(Direction.BOTH).vertexIds();
        Assertions.assertEquals((int)100, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assertions.assertEquals((int)20, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).vertexIds();
        Assertions.assertEquals((int)10, (int)vl.size());
        Assertions.assertFalse((boolean)vl.isSorted());
        Assertions.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        for (Object o : v.query().labels(new String[]{"name"}).properties()) {
            JanusGraphVertexProperty p = (JanusGraphVertexProperty)o;
            if ((Long)p.value("time") >= 50L) continue;
            p.remove();
        }
        for (Object o : v.query().direction(Direction.BOTH).edges()) {
            JanusGraphEdge e = (JanusGraphEdge)o;
            if ((Long)e.value("time") >= 50L) continue;
            e.remove();
        }
        ns = new JanusGraphVertex[150];
        for (int i = 100; i < 150; ++i) {
            double w = (double)i * 0.5 % 5.0;
            v.property("name", (Object)("v" + i), new Object[]{"weight", w, "time", (long)i});
            ns[i] = this.tx.addVertex(new Object[0]);
            for (String label : new String[]{"connect", "child", "link"}) {
                JanusGraphEdge janusGraphEdge = v.addEdge(label, (Vertex)ns[i], new Object[]{"weight", w, "time", (long)i});
            }
        }
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.newTx();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        u = JanusGraphTest.getV((Transaction)this.tx, u);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
    }

    @Test
    public void testAutoSchemaMakerAllowsToSetCardinalityList() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex next = (Vertex)g.addV().property(VertexProperty.Cardinality.list, (Object)"name", (Object)"marko a. rodriguez", new Object[0]).property(VertexProperty.Cardinality.list, (Object)"name", (Object)"sdsdsd", new Object[0]).next();
        next = (Vertex)g.V(new Object[]{next.id()}).property((Object)"name", (Object)"sdsdsd", new Object[0]).next();
        Assertions.assertEquals((int)3, (int)g.V(new Object[]{next}).values(new String[]{"name"}).toList().size());
    }

    @Test
    public void testAutoSchemaMakerAllowsToSetCardinalitySet() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex next = (Vertex)g.addV().property(VertexProperty.Cardinality.set, (Object)"name", (Object)"marko a. rodriguez", new Object[0]).property(VertexProperty.Cardinality.set, (Object)"name", (Object)"sdsdsd", new Object[0]).property(VertexProperty.Cardinality.set, (Object)"name", (Object)"sdsdsd", new Object[0]).next();
        next = (Vertex)g.V(new Object[]{next.id()}).property((Object)"name", (Object)"sdsdsd", new Object[0]).next();
        Assertions.assertEquals((int)2, (int)g.V(new Object[]{next}).values(new String[]{"name"}).toList().size());
    }

    @Test
    public void testAutoSchemaMakerAllowsToSetCardinalitySingle() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex next = (Vertex)g.addV().property(VertexProperty.Cardinality.single, (Object)"name", (Object)"marko a. rodriguez", new Object[0]).property((Object)"name", (Object)"sdsdsd", new Object[0]).property((Object)"name", (Object)"sdsdsd", new Object[0]).next();
        Assertions.assertEquals((int)1, (int)g.V(new Object[]{next}).values(new String[]{"name"}).toList().size());
    }

    private void createStrictSchemaForVertexProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel label = this.mgmt.makeVertexLabel("user").make();
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(label, new PropertyKey[]{id});
        this.finishSchema();
    }

    @Test
    public void testEnforcedSchemaAllowsDefinedVertexProperties() {
        this.createStrictSchemaForVertexProperties();
        JanusGraphVertex v = this.tx.addVertex("user");
        v.property("id", (Object)10);
    }

    @Test
    public void testSchemaIsEnforcedForVertexProperties() {
        this.createStrictSchemaForVertexProperties();
        JanusGraphVertex v = this.tx.addVertex("user");
        try {
            v.property("test", (Object)10);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAllowDisablingSchemaConstraintForVertexProperty() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), false);
        this.mgmt.makeVertexLabel("user").make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex("user");
        v.property("test", (Object)10);
    }

    @Test
    public void testAllowDisablingSchemaConstraintForConnection() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), false);
        this.mgmt.makeVertexLabel("user").make();
        this.mgmt.makeEdgeLabel("knows").make();
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
    }

    @Test
    public void testAllowDisablingSchemaConstraintForEdgeProperty() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), false);
        this.mgmt.makeVertexLabel("user").make();
        this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"test", 10});
    }

    @Test
    public void testAutoSchemaMakerForVertexPropertyConstraints() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v1 = this.tx.addVertex("user");
        v1.property("test", (Object)10);
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v2.property("test", (Object)10);
        try {
            v2.property("id", (Object)10);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSupportDirectCommitOfSchemaChangesForVertexProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        GraphTraversalSource g = this.graph.traversal();
        VertexLabel label = this.mgmt.makeVertexLabel("user").make();
        PropertyKey prop = this.mgmt.makePropertyKey("id").dataType(Integer.class).make();
        this.mgmt.addProperties(label, new PropertyKey[]{prop});
        this.mgmt.commit();
        g.addV("user").property((Object)"id", (Object)10, new Object[0]).iterate();
    }

    private GraphTraversalSource prepareGraphForDirectCommitTests() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        GraphTraversalSource g = this.graph.traversal();
        VertexLabel user = this.mgmt.makeVertexLabel("user").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{id});
        this.mgmt.addConnection(edge, user, user);
        this.mgmt.commit();
        return g;
    }

    @Test
    public void testSupportDirectCommitOfSchemaChangesForConnection() {
        GraphTraversalSource g = this.prepareGraphForDirectCommitTests();
        g.addV("user").as("p1", new String[0]).addV("user").addE("knows").from("p1").iterate();
    }

    @Test
    public void testSupportDirectCommitOfSchemaChangesForEdgeProperties() {
        GraphTraversalSource g = this.prepareGraphForDirectCommitTests();
        g.addV("user").as("p1", new String[0]).addV("user").addE("knows").from("p1").property((Object)"id", (Object)10, new Object[0]).iterate();
    }

    private void createStrictSchemaForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel user = this.mgmt.makeVertexLabel("user").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{id});
        this.mgmt.addConnection(edge, user, user);
        this.finishSchema();
    }

    @Test
    public void testEnforcedSchemaAllowsDefinedEdgeProperties() {
        this.createStrictSchemaForEdgeProperties();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10});
    }

    @Test
    public void testSchemaIsEnforcedForEdgeProperties() {
        this.createStrictSchemaForEdgeProperties();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        try {
            v1.addEdge("knows", (Vertex)v2, new Object[]{"test", 10});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAllowSingleCardinalityForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        PropertyKey propertyKey1 = this.mgmt.makePropertyKey("propertyKey1").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{propertyKey1});
        PropertyKey propertyKey2 = this.mgmt.makePropertyKey("propertyKey2").dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{propertyKey2});
        this.finishSchema();
    }

    @Test
    public void testBanListCardinalityForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        try {
            PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            this.mgmt.addProperties(edge, new PropertyKey[]{id});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
    }

    @Test
    public void testBanSetCardinalityForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        try {
            PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SET).dataType(Integer.class).make();
            this.mgmt.addProperties(edge, new PropertyKey[]{id});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
    }

    @Test
    public void testAutoSchemaMakerForEdgePropertyConstraints() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10});
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        v1 = this.tx.addVertex("user");
        v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10});
        try {
            v1.addEdge("knows", (Vertex)v2, new Object[]{"test", 10});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void createStrictSchemaForConnections() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel user = this.mgmt.makeVertexLabel("user").make();
        VertexLabel company = this.mgmt.makeVertexLabel("company").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.makeEdgeLabel("buys").make();
        this.mgmt.addConnection(edge, user, company);
        this.finishSchema();
    }

    @Test
    public void testEnforcedSchemaAllowsDefinedConnections() {
        this.createStrictSchemaForConnections();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("company");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
    }

    @Test
    public void testSchemaIsEnforcedForConnections() {
        this.createStrictSchemaForConnections();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        try {
            v1.addEdge("buys", (Vertex)v1, new Object[0]);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        JanusGraphVertex v2 = this.tx.addVertex("company");
        try {
            v2.addEdge("knows", (Vertex)v1, new Object[0]);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAutoSchemaMakerForConnectionConstraints() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        v1 = this.tx.addVertex("user");
        v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        try {
            v1.addEdge("has", (Vertex)v2, new Object[0]);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSupportChangeNameOfEdgeAndUpdateConnections() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel user = this.mgmt.makeVertexLabel("V1").make();
        VertexLabel company = this.mgmt.makeVertexLabel("V2").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("E1").make();
        this.mgmt.addConnection(edge, user, company);
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("V1");
        JanusGraphVertex v2 = this.tx.addVertex("V2");
        v1.addEdge("E1", (Vertex)v2, new Object[0]);
        this.newTx();
        edge = this.mgmt.getEdgeLabel("E1");
        this.mgmt.changeName((JanusGraphSchemaElement)edge, "E2");
        this.mgmt.commit();
        JanusGraphVertex v3 = this.tx.addVertex("V1");
        JanusGraphVertex v4 = this.tx.addVertex("V2");
        v3.addEdge("E2", (Vertex)v4, new Object[0]);
    }

    private void createStrictSchemaForComplexConnections() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel v1 = this.mgmt.makeVertexLabel("V1").make();
        VertexLabel v2 = this.mgmt.makeVertexLabel("V2").make();
        VertexLabel v3 = this.mgmt.makeVertexLabel("V3").make();
        VertexLabel v4 = this.mgmt.makeVertexLabel("V4").make();
        EdgeLabel e1 = this.mgmt.makeEdgeLabel("E1").make();
        EdgeLabel e2 = this.mgmt.makeEdgeLabel("E2").make();
        this.mgmt.addConnection(e1, v1, v2);
        this.mgmt.addConnection(e1, v3, v4);
        this.mgmt.addConnection(e2, v1, v4);
        this.mgmt.addConnection(e2, v3, v2);
        this.finishSchema();
    }

    @Test
    public void testAllowEnforcedComplexConnections() {
        this.createStrictSchemaForComplexConnections();
        JanusGraphVertex v1 = this.tx.addVertex("V1");
        JanusGraphVertex v2 = this.tx.addVertex("V2");
        JanusGraphVertex v3 = this.tx.addVertex("V3");
        JanusGraphVertex v4 = this.tx.addVertex("V4");
        v1.addEdge("E1", (Vertex)v2, new Object[0]);
        v3.addEdge("E1", (Vertex)v4, new Object[0]);
        v3.addEdge("E2", (Vertex)v2, new Object[0]);
        v1.addEdge("E2", (Vertex)v4, new Object[0]);
    }

    @Test
    public void testEnforceComplexConnections() {
        this.createStrictSchemaForComplexConnections();
        JanusGraphVertex v1 = this.tx.addVertex("V1");
        JanusGraphVertex v2 = this.tx.addVertex("V2");
        JanusGraphVertex v3 = this.tx.addVertex("V3");
        JanusGraphVertex v4 = this.tx.addVertex("V4");
        Assertions.assertThrows(IllegalArgumentException.class, () -> v1.addEdge("E2", (Vertex)v2, new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> v3.addEdge("E2", (Vertex)v4, new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> v3.addEdge("E1", (Vertex)v2, new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> v1.addEdge("E1", (Vertex)v4, new Object[0]));
    }

    private boolean isSortedByID(VertexList vl) {
        for (int i = 1; i < vl.size(); ++i) {
            if (vl.getID(i - 1) <= vl.getID(i)) continue;
            return false;
        }
        return true;
    }

    public static void evaluateQuery(JanusGraphVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs) {
        JanusGraphTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of());
    }

    public static void evaluateQuery(JanusGraphVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, PropertyKey orderKey, Order order) {
        JanusGraphTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey, (Object)order));
    }

    public static void evaluateQuery(JanusGraphVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap) {
        Iterable result;
        SimpleQueryProfiler profiler = new SimpleQueryProfiler();
        ((BasicVertexCentricQueryBuilder)query).profiler((QueryProfiler)profiler);
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case RELATION: {
                result = query.relations();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OrderList orders = (OrderList)profiler.getAnnotation("orders");
        int no = 0;
        JanusGraphElement previous = null;
        for (JanusGraphElement e : result) {
            Assertions.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assertions.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assertions.assertEquals((int)expectedResults, (int)no);
        Assertions.assertNotNull((Object)orders);
        Assertions.assertEquals((int)orderMap.size(), (int)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assertions.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assertions.assertTrue((boolean)orders.containsKey(key));
        }
        Assertions.assertEquals((Integer)1, (Integer)((Integer)profiler.getAnnotation("vertices")));
        int subQueryCounter = 0;
        for (SimpleQueryProfiler subProfiler : profiler) {
            Assertions.assertNotNull((Object)subProfiler);
            if (subProfiler.getGroupName().equals("optimization")) continue;
            if (subQuerySpecs.length == 2) {
                Assertions.assertEquals((Object)subQuerySpecs[0], (Object)subProfiler.getAnnotation("isFitted"));
                Assertions.assertEquals((Object)subQuerySpecs[1], (Object)subProfiler.getAnnotation("isOrdered"));
            }
            ++subQueryCounter;
        }
        Assertions.assertEquals((int)numSubQueries, (int)subQueryCounter);
    }

    @Test
    public void testEdgesExceedCacheSize() {
        int numEdges = this.graph.getConfiguration().getTxVertexCacheSize();
        JanusGraphVertex parentVertex = this.graph.addVertex(new Object[0]);
        for (int i = 0; i < numEdges; ++i) {
            JanusGraphVertex childVertex = this.graph.addVertex(new Object[0]);
            parentVertex.addEdge("friend", (Vertex)childVertex, new Object[0]);
        }
        this.graph.tx().commit();
        JanusGraphAssert.assertCount(numEdges, parentVertex.query().direction(Direction.OUT).edges());
        ((JanusGraphEdge)parentVertex.query().direction(Direction.OUT).edges().iterator().next()).remove();
        JanusGraphAssert.assertCount(numEdges - 1, parentVertex.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertCount(numEdges - 1, parentVertex.query().direction(Direction.OUT).edges());
    }

    @Test
    public void testRemoveCachedVertexVisibility() {
        int cacheSize = this.graph.getConfiguration().getTxVertexCacheSize();
        ArrayList<Long> vertexIds = new ArrayList<Long>();
        for (int i = 0; i < cacheSize; ++i) {
            JanusGraphVertex vertex = this.graph.addVertex(new Object[0]);
            vertexIds.add(vertex.longId());
        }
        long vertexIdToBeDeleted = this.graph.addVertex(new Object[0]).longId();
        this.graph.tx().commit();
        Vertex retrievedVertex = (Vertex)this.graph.traversal().V(new Object[]{vertexIdToBeDeleted}).next();
        retrievedVertex.remove();
        this.graph.traversal().V(new Object[]{vertexIds}).toStream().collect(Collectors.toList());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[]{vertexIdToBeDeleted}).hasNext());
    }

    @Test
    public void testNestedContainPredicates() {
        int graphSize = 10;
        for (int i = 0; i < graphSize; ++i) {
            this.graph.addVertex(new Object[]{"id", i});
        }
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).has("id", P.within((Object[])new Integer[]{4, 5, 6})).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).has("id", P.within((Object[])new Object[0])).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)6L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)5L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).has("id", P.without((Object[])new Integer[]{4, 5, 6})).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).has("id", P.without((Object[])new Object[0])).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 1), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 6), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 5), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 2), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Object[0])), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Object[0])), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
    }

    @Test
    public void testTinkerPopCardinality() {
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        PropertyKey names = this.mgmt.makePropertyKey("names").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.mgmt.buildIndex("byId", Vertex.class).addKey(id).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex v = this.graph.addVertex(new Object[]{"id", 1});
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t1", new Object[0]);
        this.graph.addVertex(new Object[]{"id", 2, "names", "n1", "names", "n2"});
        this.graph.tx().commit();
        GraphTraversalSource gts = this.graph.traversal();
        v = (Vertex)gts.V(new Object[0]).has("id", (Object)1).next();
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t2", new Object[0]);
        v = (Vertex)gts.V(new Object[0]).has("id", (Object)1).next();
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t3", new Object[0]);
        JanusGraphAssert.assertCount(1, (Traversal)gts.V(new Object[]{v}).properties(new String[]{"name"}));
        JanusGraphAssert.assertCount(2, (Traversal)gts.V(new Object[0]).has("id", (Object)2).properties(new String[]{"names"}));
        JanusGraphAssert.assertCount(2, (Traversal)gts.V(new Object[0]).hasLabel("vertex", new String[0]));
    }

    @Test
    public void testTinkerPopOptimizationStrategies() {
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        PropertyKey weight = this.mgmt.makePropertyKey("weight").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.buildIndex("byId", Vertex.class).addKey(id).buildCompositeIndex();
        this.mgmt.buildIndex("byWeight", Vertex.class).addKey(weight).buildCompositeIndex();
        this.mgmt.buildIndex("byIdWeight", Vertex.class).addKey(id).addKey(weight).buildCompositeIndex();
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.buildEdgeIndex(knows, "byWeightDesc", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{weight});
        this.mgmt.buildEdgeIndex(knows, "byWeightAsc", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.asc, new PropertyKey[]{weight});
        PropertyKey names = this.mgmt.makePropertyKey("names").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.mgmt.buildPropertyIndex(names, "namesByWeight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{weight});
        this.finishSchema();
        int numV = 100;
        JanusGraphVertex[] vs = new JanusGraphVertex[numV];
        for (int i = 0; i < numV; ++i) {
            vs[i] = this.graph.addVertex(new Object[]{"id", i, "weight", i % 5});
        }
        int superV = 10;
        int sid = -1;
        JanusGraphVertex[] sv = new JanusGraphVertex[superV];
        for (int i = 0; i < superV; ++i) {
            sv[i] = this.graph.addVertex(new Object[]{"id", sid});
            for (int j = 0; j < numV; ++j) {
                sv[i].addEdge("knows", (Vertex)vs[j], new Object[]{"weight", j % 5});
                sv[i].property(VertexProperty.Cardinality.list, "names", (Object)("n" + j), new Object[]{"weight", j % 5});
            }
        }
        GraphTraversalSource gts = this.graph.traversal();
        JanusGraphTest.assertNumStep(numV / 5, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has("weight", (Object)1), JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(numV, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}), JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(numV, 1, gts.V(new Object[]{sv[0]}).out(new String[]{"knows"}), JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(10, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).limit(10L)), JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(10, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).range(10L, 20L)), LocalStep.class);
        JanusGraphTest.assertNumStep(numV, 2, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc), JanusGraphVertexStep.class, OrderGlobalStep.class);
        JanusGraphTest.assertNumStep(10, 0, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)), LocalStep.class);
        JanusGraphTest.assertNumStep(numV / 5, 2, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has("weight", (Object)1).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.asc), JanusGraphVertexStep.class, OrderGlobalStep.class);
        JanusGraphTest.assertNumStep(10, 0, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", (Object)1).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(10L)), LocalStep.class);
        JanusGraphTest.assertNumStep(5, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", (Object)1).has("weight", (Object)1).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.asc).range(10L, 15L)), LocalStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).filter((Traversal)__.inV().is((Object)vs[50])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).filter((Traversal)__.otherV().is((Object)vs[50])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).filter((Traversal)__.otherV().is((Object)vs[50])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertNumStep(1, 2, gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).filter((Traversal)__.inV().is((Object)vs[50])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).filter((Traversal)__.inV().hasId(vs[50].id(), new Object[0])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).filter((Traversal)__.otherV().hasId(vs[50].id(), new Object[0])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).filter((Traversal)__.otherV().hasId(vs[50].id(), new Object[0])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertNumStep(1, 2, gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).filter((Traversal)__.inV().hasId(vs[50].id(), new Object[0])), JanusGraphVertexStep.class, TraversalFilterStep.class);
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).inV(), gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).inV().is((Object)vs[50]), new TraversalStrategy[]{AdjacentVertexIsOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).inE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).outV(), gts.V(new Object[]{sv[0]}).inE(new String[]{"knows"}).outV().is((Object)vs[50]), new TraversalStrategy[]{AdjacentVertexIsOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).otherV(), gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).otherV().is((Object)vs[50]), new TraversalStrategy[]{AdjacentVertexIsOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).inV(), gts.V(new Object[]{sv[0]}).out(new String[]{"knows"}).is((Object)vs[50]), new TraversalStrategy[]{AdjacentVertexIsOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).inE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).outV(), gts.V(new Object[]{sv[0]}).in(new String[]{"knows"}).is((Object)vs[50]), new TraversalStrategy[]{AdjacentVertexIsOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).otherV(), gts.V(new Object[]{sv[0]}).both(new String[]{"knows"}).is((Object)vs[50]), new TraversalStrategy[]{AdjacentVertexIsOptimizerStrategy.instance()});
        JanusGraphTest.assertSameResultWithOptimizations(gts.V(new Object[]{sv[0]}).as("v1", new String[0]).out(new String[]{"knows"}).is((Object)vs[50]).as("v2", new String[0]).select("v1", "v2", new String[0]).by("id"), new TraversalStrategy[]{AdjacentVertexIsOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).inV(), gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).inV().hasId((Object)vs[50], new Object[0]), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).inE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).outV(), gts.V(new Object[]{sv[0]}).inE(new String[]{"knows"}).outV().hasId((Object)vs[50], new Object[0]), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).otherV(), gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).otherV().hasId((Object)vs[50], new Object[0]), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).inV(), gts.V(new Object[]{sv[0]}).out(new String[]{"knows"}).hasId((Object)vs[50], new Object[0]), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).inE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).outV(), gts.V(new Object[]{sv[0]}).in(new String[]{"knows"}).hasId((Object)vs[50], new Object[0]), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), (Object)vs[50]).otherV(), gts.V(new Object[]{sv[0]}).both(new String[]{"knows"}).hasId((Object)vs[50], new Object[0]), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertOptimization(gts.V(new Object[]{sv[0]}).in(new String[0]).hasId(P.neq((Object)vs[50])), gts.V(new Object[]{sv[0]}).in(new String[0]).hasId(P.neq((Object)vs[50])), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertSameResultWithOptimizations(gts.V(new Object[]{sv[0]}).as("v1", new String[0]).out(new String[]{"knows"}).hasId(vs[50].id(), new Object[0]).as("v2", new String[0]).select("v1", "v2", new String[0]).by("id"), new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        int[] loop1 = new int[]{0};
        int[] loop2 = new int[]{0};
        GraphTraversal t1 = gts.V(new Object[]{vs[0], vs[1], vs[2]}).repeat((Traversal)__.inE((String[])new String[]{"knows"}).has(ImplicitKey.ADJACENT_ID.name(), sv[0].id()).outV().out(new String[]{"knows"}).sideEffect(e -> {
            loop1[0] = e.loops();
        }).has("id", (Object)loop1[0])).times(numV);
        GraphTraversal t2 = gts.V(new Object[]{vs[0], vs[1], vs[2]}).repeat((Traversal)__.inE((String[])new String[]{"knows"}).outV().hasId(sv[0].id(), new Object[0]).out(new String[]{"knows"}).sideEffect(e -> {
            loop2[0] = e.loops();
        }).has("id", (Object)loop2[0])).times(numV);
        JanusGraphTest.assertOptimization(t1, t2, new TraversalStrategy[]{AdjacentVertexHasIdOptimizerStrategy.instance()});
        JanusGraphTest.assertNumStep(numV / 5, 1, gts.V(new Object[]{sv[0]}).properties(new String[]{"names"}).has("weight", (Object)1), JanusGraphPropertiesStep.class);
        JanusGraphTest.assertNumStep(numV, 1, gts.V(new Object[]{sv[0]}).properties(new String[]{"names"}), JanusGraphPropertiesStep.class);
        JanusGraphTest.assertNumStep(10, 0, gts.V(new Object[]{sv[0]}).local((Traversal)__.properties((String[])new String[]{"names"}).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)), LocalStep.class);
        JanusGraphTest.assertNumStep(numV, 2, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).values(new String[]{"weight"}), JanusGraphVertexStep.class, JanusGraphPropertiesStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)).has("weight", (Object)(numV / 5 % 5)), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(numV / 5, 1, gts.V(new Object[0]).has("weight", (Object)1), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(10, 1, gts.V(new Object[0]).has("weight", (Object)1).range(0L, 10L), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(superV, 1, gts.V(new Object[0]).has("id", (Object)sid), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)).as("x", new String[0]), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)).has("weight", (Object)(numV / 5 % 5)).as("x", new String[0]), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(superV * (numV / 5), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", (Object)1), JanusGraphStep.class, JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)), JanusGraphStep.class, JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)), JanusGraphStep.class, JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(superV * 10, 2, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)).limit(10L)), JanusGraphStep.class, JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(superV * 10, 1, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(superV * 10, 0, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)), LocalStep.class);
        GraphTraversal t = gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).inV().has("weight", P.between((Object)1, (Object)3)).profile("~metrics");
        JanusGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, t, JanusGraphStep.class, JanusGraphVertexStep.class);
        Assertions.assertFalse((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multiPreFetch"));
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.BATCH_PROPERTY_PREFETCHING, new String[0]), true);
        gts = this.graph.traversal();
        t = gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).inV().has("weight", P.between((Object)1, (Object)3)).profile("~metrics");
        JanusGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, t, JanusGraphStep.class, JanusGraphVertexStep.class);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multiPreFetch"));
        t = gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).inV().has("weight", P.between((Object)1, (Object)3)).profile("~metrics");
        JanusGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, t, JanusGraphStep.class, JanusGraphVertexStep.class);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multiPreFetch"));
        t = gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).inV().has("weight", P.between((Object)1, (Object)3)).limit(1000L).profile("~metrics");
        JanusGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, t, JanusGraphStep.class, JanusGraphVertexStep.class);
        Assertions.assertFalse((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multiPreFetch"));
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true);
        gts = this.graph.traversal();
        t = gts.V(new Object[]{sv[0]}).outE(new String[0]).inV().choose((Traversal)__.inE((String[])new String[]{"knows"}).has("weight", (Object)0), (Traversal)__.inE((String[])new String[]{"knows"}).has("weight", (Object)1), (Traversal)__.inE((String[])new String[]{"knows"}).has("weight", (Object)2)).profile("~metrics");
        JanusGraphTest.assertNumStep(numV * 2, 2, t, ChooseStep.class, JanusGraphVertexStep.class);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        t = gts.V(new Object[]{sv[0]}).outE(new String[0]).inV().union(new Traversal[]{__.inE((String[])new String[]{"knows"}).has("weight", (Object)0), __.inE((String[])new String[]{"knows"}).has("weight", (Object)1), __.inE((String[])new String[]{"knows"}).has("weight", (Object)2)}).profile("~metrics");
        JanusGraphTest.assertNumStep(numV * 6, 2, t, UnionStep.class, JanusGraphVertexStep.class);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        int[] loop = new int[]{0};
        t = gts.V(new Object[]{vs[0], vs[1], vs[2]}).repeat((Traversal)__.inE((String[])new String[]{"knows"}).outV().hasId(sv[0].id(), new Object[0]).out(new String[]{"knows"}).sideEffect(e -> {
            loop[0] = e.loops();
        }).has("id", (Object)loop[0])).times(numV).profile("~metrics");
        JanusGraphTest.assertNumStep(3, 1, t, RepeatStep.class);
        Assertions.assertEquals((int)(numV - 1), (int)loop[0]);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        t = gts.V(new Object[]{vs[0], vs[1], vs[2]}).optional((Traversal)__.inE((String[])new String[]{"knows"}).has("weight", (Object)0)).profile("~metrics");
        JanusGraphTest.assertNumStep(12, 1, t, OptionalStep.class);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        t = gts.V(new Object[]{vs[0], vs[1], vs[2]}).filter((Traversal)__.inE((String[])new String[]{"knows"}).has("weight", (Object)0)).profile("~metrics");
        JanusGraphTest.assertNumStep(1, 1, t, TraversalFilterStep.class);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        JanusGraphTest.assertNumStep(superV * (numV / 5), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", (Object)1), JanusGraphStep.class, JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)), JanusGraphStep.class, JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(superV * 10, 2, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)).limit(10L)), JanusGraphStep.class, JanusGraphVertexStep.class);
        JanusGraphTest.assertNumStep(superV * 10, 1, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)), JanusGraphStep.class);
        JanusGraphTest.assertNumStep(superV * 10, 0, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)), LocalStep.class);
        JanusGraphTest.assertNumStep(superV * numV, 2, gts.V(new Object[0]).has("id", (Object)sid).values(new String[]{"names"}), JanusGraphStep.class, JanusGraphPropertiesStep.class);
        t = gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)).profile("~metrics");
        JanusGraphAssert.assertCount(superV * 10, (Traversal)t);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        t = gts.V(new Object[0]).has("id", (Object)sid).values(new String[]{"names"}).profile("~metrics");
        JanusGraphAssert.assertCount(superV * numV, (Traversal)t);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true);
        gts = this.graph.traversal();
        t = gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)).profile("~metrics");
        JanusGraphAssert.assertCount(superV * 10, (Traversal)t);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        t = gts.V(new Object[0]).has("id", (Object)sid).values(new String[]{"names"}).profile("~metrics");
        JanusGraphAssert.assertCount(superV * numV, (Traversal)t);
        Assertions.assertTrue((boolean)JanusGraphTest.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
    }

    private static void assertSameResultWithOptimizations(Traversal<?, ?> originalTraversal, TraversalStrategy<?> ... strategies) {
        Traversal.Admin optimizedTraversal = originalTraversal.asAdmin().clone();
        optimizedTraversal.getStrategies().addStrategies(strategies);
        List optimizedResult = optimizedTraversal.toList();
        Traversal.Admin unOptimizedTraversal = originalTraversal.asAdmin().clone();
        Stream.of(strategies).forEach(s -> unOptimizedTraversal.getStrategies().removeStrategies(new Class[]{s.getClass()}));
        List unOptimizedResult = unOptimizedTraversal.toList();
        Assertions.assertEquals((Object)unOptimizedResult, (Object)optimizedResult);
    }

    private static boolean queryProfilerAnnotationIsPresent(Traversal t, String queryProfilerAnnotation) {
        TraversalMetrics metrics = (TraversalMetrics)t.asAdmin().getSideEffects().get("~metrics");
        return metrics.toString().contains(queryProfilerAnnotation + "=true");
    }

    private static void assertNumStep(int expectedResults, int expectedSteps, GraphTraversal traversal, Class<? extends Step> ... expectedStepTypes) {
        int num = 0;
        while (traversal.hasNext()) {
            traversal.next();
            ++num;
        }
        Assertions.assertEquals((int)expectedResults, (int)num);
        List steps = traversal.asAdmin().getSteps();
        HashSet expSteps = Sets.newHashSet((Object[])expectedStepTypes);
        int numSteps = 0;
        for (Step s : steps) {
            if (s.getClass().equals(GraphStep.class) || s.getClass().equals(StartStep.class) || !expSteps.contains(s.getClass())) continue;
            ++numSteps;
        }
        Assertions.assertEquals((int)expectedSteps, (int)numSteps);
    }

    private static void assertOptimization(Traversal<?, ?> expectedTraversal, Traversal<?, ?> originalTraversal, TraversalStrategy ... optimizationStrategies) {
        DefaultTraversalStrategies optimizations = new DefaultTraversalStrategies();
        for (TraversalStrategy strategy : optimizationStrategies) {
            optimizations.addStrategies(new TraversalStrategy[]{strategy});
        }
        originalTraversal.asAdmin().setStrategies((TraversalStrategies)optimizations);
        originalTraversal.asAdmin().applyStrategies();
        Assertions.assertEquals((Object)expectedTraversal.asAdmin().getSteps().toString(), (Object)originalTraversal.asAdmin().getSteps().toString());
    }

    private static void verifyMetrics(Metrics metric, boolean fromCache, boolean multiQuery) {
        Assertions.assertTrue((metric.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((metric.getCount("elementCount") > 0L ? 1 : 0) != 0);
        String hasMultiQuery = (String)metric.getAnnotation("multi");
        Assertions.assertTrue((boolean)(multiQuery ? hasMultiQuery.equalsIgnoreCase("true") : hasMultiQuery == null));
        block8: for (Metrics subMetric : metric.getNested()) {
            Assertions.assertTrue((subMetric.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            switch (subMetric.getName()) {
                case "optimization": {
                    Assertions.assertNull((Object)subMetric.getCount("elementCount"));
                    continue block8;
                }
                case "backend-query": {
                    if (fromCache) {
                        Assertions.fail((String)"Should not execute backend-queries when cached");
                    }
                    Assertions.assertTrue((subMetric.getCount("elementCount") > 0L ? 1 : 0) != 0);
                    continue block8;
                }
            }
            Assertions.fail((String)("Unrecognized nested query: " + subMetric.getName()));
        }
    }

    @Test
    public void testSimpleTinkerPopTraversal() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "josh"});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "lop"});
        v1.addEdge("created", (Vertex)v2, new Object[0]);
        Object id = ((Edge)this.graph.traversal().V(new Object[0]).has("name", (Object)"josh").outE(new String[]{"created"}).as("e", new String[0]).inV().has("name", (Object)"lop").select("e").next()).id();
        Assertions.assertNotNull((Object)id);
    }

    @Test
    public void testHasKeyOnEdgePropertyTraversal() {
        Vertex vertex = this.prepareDataForEdgePropertyFilterTest();
        List result = this.graph.traversal().V(new Object[]{vertex}).bothE(new String[0]).properties(new String[0]).hasKey("name", new String[0]).value().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals(result.get(0), (Object)"testValue");
    }

    @Test
    public void testHasValueOnEdgePropertyTraversal() {
        Vertex vertex = this.prepareDataForEdgePropertyFilterTest();
        List result = this.graph.traversal().V(new Object[]{vertex}).bothE(new String[0]).properties(new String[0]).hasValue((Object)"testValue", new Object[0]).value().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals(result.get(0), (Object)"testValue");
    }

    @Test
    public void testHasKeyAndHasValueOnEdgePropertyTraversal() {
        Vertex vertex = this.prepareDataForEdgePropertyFilterTest();
        List result = this.graph.traversal().V(new Object[]{vertex}).bothE(new String[0]).properties(new String[0]).hasKey("weight", new String[0]).hasValue(P.lt((Object)3)).value().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals(result.get(0), (Object)2);
    }

    private Vertex prepareDataForEdgePropertyFilterTest() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "josh"});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "lop"});
        JanusGraphVertex v3 = this.graph.addVertex(new Object[]{"name", "lop2"});
        this.graph.traversal().V(new Object[]{v1}).addE("created").to((Vertex)v2).property((Object)"name", (Object)"testValue", new Object[0]).next();
        this.graph.traversal().V(new Object[]{v1}).addE("created").to((Vertex)v3).property((Object)"weight", (Object)2, new Object[0]).next();
        return v1;
    }

    @Test
    public void simpleLogTest() throws InterruptedException {
        this.simpleLogTest(false);
    }

    @Test
    public void simpleLogTestWithFailure() throws InterruptedException {
        this.simpleLogTest(true);
    }

    public void simpleLogTest(final boolean withLogFailure) throws InterruptedException {
        String userLogName = "test";
        final Serializer serializer = this.graph.getDataSerializer();
        EdgeSerializer edgeSerializer = this.graph.getEdgeSerializer();
        final TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        final Instant startTime = times.getTime();
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LOG_BACKEND, "user"), withLogFailure ? TestMockLog.class.getName() : GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue(), JanusGraphTest.option(TestMockLog.LOG_MOCK_FAILADD, "user"), withLogFailure, JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "user"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "user"), Duration.ofMillis(250L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "user"), Duration.ofMillis(100L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), Duration.ofMillis(250L), JanusGraphTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), Duration.ofSeconds(1L));
        String instanceId = this.graph.getConfiguration().getUniqueGraphId();
        PropertyKey weight = this.tx.makePropertyKey("weight").dataType(Float.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.tx.makeEdgeLabel("knows").make();
        JanusGraphVertex n1 = this.tx.addVertex(new Object[]{"weight", 10.5});
        this.tx.addProperties(knows, new PropertyKey[]{weight});
        this.newTx();
        Instant[] txTimes = new Instant[4];
        txTimes[0] = times.getTime();
        JanusGraphTransaction tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        JanusGraphVertex v1 = tx2.addVertex(new Object[]{"weight", 111.1});
        v1.addEdge("knows", (Vertex)v1, new Object[0]);
        tx2.commit();
        long v1id = JanusGraphTest.getId((Element)v1);
        txTimes[1] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        JanusGraphVertex v2 = tx2.addVertex(new Object[]{"weight", 222.2});
        v2.addEdge("knows", (Vertex)JanusGraphTest.getV((Transaction)tx2, v1id), new Object[0]);
        tx2.commit();
        long v2id = JanusGraphTest.getId((Element)v2);
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v1 = JanusGraphTest.getV((Transaction)tx2, v1id);
        Assertions.assertEquals((double)111.1, (double)((Float)v1.value("weight")).doubleValue(), (double)0.01);
        Assertions.assertEquals((double)222.2, (double)((Float)JanusGraphTest.getV((Transaction)tx2, v2).value("weight")).doubleValue(), (double)0.01);
        tx2.commit();
        txTimes[2] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v2 = JanusGraphTest.getV((Transaction)tx2, v2id);
        Assertions.assertEquals((double)222.2, (double)((Float)v2.value("weight")).doubleValue(), (double)0.01);
        v2.remove();
        tx2.commit();
        txTimes[3] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v1 = JanusGraphTest.getV((Transaction)tx2, v1id);
        Assertions.assertEquals((double)111.1, (double)((Float)v1.value("weight")).doubleValue(), (double)0.01);
        Edge e = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assertions.assertFalse((boolean)e.property("weight").isPresent());
        e.property("weight", (Object)44.4);
        tx2.commit();
        this.close();
        Instant endTime = times.getTime();
        ReadMarker startMarker = ReadMarker.fromTime((Instant)startTime);
        Log transactionLog = this.openTxLog();
        Log userLog = this.openUserLog("test");
        final EnumMap<LogTxStatus, AtomicInteger> txMsgCounter = new EnumMap<LogTxStatus, AtomicInteger>(LogTxStatus.class);
        for (LogTxStatus status : LogTxStatus.values()) {
            txMsgCounter.put(status, new AtomicInteger(0));
        }
        final AtomicInteger userLogMeta = new AtomicInteger(0);
        transactionLog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                Instant msgTime = message.getTimestamp();
                Assertions.assertTrue((msgTime.isAfter(startTime) || msgTime.equals(startTime) ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)message.getSenderId());
                TransactionLogHeader.Entry txEntry = TransactionLogHeader.parse((StaticBuffer)message.getContent(), (Serializer)serializer, (TimestampProvider)times);
                TransactionLogHeader header = txEntry.getHeader();
                Assertions.assertTrue((header.getTimestamp().isAfter(startTime) || header.getTimestamp().equals(startTime) ? 1 : 0) != 0);
                Assertions.assertTrue((header.getTimestamp().isBefore(msgTime) || header.getTimestamp().equals(msgTime) ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)txEntry.getMetadata());
                Assertions.assertNull(txEntry.getMetadata().get(LogTxMeta.GROUPNAME));
                LogTxStatus status = txEntry.getStatus();
                if (status == LogTxStatus.PRECOMMIT) {
                    Assertions.assertTrue((boolean)txEntry.hasContent());
                    Object logId = txEntry.getMetadata().get(LogTxMeta.LOG_ID);
                    if (logId != null) {
                        Assertions.assertTrue((boolean)(logId instanceof String));
                        Assertions.assertEquals((Object)"test", logId);
                        userLogMeta.incrementAndGet();
                    }
                } else if (withLogFailure) {
                    Assertions.assertTrue((status.isPrimarySuccess() || status == LogTxStatus.SECONDARY_FAILURE ? 1 : 0) != 0);
                    if (status == LogTxStatus.SECONDARY_FAILURE) {
                        TransactionLogHeader.SecondaryFailures secFail = txEntry.getContentAsSecondaryFailures(serializer);
                        Assertions.assertTrue((boolean)secFail.failedIndexes.isEmpty());
                        Assertions.assertTrue((boolean)secFail.userLogFailure);
                    }
                } else {
                    Assertions.assertFalse((boolean)txEntry.hasContent());
                    Assertions.assertTrue((boolean)status.isSuccess());
                }
                ((AtomicInteger)txMsgCounter.get(txEntry.getStatus())).incrementAndGet();
            }

            public void updateState() {
            }
        }});
        final EnumMap<Change, AtomicInteger> userChangeCounter = new EnumMap<Change, AtomicInteger>(Change.class);
        for (Change change : Change.values()) {
            userChangeCounter.put(change, new AtomicInteger(0));
        }
        final AtomicInteger userLogMsgCounter = new AtomicInteger(0);
        userLog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                Instant msgTime = message.getTimestamp();
                Assertions.assertTrue((msgTime.isAfter(startTime) || msgTime.equals(startTime) ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)message.getSenderId());
                StaticBuffer content = message.getContent();
                Assertions.assertTrue((content != null && content.length() > 0 ? 1 : 0) != 0);
                TransactionLogHeader.Entry transactionEntry = TransactionLogHeader.parse((StaticBuffer)content, (Serializer)serializer, (TimestampProvider)times);
                Instant txTime = transactionEntry.getHeader().getTimestamp();
                Assertions.assertTrue((txTime.isBefore(msgTime) || txTime.equals(msgTime) ? 1 : 0) != 0);
                Assertions.assertTrue((txTime.isAfter(startTime) || txTime.equals(msgTime) ? 1 : 0) != 0);
                long transactionId = transactionEntry.getHeader().getId();
                Assertions.assertTrue((transactionId > 0L ? 1 : 0) != 0);
                transactionEntry.getContentAsModifications(serializer).forEach(modification -> {
                    Assertions.assertTrue((modification.state == Change.ADDED || modification.state == Change.REMOVED ? 1 : 0) != 0);
                    ((AtomicInteger)userChangeCounter.get(modification.state)).incrementAndGet();
                });
                userLogMsgCounter.incrementAndGet();
            }

            public void updateState() {
            }
        }});
        Thread.sleep(4000L);
        Assertions.assertEquals((int)5, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRECOMMIT)).get());
        Assertions.assertEquals((int)4, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRIMARY_SUCCESS)).get());
        Assertions.assertEquals((int)1, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.COMPLETE_SUCCESS)).get());
        Assertions.assertEquals((int)4, (int)userLogMeta.get());
        if (withLogFailure) {
            Assertions.assertEquals((int)4, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_FAILURE)).get());
        } else {
            Assertions.assertEquals((int)4, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_SUCCESS)).get());
        }
        if (withLogFailure) {
            Assertions.assertEquals((int)0, (int)userLogMsgCounter.get());
        } else {
            Assertions.assertEquals((int)4, (int)userLogMsgCounter.get());
            Assertions.assertEquals((int)7, (int)((AtomicInteger)userChangeCounter.get(Change.ADDED)).get());
            Assertions.assertEquals((int)4, (int)((AtomicInteger)userChangeCounter.get(Change.REMOVED)).get());
        }
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.VERBOSE_TX_RECOVERY, new String[0]), true);
        TransactionRecovery recovery = JanusGraphFactory.startTransactionRecovery((JanusGraph)this.graph, (Instant)startTime);
        AtomicInteger userLogCount = new AtomicInteger(0);
        LogProcessorFramework userLogs = JanusGraphFactory.openTransactionLog((JanusGraph)this.graph);
        userLogs.addLogProcessor("test").setStartTime(startTime).setRetryAttempts(1).addProcessor((tx, txId, changes) -> {
            JanusGraphVertex v;
            int txNo;
            Assertions.assertEquals((Object)instanceId, (Object)txId.getInstanceId());
            Assertions.assertTrue((txId.getTransactionId() > 0L && txId.getTransactionId() < 100L ? 1 : 0) != 0);
            Instant txTime = txId.getTransactionTime();
            Assertions.assertTrue((!(!txTime.isAfter(startTime) && !txTime.equals(startTime) || !txTime.isBefore(endTime) && !txTime.equals(endTime)) ? 1 : 0) != 0, (String)String.format("tx timestamp %s not between start %s and end time %s", txTime, startTime, endTime));
            Assertions.assertTrue((boolean)tx.containsRelationType("knows"));
            Assertions.assertTrue((boolean)tx.containsRelationType("weight"));
            EdgeLabel knows1 = tx.getEdgeLabel("knows");
            PropertyKey weight1 = tx.getPropertyKey("weight");
            Instant txTimeMicro = txId.getTransactionTime();
            if (txTimeMicro.isBefore(txTimes[1])) {
                txNo = 1;
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                Assertions.assertEquals((long)v1id, (long)JanusGraphTest.getId((Element)v));
                VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.ADDED, new String[]{"weight"}));
                Assertions.assertEquals((double)111.1, (double)((Float)p.value()).doubleValue(), (double)0.01);
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
            } else if (txTimeMicro.isBefore(txTimes[2])) {
                txNo = 2;
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                Assertions.assertEquals((long)v2id, (long)JanusGraphTest.getId((Element)v));
                VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.ADDED, new String[]{"weight"}));
                Assertions.assertEquals((double)222.2, (double)((Float)p.value()).doubleValue(), (double)0.01);
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
            } else if (txTimeMicro.isBefore(txTimes[3])) {
                txNo = 3;
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{weight1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.REMOVED));
                Assertions.assertEquals((long)v2id, (long)JanusGraphTest.getId((Element)v));
                VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.REMOVED, new String[]{"weight"}));
                Assertions.assertEquals((double)222.2, (double)((Float)p.value()).doubleValue(), (double)0.01);
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.REMOVED, Direction.OUT, new String[0])));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
            } else {
                txNo = 4;
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ANY));
                Assertions.assertEquals((long)v1id, (long)JanusGraphTest.getId((Element)v));
                JanusGraphEdge e1 = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)changes.getEdges((Vertex)v, Change.REMOVED, Direction.OUT, new String[]{"knows"}));
                Assertions.assertFalse((boolean)e1.property("weight").isPresent());
                Assertions.assertEquals((Object)v, (Object)e1.vertex(Direction.IN));
                e1 = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[]{"knows"}));
                Assertions.assertEquals((double)44.4, (double)((Float)e1.value("weight")).doubleValue(), (double)0.01);
                Assertions.assertEquals((Object)v, (Object)e1.vertex(Direction.IN));
            }
            JanusGraphVertex v11 = JanusGraphTest.getV((Transaction)tx, v1id);
            Assertions.assertNotNull((Object)v11);
            Assertions.assertTrue((boolean)v11.isLoaded());
            if (txNo != 2) {
                JanusGraphTest.assertMissing((Transaction)tx, v2id);
            }
            Assertions.assertEquals((double)111.1, (double)((Float)v11.value("weight")).doubleValue(), (double)0.01);
            JanusGraphAssert.assertCount(1, v11.query().direction(Direction.OUT).edges());
            userLogCount.incrementAndGet();
        }).build();
        Thread.sleep(22000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        if (withLogFailure) {
            Assertions.assertEquals((long)1L, (long)recoveryStats[0]);
            Assertions.assertEquals((long)4L, (long)recoveryStats[1]);
        } else {
            Assertions.assertEquals((long)5L, (long)recoveryStats[0]);
            Assertions.assertEquals((long)0L, (long)recoveryStats[1]);
        }
        userLogs.removeLogProcessor("test");
        userLogs.shutdown();
        Assertions.assertEquals((int)4, (int)userLogCount.get());
    }

    @Test
    public void testGlobalGraphIndexingAndQueriesForInternalIndexes() {
        JanusGraphEdge janusGraphEdge;
        JanusGraphVertex u;
        String txt;
        double w;
        JanusGraphVertexProperty p2;
        JanusGraphVertexProperty p1;
        int i;
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{weight}).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").signature(new PropertyKey[]{time}).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel organization = this.mgmt.makeVertexLabel("organization").make();
        JanusGraphIndex edge1 = this.mgmt.buildIndex("edge1", Edge.class).addKey(time).addKey(weight).buildCompositeIndex();
        JanusGraphIndex edge2 = this.mgmt.buildIndex("edge2", Edge.class).indexOnly((JanusGraphSchemaType)connect).addKey(text).buildCompositeIndex();
        JanusGraphIndex prop1 = this.mgmt.buildIndex("prop1", JanusGraphVertexProperty.class).addKey(time).buildCompositeIndex();
        JanusGraphIndex prop2 = this.mgmt.buildIndex("prop2", JanusGraphVertexProperty.class).addKey(weight).addKey(text).buildCompositeIndex();
        JanusGraphIndex vertex1 = this.mgmt.buildIndex("vertex1", Vertex.class).addKey(time).indexOnly((JanusGraphSchemaType)person).unique().buildCompositeIndex();
        JanusGraphIndex vertex12 = this.mgmt.buildIndex("vertex12", Vertex.class).addKey(text).indexOnly((JanusGraphSchemaType)person).buildCompositeIndex();
        JanusGraphIndex vertex2 = this.mgmt.buildIndex("vertex2", Vertex.class).addKey(time).addKey(name).indexOnly((JanusGraphSchemaType)organization).buildCompositeIndex();
        JanusGraphIndex vertex3 = this.mgmt.buildIndex("vertex3", Vertex.class).addKey(name).buildCompositeIndex();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(JanusGraphVertexProperty.class)));
        Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assertions.assertTrue((boolean)vertex1.isUnique());
        Assertions.assertFalse((boolean)edge2.isUnique());
        Assertions.assertEquals((Object)"prop1", (Object)prop1.name());
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assertions.assertTrue((boolean)JanusGraphVertexProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assertions.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assertions.assertEquals((int)2, (int)vertex2.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.asParameter()}).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        text = this.mgmt.getPropertyKey("text");
        time = this.mgmt.getPropertyKey("time");
        weight = this.mgmt.getPropertyKey("weight");
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(JanusGraphVertexProperty.class)));
        Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assertions.assertTrue((boolean)vertex1.isUnique());
        Assertions.assertFalse((boolean)edge2.isUnique());
        Assertions.assertEquals((Object)"prop1", (Object)prop1.name());
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assertions.assertTrue((boolean)JanusGraphVertexProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assertions.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assertions.assertEquals((int)2, (int)vertex2.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.asParameter()}).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int numV = 100;
        boolean sorted = true;
        JanusGraphVertex[] ns = new JanusGraphVertex[100];
        String[] strings = new String[]{"aaa", "bbb", "ccc", "ddd"};
        for (i = 0; i < 100; ++i) {
            ns[i] = this.tx.addVertex(i % 2 == 0 ? "person" : "organization");
            p1 = ns[i].property("name", (Object)("v" + i));
            p2 = ns[i].property("name", (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            txt = strings[i % strings.length];
            ns[i].property(VertexProperty.Cardinality.single, "weight", (Object)w, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "time", (Object)i, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "text", (Object)txt, new Object[0]);
            for (VertexProperty p : new VertexProperty[]{p1, p2}) {
                p.property("weight", (Object)w);
                p.property("time", (Object)i);
                p.property("text", (Object)txt);
            }
            u = ns[i > 0 ? i - 1 : i];
            String[] stringArray = new String[]{"connect", "related"};
            int n = stringArray.length;
            for (int p = 0; p < n; ++p) {
                String label = stringArray[p];
                Object[] objectArray = new Object[6];
                objectArray[0] = "weight";
                double d = w;
                w = d + 1.0;
                objectArray[1] = d % 5.0;
                objectArray[2] = "time";
                objectArray[3] = (long)i;
                objectArray[4] = "text";
                objectArray[5] = txt;
                janusGraphEdge = ns[i].addEdge(label, (Vertex)u, objectArray);
            }
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[10 % strings.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect"), ElementCategory.EDGE, 100 / strings.length, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.EDGE, 100 / strings.length * 2, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.name(), prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.name(), vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v51").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 0, new boolean[]{true, false}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Contain.NOT_IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.name());
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[10 % strings.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect"), ElementCategory.EDGE, 100 / strings.length, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.EDGE, 100 / strings.length * 2, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.name(), prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.name(), vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v51").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 0, new boolean[]{true, false}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Contain.NOT_IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, vertex12.name());
        for (i = 0; i < 50; ++i) {
            JanusGraphVertex v = JanusGraphTest.getV((Transaction)this.tx, ns[i]);
            v.remove();
        }
        ns = new JanusGraphVertex[150];
        for (i = 100; i < 150; ++i) {
            ns[i] = this.tx.addVertex(i % 2 == 0 ? "person" : "organization");
            p1 = ns[i].property("name", (Object)("v" + i));
            p2 = ns[i].property("name", (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            txt = strings[i % strings.length];
            ns[i].property(VertexProperty.Cardinality.single, "weight", (Object)w, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "time", (Object)i, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "text", (Object)txt, new Object[0]);
            for (VertexProperty p : new JanusGraphVertex[]{p1, p2}) {
                p.property("weight", (Object)w);
                p.property("time", (Object)i);
                p.property("text", (Object)txt);
            }
            u = ns[i > 100 ? i - 1 : i];
            for (String label : new String[]{"connect", "related"}) {
                Object[] objectArray = new Object[6];
                objectArray[0] = "weight";
                double d = w;
                w = d + 1.0;
                objectArray[1] = d % 5.0;
                objectArray[2] = "time";
                objectArray[3] = (long)i;
                objectArray[4] = "text";
                objectArray[5] = txt;
                janusGraphEdge = ns[i].addEdge(label, (Vertex)u, objectArray);
            }
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)110).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)30).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)130).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)110).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)30).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)130).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
    }

    @Test
    public void testTinkerPropInfinityLimit() {
        this.initializeGraphWithVerticesHavingNames("marko", "ark", "arko", "park", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)5L, (Long)((Long)g.V(new Object[0]).limit(-1L).count().next()));
        Assertions.assertEquals((long)4L, (Long)((Long)g.V(new Object[0]).skip(1L).count().next()));
    }

    @Test
    public void testTinkerPopTextContainingFindsCorrectValue() {
        this.initializeGraphWithVerticesHavingNames("marko", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((Object)"marko", (Object)g.V(new Object[0]).has("name", (P)TextP.containing((String)"ark")).values(new String[]{"name"}).next());
    }

    @Test
    public void testTinkerPopTextContainingFindsRightNumberOfValues() {
        this.initializeGraphWithVerticesHavingNames("marko", "ark", "arko", "park", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)4L, (Long)((Long)g.V(new Object[0]).has("name", (P)TextP.containing((String)"ark")).count().next()));
    }

    @Test
    public void testTinkerPopTextPredicatesConnectedViaAnd() {
        this.initializeGraphWithVerticesHavingNames("marko", "mark", "notmarko", "notmark", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[0]).has("name", TextP.startingWith((String)"mark").and((Predicate)TextP.endingWith((String)"ark"))).count().next()));
    }

    private void initializeGraphWithVerticesHavingNames(String ... names) {
        this.makeKey("name", String.class);
        this.finishSchema();
        GraphTraversalSource g = this.graph.traversal();
        for (String name : names) {
            g.addV().property((Object)"name", (Object)name, new Object[0]).iterate();
        }
        g.tx().commit();
    }

    @Test
    public void testTinkerPopTextStartingWith() {
        this.makeKey("name", String.class);
        this.mgmt.makeVertexLabel("person").make();
        this.finishSchema();
        GraphTraversalSource g = this.graph.traversal();
        g.addV("person").property((Object)"name", (Object)"marko", new Object[0]).iterate();
        g.tx().commit();
        Assertions.assertEquals((Object)"marko", (Object)g.V(new Object[0]).has("person", "name", (P)TextP.containing((String)"ark")).values(new String[]{"name"}).next());
    }

    @Test
    public void testIndexUniqueness() {
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("organization").make();
        JanusGraphIndex vertexIndex1 = this.mgmt.buildIndex("vindex1", Vertex.class).addKey(time).indexOnly((JanusGraphSchemaType)person).unique().buildCompositeIndex();
        JanusGraphIndex vertexIndex2 = this.mgmt.buildIndex("vindex2", Vertex.class).addKey(time).addKey(text).unique().buildCompositeIndex();
        this.finishSchema();
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v0 = tx.addVertex("person");
            v0.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
            JanusGraphVertex v1 = tx.addVertex("person");
            v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        });
        JanusGraphVertex v0 = this.tx.addVertex("person");
        v0.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        this.newTx();
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v1 = tx.addVertex("person");
            v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        });
        JanusGraphVertex v1 = this.tx.addVertex("organization");
        v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        this.newTx();
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v01 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
            JanusGraphVertex v11 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
        });
        v0 = this.tx.addVertex(new Object[]{"time", 2, "text", "hello"});
        this.newTx();
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v112 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
        });
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, String ... intersectingIndexes) {
        JanusGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1), intersectingIndexes);
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, PropertyKey orderKey2, Order order2, String ... intersectingIndexes) {
        JanusGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1, (Object)orderKey2, (Object)order2), intersectingIndexes);
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, String ... intersectingIndexes) {
        JanusGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of(), intersectingIndexes);
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap, String ... intersectingIndexes) {
        Iterable result;
        if (intersectingIndexes == null) {
            intersectingIndexes = new String[]{};
        }
        SimpleQueryProfiler profiler = new SimpleQueryProfiler();
        ((GraphCentricQueryBuilder)query).profiler((QueryProfiler)profiler);
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case VERTEX: {
                result = query.vertices();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OrderList orders = (OrderList)profiler.getAnnotation("orders");
        int no = 0;
        JanusGraphElement previous = null;
        for (JanusGraphElement e : result) {
            Assertions.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assertions.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assertions.assertEquals((int)expectedResults, (int)no);
        Assertions.assertNotNull((Object)orders);
        Assertions.assertEquals((int)orderMap.size(), (int)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assertions.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assertions.assertTrue((boolean)orders.containsKey(key));
        }
        SimpleQueryProfiler simpleQueryProfiler = (SimpleQueryProfiler)Iterables.getOnlyElement((Iterable)StreamSupport.stream(profiler.spliterator(), false).filter(p -> !p.getGroupName().equals("optimization")).collect(Collectors.toList()));
        if (subQuerySpecs.length == 2) {
            Assertions.assertEquals((Object)subQuerySpecs[0], (Object)simpleQueryProfiler.getAnnotation("isFitted"));
            Assertions.assertEquals((Object)subQuerySpecs[1], (Object)simpleQueryProfiler.getAnnotation("isOrdered"));
        }
        HashSet<Object> indexNames = new HashSet<Object>();
        int indexQueries = 0;
        boolean fullScan = false;
        for (SimpleQueryProfiler indexProfiler : simpleQueryProfiler) {
            if (indexProfiler.getAnnotation("fullscan") != null) {
                fullScan = true;
                continue;
            }
            indexNames.add(indexProfiler.getAnnotation("index"));
            ++indexQueries;
        }
        if (indexQueries > 0) {
            Assertions.assertFalse((boolean)fullScan);
        }
        if (fullScan) {
            Assertions.assertEquals((int)0, (int)intersectingIndexes.length);
        }
        Assertions.assertEquals((int)intersectingIndexes.length, (int)indexQueries);
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])intersectingIndexes), indexNames);
    }

    @Test
    public void testForceIndexUsage() {
        PropertyKey age = this.makeKey("age", Integer.class);
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildIndex("time", Vertex.class).addKey(time).buildCompositeIndex();
        this.finishSchema();
        for (int i = 1; i <= 10; ++i) {
            JanusGraphVertex janusGraphVertex = this.tx.addVertex(new Object[]{"time", i, "age", i});
        }
        JanusGraphAssert.assertCount(1, this.tx.query().has("time", (Object)5).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("age", (Object)6).vertices());
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        JanusGraphAssert.assertCount(1, this.tx.query().has("time", (Object)5).vertices());
        try {
            JanusGraphAssert.assertCount(1, this.tx.query().has("age", (Object)6).vertices());
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLargeJointIndexRetrieval() {
        this.makeVertexIndexedKey("sid", Integer.class);
        this.makeVertexIndexedKey("color", String.class);
        this.finishSchema();
        int sids = 17;
        String[] colors = new String[]{"blue", "red", "yellow", "brown", "green", "orange", "purple"};
        int multiplier = 200;
        int numV = sids * colors.length * multiplier;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex janusGraphVertex = this.graph.addVertex(new Object[]{"color", colors[i % colors.length], "sid", i % sids});
        }
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(numV / sids, this.graph.query().has("sid", (Object)8).vertices());
        JanusGraphAssert.assertCount(numV / colors.length, this.graph.query().has("color", (Object)colors[2]).vertices());
        JanusGraphAssert.assertCount(multiplier, this.graph.query().has("sid", (Object)11).has("color", (Object)colors[3]).vertices());
    }

    @Test
    public void testIndexQueryWithLabelsAndContainsIN() {
        String labelName = "labelName";
        VertexLabel label = this.mgmt.makeVertexLabel(labelName).make();
        PropertyKey uid = this.mgmt.makePropertyKey("uid").dataType(String.class).make();
        JanusGraphIndex uidCompositeIndex = this.mgmt.buildIndex("uidIndex", Vertex.class).indexOnly((JanusGraphSchemaType)label).addKey(uid).unique().buildCompositeIndex();
        this.mgmt.setConsistency((JanusGraphSchemaElement)uidCompositeIndex, ConsistencyModifier.LOCK);
        this.finishSchema();
        JanusGraphVertex foo = this.graph.addVertex(labelName);
        JanusGraphVertex bar = this.graph.addVertex(labelName);
        foo.property("uid", (Object)"foo");
        bar.property("uid", (Object)"bar");
        this.graph.tx().commit();
        Iterable vertexes = this.graph.query().has("uid", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)"foo", (Object)"bar")).has(LABEL_NAME, (Object)labelName).vertices();
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)vertexes));
        for (JanusGraphVertex v : vertexes) {
            Assertions.assertEquals((Object)labelName, (Object)v.vertexLabel().name());
        }
    }

    @Test
    public void testLimitWithMixedIndexCoverage() {
        String key1 = "vt";
        String key2 = "firstname";
        String value1 = "user";
        String alice = "alice";
        String bob = "bob";
        this.makeVertexIndexedKey("vt", String.class);
        this.makeKey("firstname", String.class);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"vt", "user", "firstname", "alice"});
        this.tx.addVertex(new Object[]{"vt", "user", "firstname", "bob"});
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "bob");
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "alice");
        this.tx.commit();
        this.tx = this.graph.newTransaction();
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "bob");
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "alice");
    }

    private static void getVertexWithLimitAndAssertProperties(JanusGraphTransaction tx, String key1, String value1, String key2, String value2) {
        JanusGraphVertex v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)tx.query().has(key1, (Object)value1).has(key2, (Object)value2).limit(1).vertices());
        Assertions.assertEquals((Object)value2, (Object)v.value(key2));
        Assertions.assertEquals((Object)value1, (Object)v.value(key1));
    }

    @Test
    public void testWithoutIndex() {
        PropertyKey kid = this.mgmt.makePropertyKey("kid").dataType(Long.class).make();
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makeEdgeLabel("knows").signature(new PropertyKey[]{kid}).make();
        this.finishSchema();
        Random random = new Random();
        int numV = 1000;
        JanusGraphVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex v = this.graph.addVertex(new Object[]{"kid", random.nextInt(numV), "name", "v" + i});
            if (previous != null) {
                JanusGraphEdge janusGraphEdge = v.addEdge("knows", (Vertex)previous, new Object[]{"kid", random.nextInt(numV / 2)});
            }
            previous = v;
        }
        JanusGraphTest.assertElementOrderForWithoutIndex(this.graph);
        this.clopen(new Object[0]);
        JanusGraphTest.assertElementOrderForWithoutIndex(this.graph);
    }

    private static void assertElementOrderForWithoutIndex(StandardJanusGraph graph) {
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(500).vertices(), "kid", Order.ASC, 500);
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(300).edges(), "kid", Order.ASC, 300);
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(400).vertices(), "kid", Order.DESC, 400);
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(200).edges(), "kid", Order.DESC, 200);
    }

    @Test
    public void testNeqQuery() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p1", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p1", P.neq(null)).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p2", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p2", P.neq(null)).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p3", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p3", P.neq(null)).hasNext());
    }

    @Test
    public void testHasNullQuery() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p1", null).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p2", null).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p3", null).hasNext());
    }

    @Test
    public void testHasNot() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p1").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p1").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p1", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p1", (Object)"value").vertices().iterator().hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p2").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p2").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p2", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p2", (Object)"value").vertices().iterator().hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p3").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p3").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p3", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p3", (Object)"value").vertices().iterator().hasNext());
    }

    @Test
    public void testNotHas() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p1")).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p2")).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p3")).hasNext());
    }

    @Test
    public void testVertexCentricIndexWithNull() {
        EdgeLabel bought = this.makeLabel("bought");
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildEdgeIndex(bought, "byTimeDesc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildEdgeIndex(bought, "byTimeAsc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.asc, new PropertyKey[]{time});
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)1);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)2);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)3);
        v1.addEdge("bought", (Vertex)v2, new Object[0]);
        v1.addEdge("bought", (Vertex)v2, new Object[0]);
        JanusGraphTest.assertVertexCentricIndexWithNull(v1);
        this.newTx();
        v1 = this.tx.getVertex(v1.longId());
        JanusGraphTest.assertVertexCentricIndexWithNull(v1);
    }

    private static void assertVertexCentricIndexWithNull(JanusGraphVertex v1) {
        Assertions.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
        Assertions.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Object)1).edgeCount());
        Assertions.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)3).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)1).edgeCount());
        Assertions.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)5).edgeCount());
        Assertions.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)0).edgeCount());
        Assertions.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)3).edgeCount());
        Assertions.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)2).edgeCount());
        Assertions.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).hasNot("time").edgeCount());
        Assertions.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
    }

    @Test
    public void testCreateDelete() {
        this.makeKey("weight", Double.class);
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{uid}).sortOrder(Order.DESC).directed().make();
        this.mgmt.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        this.finishSchema();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.graph.addVertex(new Object[]{"uid", 445});
        JanusGraphEdge e = v3.addEdge("knows", (Vertex)v1, new Object[]{"uid", 111});
        JanusGraphEdge e2 = v1.addEdge("friend", (Vertex)v3, new Object[0]);
        Assertions.assertEquals((int)111, (int)((Integer)e.value("uid")));
        this.graph.tx().commit();
        v3 = JanusGraphTest.getV((Transaction)this.graph, v3);
        Assertions.assertEquals((int)445, (int)((Integer)v3.value("uid")));
        e = (Edge)Iterables.getOnlyElement((Iterable)v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assertions.assertEquals((int)111, (int)((Integer)e.value("uid")));
        Assertions.assertEquals((Object)e, (Object)JanusGraphTest.getE((Transaction)this.graph, e.id()));
        Assertions.assertEquals((Object)e, (Object)JanusGraphTest.getE((Transaction)this.graph, e.id().toString()));
        VertexProperty p = (VertexProperty)JanusGraphTest.getOnlyElement(v3.properties(new String[]{"uid"}));
        p.remove();
        v3.property("uid", (Object)353);
        e = (Edge)Iterables.getOnlyElement((Iterable)v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        e.property("uid", (Object)222);
        e2 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"friend"}).edges());
        e2.property("uid", (Object)1);
        e2.property("weight", (Object)2.0);
        Assertions.assertEquals((int)1, (int)((Integer)e2.value("uid")));
        Assertions.assertEquals((double)2.0, (double)((Double)e2.value("weight")), (double)1.0E-4);
        this.clopen(new Object[0]);
        v3 = JanusGraphTest.getV((Transaction)this.graph, v3.id());
        Assertions.assertEquals((int)353, (int)((Integer)v3.value("uid")));
        e = (Edge)Iterables.getOnlyElement((Iterable)v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assertions.assertEquals((int)222, (int)((Integer)e.value("uid")));
    }

    @Test
    public void testRemoveEdge() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e = v1.addEdge("related", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        e.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.tx.query().edges().iterator().hasNext());
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLTiming() throws Exception {
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        int ttl1 = 1;
        int ttl2 = 4;
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(ttl1));
        EdgeLabel label2 = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)label2, Duration.ofSeconds(ttl2));
        EdgeLabel label3 = this.mgmt.makeEdgeLabel("indifferentTo").make();
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl1), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl2), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label2));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)label3));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        v2.addEdge("dislikes", (Vertex)v1, new Object[0]);
        v3.addEdge("indifferentTo", (Vertex)v1, new Object[0]);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        long commitTime = System.currentTimeMillis();
        this.graph.tx().commit();
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        Thread.sleep(commitTime + ((long)ttl1 * 1000L + 200L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        Thread.sleep(commitTime + ((long)ttl2 * 1000L + 500L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLWithTransactions() throws Exception {
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(1L));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        Thread.sleep(1001L);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        this.graph.tx().commit();
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        Thread.sleep(1001L);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
    }

    @Test
    @Tag(value="BRITTLE_TESTS")
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLWithIndex() throws Exception {
        int ttl = 1;
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        EdgeLabel wavedAt = this.mgmt.makeEdgeLabel("wavedAt").signature(new PropertyKey[]{time}).make();
        this.mgmt.buildEdgeIndex(wavedAt, "timeindex", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildIndex("edge-time", Edge.class).addKey(time).buildCompositeIndex();
        this.mgmt.setTTL((JanusGraphSchemaType)wavedAt, Duration.ofSeconds(ttl));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)time));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl), (Object)this.mgmt.getTTL((JanusGraphSchemaType)wavedAt));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("wavedAt", (Vertex)v2, new Object[]{"time", 42});
        Assertions.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("time", (Object)42).edges());
        this.graph.tx().commit();
        long commitTime = System.currentTimeMillis();
        Assertions.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("time", (Object)42).edges());
        Thread.sleep(commitTime + ((long)ttl * 1000L + 100L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        Assertions.assertFalse((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertEmpty(this.graph.query().has("time", (Object)42).edges());
    }

    @Test
    @Tag(value="BRITTLE_TESTS")
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testPropertyTTLTiming() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey place = this.mgmt.makePropertyKey("place").dataType(String.class).make();
        this.mgmt.setTTL((JanusGraphSchemaType)name, Duration.ofSeconds(42L));
        this.mgmt.setTTL((JanusGraphSchemaType)place, Duration.ofSeconds(1L));
        JanusGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        JanusGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(place).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(2L));
        Assertions.assertEquals((Object)Duration.ofSeconds(42L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)place));
        Assertions.assertEquals((Object)Duration.ofSeconds(2L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{T.label, "event", "name", "some event", "place", "somewhere"});
        this.tx.commit();
        Object id = v1.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNotNull((Object)v1);
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNotNull((Object)v1);
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNull((Object)v1);
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testVertexTTLWithCompositeIndex() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Long.class).make();
        JanusGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        JanusGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(time).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(1L));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)time));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{T.label, "event", "name", "some event", "time", System.currentTimeMillis()});
        this.tx.commit();
        Object id = v1.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNotNull((Object)v1);
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNull((Object)v1);
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").vertices());
    }

    @Test
    @Tag(value="BRITTLE_TESTS")
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLLimitedByVertexTTL() throws Exception {
        Boolean dbCache = (Boolean)this.config.get("cache.db-cache", Boolean.class);
        if (null == dbCache) {
            dbCache = false;
        }
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)likes, Duration.ofSeconds(42L));
        EdgeLabel dislikes = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)dislikes, Duration.ofSeconds(1L));
        EdgeLabel indifferentTo = this.mgmt.makeEdgeLabel("indifferentTo").make();
        VertexLabel label1 = this.mgmt.makeVertexLabel("person").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(2L));
        Assertions.assertEquals((Object)Duration.ofSeconds(42L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)likes));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)dislikes));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)indifferentTo));
        Assertions.assertEquals((Object)Duration.ofSeconds(2L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex("person");
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphEdge v1LikesV2 = v1.addEdge("likes", (Vertex)v2, new Object[0]);
        JanusGraphEdge v1DislikesV2 = v1.addEdge("dislikes", (Vertex)v2, new Object[0]);
        JanusGraphEdge v1IndifferentToV2 = v1.addEdge("indifferentTo", (Vertex)v2, new Object[0]);
        this.tx.commit();
        long commitTime = System.currentTimeMillis();
        Object v1Id = v1.id();
        Object v2id = v2.id();
        Object v1LikesV2Id = v1LikesV2.id();
        Object v1DislikesV2Id = v1DislikesV2.id();
        Object v1IndifferentToV2Id = v1IndifferentToV2.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1Id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        v1LikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = JanusGraphTest.getE((Transaction)this.graph, v1IndifferentToV2Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v1LikesV2);
        Assertions.assertNotNull((Object)v1DislikesV2);
        Assertions.assertNotNull((Object)v1IndifferentToV2);
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        Thread.sleep(commitTime + 1001L - System.currentTimeMillis());
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1Id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        v1LikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = JanusGraphTest.getE((Transaction)this.graph, v1IndifferentToV2Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v1LikesV2);
        Assertions.assertNull((Object)v1DislikesV2);
        Assertions.assertNotNull((Object)v1IndifferentToV2);
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
        JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        Thread.sleep(commitTime + 2001L - System.currentTimeMillis());
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1Id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        v1LikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = JanusGraphTest.getE((Transaction)this.graph, v1IndifferentToV2Id);
        Assertions.assertNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNull((Object)v1LikesV2);
        Assertions.assertNull((Object)v1DislikesV2);
        Assertions.assertNull((Object)v1IndifferentToV2);
        if (!dbCache.booleanValue()) {
            JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
            JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
            JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        }
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testSettingTTLOnUnsupportedType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ImplicitKey type = ImplicitKey.ID;
            this.mgmt.setTTL((JanusGraphSchemaType)type, Duration.ZERO);
        });
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testUnsettingTTL() throws InterruptedException {
        int initialTTLMillis = 2000;
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)likes, Duration.ofMillis(initialTTLMillis));
        this.mgmt.commit();
        this.graph.tx().rollback();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Thread.sleep((long)Math.ceil((double)initialTTLMillis * 1.25));
        Assertions.assertEquals((int)2, (int)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assertions.assertEquals((int)0, (int)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        this.mgmt.setTTL((JanusGraphSchemaType)this.mgmt.getEdgeLabel("likes"), Duration.ZERO);
        this.mgmt.commit();
        Thread.sleep(1L);
        Assertions.assertEquals((int)2, (int)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assertions.assertEquals((int)0, (int)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        v1 = this.graph.addVertex(new Object[0]);
        v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Thread.sleep((long)Math.ceil((double)initialTTLMillis * 1.25));
        Assertions.assertEquals((int)4, (int)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assertions.assertEquals((int)1, (int)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        this.graph.tx().rollback();
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testGettingUndefinedEdgeLabelTTL() {
        this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)this.mgmt.getEdgeLabel("likes")));
        this.mgmt.rollback();
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testGettingUndefinedVertexLabelTTL() {
        this.mgmt.makeVertexLabel("foo").make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)this.mgmt.getVertexLabel("foo")));
        this.mgmt.rollback();
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testGetTTLFromUnsupportedType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ImplicitKey type = ImplicitKey.ID;
            this.mgmt.getTTL((JanusGraphSchemaType)type);
        });
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testSettingTTLOnNonStaticVertexLabel() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            VertexLabel label1 = this.mgmt.makeVertexLabel("event").make();
            this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(42L));
        });
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLImplicitKey() throws Exception {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        Assertions.assertEquals((Object)"~ttl", (Object)ImplicitKey.TTL.name());
        int ttl = 86400;
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        EdgeLabel hasLiked = this.mgmt.makeEdgeLabel("hasLiked").make();
        this.mgmt.setTTL((JanusGraphSchemaType)likes, Duration.ofSeconds(ttl));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl), (Object)this.mgmt.getTTL((JanusGraphSchemaType)likes));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)hasLiked));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e1 = v1.addEdge("likes", (Vertex)v2, new Object[0]);
        JanusGraphEdge e2 = v1.addEdge("hasLiked", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Duration d = (Duration)e1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"likes"}).edges());
        d = (Duration)e1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"likes"}).edges());
        d = (Duration)e1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        d = (Duration)e2.value("~ttl");
        Assertions.assertEquals((Object)Duration.ZERO, (Object)d);
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testVertexTTLImplicitKey() throws Exception {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        int ttl1 = 1;
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(ttl1));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl1), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex("event");
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        this.tx.commit();
        Object v1id = v1.id();
        Object v2id = v2.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        Duration d = (Duration)v1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)d);
        d = (Duration)v2.value("~ttl");
        Assertions.assertEquals((Object)Duration.ZERO, (Object)d);
    }

    @Test
    public void testAutoSchemaMakerForVertexPropertyDataType() {
        JanusGraphVertex v1 = this.tx.addVertex("user");
        v1.property("id", (Object)10);
        v1.property("created", (Object)new Date());
        PropertyKey idPropertyKey = this.tx.getPropertyKey("id");
        Assertions.assertEquals(Integer.class, (Object)idPropertyKey.dataType(), (String)"Data type not identified correctly by auto schema maker");
        PropertyKey createdPropertyKey = this.tx.getPropertyKey("created");
        Assertions.assertEquals(Date.class, (Object)createdPropertyKey.dataType(), (String)"Data type not identified properly by auto schema maker");
    }

    @Test
    public void testAutoSchemaMakerForEdgePropertyDataType() {
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10, "created", new Date()});
        PropertyKey idPropertyKey = this.tx.getPropertyKey("id");
        Assertions.assertEquals(Integer.class, (Object)idPropertyKey.dataType(), (String)"Data type not identified correctly by auto schema maker");
        PropertyKey createdPropertyKey = this.tx.getPropertyKey("created");
        Assertions.assertEquals(Date.class, (Object)createdPropertyKey.dataType(), (String)"Data type not identified correctly by auto schema maker");
    }

    @Test
    public void testWriteAndReadWithJanusGraphIoRegistryWithGryo(@TempDir Path tempDir) {
        Path file = tempDir.resolve("testgraph_" + this.getClass().getCanonicalName() + ".kryo");
        this.testWritingAndReading(file.toFile());
    }

    @Test
    public void testWriteAndReadWithJanusGraphIoRegistryWithGraphson(@TempDir Path tempDir) {
        Path file = tempDir.resolve("testgraph_" + this.getClass().getCanonicalName() + ".json");
        this.testWritingAndReading(file.toFile());
    }

    private void testWritingAndReading(File f) {
        GraphTraversalSource g = this.graph.traversal();
        g.addV().property((Object)"name", (Object)f.getName(), new Object[0]).iterate();
        g.tx().commit();
        Assertions.assertEquals((long)0L, (long)f.length());
        g.io(f.getAbsolutePath()).write().iterate();
        Assertions.assertTrue((f.length() > 0L ? 1 : 0) != 0, (String)("File " + f.getAbsolutePath() + " was expected to be not empty, but is"));
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        g.V(new Object[0]).has("name", (Object)f.getName()).drop().iterate();
        g.tx().commit();
        g.io(f.getAbsolutePath()).read().iterate();
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[0]).has("name", (Object)f.getName()).count().next()));
    }

    private static /* synthetic */ void lambda$testAutomaticTypeCreation$33(Vertex v1) throws Throwable {
        v1.addEdge("blub", v1, new Object[0]);
    }

    private static /* synthetic */ void lambda$testAutomaticTypeCreation$32(Vertex v1) throws Throwable {
        v1.property("bla", (Object)5);
    }

    private static interface TransactionJob {
        public void run(JanusGraphTransaction var1);
    }

    public static interface Equals<T> {
        public boolean verifyValue(T var1);
    }
}

