/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.diskstorage.util.TestLockerManager;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.testutil.JanusGraphAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="SERIAL_TESTS")
public abstract class JanusGraphEventualGraphTest
extends JanusGraphBaseTest {
    @Test
    public void verifyEligibility() {
        Preconditions.checkArgument((!this.graph.getConfiguration().getBackend().getStoreFeatures().hasTxIsolation() ? 1 : 0) != 0, (Object)"This test suite only applies to eventually consistent data stores");
    }

    @Test
    public void concurrentIndexTest() {
        this.makeVertexIndexedUniqueKey("uid", String.class);
        this.makeVertexIndexedKey("value", Object.class);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"uid", "v"});
        this.clopen(new Object[0]);
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        JanusGraphEventualGraphTest.getVertex(tx1, "uid", (Object)"v").property(VertexProperty.Cardinality.single, "value", (Object)11, new Object[0]);
        JanusGraphEventualGraphTest.getVertex(tx2, "uid", (Object)"v").property(VertexProperty.Cardinality.single, "value", (Object)11, new Object[0]);
        tx1.commit();
        tx2.commit();
        Assertions.assertEquals((Object)"v", (Object)Iterators.getOnlyElement((Iterator)((JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("value", (Object)11).vertices())).values(new String[]{"uid"})));
    }

    @Test
    public void testTimestampSetting() {
        this.clopen(JanusGraphEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, "edgestore"), true, JanusGraphEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        JanusGraphTransaction tx1 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(100L)).start();
        String name = "name";
        String age = "age";
        String address = "address";
        JanusGraphVertex v1 = tx1.addVertex(new Object[]{name, "a"});
        JanusGraphVertex v2 = tx1.addVertex(new Object[]{age, "14", name, "b", age, "42"});
        tx1.commit();
        long id1 = JanusGraphEventualGraphTest.getId((Element)v1);
        long id2 = JanusGraphEventualGraphTest.getId((Element)v2);
        JanusGraphTransaction tx2 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(1000L)).start();
        v1 = JanusGraphEventualGraphTest.getV((Transaction)tx2, id1);
        v2 = JanusGraphEventualGraphTest.getV((Transaction)tx2, id2);
        Iterator propertyIterator = v1.properties(new String[]{name});
        while (propertyIterator.hasNext()) {
            VertexProperty prop = (VertexProperty)propertyIterator.next();
            if (this.features.hasTimestamps()) {
                Instant t = (Instant)prop.value("~timestamp");
                Assertions.assertEquals((long)100L, (long)t.getEpochSecond());
                Assertions.assertEquals((int)Instant.ofEpochSecond(0L, 1000L).getNano(), (int)t.getNano());
            }
            if (!this.features.hasCellTTL()) continue;
            Duration d = (Duration)prop.value("~ttl");
            Assertions.assertEquals((long)0L, (long)d.getSeconds());
            Assertions.assertTrue((boolean)d.isZero());
        }
        Assertions.assertEquals((long)1L, (long)v1.query().propertyCount());
        Assertions.assertEquals((long)1L, (long)v1.query().has("~timestamp", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)Instant.ofEpochSecond(10L)).propertyCount());
        Assertions.assertEquals((long)1L, (long)v1.query().has("~timestamp", (Object)Instant.ofEpochSecond(100L, 1000L)).propertyCount());
        v1.property(name).remove();
        v1.property(VertexProperty.Cardinality.single, address, (Object)"xyz", new Object[0]);
        JanusGraphEdge edge = v2.addEdge("parent", (Vertex)v1, new Object[0]);
        tx2.commit();
        Object edgeId = edge.id();
        JanusGraphVertex afterTx2 = JanusGraphEventualGraphTest.getV((Transaction)this.graph, id1);
        Assertions.assertFalse((boolean)afterTx2.keys().contains(name));
        Assertions.assertEquals((Object)"xyz", (Object)afterTx2.value(address));
        JanusGraphAssert.assertCount(1, afterTx2.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        Assertions.assertNotNull((Object)JanusGraphEventualGraphTest.getE((Transaction)this.graph, edgeId));
        this.graph.tx().commit();
        JanusGraphTransaction tx3 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(200L)).start();
        v1 = JanusGraphEventualGraphTest.getV((Transaction)tx3, id1);
        v1.property(address).remove();
        tx3.commit();
        JanusGraphVertex afterTx3 = JanusGraphEventualGraphTest.getV((Transaction)this.graph, id1);
        this.graph.tx().commit();
        Assertions.assertEquals((Object)"xyz", (Object)afterTx3.value(address));
        JanusGraphTransaction tx4 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(2000L)).start();
        v2 = JanusGraphEventualGraphTest.getV((Transaction)tx4, id2);
        v2.property(VertexProperty.Cardinality.single, age, (Object)"15", new Object[0]);
        JanusGraphEventualGraphTest.getE((Transaction)tx4, edgeId).remove();
        tx4.commit();
        JanusGraphVertex afterTx4 = JanusGraphEventualGraphTest.getV((Transaction)this.graph, id2);
        Assertions.assertEquals((Object)"15", (Object)afterTx4.value(age));
        JanusGraphAssert.assertCount(0, afterTx4.query().direction(Direction.OUT).labels(new String[]{"parent"}).edges());
        Assertions.assertNull((Object)JanusGraphEventualGraphTest.getE((Transaction)this.graph, edgeId));
        JanusGraphTransaction tx5 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(1500L)).start();
        v2 = JanusGraphEventualGraphTest.getV((Transaction)tx5, id2);
        v2.property(VertexProperty.Cardinality.single, age, (Object)"16", new Object[0]);
        tx5.commit();
        JanusGraphVertex afterTx5 = JanusGraphEventualGraphTest.getV((Transaction)this.graph, id2);
        Assertions.assertEquals((Object)"15", (Object)afterTx5.value(age));
    }

    @Test
    public void testTimestampedEdgeUpdates() {
        this.clopen(JanusGraphEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, "edgestore"), true, JanusGraphEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        JanusGraphTransaction tx = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(100L)).start();
        JanusGraphVertex v1 = tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = tx.addVertex(new Object[0]);
        JanusGraphEdge e = v1.addEdge("related", (Vertex)v2, new Object[0]);
        e.property("time", (Object)25);
        tx.commit();
        tx = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(200L)).start();
        v1 = tx.getVertex(v1.longId());
        Assertions.assertNotNull((Object)v1);
        e = (Edge)Iterators.getOnlyElement((Iterator)v1.edges(Direction.OUT, new String[]{"related"}));
        Assertions.assertNotNull((Object)e);
        Assertions.assertEquals((Integer)25, (Integer)((Integer)e.value("time")));
        e.property("time", (Object)125);
        tx.commit();
        tx = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(300L)).start();
        v1 = tx.getVertex(v1.longId());
        Assertions.assertNotNull((Object)v1);
        e = (Edge)Iterators.getOnlyElement((Iterator)v1.edges(Direction.OUT, new String[]{"related"}));
        Assertions.assertEquals((Integer)125, (Integer)((Integer)e.value("time")));
        e.remove();
        tx.commit();
    }

    @Test
    public void testBatchLoadingNoLock() {
        this.testBatchLoadingLocking(true);
    }

    @Test
    public void testLockException() {
        try {
            this.testBatchLoadingLocking(false);
            Assertions.fail();
        }
        catch (JanusGraphException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            Assertions.assertEquals(UnsupportedOperationException.class, cause.getClass());
        }
    }

    public void testBatchLoadingLocking(boolean batchLoading) {
        JanusGraphVertex v;
        int i;
        PropertyKey uid = this.makeKey("uid", Long.class);
        JanusGraphIndex uidIndex = this.mgmt.buildIndex("uid", Vertex.class).unique().addKey(uid).buildCompositeIndex();
        this.mgmt.setConsistency((JanusGraphSchemaElement)uid, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)uidIndex, ConsistencyModifier.LOCK);
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.setConsistency((JanusGraphSchemaElement)knows, ConsistencyModifier.LOCK);
        this.finishSchema();
        TestLockerManager.ERROR_ON_LOCKING = true;
        this.clopen(JanusGraphEventualGraphTest.option(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]), batchLoading, JanusGraphEventualGraphTest.option(GraphDatabaseConfiguration.LOCK_BACKEND, new String[0]), "test");
        int numV = 10000;
        for (i = 0; i < numV; ++i) {
            v = this.tx.addVertex(new Object[]{"uid", i + 1});
            v.addEdge("knows", (Vertex)v, new Object[0]);
        }
        this.clopen(new Object[0]);
        for (i = 0; i < Math.min(numV, 300); ++i) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("uid", (Object)(i + 1)).vertices()));
            v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.graph.query().has("uid", (Object)(i + 1)).vertices());
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges()));
        }
    }

    @Test
    public void testConsistencyModifier() throws InterruptedException {
        this.makeKey("sig", Integer.class);
        this.makeKey("weight", Double.class);
        this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        this.mgmt.makePropertyKey("value").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        PropertyKey valuef = this.mgmt.makePropertyKey("valuef").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        this.mgmt.setConsistency((JanusGraphSchemaElement)valuef, ConsistencyModifier.FORK);
        this.mgmt.makeEdgeLabel("em").multiplicity(Multiplicity.MULTI).make();
        EdgeLabel emf = this.mgmt.makeEdgeLabel("emf").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.setConsistency((JanusGraphSchemaElement)emf, ConsistencyModifier.FORK);
        this.mgmt.makeEdgeLabel("es").multiplicity(Multiplicity.SIMPLE).make();
        this.mgmt.makeEdgeLabel("o2o").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.makeEdgeLabel("o2m").multiplicity(Multiplicity.ONE2MANY).make();
        this.finishSchema();
        JanusGraphVertex u = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        JanusGraphRelation[] rs = new JanusGraphRelation[9];
        boolean transactionId = true;
        rs[0] = this.sign((JanusGraphRelation)v.property("weight", (Object)5.0), 1);
        rs[1] = this.sign((JanusGraphRelation)v.property("name", (Object)"John"), 1);
        rs[2] = this.sign((JanusGraphRelation)v.property("value", (Object)2), 1);
        rs[3] = this.sign((JanusGraphRelation)v.property("valuef", (Object)2), 1);
        rs[6] = this.sign((JanusGraphRelation)v.addEdge("es", (Vertex)u, new Object[0]), 1);
        rs[7] = this.sign((JanusGraphRelation)v.addEdge("o2o", (Vertex)u, new Object[0]), 1);
        rs[8] = this.sign((JanusGraphRelation)v.addEdge("o2m", (Vertex)u, new Object[0]), 1);
        rs[4] = this.sign((JanusGraphRelation)v.addEdge("em", (Vertex)u, new Object[0]), 1);
        rs[5] = this.sign((JanusGraphRelation)v.addEdge("emf", (Vertex)u, new Object[0]), 1);
        this.newTx();
        long vid = JanusGraphEventualGraphTest.getId((Element)v);
        long uid = JanusGraphEventualGraphTest.getId((Element)u);
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        int wintx = 20;
        this.processTx(tx1, 10, vid, uid);
        this.processTx(tx2, 20, vid, uid);
        tx1.commit();
        Thread.sleep(5L);
        tx2.commit();
        this.newTx();
        v = JanusGraphEventualGraphTest.getV((Transaction)this.tx, vid);
        Assertions.assertEquals((double)6.0, (double)((Double)v.value("weight")), (double)1.0E-5);
        VertexProperty p = (VertexProperty)JanusGraphEventualGraphTest.getOnlyElement(v.properties(new String[]{"weight"}));
        Assertions.assertEquals((int)20, (int)((Integer)p.value("sig")));
        p = (VertexProperty)JanusGraphEventualGraphTest.getOnlyElement(v.properties(new String[]{"name"}));
        Assertions.assertEquals((Object)"Bob", (Object)p.value());
        Assertions.assertEquals((int)20, (int)((Integer)p.value("sig")));
        p = (VertexProperty)JanusGraphEventualGraphTest.getOnlyElement(v.properties(new String[]{"value"}));
        Assertions.assertEquals((long)rs[2].longId(), (long)JanusGraphEventualGraphTest.getId((Element)p));
        Assertions.assertEquals((int)20, (int)((Integer)p.value("sig")));
        JanusGraphAssert.assertCount(2, v.properties(new String[]{"valuef"}));
        Iterator ppiter = v.properties(new String[]{"valuef"});
        while (ppiter.hasNext()) {
            VertexProperty pp = (VertexProperty)ppiter.next();
            Assertions.assertNotEquals((long)rs[3].longId(), (long)JanusGraphEventualGraphTest.getId((Element)pp));
            Assertions.assertEquals((Object)2, (Object)pp.value());
        }
        Edge e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"es"}).edges());
        Assertions.assertEquals((int)20, (int)((Integer)e.value("sig")));
        Assertions.assertNotEquals((long)rs[6].longId(), (long)JanusGraphEventualGraphTest.getId((Element)e));
        e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"o2o"}).edges());
        Assertions.assertEquals((int)20, (int)((Integer)e.value("sig")));
        Assertions.assertEquals((long)rs[7].longId(), (long)JanusGraphEventualGraphTest.getId((Element)e));
        e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"o2m"}).edges());
        Assertions.assertEquals((int)20, (int)((Integer)e.value("sig")));
        Assertions.assertNotEquals((long)rs[8].longId(), (long)JanusGraphEventualGraphTest.getId((Element)e));
        e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"em"}).edges());
        Assertions.assertEquals((int)20, (int)((Integer)e.value("sig")));
        Assertions.assertEquals((long)rs[4].longId(), (long)JanusGraphEventualGraphTest.getId((Element)e));
        for (Object o : v.query().direction(Direction.OUT).labels(new String[]{"emf"}).edges()) {
            Edge ee = (Edge)o;
            Assertions.assertNotEquals((long)rs[5].longId(), (long)JanusGraphEventualGraphTest.getId((Element)ee));
            Assertions.assertEquals((Object)uid, (Object)ee.inVertex().id());
        }
    }

    private void processTx(JanusGraphTransaction tx, int transactionId, long vid, long uid) {
        JanusGraphVertex v = JanusGraphEventualGraphTest.getV((Transaction)tx, vid);
        JanusGraphVertex u = JanusGraphEventualGraphTest.getV((Transaction)tx, uid);
        Assertions.assertEquals((double)5.0, (double)((Double)v.value("weight")), (double)1.0E-5);
        VertexProperty p = (VertexProperty)JanusGraphEventualGraphTest.getOnlyElement(v.properties(new String[]{"weight"}));
        Assertions.assertEquals((int)1, (int)((Integer)p.value("sig")));
        this.sign((JanusGraphRelation)v.property("weight", (Object)6.0), transactionId);
        p = (VertexProperty)JanusGraphEventualGraphTest.getOnlyElement(v.properties(new String[]{"name"}));
        Assertions.assertEquals((int)1, (int)((Integer)p.value("sig")));
        Assertions.assertEquals((Object)"John", (Object)p.value());
        p.remove();
        this.sign((JanusGraphRelation)v.property("name", (Object)"Bob"), transactionId);
        for (String pkey : new String[]{"value", "valuef"}) {
            p = (VertexProperty)JanusGraphEventualGraphTest.getOnlyElement(v.properties(new String[]{pkey}));
            Assertions.assertEquals((int)1, (int)((Integer)p.value("sig")));
            Assertions.assertEquals((Object)2, (Object)p.value());
            this.sign((JanusGraphRelation)((JanusGraphVertexProperty)p), transactionId);
        }
        Edge e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"es"}).edges());
        Assertions.assertEquals((int)1, (int)((Integer)e.value("sig")));
        e.remove();
        this.sign((JanusGraphRelation)v.addEdge("es", (Vertex)u, new Object[0]), transactionId);
        e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"o2o"}).edges());
        Assertions.assertEquals((int)1, (int)((Integer)e.value("sig")));
        this.sign((JanusGraphRelation)((JanusGraphEdge)e), transactionId);
        e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"o2m"}).edges());
        Assertions.assertEquals((int)1, (int)((Integer)e.value("sig")));
        e.remove();
        this.sign((JanusGraphRelation)v.addEdge("o2m", (Vertex)u, new Object[0]), transactionId);
        for (String label : new String[]{"em", "emf"}) {
            e = (Edge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{label}).edges());
            Assertions.assertEquals((int)1, (int)((Integer)e.value("sig")));
            this.sign((JanusGraphRelation)((JanusGraphEdge)e), transactionId);
        }
    }

    private JanusGraphRelation sign(JanusGraphRelation r, int id) {
        r.property("sig", (Object)id);
        return r;
    }
}

