/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.JanusGraphBaseStoreFeaturesTest;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.LogManager;
import org.janusgraph.diskstorage.log.kcvs.KCVSLogManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class JanusGraphBaseTest
implements JanusGraphBaseStoreFeaturesTest {
    public static final String LABEL_NAME = T.label.getAccessor();
    public static final String ID_NAME = T.id.getAccessor();
    public WriteConfiguration config;
    public BasicConfiguration readConfig;
    public StandardJanusGraph graph;
    public StoreFeatures features;
    public JanusGraphTransaction tx;
    public JanusGraphManagement mgmt;
    public TestInfo testInfo;
    public Map<String, LogManager> logManagers;
    private KeyColumnValueStoreManager logStoreManager = null;
    public static final int DEFAULT_THREAD_COUNT = 4;

    public abstract WriteConfiguration getConfiguration();

    public Configuration getConfig() {
        return new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config.copy(), BasicConfiguration.Restriction.NONE);
    }

    public static void clearGraph(WriteConfiguration config) throws BackendException {
        JanusGraphBaseTest.getBackend(config, true).clearStorage();
    }

    public static Backend getBackend(WriteConfiguration config, boolean initialize) throws BackendException {
        ModifiableConfiguration adjustedConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config.copy(), BasicConfiguration.Restriction.NONE);
        adjustedConfig.set(GraphDatabaseConfiguration.LOCK_LOCAL_MEDIATOR_GROUP, (Object)"tmp", new String[0]);
        adjustedConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"inst", new String[0]);
        Backend backend = new Backend((Configuration)adjustedConfig);
        if (initialize) {
            backend.initialize((Configuration)adjustedConfig);
        }
        return backend;
    }

    @Override
    public StoreFeatures getStoreFeatures() {
        return this.features;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
        this.config = this.getConfiguration();
        TestGraphConfigs.applyOverrides(this.config);
        Preconditions.checkNotNull((Object)this.config);
        this.logManagers = new HashMap<String, LogManager>();
        JanusGraphBaseTest.clearGraph(this.config);
        this.readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config, BasicConfiguration.Restriction.NONE);
        this.open(this.config);
    }

    public void open(WriteConfiguration config) {
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)config);
        this.features = this.graph.getConfiguration().getStoreFeatures();
        this.tx = this.graph.newTransaction();
        this.mgmt = this.graph.openManagement();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.close();
        this.closeLogs();
    }

    public void finishSchema() {
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.commit();
        }
        this.mgmt = this.graph.openManagement();
        this.newTx();
        this.graph.tx().commit();
    }

    public void close() {
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.rollback();
        }
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        if (null != this.graph && this.graph.isOpen()) {
            this.graph.close();
        }
    }

    public void newTx() {
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        this.tx = this.graph.newTransaction();
    }

    public static Map<TestConfigOption, Object> validateConfigOptions(Object ... settings) {
        Preconditions.checkArgument((settings.length % 2 == 0 ? 1 : 0) != 0, (String)"Expected even number of settings: %s", (Object[])settings);
        HashMap options = Maps.newHashMap();
        for (int i = 0; i < settings.length; i += 2) {
            Preconditions.checkArgument((boolean)(settings[i] instanceof TestConfigOption), (String)"Expected configuration option but got: %s", (Object[])new Object[]{settings[i]});
            Preconditions.checkNotNull((Object)settings[i + 1], (String)"Null setting at position [%s]", (Object[])new Object[]{i + 1});
            options.put((TestConfigOption)settings[i], settings[i + 1]);
        }
        return options;
    }

    public void clopen(Object ... settings) {
        this.config = this.getConfiguration();
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.rollback();
        }
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        if (settings != null && settings.length > 0) {
            Map<TestConfigOption, Object> options = JanusGraphBaseTest.validateConfigOptions(settings);
            JanusGraphManagement janusGraphManagement = null;
            ModifiableConfiguration modifiableConfiguration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.config, BasicConfiguration.Restriction.LOCAL);
            for (Map.Entry<TestConfigOption, Object> option : options.entrySet()) {
                if (option.getKey().option.isLocal()) {
                    modifiableConfiguration.set(option.getKey().option, option.getValue(), option.getKey().umbrella);
                    continue;
                }
                if (janusGraphManagement == null) {
                    janusGraphManagement = this.graph.openManagement();
                }
                janusGraphManagement.set(ConfigElement.getPath((ConfigElement)option.getKey().option, (String[])option.getKey().umbrella), option.getValue());
            }
            if (janusGraphManagement != null) {
                janusGraphManagement.commit();
            }
            modifiableConfiguration.close();
        }
        if (null != this.graph && null != this.graph.tx() && this.graph.tx().isOpen()) {
            this.graph.tx().commit();
        }
        if (null != this.graph && this.graph.isOpen()) {
            this.graph.close();
        }
        Preconditions.checkNotNull((Object)this.config);
        this.open(this.config);
    }

    public static TestConfigOption option(ConfigOption option, String ... umbrella) {
        return new TestConfigOption(option, umbrella);
    }

    private void closeLogs() {
        try {
            for (LogManager lm : this.logManagers.values()) {
                lm.close();
            }
            this.logManagers.clear();
            if (this.logStoreManager != null) {
                this.logStoreManager.close();
                this.logStoreManager = null;
            }
        }
        catch (BackendException e) {
            throw new JanusGraphException((Throwable)e);
        }
    }

    public void closeLogManager(String logManagerName) {
        if (this.logManagers.containsKey(logManagerName)) {
            try {
                this.logManagers.remove(logManagerName).close();
            }
            catch (BackendException e) {
                throw new JanusGraphException("Could not close log manager " + logManagerName, (Throwable)e);
            }
        }
    }

    public Log openUserLog(String identifier) {
        return this.openLog("user", "ulog_" + identifier);
    }

    public Log openTxLog() {
        return this.openLog("tx", "txlog");
    }

    private Log openLog(String logManagerName, String logName) {
        try {
            StoreFeatures f;
            boolean part;
            ModifiableConfiguration configuration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.config.copy(), BasicConfiguration.Restriction.NONE);
            configuration.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"reader", new String[0]);
            configuration.set(GraphDatabaseConfiguration.LOG_READ_INTERVAL, (Object)Duration.ofMillis(500L), new String[]{logManagerName});
            if (this.logStoreManager == null) {
                this.logStoreManager = Backend.getStorageManager((Configuration)configuration);
            }
            boolean bl = part = (f = this.logStoreManager.getFeatures()).isDistributed() && f.isKeyOrdered();
            if (part) {
                for (String partitionedLogName : new String[]{"user", "tx", "janusgraph"}) {
                    configuration.set(KCVSLogManager.LOG_MAX_PARTITIONS, (Object)8, new String[]{partitionedLogName});
                }
            }
            Preconditions.checkNotNull((Object)this.logStoreManager);
            if (!this.logManagers.containsKey(logManagerName)) {
                Configuration logConfig = configuration.restrictTo(new String[]{logManagerName});
                Preconditions.checkState((boolean)((String)logConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0])).equals(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue()));
                this.logManagers.put(logManagerName, (LogManager)new KCVSLogManager(this.logStoreManager, logConfig));
            }
            Preconditions.checkState((boolean)this.logManagers.containsKey(logManagerName));
            return this.logManagers.get(logManagerName).openLog(logName);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not open log: " + logName, (Throwable)e);
        }
    }

    public PropertyKey makeVertexIndexedKey(String name, Class dataType) {
        PropertyKey key = this.mgmt.makePropertyKey(name).dataType(dataType).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(name, Vertex.class).addKey(key).buildCompositeIndex();
        return key;
    }

    public PropertyKey makeVertexIndexedUniqueKey(String name, Class dataType) {
        PropertyKey key = this.mgmt.makePropertyKey(name).dataType(dataType).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(name, Vertex.class).addKey(key).unique().buildCompositeIndex();
        return key;
    }

    public void createExternalVertexIndex(PropertyKey key, String backingIndex) {
        this.createExternalIndex(key, Vertex.class, backingIndex);
    }

    public void createExternalEdgeIndex(PropertyKey key, String backingIndex) {
        this.createExternalIndex(key, Edge.class, backingIndex);
    }

    public JanusGraphIndex getExternalIndex(Class<? extends Element> clazz, String backingIndex) {
        String prefix;
        if (Vertex.class.isAssignableFrom(clazz)) {
            prefix = "v";
        } else if (Edge.class.isAssignableFrom(clazz)) {
            prefix = "e";
        } else if (JanusGraphVertexProperty.class.isAssignableFrom(clazz)) {
            prefix = "p";
        } else {
            throw new AssertionError((Object)clazz.toString());
        }
        String indexName = prefix + backingIndex;
        JanusGraphIndex index = this.mgmt.getGraphIndex(indexName);
        if (index == null) {
            index = this.mgmt.buildIndex(indexName, clazz).buildMixedIndex(backingIndex);
        }
        return index;
    }

    private void createExternalIndex(PropertyKey key, Class<? extends Element> clazz, String backingIndex) {
        this.mgmt.addIndexKey(this.getExternalIndex(clazz, backingIndex), key, new Parameter[0]);
    }

    public PropertyKey makeKey(String name, Class dataType) {
        return this.mgmt.makePropertyKey(name).dataType(dataType).cardinality(Cardinality.SINGLE).make();
    }

    public EdgeLabel makeLabel(String name) {
        return this.mgmt.makeEdgeLabel(name).make();
    }

    public EdgeLabel makeKeyedEdgeLabel(String name, PropertyKey sort, PropertyKey signature) {
        return ((StandardEdgeLabelMaker)this.tx.makeEdgeLabel(name)).sortKey(new PropertyKey[]{sort}).signature(new PropertyKey[]{signature}).directed().make();
    }

    public static int getThreadCount() {
        String s = System.getProperty("janusgraph.test.threads");
        if (null != s) {
            return Integer.valueOf(s);
        }
        return 4;
    }

    public static int wrapAround(int value, int maxValue) {
        if ((value %= maxValue) < 0) {
            value += maxValue;
        }
        return value;
    }

    public JanusGraphVertex getVertex(String key, Object value) {
        return JanusGraphBaseTest.getVertex(this.tx, key, value);
    }

    public JanusGraphVertex getVertex(PropertyKey key, Object value) {
        return JanusGraphBaseTest.getVertex(this.tx, key, value);
    }

    public static JanusGraphVertex getVertex(JanusGraphTransaction tx, String key, Object value) {
        return JanusGraphBaseTest.getOnlyElement(tx.query().has(key, value).vertices(), null);
    }

    public static JanusGraphVertex getVertex(JanusGraphTransaction tx, PropertyKey key, Object value) {
        return JanusGraphBaseTest.getVertex(tx, key.name(), value);
    }

    public static double round(double d) {
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    public static JanusGraphVertex getOnlyVertex(JanusGraphQuery<?> query) {
        return (JanusGraphVertex)JanusGraphBaseTest.getOnlyElement(query.vertices());
    }

    public static JanusGraphEdge getOnlyEdge(JanusGraphVertexQuery<?> query) {
        return (JanusGraphEdge)JanusGraphBaseTest.getOnlyElement(query.edges());
    }

    public static <E> E getOnlyElement(Iterable<E> traversal) {
        return JanusGraphBaseTest.getOnlyElement(traversal.iterator());
    }

    public static <E> E getOnlyElement(Iterator<E> traversal) {
        if (!traversal.hasNext()) {
            throw new NoSuchElementException();
        }
        return JanusGraphBaseTest.getOnlyElement(traversal, null);
    }

    public static <E> E getOnlyElement(Iterable<E> traversal, E defaultElement) {
        return JanusGraphBaseTest.getOnlyElement(traversal.iterator(), defaultElement);
    }

    public static <E> E getOnlyElement(Iterator<E> traversal, E defaultElement) {
        if (!traversal.hasNext()) {
            return defaultElement;
        }
        E result = traversal.next();
        if (traversal.hasNext()) {
            throw new IllegalArgumentException("Traversal contains more than 1 element: " + result + ", " + traversal.next());
        }
        return result;
    }

    public static void assertMissing(Transaction g, Object vid) {
        Assertions.assertFalse((boolean)g.vertices(new Object[]{vid}).hasNext());
    }

    public static JanusGraphVertex getV(Transaction g, Object vid) {
        if (!g.vertices(new Object[]{vid}).hasNext()) {
            return null;
        }
        return (JanusGraphVertex)g.vertices(new Object[]{vid}).next();
    }

    public static JanusGraphEdge getE(Transaction g, Object eid) {
        if (!g.edges(new Object[]{eid}).hasNext()) {
            return null;
        }
        return (JanusGraphEdge)g.edges(new Object[]{eid}).next();
    }

    public static String n(Object obj) {
        if (obj instanceof RelationType) {
            return ((RelationType)obj).name();
        }
        return obj.toString();
    }

    public static long getId(Element e) {
        return ((JanusGraphElement)e).longId();
    }

    public static void verifyElementOrder(Iterable<? extends Element> elements, String key, Order order, int expectedCount) {
        JanusGraphBaseTest.verifyElementOrder(elements.iterator(), key, order, expectedCount);
    }

    public static void verifyElementOrder(Iterator<? extends Element> elements, String key, Order order, int expectedCount) {
        Comparable previous = null;
        int count = 0;
        while (elements.hasNext()) {
            Element element = elements.next();
            Comparable current = (Comparable)element.value(key);
            if (previous != null) {
                int cmp = previous.compareTo(current);
                Assertions.assertTrue((boolean)(order == Order.ASC ? cmp <= 0 : cmp >= 0), (String)(previous + " <> " + current + " @ " + count));
            }
            previous = current;
            ++count;
        }
        Assertions.assertEquals((int)expectedCount, (int)count);
    }

    public static <T> Stream<T> asStream(Iterator<T> source) {
        Iterable iterable = () -> source;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public JanusGraph getForceIndexGraph() {
        return this.getForceIndexGraph(this.getConfiguration());
    }

    public JanusGraph getForceIndexGraph(WriteConfiguration writeConfiguration) {
        ModifiableConfiguration adjustedConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, writeConfiguration, BasicConfiguration.Restriction.NONE);
        adjustedConfig.set(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, (Object)true, new String[0]);
        WriteConfiguration adjustedWriteConfig = adjustedConfig.getConfiguration();
        TestGraphConfigs.applyOverrides(adjustedWriteConfig);
        Preconditions.checkNotNull((Object)adjustedWriteConfig);
        return JanusGraphFactory.open((ReadConfiguration)adjustedWriteConfig);
    }

    public static final class TestConfigOption {
        public final ConfigOption option;
        public final String[] umbrella;

        public TestConfigOption(ConfigOption option, String ... umbrella) {
            Preconditions.checkNotNull((Object)option);
            this.option = option;
            if (umbrella == null) {
                umbrella = new String[]{};
            }
            this.umbrella = umbrella;
        }
    }
}

