/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.time.Duration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class WritableConfigurationTest {
    private WriteConfiguration config;

    public abstract WriteConfiguration getConfig();

    @BeforeEach
    public void setup() {
        this.config = this.getConfig();
    }

    @AfterEach
    public void cleanup() {
        this.config.close();
    }

    @Test
    public void configTest() {
        this.config.set("test.key", (Object)"world");
        this.config.set("test.bar", (Object)100);
        this.config.set("storage.xyz", (Object)true);
        this.config.set("storage.abc", (Object)Boolean.FALSE);
        this.config.set("storage.duba", (Object)new String[]{"x", "y"});
        this.config.set("times.60m", (Object)Duration.ofMinutes(60L));
        this.config.set("obj", new Object());
        Assertions.assertEquals((Object)"world", (Object)this.config.get("test.key", String.class));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"test.key", (Object)"test.bar"), (Object)Sets.newHashSet((Iterable)this.config.getKeys("test")));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"storage.xyz", (Object)"storage.duba", (Object)"storage.abc"), (Object)Sets.newHashSet((Iterable)this.config.getKeys("storage")));
        Assertions.assertEquals((int)100, (int)((Integer)this.config.get("test.bar", Integer.class)));
        Assertions.assertEquals((Object)true, (Object)this.config.get("storage.xyz", Boolean.class));
        Assertions.assertEquals((Object)false, (Object)this.config.get("storage.abc", Boolean.class));
        Assertions.assertArrayEquals((Object[])new String[]{"x", "y"}, (Object[])((Object[])this.config.get("storage.duba", String[].class)));
        Assertions.assertEquals((Object)Duration.ofMinutes(60L), (Object)this.config.get("times.60m", Duration.class));
        Assertions.assertTrue((boolean)Object.class.isAssignableFrom(this.config.get("obj", Object.class).getClass()));
    }
}

