/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.janusgraph.diskstorage.AbstractKCVSTest;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.KeyColumnValueStoreUtil;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSUtil;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CacheTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVEntryMutation;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.keycolumnvalue.cache.NoKCVSCache;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiWriteKeyColumnValueStoreTest
extends AbstractKCVSTest {
    private final Logger log = LoggerFactory.getLogger(MultiWriteKeyColumnValueStoreTest.class);
    final int bufferSize = 20;
    protected final String storeName1 = "testStore1";
    private KCVSCache store1;
    protected final String storeName2 = "testStore2";
    private KCVSCache store2;
    public KeyColumnValueStoreManager manager;
    public StoreTransaction tx;
    private final Random rand = new Random(10L);

    @BeforeEach
    public void setUp() throws Exception {
        KeyColumnValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        this.open();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.close();
    }

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    public void open() throws BackendException {
        this.manager = this.openStorageManager();
        this.tx = new CacheTransaction(this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig()), this.manager, 20, Duration.ofMillis(100L), true);
        this.store1 = new NoKCVSCache(this.manager.openDatabase("testStore1"));
        this.store2 = new NoKCVSCache(this.manager.openDatabase("testStore2"));
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        if (null != this.store1) {
            this.store1.close();
        }
        if (null != this.store2) {
            this.store2.close();
        }
        if (null != this.manager) {
            this.manager.close();
        }
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    public void newTx() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.tx = new CacheTransaction(this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig()), this.manager, 20, Duration.ofMillis(100L), true);
    }

    @Test
    public void deletionsAppliedBeforeAdditions() throws BackendException {
        int i;
        StaticBuffer b1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        Assertions.assertNull((Object)KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx));
        ArrayList additions = Lists.newArrayList((Object[])new Entry[]{StaticArrayEntry.of((StaticBuffer)b1, (StaticBuffer)b1)});
        ArrayList deletions = Lists.newArrayList((Iterable)additions);
        HashMap<StaticBuffer, KCVEntryMutation> combination = new HashMap<StaticBuffer, KCVEntryMutation>(1);
        HashMap<StaticBuffer, KCVEntryMutation> deleteOnly = new HashMap<StaticBuffer, KCVEntryMutation>(1);
        HashMap<StaticBuffer, KCVEntryMutation> addOnly = new HashMap<StaticBuffer, KCVEntryMutation>(1);
        combination.put(b1, new KCVEntryMutation((List)additions, (List)deletions));
        deleteOnly.put(b1, new KCVEntryMutation(KeyColumnValueStore.NO_ADDITIONS, (List)deletions));
        addOnly.put(b1, new KCVEntryMutation((List)additions, KCVSCache.NO_DELETIONS));
        this.store1.mutateEntries(b1, (List)additions, (List)deletions, this.tx);
        this.newTx();
        StaticBuffer result = KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx);
        Assertions.assertEquals((Object)b1, (Object)result);
        this.store1.mutateEntries(b1, KeyColumnValueStore.NO_ADDITIONS, (List)deletions, this.tx);
        this.newTx();
        for (i = 0; i < 100; ++i) {
            StaticBuffer n = KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx);
            Assertions.assertNull((Object)n);
            this.store1.mutateEntries(b1, (List)additions, KCVSCache.NO_DELETIONS, this.tx);
            this.newTx();
            this.store1.mutateEntries(b1, KeyColumnValueStore.NO_ADDITIONS, (List)deletions, this.tx);
            this.newTx();
            n = KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx);
            Assertions.assertNull((Object)n);
        }
        for (i = 0; i < 100; ++i) {
            this.store1.mutateEntries(b1, KeyColumnValueStore.NO_ADDITIONS, (List)deletions, this.tx);
            this.newTx();
            this.store1.mutateEntries(b1, (List)additions, KCVSCache.NO_DELETIONS, this.tx);
            this.newTx();
            Assertions.assertEquals((Object)b1, (Object)KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx));
        }
        for (i = 0; i < 100; ++i) {
            this.store1.mutateEntries(b1, (List)additions, (List)deletions, this.tx);
            this.newTx();
            Assertions.assertEquals((Object)b1, (Object)KCVSUtil.get((KeyColumnValueStore)this.store1, (StaticBuffer)b1, (StaticBuffer)b1, (StoreTransaction)this.tx));
        }
    }

    @Test
    public void mutateManyWritesSameKeyOnMultipleCFs() throws BackendException {
        long arbitraryLong = 42L;
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(1764L);
        StaticBuffer val = KeyColumnValueStoreUtil.longToByteBuffer(74088L);
        StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer(42L);
        StaticBuffer nextCol = KeyColumnValueStoreUtil.longToByteBuffer(43L);
        StoreTransaction directTx = this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig());
        KCVMutation km = new KCVMutation((List)Lists.newArrayList((Object[])new Entry[]{StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)val)}), (List)Lists.newArrayList());
        ImmutableMap keyColumnAndValue = ImmutableMap.of((Object)key, (Object)km);
        ImmutableMap mutations = ImmutableMap.of((Object)"testStore1", (Object)keyColumnAndValue, (Object)"testStore2", (Object)keyColumnAndValue);
        this.manager.mutateMany((Map)mutations, directTx);
        directTx.commit();
        KeySliceQuery query = new KeySliceQuery(key, col, nextCol);
        ImmutableList expected = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)val));
        Assertions.assertEquals((Object)expected, (Object)this.store1.getSlice(query, this.tx));
        Assertions.assertEquals((Object)expected, (Object)this.store2.getSlice(query, this.tx));
    }

    @Test
    public void mutateManyStressTest() throws BackendException {
        this.mutateManyStressTestWithVariableRounds();
    }

    protected void mutateManyStressTestWithVariableRounds() throws BackendException {
        HashMap<StaticBuffer, Map<StaticBuffer, StaticBuffer>> state = new HashMap<StaticBuffer, Map<StaticBuffer, StaticBuffer>>();
        int deletions = 1024;
        int additions = 4096;
        for (int round = 0; round < 5; ++round) {
            Map<StaticBuffer, KCVEntryMutation> changes = this.mutateState(state, deletions, additions);
            this.applyChanges(changes, this.store1, this.tx);
            this.applyChanges(changes, this.store2, this.tx);
            this.newTx();
            int deletesExpected = 0 == round ? 0 : deletions;
            int stateSizeExpected = additions + (additions - deletions) * round;
            Assertions.assertEquals((int)stateSizeExpected, (int)this.checkThatStateExistsInStore(state, (KeyColumnValueStore)this.store1, round));
            Assertions.assertEquals((int)deletesExpected, (int)this.checkThatDeletionsApplied(changes, (KeyColumnValueStore)this.store1, round));
            Assertions.assertEquals((int)stateSizeExpected, (int)this.checkThatStateExistsInStore(state, (KeyColumnValueStore)this.store2, round));
            Assertions.assertEquals((int)deletesExpected, (int)this.checkThatDeletionsApplied(changes, (KeyColumnValueStore)this.store2, round));
        }
    }

    public void applyChanges(Map<StaticBuffer, KCVEntryMutation> changes, KCVSCache store, StoreTransaction tx) throws BackendException {
        for (Map.Entry<StaticBuffer, KCVEntryMutation> change : changes.entrySet()) {
            store.mutateEntries(change.getKey(), change.getValue().getAdditions(), change.getValue().getDeletions(), tx);
        }
    }

    public int checkThatStateExistsInStore(Map<StaticBuffer, Map<StaticBuffer, StaticBuffer>> state, KeyColumnValueStore store, int round) throws BackendException {
        int checked = 0;
        for (StaticBuffer key : state.keySet()) {
            for (StaticBuffer col : state.get(key).keySet()) {
                StaticBuffer val = state.get(key).get(col);
                Assertions.assertEquals((Object)val, (Object)KCVSUtil.get((KeyColumnValueStore)store, (StaticBuffer)key, (StaticBuffer)col, (StoreTransaction)this.tx));
                ++checked;
            }
        }
        this.log.debug("Checked existence of {} key-column-value triples on round {}", (Object)checked, (Object)round);
        return checked;
    }

    public int checkThatDeletionsApplied(Map<StaticBuffer, KCVEntryMutation> changes, KeyColumnValueStore store, int round) throws BackendException {
        int checked = 0;
        int skipped = 0;
        for (StaticBuffer key : changes.keySet()) {
            KCVEntryMutation m = changes.get(key);
            if (!m.hasDeletions()) continue;
            List deletions = m.getDeletions();
            List additions = m.getAdditions();
            for (Entry entry : deletions) {
                StaticBuffer col = entry.getColumn();
                if (null != additions && additions.contains(StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col))) {
                    ++skipped;
                    continue;
                }
                Assertions.assertNull((Object)KCVSUtil.get((KeyColumnValueStore)store, (StaticBuffer)key, (StaticBuffer)col, (StoreTransaction)this.tx));
                ++checked;
            }
        }
        this.log.debug("Checked absence of {} key-column-value deletions on round {} (skipped {})", new Object[]{checked, round, skipped});
        return checked;
    }

    public Map<StaticBuffer, KCVEntryMutation> mutateState(Map<StaticBuffer, Map<StaticBuffer, StaticBuffer>> state, int maxDeletionCount, int additionCount) {
        int keyLength = 8;
        int colLength = 16;
        HashMap<StaticBuffer, KCVEntryMutation> result = new HashMap<StaticBuffer, KCVEntryMutation>();
        int deletions = 0;
        StaticBuffer key = null;
        StaticArrayBuffer col = null;
        Entry entry = null;
        Iterator<StaticBuffer> iterator = state.keySet().iterator();
        while (iterator.hasNext() && deletions < maxDeletionCount) {
            key = iterator.next();
            Iterator<Map.Entry<StaticBuffer, StaticBuffer>> columnIterator = state.get(key).entrySet().iterator();
            while (columnIterator.hasNext() && deletions < maxDeletionCount) {
                Map.Entry<StaticBuffer, StaticBuffer> colEntry = columnIterator.next();
                entry = StaticArrayEntry.of((StaticBuffer)colEntry.getKey(), (StaticBuffer)colEntry.getValue());
                if (!result.containsKey(key)) {
                    KCVEntryMutation m = new KCVEntryMutation(new LinkedList(), new LinkedList());
                    result.put(key, m);
                }
                ((KCVEntryMutation)result.get(key)).deletion((Object)entry);
                ++deletions;
                columnIterator.remove();
                if (!state.get(key).isEmpty()) continue;
                Assertions.assertFalse((boolean)columnIterator.hasNext());
                iterator.remove();
            }
        }
        for (int i = 0; i < additionCount; ++i) {
            KCVEntryMutation m;
            do {
                byte[] keyBuf = new byte[8];
                this.rand.nextBytes(keyBuf);
                key = new StaticArrayBuffer(keyBuf);
                byte[] colBuf = new byte[16];
                this.rand.nextBytes(colBuf);
                col = new StaticArrayBuffer(colBuf);
            } while (state.containsKey(key) && state.get(key).containsKey(col));
            if (!state.containsKey(key)) {
                m = new HashMap();
                state.put(key, (Map<StaticBuffer, StaticBuffer>)m);
            }
            state.get(key).put((StaticBuffer)col, (StaticBuffer)col);
            if (!result.containsKey(key)) {
                m = new KCVEntryMutation(new LinkedList(), new LinkedList());
                result.put(key, m);
            }
            ((KCVEntryMutation)result.get(key)).addition((Object)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col));
        }
        return result;
    }
}

