/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.janusgraph.diskstorage.AbstractKCVSTest;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.KeyColumnValueStoreUtil;
import org.janusgraph.diskstorage.KeyValueStoreUtil;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSUtil;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.locking.LocalLockMediators;
import org.janusgraph.diskstorage.locking.Locker;
import org.janusgraph.diskstorage.locking.LockerProvider;
import org.janusgraph.diskstorage.locking.PermanentLockingException;
import org.janusgraph.diskstorage.locking.TemporaryLockingException;
import org.janusgraph.diskstorage.locking.consistentkey.ConsistentKeyLocker;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingStoreManager;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingTransaction;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.KeyColumn;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LockKeyColumnValueStoreTest
extends AbstractKCVSTest {
    private static final Logger log = LoggerFactory.getLogger(LockKeyColumnValueStoreTest.class);
    public static final int CONCURRENCY = 8;
    public static final int NUM_TX = 2;
    public static final String DB_NAME = "test";
    protected static final long EXPIRE_MS = 5000L;
    public KeyColumnValueStoreManager[] manager;
    public StoreTransaction[][] tx;
    public KeyColumnValueStore[] store;
    private StaticBuffer k;
    private StaticBuffer c1;
    private StaticBuffer c2;
    private StaticBuffer v1;
    private StaticBuffer v2;
    protected final String concreteClassName = this.getClass().getSimpleName();

    @BeforeEach
    public void setUp() throws Exception {
        try (KeyColumnValueStoreManager tmp = null;){
            tmp = this.openStorageManager(0, (Configuration)GraphDatabaseConfiguration.buildGraphConfiguration());
            tmp.clearStorage();
        }
        for (int i = 0; i < 8; ++i) {
            LocalLockMediators.INSTANCE.clear(this.concreteClassName + i);
        }
        this.open();
        this.k = KeyValueStoreUtil.getBuffer("testkey");
        this.c1 = KeyValueStoreUtil.getBuffer("col1");
        this.c2 = KeyValueStoreUtil.getBuffer("col2");
        this.v1 = KeyValueStoreUtil.getBuffer("val1");
        this.v2 = KeyValueStoreUtil.getBuffer("val2");
    }

    public abstract KeyColumnValueStoreManager openStorageManager(int var1, Configuration var2) throws BackendException;

    public void open() throws BackendException {
        this.manager = new KeyColumnValueStoreManager[8];
        this.tx = new StoreTransaction[8][2];
        this.store = new KeyColumnValueStore[8];
        for (int i = 0; i < 8; ++i) {
            ModifiableConfiguration sc = GraphDatabaseConfiguration.buildGraphConfiguration();
            sc.set(GraphDatabaseConfiguration.LOCK_LOCAL_MEDIATOR_GROUP, (Object)(this.concreteClassName + i), new String[0]);
            sc.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)("inst" + i), new String[0]);
            sc.set(GraphDatabaseConfiguration.LOCK_RETRY, (Object)10, new String[0]);
            sc.set(GraphDatabaseConfiguration.LOCK_EXPIRE, (Object)Duration.ofMillis(5000L), new String[0]);
            this.manager[i] = this.openStorageManager(i, (Configuration)sc);
            StoreFeatures storeFeatures = this.manager[i].getFeatures();
            this.store[i] = this.manager[i].openDatabase(DB_NAME);
            for (int j = 0; j < 2; ++j) {
                this.tx[i][j] = this.manager[i].beginTransaction((BaseTransactionConfig)this.getTxConfig());
                log.debug("Began transaction of class {}", (Object)this.tx[i][j].getClass().getCanonicalName());
            }
            if (storeFeatures.hasLocking()) continue;
            Preconditions.checkArgument((boolean)storeFeatures.isKeyConsistent(), (Object)"Store needs to support some form of locking");
            KeyColumnValueStore lockerStore = this.manager[i].openDatabase("test_lock_");
            ConsistentKeyLocker c = ((ConsistentKeyLocker.Builder)new ConsistentKeyLocker.Builder(lockerStore, (StoreManager)this.manager[i]).fromConfig((Configuration)sc).mediatorName(this.concreteClassName + i)).build();
            this.store[i] = new ExpectedValueCheckingStore(this.store[i], (Locker)c);
            for (int j = 0; j < 2; ++j) {
                this.tx[i][j] = new ExpectedValueCheckingTransaction(this.tx[i][j], this.manager[i].beginTransaction((BaseTransactionConfig)this.getConsistentTxConfig((StoreManager)this.manager[i])), (Duration)GraphDatabaseConfiguration.STORAGE_READ_WAITTIME.getDefaultValue());
            }
        }
    }

    public StoreTransaction newTransaction(KeyColumnValueStoreManager manager) throws BackendException {
        StoreTransaction transaction = manager.beginTransaction((BaseTransactionConfig)this.getTxConfig());
        if (!manager.getFeatures().hasLocking() && manager.getFeatures().isKeyConsistent()) {
            transaction = new ExpectedValueCheckingTransaction(transaction, manager.beginTransaction((BaseTransactionConfig)this.getConsistentTxConfig((StoreManager)manager)), (Duration)GraphDatabaseConfiguration.STORAGE_READ_WAITTIME.getDefaultValue());
        }
        return transaction;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        for (int i = 0; i < 8; ++i) {
            this.store[i].close();
            for (int j = 0; j < 2; ++j) {
                log.debug("Committing tx[{}][{}] = {}", new Object[]{i, j, this.tx[i][j]});
                if (this.tx[i][j] == null) continue;
                this.tx[i][j].commit();
            }
            this.manager[i].close();
        }
        LocalLockMediators.INSTANCE.clear();
    }

    @Test
    public void singleLockAndUnlock() throws BackendException {
        this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][0]);
        this.store[0].mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c1, (StaticBuffer)this.v1)), KeyColumnValueStore.NO_DELETIONS, this.tx[0][0]);
        this.tx[0][0].commit();
        this.tx[0][0] = this.newTransaction(this.manager[0]);
        Assertions.assertEquals((Object)this.v1, (Object)KCVSUtil.get((KeyColumnValueStore)this.store[0], (StaticBuffer)this.k, (StaticBuffer)this.c1, (StoreTransaction)this.tx[0][0]));
    }

    @Test
    public void transactionMayReenterLock() throws BackendException {
        this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][0]);
        this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][0]);
        this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][0]);
        this.store[0].mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c1, (StaticBuffer)this.v1)), KeyColumnValueStore.NO_DELETIONS, this.tx[0][0]);
        this.tx[0][0].commit();
        this.tx[0][0] = this.newTransaction(this.manager[0]);
        Assertions.assertEquals((Object)this.v1, (Object)KCVSUtil.get((KeyColumnValueStore)this.store[0], (StaticBuffer)this.k, (StaticBuffer)this.c1, (StoreTransaction)this.tx[0][0]));
    }

    @Test
    public void expectedValueMismatchCausesMutateFailure() throws BackendException {
        Assertions.assertThrows(PermanentLockingException.class, () -> {
            this.store[0].acquireLock(this.k, this.c1, this.v1, this.tx[0][0]);
            this.store[0].mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c1, (StaticBuffer)this.v1)), KeyColumnValueStore.NO_DELETIONS, this.tx[0][0]);
        });
    }

    @Test
    public void testLocalLockContention() throws BackendException {
        this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][0]);
        try {
            this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][1]);
            Assertions.fail((String)"Lock contention exception not thrown");
        }
        catch (BackendException e) {
            Assertions.assertTrue((e instanceof PermanentLockingException || e instanceof TemporaryLockingException ? 1 : 0) != 0);
        }
        try {
            this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][1]);
            Assertions.fail((String)"Lock contention exception not thrown (2nd try)");
        }
        catch (BackendException e) {
            Assertions.assertTrue((e instanceof PermanentLockingException || e instanceof TemporaryLockingException ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRemoteLockContention() throws InterruptedException, BackendException {
        this.store[0].acquireLock(this.k, this.c1, null, this.tx[0][0]);
        Thread.sleep(50L);
        try {
            this.store[1].acquireLock(this.k, this.c1, null, this.tx[1][0]);
        }
        catch (BackendException e) {
            Assertions.fail((String)"Contention between remote transactions detected too soon");
        }
        Thread.sleep(50L);
        try {
            this.store[1].mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c1, (StaticBuffer)this.v2)), KeyColumnValueStore.NO_DELETIONS, this.tx[1][0]);
            Assertions.fail((String)"Expected lock contention between remote transactions did not occur");
        }
        catch (BackendException e) {
            Assertions.assertTrue((e instanceof PermanentLockingException || e instanceof TemporaryLockingException ? 1 : 0) != 0);
        }
        this.store[0].mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c1, (StaticBuffer)this.v1)), KeyColumnValueStore.NO_DELETIONS, this.tx[0][0]);
        this.tx[0][0].commit();
        this.tx[0][0] = this.newTransaction(this.manager[0]);
        Assertions.assertEquals((Object)this.v1, (Object)KCVSUtil.get((KeyColumnValueStore)this.store[0], (StaticBuffer)this.k, (StaticBuffer)this.c1, (StoreTransaction)this.tx[0][0]));
    }

    @Test
    public void singleTransactionWithMultipleLocks() throws BackendException {
        this.tryWrites(this.store[0], this.manager[0], this.tx[0][0], this.store[0], this.tx[0][0]);
        this.tx[0][0] = null;
    }

    @Test
    public void twoLocalTransactionsWithIndependentLocks() throws BackendException {
        this.tryWrites(this.store[0], this.manager[0], this.tx[0][0], this.store[0], this.tx[0][1]);
        this.tx[0][0] = null;
        this.tx[0][1] = null;
    }

    @Test
    public void twoTransactionsWithIndependentLocks() throws BackendException {
        this.tryWrites(this.store[0], this.manager[0], this.tx[0][0], this.store[1], this.tx[1][0]);
        this.tx[0][0] = null;
        this.tx[1][0] = null;
    }

    @Test
    public void expiredLocalLockIsIgnored() throws BackendException, InterruptedException {
        this.tryLocks(this.store[0], this.tx[0][0], this.store[0], this.tx[0][1], true);
    }

    @Test
    public void expiredRemoteLockIsIgnored() throws BackendException, InterruptedException {
        this.tryLocks(this.store[0], this.tx[0][0], this.store[1], this.tx[1][0], false);
    }

    @Test
    public void repeatLockingDoesNotExtendExpiration() throws BackendException, InterruptedException {
        long start = System.currentTimeMillis();
        long gracePeriodMS = 50L;
        long loopDurationMS = 5000L - gracePeriodMS;
        long targetMS = start + loopDurationMS;
        int steps = 20;
        this.store[0].acquireLock(this.k, this.k, null, this.tx[0][0]);
        for (int i = 0; i <= steps && targetMS > System.currentTimeMillis(); ++i) {
            this.store[0].acquireLock(this.k, this.k, null, this.tx[0][0]);
            Thread.sleep(loopDurationMS / (long)steps);
        }
        Thread.sleep(gracePeriodMS * 2L);
        try {
            this.store[0].acquireLock(this.k, this.k, null, this.tx[0][1]);
        }
        catch (BackendException e) {
            log.debug("Relocking exception follows", (Throwable)e);
            Assertions.fail((String)"Relocking following expiration failed");
        }
    }

    @Test
    public void parallelNoncontendedLockStressTest() throws InterruptedException {
        int i;
        ExecutorService stressPool = Executors.newFixedThreadPool(8);
        CountDownLatch stressComplete = new CountDownLatch(8);
        long maxWallTimeAllowedMilliseconds = 90000L;
        int lockOperationsPerThread = 100;
        LockStressor[] ls = new LockStressor[8];
        for (i = 0; i < 8; ++i) {
            ls[i] = new LockStressor(this.manager[i], this.store[i], stressComplete, 100, KeyColumnValueStoreUtil.longToByteBuffer(i));
            stressPool.execute(ls[i]);
        }
        Assertions.assertTrue((boolean)stressComplete.await(90000L, TimeUnit.MILLISECONDS), (String)"Timeout exceeded");
        for (i = 0; i < 8; ++i) {
            if (0 < ls[i].temporaryFailures) {
                log.warn("Recorded {} temporary failures for thread index {}", (Object)ls[i].temporaryFailures, (Object)i);
            }
            Assertions.assertEquals((int)100, (int)(ls[i].succeeded + ls[i].temporaryFailures));
        }
    }

    @Test
    public void testLocksOnMultipleStores() throws Exception {
        int numStores = 6;
        StaticBuffer key = BufferUtil.getLongBuffer((long)1L);
        StaticBuffer col = BufferUtil.getLongBuffer((long)2L);
        StaticBuffer val2 = BufferUtil.getLongBuffer((long)8L);
        LockerProvider mockLockerProvider = (LockerProvider)EasyMock.createStrictMock(LockerProvider.class);
        Locker mockLocker = (Locker)EasyMock.createStrictMock(Locker.class);
        ExpectedValueCheckingStoreManager expManager = new ExpectedValueCheckingStoreManager(this.manager[0], "multi_store_lock_mgr", mockLockerProvider, Duration.ofMillis(100L));
        StandardBaseTransactionConfig txCfg = StandardBaseTransactionConfig.of((TimestampProvider)times);
        ExpectedValueCheckingTransaction tx = expManager.beginTransaction((BaseTransactionConfig)txCfg);
        EasyMock.expect((Object)mockLockerProvider.getLocker((String)EasyMock.anyObject(String.class))).andReturn((Object)mockLocker).times(6);
        mockLocker.writeLock((KeyColumn)EasyMock.eq((Object)new KeyColumn(key, col)), (StoreTransaction)EasyMock.eq((Object)tx.getConsistentTx()));
        EasyMock.expectLastCall().times(4);
        mockLocker.checkLocks(tx.getConsistentTx());
        EasyMock.expectLastCall().times(4);
        EasyMock.replay((Object[])new Object[]{mockLockerProvider});
        EasyMock.replay((Object[])new Object[]{mockLocker});
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < 6; ++i) {
            String storeName = "multi_store_lock_" + i;
            KeyColumnValueStore s = expManager.openDatabase(storeName);
            if (i % 3 < 2) {
                s.acquireLock(key, col, null, (StoreTransaction)tx);
            }
            if (i % 3 <= 0) continue;
            builder.put((Object)storeName, (Object)ImmutableMap.of((Object)key, (Object)new KCVMutation((List)ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)val2)), (List)ImmutableList.of())));
        }
        expManager.mutateMany((Map)builder.build(), (StoreTransaction)tx);
        expManager.close();
        EasyMock.verify((Object[])new Object[]{mockLockerProvider});
        EasyMock.verify((Object[])new Object[]{mockLocker});
    }

    private void tryWrites(KeyColumnValueStore store1, KeyColumnValueStoreManager keyColumnValueStoreManager, StoreTransaction tx1, KeyColumnValueStore store2, StoreTransaction tx2) throws BackendException {
        Assertions.assertNull((Object)KCVSUtil.get((KeyColumnValueStore)store1, (StaticBuffer)this.k, (StaticBuffer)this.c1, (StoreTransaction)tx1));
        Assertions.assertNull((Object)KCVSUtil.get((KeyColumnValueStore)store2, (StaticBuffer)this.k, (StaticBuffer)this.c2, (StoreTransaction)tx2));
        store1.acquireLock(this.k, this.c1, null, tx1);
        store2.acquireLock(this.k, this.c2, null, tx2);
        store1.mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c1, (StaticBuffer)this.v1)), KeyColumnValueStore.NO_DELETIONS, tx1);
        store2.mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c2, (StaticBuffer)this.v2)), KeyColumnValueStore.NO_DELETIONS, tx2);
        tx1.commit();
        if (tx2 != tx1) {
            tx2.commit();
        }
        StoreTransaction transaction = this.newTransaction(keyColumnValueStoreManager);
        Assertions.assertEquals((Object)this.v1, (Object)KCVSUtil.get((KeyColumnValueStore)store1, (StaticBuffer)this.k, (StaticBuffer)this.c1, (StoreTransaction)transaction));
        Assertions.assertEquals((Object)this.v2, (Object)KCVSUtil.get((KeyColumnValueStore)store2, (StaticBuffer)this.k, (StaticBuffer)this.c2, (StoreTransaction)transaction));
        transaction.commit();
    }

    private void tryLocks(KeyColumnValueStore s1, StoreTransaction tx1, KeyColumnValueStore s2, StoreTransaction tx2, boolean detectLocally) throws BackendException, InterruptedException {
        s1.acquireLock(this.k, this.k, null, tx1);
        if (detectLocally) {
            try {
                s2.acquireLock(this.k, this.k, null, tx2);
                Assertions.fail((String)"Expected lock contention between transactions did not occur");
            }
            catch (BackendException e) {
                Assertions.assertTrue((e instanceof PermanentLockingException || e instanceof TemporaryLockingException ? 1 : 0) != 0);
            }
        }
        Thread.sleep(5100L);
        s2.acquireLock(this.k, this.k, null, tx2);
        s2.mutate(this.k, Collections.singletonList(StaticArrayEntry.of((StaticBuffer)this.c2, (StaticBuffer)this.v2)), KeyColumnValueStore.NO_DELETIONS, tx2);
    }

    private class LockStressor
    implements Runnable {
        private final KeyColumnValueStoreManager manager;
        private final KeyColumnValueStore store;
        private final CountDownLatch doneLatch;
        private final int opCount;
        private final StaticBuffer toLock;
        private int succeeded = 0;
        private int temporaryFailures = 0;

        private LockStressor(KeyColumnValueStoreManager manager, KeyColumnValueStore store, CountDownLatch doneLatch, int opCount, StaticBuffer toLock) {
            this.manager = manager;
            this.store = store;
            this.doneLatch = doneLatch;
            this.opCount = opCount;
            this.toLock = toLock;
        }

        @Override
        public void run() {
            for (int opIndex = 0; opIndex < this.opCount; ++opIndex) {
                StoreTransaction tx = null;
                try {
                    tx = LockKeyColumnValueStoreTest.this.newTransaction(this.manager);
                    this.store.acquireLock(this.toLock, this.toLock, null, tx);
                    this.store.mutate(this.toLock, (List)ImmutableList.of(), Collections.singletonList(this.toLock), tx);
                    tx.commit();
                    ++this.succeeded;
                    continue;
                }
                catch (TemporaryLockingException e) {
                    ++this.temporaryFailures;
                    continue;
                }
                catch (Throwable t) {
                    log.error("Unexpected locking-related exception on iteration " + (opIndex + 1) + "/" + this.opCount, t);
                }
            }
            this.doneLatch.countDown();
        }
    }
}

