/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.janusgraph.JanusGraphBaseStoreFeaturesTest;
import org.janusgraph.diskstorage.AbstractKCVSTest;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.KeyValueStoreUtil;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KVQuery;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KVUtil;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.testutil.FeatureFlag;
import org.janusgraph.testutil.JanusGraphFeature;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyValueStoreTest
extends AbstractKCVSTest
implements JanusGraphBaseStoreFeaturesTest {
    private final Logger log = LoggerFactory.getLogger(KeyValueStoreTest.class);
    private final int numKeys = 2000;
    protected OrderedKeyValueStoreManager manager;
    protected StoreTransaction tx;
    protected OrderedKeyValueStore store;

    @BeforeEach
    public void setUp() throws Exception {
        OrderedKeyValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        this.open();
    }

    public void open() throws BackendException {
        this.manager = this.openStorageManager();
        String storeName = "testStore1";
        this.store = this.manager.openDatabase(storeName);
        this.tx = this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig());
    }

    public abstract OrderedKeyValueStoreManager openStorageManager() throws BackendException;

    @Override
    public StoreFeatures getStoreFeatures() {
        return this.manager.getFeatures();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.store.close();
        this.manager.close();
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    @Test
    public void createDatabase() {
    }

    public String[] generateValues() {
        return KeyValueStoreUtil.generateData(2000);
    }

    public void loadValues(String[] values) throws BackendException {
        for (int i = 0; i < 2000; ++i) {
            this.store.insert(KeyValueStoreUtil.getBuffer(i), KeyValueStoreUtil.getBuffer(values[i]), this.tx, null);
        }
    }

    public Set<Integer> deleteValues(int start, int every) throws BackendException {
        HashSet<Integer> removed = new HashSet<Integer>();
        for (int i = start; i < 2000; i += every) {
            removed.add(i);
            this.store.delete(KeyValueStoreUtil.getBuffer(i), this.tx);
        }
        return removed;
    }

    public void checkValueExistence(String[] values) throws BackendException {
        this.checkValueExistence(values, new HashSet<Integer>());
    }

    public void checkValueExistence(String[] values, Set<Integer> removed) throws BackendException {
        for (int i = 0; i < 2000; ++i) {
            boolean result = this.store.containsKey(KeyValueStoreUtil.getBuffer(i), this.tx);
            if (removed.contains(i)) {
                Assertions.assertFalse((boolean)result);
                continue;
            }
            Assertions.assertTrue((boolean)result);
        }
    }

    public void checkValues(String[] values) throws BackendException {
        this.checkValues(values, new HashSet<Integer>());
    }

    public void checkValues(String[] values, Set<Integer> removed) throws BackendException {
        for (int i = 0; i < 2000; ++i) {
            StaticBuffer result = this.store.get(KeyValueStoreUtil.getBuffer(i), this.tx);
            if (removed.contains(i)) {
                Assertions.assertNull((Object)result);
                continue;
            }
            Assertions.assertEquals((Object)values[i], (Object)KeyValueStoreUtil.getString(result));
        }
        if (this.manager.getFeatures().hasMultiQuery()) {
            ArrayList queries = Lists.newArrayList();
            for (int i = 0; i < 2000; ++i) {
                StaticBuffer key = KeyValueStoreUtil.getBuffer(i);
                queries.add(new KVQuery(key, BufferUtil.nextBiggerBuffer((StaticBuffer)key), 2));
            }
            Map results = this.store.getSlices((List)queries, this.tx);
            for (int i = 0; i < 2000; ++i) {
                StaticBuffer value;
                RecordIterator result = (RecordIterator)results.get(queries.get(i));
                Assertions.assertNotNull((Object)result);
                if (result.hasNext()) {
                    value = ((KeyValueEntry)result.next()).getValue();
                    Assertions.assertFalse((boolean)result.hasNext());
                } else {
                    value = null;
                }
                if (removed.contains(i)) {
                    Assertions.assertNull((Object)value);
                    continue;
                }
                Assertions.assertEquals((Object)values[i], (Object)KeyValueStoreUtil.getString(value));
            }
        }
    }

    @Test
    public void storeAndRetrieve() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    @Test
    public void storeAndRetrieveWithClosing() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    @Test
    public void deletionTest1() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        Set<Integer> deleted = this.deleteValues(0, 10);
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    public void deletionTest2() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        Set<Integer> deleted = this.deleteValues(0, 10);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.Scan)
    public void scanTest() throws BackendException {
        String[] values = this.generateValues();
        this.loadValues(values);
        RecordIterator<KeyValueEntry> iterator0 = this.getAllData(this.tx);
        Assertions.assertEquals((int)2000, (int)KeyValueStoreUtil.count(iterator0));
        this.clopen();
        RecordIterator<KeyValueEntry> iterator1 = this.getAllData(this.tx);
        RecordIterator<KeyValueEntry> iterator2 = this.getAllData(this.tx);
        RecordIterator<KeyValueEntry> iterator3 = this.getAllData(this.tx);
        Assertions.assertEquals((int)2000, (int)KeyValueStoreUtil.count(iterator1));
        Assertions.assertEquals((int)2000, (int)KeyValueStoreUtil.count(iterator2));
    }

    private RecordIterator<KeyValueEntry> getAllData(StoreTransaction tx) throws BackendException {
        return this.store.getSlice(new KVQuery(BackendTransaction.EDGESTORE_MIN_KEY, BackendTransaction.EDGESTORE_MAX_KEY), tx);
    }

    public void checkSlice(String[] values, Set<Integer> removed, int start, int end, int limit) throws BackendException {
        EntryList entries = limit <= 0 ? KVUtil.getSlice((OrderedKeyValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(start), (StaticBuffer)KeyValueStoreUtil.getBuffer(end), (StoreTransaction)this.tx) : KVUtil.getSlice((OrderedKeyValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(start), (StaticBuffer)KeyValueStoreUtil.getBuffer(end), (int)limit, (StoreTransaction)this.tx);
        int pos = 0;
        for (int i = start; i < end; ++i) {
            if (removed.contains(i)) continue;
            if (pos < limit) {
                Entry entry = (Entry)entries.get(pos);
                int id = KeyValueStoreUtil.getID(entry.getColumn());
                String str = KeyValueStoreUtil.getString((StaticBuffer)entry.getValueAs(StaticBuffer.STATIC_FACTORY));
                Assertions.assertEquals((int)i, (int)id);
                Assertions.assertEquals((Object)values[i], (Object)str);
            }
            ++pos;
        }
        if (limit > 0 && pos >= limit) {
            Assertions.assertEquals((int)limit, (int)entries.size());
        } else {
            Assertions.assertNotNull((Object)entries);
            Assertions.assertEquals((int)pos, (int)entries.size());
        }
    }

    @Test
    public void intervalTest1() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        Set<Integer> deleted = this.deleteValues(0, 10);
        this.clopen();
        this.checkSlice(values, deleted, 5, 25, -1);
        this.checkSlice(values, deleted, 5, 250, 10);
        this.checkSlice(values, deleted, 500, 1250, -1);
        this.checkSlice(values, deleted, 500, 1250, 1000);
        this.checkSlice(values, deleted, 500, 1250, 100);
        this.checkSlice(values, deleted, 50, 20, 10);
        this.checkSlice(values, deleted, 50, 20, -1);
    }
}

