/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.locking.Locker;
import org.janusgraph.diskstorage.locking.LockerProvider;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingStoreManager;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.KeyColumn;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.StaticArrayEntryList;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExpectedValueCheckingTest {
    private IMocksControl ctrl;
    private ExpectedValueCheckingStoreManager expectManager;
    private KeyColumnValueStoreManager backingManager;
    private StoreTransaction consistentTx;
    private StoreTransaction inconsistentTx;
    private StoreTransaction expectTx;
    private Locker backingLocker;
    private KeyColumnValueStore backingStore;
    private KeyColumnValueStore expectStore;
    private Capture<BaseTransactionConfig> txConfigCapture;
    private static final String STORE_NAME = "ExpectTestStore";
    private static final String LOCK_SUFFIX = "_expecttest";
    private static final String LOCKER_NAME = "ExpectTestStore_expecttest";
    private static final StaticBuffer DATA_KEY = BufferUtil.getIntBuffer((int)1);
    private static final StaticBuffer DATA_COL = BufferUtil.getIntBuffer((int)2);
    private static final StaticBuffer DATA_VAL = BufferUtil.getIntBuffer((int)4);
    private static final StaticBuffer LOCK_KEY = BufferUtil.getIntBuffer((int)32);
    private static final StaticBuffer LOCK_COL = BufferUtil.getIntBuffer((int)64);
    private static final StaticBuffer LOCK_VAL = BufferUtil.getIntBuffer((int)128);

    @BeforeEach
    public void setupMocks() throws BackendException {
        this.ctrl = EasyMock.createStrictControl();
        this.ctrl.checkOrder(true);
        this.backingManager = (KeyColumnValueStoreManager)this.ctrl.createMock(KeyColumnValueStoreManager.class);
        LockerProvider lockerProvider = (LockerProvider)this.ctrl.createMock(LockerProvider.class);
        ModifiableConfiguration globalConfig = GraphDatabaseConfiguration.buildGraphConfiguration();
        ModifiableConfiguration localConfig = GraphDatabaseConfiguration.buildGraphConfiguration();
        ModifiableConfiguration defaultConfig = GraphDatabaseConfiguration.buildGraphConfiguration();
        globalConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"global", new String[0]);
        localConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"local", new String[0]);
        defaultConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"default", new String[0]);
        StandardBaseTransactionConfig defaultTxConfig = new StandardBaseTransactionConfig.Builder().customOptions((Configuration)defaultConfig).timestampProvider((TimestampProvider)TimestampProviders.MICRO).build();
        StandardStoreFeatures backingFeatures = new StandardStoreFeatures.Builder().keyConsistent((Configuration)globalConfig, (Configuration)localConfig).build();
        EasyMock.expect((Object)this.backingManager.getFeatures()).andReturn((Object)backingFeatures).once();
        this.txConfigCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        this.inconsistentTx = (StoreTransaction)this.ctrl.createMock(StoreTransaction.class);
        this.consistentTx = (StoreTransaction)this.ctrl.createMock(StoreTransaction.class);
        EasyMock.expect((Object)this.backingManager.beginTransaction((BaseTransactionConfig)EasyMock.capture(this.txConfigCapture))).andReturn((Object)this.inconsistentTx);
        EasyMock.expect((Object)this.backingManager.beginTransaction((BaseTransactionConfig)EasyMock.capture(this.txConfigCapture))).andReturn((Object)this.consistentTx);
        this.backingLocker = (Locker)this.ctrl.createMock(Locker.class);
        this.backingStore = (KeyColumnValueStore)this.ctrl.createMock(KeyColumnValueStore.class);
        EasyMock.expect((Object)this.backingManager.openDatabase(STORE_NAME)).andReturn((Object)this.backingStore);
        EasyMock.expect((Object)this.backingStore.getName()).andReturn((Object)STORE_NAME);
        EasyMock.expect((Object)lockerProvider.getLocker(LOCKER_NAME)).andReturn((Object)this.backingLocker);
        this.ctrl.replay();
        this.expectManager = new ExpectedValueCheckingStoreManager(this.backingManager, LOCK_SUFFIX, lockerProvider, Duration.ofSeconds(1L));
        this.expectTx = this.expectManager.beginTransaction((BaseTransactionConfig)defaultTxConfig);
        this.expectStore = this.expectManager.openDatabase(STORE_NAME);
        this.ctrl.verify();
        this.ctrl.reset();
    }

    @AfterEach
    public void verifyMocks() {
        this.ctrl.verify();
        this.ctrl.reset();
        Assertions.assertTrue((boolean)this.txConfigCapture.hasCaptured());
        List transactionConfigurations = this.txConfigCapture.getValues();
        Assertions.assertEquals((int)2, (int)transactionConfigurations.size());
        Assertions.assertEquals((Object)"default", (Object)((BaseTransactionConfig)transactionConfigurations.get(0)).getCustomOption(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID));
        Assertions.assertEquals((Object)"global", (Object)((BaseTransactionConfig)transactionConfigurations.get(1)).getCustomOption(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID));
    }

    @Test
    public void testMutateWithLockUsesConsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList deletions = ImmutableList.of();
        KeyColumn kc = new KeyColumn(LOCK_KEY, LOCK_COL);
        this.backingLocker.writeLock(kc, this.consistentTx);
        this.backingLocker.checkLocks(this.consistentTx);
        StaticBuffer nextBuf = BufferUtil.nextBiggerBuffer((StaticBuffer)kc.getColumn());
        KeySliceQuery expectedValueQuery = new KeySliceQuery(kc.getKey(), kc.getColumn(), nextBuf);
        EasyMock.expect((Object)this.backingStore.getSlice(expectedValueQuery, this.consistentTx)).andReturn((Object)StaticArrayEntryList.of((Entry[])new Entry[]{StaticArrayEntry.of((StaticBuffer)LOCK_COL, (StaticBuffer)LOCK_VAL)}));
        this.backingStore.mutate(DATA_KEY, (List)adds, (List)deletions, this.consistentTx);
        this.ctrl.replay();
        this.expectStore.acquireLock(LOCK_KEY, LOCK_COL, LOCK_VAL, this.expectTx);
        this.expectStore.mutate(DATA_KEY, (List)adds, (List)deletions, this.expectTx);
    }

    @Test
    public void testMutateWithoutLockUsesInconsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList deletions = ImmutableList.of();
        this.backingStore.mutate(DATA_KEY, (List)adds, (List)deletions, this.inconsistentTx);
        this.ctrl.replay();
        this.expectStore.mutate(DATA_KEY, (List)adds, (List)deletions, this.expectTx);
    }

    @Test
    public void testMutateManyWithLockUsesConsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList deletions = ImmutableList.of();
        ImmutableMap mutations = ImmutableMap.of((Object)STORE_NAME, (Object)ImmutableMap.of((Object)DATA_KEY, (Object)new KCVMutation((List)adds, (List)deletions)));
        KeyColumn kc = new KeyColumn(LOCK_KEY, LOCK_COL);
        this.backingLocker.writeLock(kc, this.consistentTx);
        this.backingLocker.checkLocks(this.consistentTx);
        StaticBuffer nextBuf = BufferUtil.nextBiggerBuffer((StaticBuffer)kc.getColumn());
        KeySliceQuery expectedValueQuery = new KeySliceQuery(kc.getKey(), kc.getColumn(), nextBuf);
        EasyMock.expect((Object)this.backingStore.getSlice(expectedValueQuery, this.consistentTx)).andReturn((Object)StaticArrayEntryList.of((Entry[])new Entry[]{StaticArrayEntry.of((StaticBuffer)LOCK_COL, (StaticBuffer)LOCK_VAL)}));
        this.backingManager.mutateMany((Map)mutations, this.consistentTx);
        this.ctrl.replay();
        this.expectStore.acquireLock(LOCK_KEY, LOCK_COL, LOCK_VAL, this.expectTx);
        this.expectManager.mutateMany((Map)mutations, this.expectTx);
    }

    @Test
    public void testMutateManyWithoutLockUsesInconsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList deletions = ImmutableList.of();
        ImmutableMap mutations = ImmutableMap.of((Object)STORE_NAME, (Object)ImmutableMap.of((Object)DATA_KEY, (Object)new KCVMutation((List)adds, (List)deletions)));
        this.backingManager.mutateMany((Map)mutations, this.inconsistentTx);
        this.ctrl.replay();
        this.expectManager.mutateMany((Map)mutations, this.expectTx);
    }
}

