/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.zonalstats;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.List;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ROI;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.RangeExtendedComparator;
import org.jaitools.numeric.RangeUtils;
import org.jaitools.numeric.Statistic;

public class ZonalStatsDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -526208282980300507L;
    public static final String ZONAL_STATS_PROPERTY = "ZonalStatsProperty";
    static final int DATA_IMAGE = 0;
    static final int ZONE_IMAGE = 1;
    private static final String[] srcImageNames = new String[]{"dataImage", "zoneImage"};
    private static final Class<?>[][] srcImageClasses = new Class[][]{{RenderedImage.class, RenderedImage.class}};
    static final int STATS_ARG = 0;
    static final int BAND_ARG = 1;
    static final int ROI_ARG = 2;
    static final int ZONE_TRANSFORM_ARG = 3;
    static final int RANGES_ARG = 4;
    static final int RANGES_TYPE_ARG = 5;
    static final int RANGE_LOCAL_STATS_ARG = 6;
    static final int NODATA_RANGES_ARG = 7;
    private static final String[] paramNames = new String[]{"stats", "bands", "roi", "zoneTransform", "ranges", "rangesType", "rangeLocalStats", "noDataRanges"};
    private static final Class<?>[] paramClasses = new Class[]{Statistic[].class, Integer[].class, ROI.class, AffineTransform.class, Collection.class, Range.Type.class, Boolean.class, Collection.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, new Integer[]{0}, null, null, null, Range.Type.UNDEFINED, Boolean.FALSE, null};

    public ZonalStatsDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "ZonalStats"}, {"LocalName", "ZonalStats"}, {"Vendor", "org.jaitools.media.jai"}, {"Description", "Calculate neighbourhood statistics"}, {"DocURL", "http://code.google.com/p/jaitools/"}, {"Version", "1.0.0"}, {"arg0Desc", String.format("%s - an array of Statistic constants specifying the statistics required", paramNames[0])}, {"arg1Desc", String.format("%s (default %s) - the bands of the data image to process", paramNames[1], paramDefaults[1])}, {"arg2Desc", String.format("%s (default ) - an optional ROI for masking the data image", paramNames[2], paramDefaults[2])}, {"arg3Desc", String.format("%s (default %s) - an optional AffineTransform to map dataImage pixel coords to zoneImage pixel coords", paramNames[3], paramDefaults[3])}, {"arg4Desc", String.format("%s (default %s) - an optional Collection of Ranges that define dataImage values to include or exclude", paramNames[4], paramDefaults[4])}, {"arg5Desc", String.format("%s (default %s) - whether to include or exclude provided ranges", paramNames[5], paramDefaults[5])}, {"arg6Desc", String.format("%s (default %s) - whether to calculate statistics separately for ranges (when provided)", paramNames[6], paramDefaults[6])}, {"arg7Desc", String.format("%s (default %s) - an optional Collection of Ranges defining values to treat as NODATA", paramNames[7], paramDefaults[7])}}, new String[]{"rendered"}, srcImageNames, (Class[][])srcImageClasses, paramNames, (Class[])paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock pb, StringBuffer msg) {
        Object rangesType;
        Object noDataRangeObject;
        Object range;
        if (pb.getNumSources() == 0 || pb.getNumSources() > 2) {
            msg.append("ZonalStats operator takes 1 or 2 source images");
            return false;
        }
        Object rangeObject = pb.getObjectParameter(4);
        if (rangeObject != null) {
            boolean ok = true;
            if (rangeObject instanceof Collection) {
                Collection coll = (Collection)rangeObject;
                if (!coll.isEmpty()) {
                    range = coll.iterator().next();
                    if (!(range instanceof Range)) {
                        msg.append(paramNames[4]).append(" arg has to be of type List<Range<Double>>");
                        ok = false;
                    } else {
                        List sortedRanges = RangeUtils.sort(coll);
                        int elements = sortedRanges.size();
                        if (elements > 1) {
                            RangeExtendedComparator rc = new RangeExtendedComparator();
                            List rr = sortedRanges;
                            for (int i = 0; i < elements - 1; ++i) {
                                Range r2;
                                Range r1 = rr.get(i);
                                RangeExtendedComparator.Result result = rc.compare(r1, r2 = rr.get(i + 1));
                                if (!RangeExtendedComparator.isIntersection(result)) continue;
                                ok = false;
                                msg.append(paramNames[4]).append(" arg can't contain intersecting ranges");
                                break;
                            }
                        }
                    }
                }
            } else if (rangeObject != null) {
                ok = false;
                msg.append(paramNames[4]).append(" arg has to be of type List<Range<Double>>");
            }
            if (!ok) {
                return false;
            }
        }
        if ((noDataRangeObject = pb.getObjectParameter(7)) != null) {
            boolean ok = true;
            if (noDataRangeObject instanceof List) {
                range = ((List)noDataRangeObject).get(0);
                if (!(range instanceof Range)) {
                    msg.append(paramNames[7]).append(" arg has to be of type List<Range<Double>>");
                    ok = false;
                }
            } else if (noDataRangeObject != null) {
                ok = false;
                msg.append(paramNames[7]).append(" arg has to be of type List<Range<Double>>");
            }
            if (!ok) {
                return false;
            }
        }
        if ((rangesType = pb.getObjectParameter(5)) != null && rangesType instanceof Range.Type) {
            Range.Type rt = (Range.Type)((Object)rangesType);
            if (rangeObject != null && rt == Range.Type.UNDEFINED) {
                msg.append(paramNames[5]).append(" arg has to be of Type.EXCLUDED or Type.INCLUDED when specifying a Ranges List");
                return false;
            }
        }
        Object bandsObject = pb.getObjectParameter(1);
        Integer[] bands = null;
        if (!(bandsObject instanceof Integer[])) {
            msg.append(paramNames[1]).append(" arg has to be of type Integer[]");
            return false;
        }
        bands = (Integer[])bandsObject;
        RenderedImage dataImg = pb.getRenderedSource(0);
        for (Integer band : bands) {
            if (band >= 0 && band < dataImg.getSampleModel().getNumBands()) continue;
            msg.append("band index out of bounds for source image: ").append(band);
            return false;
        }
        Rectangle dataBounds = new Rectangle(dataImg.getMinX(), dataImg.getMinY(), dataImg.getWidth(), dataImg.getHeight());
        Object roiObject = pb.getObjectParameter(2);
        if (roiObject != null) {
            if (!(roiObject instanceof ROI)) {
                msg.append("The supplied ROI is not a supported class");
                return false;
            }
            if (!((ROI)roiObject).intersects(dataBounds)) {
                msg.append("The supplied ROI does not intersect the source image");
                return false;
            }
        }
        if (pb.getNumSources() == 2) {
            RenderedImage zoneImg = pb.getRenderedSource(1);
            int dataType = zoneImg.getSampleModel().getDataType();
            boolean integralType = false;
            if (dataType == 0 || dataType == 3 || dataType == 2 || dataType == 1) {
                integralType = true;
            }
            if (!integralType) {
                msg.append("The zone image must be an integral data type");
                return false;
            }
            AffineTransform tr = null;
            Object trObject = pb.getObjectParameter(3);
            if (trObject != null && !(trObject instanceof AffineTransform)) {
                msg.append("The supplied transform should be an instance of AffineTransform");
                return false;
            }
            tr = (AffineTransform)trObject;
            Rectangle zoneBounds = new Rectangle(zoneImg.getMinX(), zoneImg.getMinY(), zoneImg.getWidth(), zoneImg.getHeight());
            if (tr != null && !tr.isIdentity()) {
                Shape zoneBoundsTransformed = tr.createTransformedShape(zoneBounds);
                if (!zoneBoundsTransformed.intersects(dataBounds)) {
                    msg.append("Zone image bounds are outside the data image bounds");
                    return false;
                }
            } else if (!dataBounds.intersects(zoneBounds)) {
                msg.append("Zone image bounds are outside the data image bounds");
                return false;
            }
        }
        return true;
    }
}

